/*
 * Decompiled with CFR 0.152.
 */
package ffx.numerics.switching;

import ffx.numerics.switching.MultiplicativeSwitch;
import ffx.numerics.switching.PowerSwitch;
import ffx.numerics.switching.UnivariateSwitchingFunction;
import java.util.logging.Logger;
import org.apache.commons.math3.util.FastMath;

public class CompositeSwitch
implements UnivariateSwitchingFunction {
    private static final Logger logger = Logger.getLogger(CompositeSwitch.class.getName());
    private final UnivariateSwitchingFunction primaryFunction;
    private final UnivariateSwitchingFunction startSwitch;
    private final UnivariateSwitchingFunction endSwitch;
    private final double lbPrimary;
    private final double ubPrimary;
    private final double lb;
    private final double ub;
    private final double multLB;
    private final double fdLB;
    private final double fdLB2;
    private final double multUB;
    private final double fdUB;
    private final double fdUB2;

    public CompositeSwitch() {
        this(new PowerSwitch());
    }

    public CompositeSwitch(UnivariateSwitchingFunction primary) {
        this(primary, new MultiplicativeSwitch(), new MultiplicativeSwitch(), 0.1, 0.9);
    }

    public CompositeSwitch(UnivariateSwitchingFunction primary, UnivariateSwitchingFunction start, UnivariateSwitchingFunction end, double lbPrimary, double ubPrimary) {
        this(primary, start, end, lbPrimary, ubPrimary, 0.0, 1.0);
    }

    public CompositeSwitch(UnivariateSwitchingFunction primary, UnivariateSwitchingFunction start, UnivariateSwitchingFunction end, double lbPrimary, double ubPrimary, double lb, double ub) {
        if (lbPrimary > ubPrimary) {
            throw new IllegalArgumentException(String.format(" Lower primary bound %10.4g was greater than upper primary bound %10.4g", lbPrimary, ubPrimary));
        }
        if (lb > ub) {
            throw new IllegalArgumentException(String.format(" Lower bound %10.4g was greater than upper bound %10.4g", lb, ub));
        }
        assert (lb < lbPrimary && ub > ubPrimary);
        this.primaryFunction = primary;
        this.startSwitch = start;
        this.endSwitch = end;
        this.lbPrimary = lbPrimary;
        this.ubPrimary = ubPrimary;
        this.lb = lb;
        this.ub = ub;
        this.fdLB = lbPrimary - lb;
        this.multLB = 1.0 / this.fdLB;
        this.fdLB2 = this.fdLB * this.fdLB;
        this.fdUB = ub - ubPrimary;
        this.multUB = 1.0 / this.fdUB;
        this.fdUB2 = this.fdUB * this.fdUB;
    }

    @Override
    public boolean constantOutsideBounds() {
        return this.startSwitch.constantOutsideBounds() && this.endSwitch.constantOutsideBounds();
    }

    @Override
    public double firstDerivative(double x) throws IllegalArgumentException {
        if (x < this.lbPrimary) {
            return this.fdLower(x);
        }
        if (x > this.ubPrimary) {
            return this.fdUpper(x);
        }
        return this.primaryFunction.firstDerivative(x);
    }

    @Override
    public int getHighestOrderZeroDerivative() {
        return Math.max(Math.max(this.startSwitch.getHighestOrderZeroDerivative(), this.endSwitch.getHighestOrderZeroDerivative()), this.primaryFunction.getHighestOrderZeroDerivative());
    }

    @Override
    public double getOneBound() {
        return this.ub;
    }

    @Override
    public double getZeroBound() {
        return this.lb;
    }

    @Override
    public double nthDerivative(double x, int order) throws IllegalArgumentException {
        return switch (order) {
            case 0 -> this.valueAt(x);
            case 1 -> this.firstDerivative(x);
            case 2 -> this.secondDerivative(x);
            default -> throw new IllegalArgumentException(" Composite switches do not yet have support for arbitrary derivatives");
        };
    }

    @Override
    public double secondDerivative(double x) throws IllegalArgumentException {
        if (x < this.lbPrimary) {
            return this.sdLower(x);
        }
        if (x > this.ubPrimary) {
            return this.sdUpper(x);
        }
        return this.primaryFunction.secondDerivative(x);
    }

    @Override
    public boolean symmetricToUnity() {
        return this.primaryFunction.symmetricToUnity() && this.startSwitch.equals(this.endSwitch) && this.lbPrimary - this.lb == this.ub - this.ubPrimary;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(String.format(" Composite switch with overall range %12.5g-%12.5g, with an inner range %12.5g-%12.5g", this.lb, this.ub, this.lbPrimary, this.ubPrimary));
        sb.append("\n Primary switch: ").append(this.primaryFunction.toString());
        sb.append("\n Start switch:   ").append(this.startSwitch.toString());
        sb.append("\n End switch:     ").append(this.endSwitch.toString());
        return sb.toString();
    }

    @Override
    public boolean validOutsideBounds() {
        return this.startSwitch.constantOutsideBounds() && this.endSwitch.constantOutsideBounds();
    }

    @Override
    public double valueAt(double x) throws IllegalArgumentException {
        if (x < this.lbPrimary) {
            return this.valLower(x);
        }
        if (x > this.ubPrimary) {
            return this.valUpper(x);
        }
        return this.primaryFunction.valueAt(x);
    }

    private boolean approxEquals(double x1, double x2) {
        return this.approxEquals(x1, x2, 1.0E-11);
    }

    private boolean approxEquals(double x1, double x2, double tol) {
        double largerVal = FastMath.max((double)FastMath.abs((double)x1), (double)FastMath.abs((double)x2));
        if (largerVal == 0.0) {
            return true;
        }
        if (largerVal > 1.0E-6) {
            return FastMath.abs((double)((x1 - x2) / largerVal)) < tol;
        }
        return FastMath.abs((double)(x1 - x2)) < tol;
    }

    private boolean testJoints() {
        if (!this.approxEquals(this.valLower(this.lbPrimary), this.primaryFunction.valueAt(this.lbPrimary))) {
            return false;
        }
        if (!this.approxEquals(this.valUpper(this.ubPrimary), this.primaryFunction.valueAt(this.ubPrimary))) {
            return false;
        }
        if (!this.approxEquals(this.fdLower(this.lbPrimary), this.primaryFunction.firstDerivative(this.lbPrimary))) {
            return false;
        }
        if (!this.approxEquals(this.fdUpper(this.ubPrimary), this.primaryFunction.firstDerivative(this.ubPrimary))) {
            return false;
        }
        if (!this.approxEquals(this.sdLower(this.lbPrimary), this.primaryFunction.secondDerivative(this.lbPrimary))) {
            return false;
        }
        return this.approxEquals(this.sdUpper(this.ubPrimary), this.primaryFunction.secondDerivative(this.ubPrimary));
    }

    private double lbX(double x) {
        return (x - this.lb) * this.multLB;
    }

    private double ubX(double x) {
        return (this.ub - x) * this.multUB;
    }

    private double valLower(double x) {
        return this.startSwitch.valueAt(this.lbX(x)) * this.primaryFunction.valueAt(x);
    }

    private double valUpper(double x) {
        return this.endSwitch.valueAt(this.ubX(x)) * this.primaryFunction.valueAt(x);
    }

    private double fdLower(double x) {
        double swX = this.lbX(x);
        double val = this.primaryFunction.firstDerivative(x) * this.startSwitch.valueAt(swX);
        return val += this.primaryFunction.valueAt(x) * this.startSwitch.firstDerivative(swX) * this.fdLB;
    }

    private double fdUpper(double x) {
        double swX = this.ubX(x);
        double val = this.primaryFunction.firstDerivative(x) * this.endSwitch.valueAt(swX);
        return val += this.primaryFunction.valueAt(x) * this.endSwitch.firstDerivative(swX) * this.fdUB;
    }

    private double sdLower(double x) {
        double swX = this.lbX(x);
        double val = this.primaryFunction.secondDerivative(x) * this.startSwitch.valueAt(swX);
        val += 2.0 * this.primaryFunction.firstDerivative(x) * this.startSwitch.firstDerivative(swX) * this.fdLB;
        return val += this.primaryFunction.valueAt(x) * this.startSwitch.secondDerivative(swX) * this.fdLB2;
    }

    private double sdUpper(double x) {
        double swX = this.ubX(x);
        double val = this.primaryFunction.secondDerivative(x) * this.endSwitch.valueAt(swX);
        val += 2.0 * this.primaryFunction.firstDerivative(x) * this.endSwitch.firstDerivative(swX) * this.fdUB;
        return val += this.primaryFunction.valueAt(x) * this.endSwitch.secondDerivative(swX) * this.fdUB2;
    }
}

