/*
 * Decompiled with CFR 0.152.
 */
package ffx.numerics.switching;

import ffx.numerics.switching.MultiplicativeSwitch;
import ffx.numerics.switching.UnivariateSwitchingFunction;
import org.apache.commons.math3.util.FastMath;

public class BellCurveSwitch
implements UnivariateSwitchingFunction {
    private final double midpoint;
    private final double halfWidth;
    private final double invWidth;
    private final UnivariateSwitchingFunction switchingFunction;
    private final UnivariateSwitchingFunction secondSwitchingFunction;

    public BellCurveSwitch() {
        this(0.5);
    }

    public BellCurveSwitch(double midpoint) {
        this(midpoint, 1.0);
    }

    public BellCurveSwitch(double midpoint, double width) {
        this.midpoint = midpoint;
        this.invWidth = 1.0 / width;
        this.halfWidth = 0.5 * width;
        this.switchingFunction = new MultiplicativeSwitch(midpoint, midpoint - this.halfWidth);
        this.secondSwitchingFunction = new MultiplicativeSwitch(midpoint, midpoint + this.halfWidth);
    }

    @Override
    public boolean constantOutsideBounds() {
        return this.switchingFunction.constantOutsideBounds() && this.secondSwitchingFunction.constantOutsideBounds();
    }

    @Override
    public double firstDerivative(double x) {
        if (x > this.midpoint) {
            return this.invWidth * this.secondSwitchingFunction.firstDerivative(x);
        }
        return this.invWidth * this.switchingFunction.firstDerivative(x);
    }

    @Override
    public int getHighestOrderZeroDerivative() {
        return Math.min(this.switchingFunction.getHighestOrderZeroDerivative(), this.secondSwitchingFunction.getHighestOrderZeroDerivative());
    }

    @Override
    public double getOneBound() {
        return this.midpoint + this.halfWidth;
    }

    @Override
    public double getZeroBound() {
        return this.midpoint - this.halfWidth;
    }

    @Override
    public double nthDerivative(double x, int order) throws IllegalArgumentException {
        double mult = FastMath.pow((double)this.invWidth, (int)order);
        if (x > this.midpoint) {
            return mult * this.secondSwitchingFunction.nthDerivative(x, order);
        }
        return mult * this.switchingFunction.nthDerivative(x, order);
    }

    @Override
    public double secondDerivative(double x) {
        if (x > this.midpoint) {
            return this.invWidth * this.invWidth * this.secondSwitchingFunction.secondDerivative(x);
        }
        return this.invWidth * this.invWidth * this.switchingFunction.secondDerivative(x);
    }

    @Override
    public boolean symmetricToUnity() {
        return this.switchingFunction.symmetricToUnity() && this.secondSwitchingFunction.symmetricToUnity();
    }

    public String toString() {
        return String.format(" Spliced 5'th order Hermite splines with midpoint %11.5g, width %11.5g", this.midpoint, 2.0 * this.halfWidth);
    }

    @Override
    public boolean validOutsideBounds() {
        return this.switchingFunction.validOutsideBounds() && this.secondSwitchingFunction.validOutsideBounds();
    }

    @Override
    public double valueAt(double x) throws IllegalArgumentException {
        if (x > this.midpoint) {
            return this.secondSwitchingFunction.valueAt(x);
        }
        return this.switchingFunction.valueAt(x);
    }
}

