/*
 * Decompiled with CFR 0.152.
 */
package ffx.numerics.spline;

import java.util.Arrays;

public class UniformBSpline {
    private UniformBSpline() {
    }

    public static void bSpline(double x, int order, double[] coefficients) {
        coefficients[0] = 1.0 - x;
        coefficients[1] = x;
        for (int k = 2; k < order; ++k) {
            UniformBSpline.bSplineRecursion(x, k, coefficients, coefficients);
        }
    }

    public static void bSplineDerivatives(double x, int order, int deriveOrder, double[][] coefficients, double[][] work) {
        int k;
        assert (deriveOrder <= order - 1 && deriveOrder <= 5);
        for (k = 0; k < order; ++k) {
            Arrays.fill(work[k], 0.0);
        }
        work[1][0] = 1.0 - x;
        work[1][1] = x;
        work[2][0] = 0.5 * (1.0 - x) * work[1][0];
        work[2][1] = 0.5 * ((x + 1.0) * work[1][0] + (2.0 - x) * work[1][1]);
        work[2][2] = 0.5 * x * work[1][1];
        for (k = 3; k < order; ++k) {
            UniformBSpline.bSplineRecursion(x, k, work[k - 1], work[k]);
        }
        int o1 = order - 1;
        try {
            if (deriveOrder > 0) {
                int o2 = order - 2;
                UniformBSpline.bSplineDiff(work[o2], o1);
                if (deriveOrder > 1) {
                    int o3 = order - 3;
                    UniformBSpline.bSplineDiff(work[o3], o2);
                    UniformBSpline.bSplineDiff(work[o3], o1);
                    if (deriveOrder > 2) {
                        int o4 = order - 4;
                        UniformBSpline.bSplineDiff(work[o4], o3);
                        UniformBSpline.bSplineDiff(work[o4], o2);
                        UniformBSpline.bSplineDiff(work[o4], o1);
                        if (deriveOrder > 3) {
                            int o5 = order - 5;
                            UniformBSpline.bSplineDiff(work[o5], o4);
                            UniformBSpline.bSplineDiff(work[o5], o3);
                            UniformBSpline.bSplineDiff(work[o5], o2);
                            UniformBSpline.bSplineDiff(work[o5], o1);
                            if (deriveOrder > 4) {
                                int o6 = order - 6;
                                UniformBSpline.bSplineDiff(work[o6], o5);
                                UniformBSpline.bSplineDiff(work[o6], o4);
                                UniformBSpline.bSplineDiff(work[o6], o3);
                                UniformBSpline.bSplineDiff(work[o6], o2);
                                UniformBSpline.bSplineDiff(work[o6], o1);
                                if (deriveOrder > 5) {
                                    throw new Exception(" Unsupported option: dr_ord > 5");
                                }
                            }
                        }
                    }
                }
            }
        }
        catch (Exception o2) {
            // empty catch block
        }
        int deriveOrder1 = deriveOrder + 1;
        for (int k2 = 0; k2 < order; ++k2) {
            double[] tk = coefficients[k2];
            try {
                for (int j = 0; j < deriveOrder1; ++j) {
                    tk[j] = work[o1 - j][k2];
                }
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static void bSplineDiff(double[] coefficients, int order) {
        int order1 = order - 1;
        coefficients[order] = coefficients[order1];
        for (int i = order1; i > 0; --i) {
            coefficients[i] = coefficients[i - 1] - coefficients[i];
        }
        coefficients[0] = -coefficients[0];
    }

    private static void bSplineRecursion(double x, int order, double[] coefficients, double[] newCoefficients) {
        double div = 1.0 / (double)order;
        double k1mw = (double)order + (1.0 - x);
        int km1 = order - 1;
        newCoefficients[order] = div * x * coefficients[km1];
        for (int i = 1; i < order; ++i) {
            int kmi = order - i;
            int km1i = km1 - i;
            double x1 = x + (double)i;
            double k1mwi = k1mw - (double)i;
            newCoefficients[kmi] = div * (x1 * coefficients[km1i] + k1mwi * coefficients[kmi]);
        }
        double oneX = 1.0 - x;
        newCoefficients[0] = div * oneX * coefficients[0];
    }
}

