/*
 * Decompiled with CFR 0.152.
 */
package ffx.numerics.optimization;

import ffx.numerics.OptimizationInterface;
import ffx.numerics.optimization.LBFGS;
import org.apache.commons.math3.util.FastMath;

public class LineSearch {
    private static final double STEP_SCALE_FACTOR = 10.0;
    private static final double PARABOLIC_UPPER_LIMIT = 2.0;
    private static final double PARABOLIC_LOWER_LIMIT = 0.5;
    private static final double RESTART_STEP_SCALE = 10.0;
    private final int n;
    private final double[] s;
    private final double[] x0;
    private OptimizationInterface optimizationSystem;
    private int[] functionEvaluations;
    private LineSearchResult[] info;
    private double[] x;
    private double[] g;
    private double step;
    private int interpolation;
    private double f0;
    private double fA;
    private double fB;
    private double fC;
    private double sg0;
    private double sgA;
    private double sgB;
    private double sgC;
    private boolean restart;

    LineSearch(int n) {
        this.s = new double[n];
        this.x0 = new double[n];
        this.n = n;
    }

    public double search(int n, double[] x, double f, double[] g, double[] p, double[] angle, double fMove, LineSearchResult[] info, int[] functionEvaluations, OptimizationInterface optimizationSystem) {
        if (n <= 0) {
            throw new IllegalArgumentException("Number of variables must be positive");
        }
        if (x == null || x.length < n) {
            throw new IllegalArgumentException("Coordinate array is null or too small");
        }
        if (g == null || g.length < n) {
            throw new IllegalArgumentException("Gradient array is null or too small");
        }
        if (p == null || p.length < n) {
            throw new IllegalArgumentException("Search direction array is null or too small");
        }
        if (angle == null || angle.length < 1) {
            throw new IllegalArgumentException("Angle array is null or too small");
        }
        if (info == null || info.length < 1) {
            throw new IllegalArgumentException("Info array is null or too small");
        }
        if (functionEvaluations == null || functionEvaluations.length < 1) {
            throw new IllegalArgumentException("Function evaluations array is null or too small");
        }
        if (optimizationSystem == null) {
            throw new IllegalArgumentException("Optimization system cannot be null");
        }
        this.x = x;
        this.g = g;
        this.optimizationSystem = optimizationSystem;
        this.functionEvaluations = functionEvaluations;
        this.info = info;
        this.fA = 0.0;
        this.fB = 0.0;
        this.fC = 0.0;
        this.sgA = 0.0;
        this.sgB = 0.0;
        this.sgC = 0.0;
        info[0] = null;
        System.arraycopy(p, 0, this.s, 0, n);
        double gNorm = FastMath.sqrt((double)LBFGS.v1DotV2(n, g, 0, 1, g, 0, 1));
        double sNorm = FastMath.sqrt((double)LBFGS.v1DotV2(n, this.s, 0, 1, this.s, 0, 1));
        if (sNorm < Double.MIN_NORMAL) {
            info[0] = LineSearchResult.IntplnErr;
            return f;
        }
        this.f0 = f;
        System.arraycopy(x, 0, this.x0, 0, n);
        int i = 0;
        while (i < n) {
            int n2 = i++;
            this.s[n2] = this.s[n2] / sNorm;
        }
        this.sg0 = LBFGS.v1DotV2(n, this.s, 0, 1, g, 0, 1);
        double cosang = gNorm < Double.MIN_NORMAL ? 0.0 : -this.sg0 / gNorm;
        cosang = FastMath.min((double)1.0, (double)FastMath.max((double)-1.0, (double)cosang));
        angle[0] = FastMath.toDegrees((double)FastMath.acos((double)cosang));
        if (angle[0] > 180.0) {
            info[0] = LineSearchResult.WideAngle;
            return f;
        }
        this.step = this.sg0 != 0.0 ? 2.0 * FastMath.abs((double)(fMove / this.sg0)) : sNorm;
        this.step = FastMath.min((double)this.step, (double)sNorm);
        this.step = FastMath.min((double)FastMath.max((double)this.step, (double)1.0E-16), (double)5.0);
        return this.begin();
    }

    private double begin() {
        this.restart = true;
        this.interpolation = 0;
        this.fB = this.f0;
        this.sgB = this.sg0;
        return this.step();
    }

    private double step() {
        this.fA = this.fB;
        this.sgA = this.sgB;
        LBFGS.aV1PlusV2(this.n, this.step, this.s, 0, 1, this.x, 0, 1);
        this.functionEvaluations[0] = this.functionEvaluations[0] + 1;
        this.fB = this.optimizationSystem.energyAndGradient(this.x, this.g);
        this.sgB = LBFGS.v1DotV2(this.n, this.s, 0, 1, this.g, 0, 1);
        if (FastMath.abs((double)(this.sgB / this.sgA)) >= 10000.0 && this.restart) {
            System.arraycopy(this.x0, 0, this.x, 0, this.n);
            this.step /= 10.0;
            this.info[0] = LineSearchResult.ScaleStep;
            this.begin();
        }
        this.restart = false;
        if (FastMath.abs((double)(this.sgB / this.sg0)) <= 0.9 && this.fB < this.fA) {
            if (this.info[0] == null) {
                this.info[0] = LineSearchResult.Success;
            }
            this.f0 = this.fB;
            this.sg0 = this.sgB;
            return this.f0;
        }
        if (this.sgB * this.sgA < 0.0 || this.fB > this.fA) {
            return this.cubic();
        }
        this.step = 2.0 * this.step;
        if (this.sgB > this.sgA) {
            double parab = (this.fA - this.fB) / (this.sgB - this.sgA);
            this.step = parab = FastMath.min((double)(2.0 * this.step), (double)FastMath.max((double)(0.5 * this.step), (double)parab));
        }
        this.step = FastMath.min((double)this.step, (double)5.0);
        return this.step();
    }

    private double cubic() {
        double sg1;
        double cubstp;
        ++this.interpolation;
        double sss = 3.0 * (this.fB - this.fA) / this.step - this.sgA - this.sgB;
        double ttt = sss * sss - this.sgA * this.sgB;
        if (ttt < 0.0) {
            this.info[0] = LineSearchResult.IntplnErr;
            this.f0 = this.fB;
            this.sg0 = this.sgB;
            return this.f0;
        }
        double cube = this.step * (this.sgB + (ttt = FastMath.sqrt((double)ttt)) + sss) / (this.sgB - this.sgA + 2.0 * ttt);
        if (cube < 0.0 || cube > this.step) {
            this.info[0] = LineSearchResult.IntplnErr;
            this.f0 = this.fB;
            this.sg0 = this.sgB;
            return this.f0;
        }
        LBFGS.aV1PlusV2(this.n, -cube, this.s, 0, 1, this.x, 0, 1);
        this.functionEvaluations[0] = this.functionEvaluations[0] + 1;
        this.fC = this.optimizationSystem.energyAndGradient(this.x, this.g);
        this.sgC = LBFGS.v1DotV2(this.n, this.s, 0, 1, this.g, 0, 1);
        if (FastMath.abs((double)(this.sgC / this.sg0)) <= 0.9) {
            if (this.info[0] == null) {
                this.info[0] = LineSearchResult.Success;
            }
            this.f0 = this.fC;
            this.sg0 = this.sgC;
            return this.f0;
        }
        if ((this.fC <= this.fA || this.fC <= this.fB) && (cubstp = FastMath.min((double)FastMath.abs((double)cube), (double)FastMath.abs((double)(this.step - cube)))) >= 1.0E-16 && this.interpolation < 5) {
            if (this.sgA * this.sgB < 0.0) {
                if (this.sgA * this.sgC < 0.0) {
                    this.fB = this.fC;
                    this.sgB = this.sgC;
                    this.step -= cube;
                } else {
                    this.fA = this.fC;
                    this.sgA = this.sgC;
                    this.step = cube;
                    LBFGS.aV1PlusV2(this.n, cube, this.s, 0, 1, this.x, 0, 1);
                }
            } else if (this.sgA * this.sgC < 0.0 || this.fA <= this.fC) {
                this.fB = this.fC;
                this.sgB = this.sgC;
                this.step -= cube;
            } else {
                this.fA = this.fC;
                this.sgA = this.sgC;
                this.step = cube;
                LBFGS.aV1PlusV2(this.n, cube, this.s, 0, 1, this.x, 0, 1);
            }
            return this.cubic();
        }
        double f1 = FastMath.min((double)this.fA, (double)FastMath.min((double)this.fB, (double)this.fC));
        if (f1 == this.fA) {
            sg1 = this.sgA;
            LBFGS.aV1PlusV2(this.n, cube - this.step, this.s, 0, 1, this.x, 0, 1);
        } else if (f1 == this.fB) {
            sg1 = this.sgB;
            LBFGS.aV1PlusV2(this.n, cube, this.s, 0, 1, this.x, 0, 1);
        } else {
            sg1 = this.sgC;
        }
        if (f1 > this.f0) {
            this.functionEvaluations[0] = this.functionEvaluations[0] + 1;
            this.f0 = this.optimizationSystem.energyAndGradient(this.x, this.g);
            this.sg0 = LBFGS.v1DotV2(this.n, this.s, 0, 1, this.g, 0, 1);
            this.info[0] = LineSearchResult.IntplnErr;
            return this.f0;
        }
        this.f0 = f1;
        this.sg0 = sg1;
        if (sg1 > 0.0) {
            int i = 0;
            while (i < this.n) {
                int n = i++;
                this.s[n] = this.s[n] * -1.0;
            }
            this.sg0 = -sg1;
        }
        this.step = FastMath.max((double)cube, (double)(this.step - cube)) / 10.0;
        this.step = FastMath.max((double)this.step, (double)1.0E-16);
        if (this.info[0] == LineSearchResult.ReSearch) {
            this.functionEvaluations[0] = this.functionEvaluations[0] + 1;
            this.f0 = this.optimizationSystem.energyAndGradient(this.x, this.g);
            this.sg0 = LBFGS.v1DotV2(this.n, this.s, 0, 1, this.g, 0, 1);
            this.info[0] = LineSearchResult.BadIntpln;
            return this.f0;
        }
        this.info[0] = LineSearchResult.ReSearch;
        return this.begin();
    }

    public static enum LineSearchResult {
        Success,
        WideAngle,
        ScaleStep,
        IntplnErr,
        ReSearch,
        BadIntpln;

    }
}

