/*
 * Decompiled with CFR 0.152.
 */
package ffx.numerics.multipole;

import ffx.numerics.multipole.CoulombTensorQISIMD;
import ffx.numerics.multipole.Operator;
import ffx.numerics.multipole.TholeTensorGlobalSIMD;
import jdk.incubator.vector.DoubleVector;

public class TholeTensorQISIMD
extends CoulombTensorQISIMD {
    private DoubleVector thole;
    private DoubleVector AiAk;

    public TholeTensorQISIMD(int order, DoubleVector thole, DoubleVector AiAk) {
        super(order);
        this.thole = thole;
        this.AiAk = AiAk;
        this.operator = Operator.THOLE_FIELD;
        assert (order <= 4);
    }

    public void setThole(DoubleVector thole, DoubleVector AiAk) {
        this.thole = thole;
        this.AiAk = AiAk;
    }

    public boolean checkThole(DoubleVector r) {
        return TholeTensorGlobalSIMD.checkThole(this.thole, this.AiAk, r);
    }

    @Override
    protected void source(DoubleVector[] T000) {
        super.source(T000);
        TholeTensorGlobalSIMD.tholeSource(this.thole, this.AiAk, this.R, T000);
    }
}

