/*
 * Decompiled with CFR 0.152.
 */
package ffx.numerics.multipole;

import ffx.numerics.multipole.CoulombTensorQI;
import ffx.numerics.multipole.Operator;
import ffx.numerics.multipole.TholeTensorGlobal;

public class TholeTensorQI
extends CoulombTensorQI {
    private double thole;
    private double AiAk;

    public TholeTensorQI(int order, double thole, double AiAk) {
        super(order);
        this.thole = thole;
        this.AiAk = AiAk;
        this.operator = Operator.THOLE_FIELD;
        assert (order <= 4);
    }

    public void setThole(double thole, double AiAk) {
        this.thole = thole;
        this.AiAk = AiAk;
    }

    public boolean checkThole(double r) {
        return TholeTensorGlobal.checkThole(this.thole, this.AiAk, r);
    }

    @Override
    protected void source(double[] T000) {
        super.source(T000);
        TholeTensorGlobal.tholeSource(this.thole, this.AiAk, this.R, false, T000);
    }
}

