/*
 * Decompiled with CFR 0.152.
 */
package ffx.numerics.multipole;

import ffx.numerics.multipole.CoulombTensorGlobalSIMD;
import ffx.numerics.multipole.Operator;
import jdk.incubator.vector.DoubleVector;
import jdk.incubator.vector.Vector;
import jdk.incubator.vector.VectorMask;
import jdk.incubator.vector.VectorOperators;
import jdk.incubator.vector.VectorSpecies;

public class TholeTensorGlobalSIMD
extends CoulombTensorGlobalSIMD {
    private static final double threeFifths = 0.6;
    private static final double oneThirtyFifth = 0.02857142857142857;
    private DoubleVector thole;
    private DoubleVector AiAk;

    public TholeTensorGlobalSIMD(int order, DoubleVector thole, DoubleVector AiAk) {
        super(order);
        this.thole = thole;
        this.AiAk = AiAk;
        this.operator = Operator.THOLE_FIELD;
        assert (order <= 4);
    }

    public void setThole(DoubleVector thole, DoubleVector AiAk) {
        this.thole = thole;
        this.AiAk = AiAk;
    }

    public boolean checkThole(DoubleVector r) {
        return TholeTensorGlobalSIMD.checkThole(this.thole, this.AiAk, r);
    }

    protected static boolean checkThole(DoubleVector thole, DoubleVector AiAk, DoubleVector r) {
        DoubleVector rAiAk = r.mul((Vector)AiAk);
        VectorMask check = thole.mul((Vector)rAiAk).mul((Vector)rAiAk).mul((Vector)rAiAk).lt(50.0);
        return check.anyTrue();
    }

    @Override
    protected void source(DoubleVector[] T000) {
        super.source(T000);
        TholeTensorGlobalSIMD.tholeSource(this.thole, this.AiAk, this.R, T000);
    }

    protected static void tholeSource(DoubleVector thole, DoubleVector AiAk, DoubleVector R, DoubleVector[] T000) {
        DoubleVector u = R.mul((Vector)AiAk);
        DoubleVector u3 = thole.mul((Vector)u.mul((Vector)u).mul((Vector)u));
        DoubleVector u6 = u3.mul((Vector)u3);
        DoubleVector u9 = u6.mul((Vector)u3);
        DoubleVector expU3 = u3.neg().lanewise(VectorOperators.EXP);
        T000[0] = DoubleVector.zero((VectorSpecies)R.species());
        T000[1] = T000[1].mul((Vector)expU3);
        T000[2] = T000[2].mul((Vector)u3.add(1.0).mul((Vector)expU3));
        T000[3] = T000[3].mul((Vector)u3.add(1.0).add((Vector)u6.mul(0.6)).mul((Vector)expU3));
        T000[4] = T000[4].mul((Vector)u3.add(1.0).add((Vector)u6.mul(18.0).add((Vector)u9.mul(9.0)).mul(0.02857142857142857)).mul((Vector)expU3));
    }
}

