/*
 * Decompiled with CFR 0.152.
 */
package ffx.numerics.multipole;

import ffx.numerics.multipole.CoulombTensorGlobal;
import ffx.numerics.multipole.Operator;
import org.apache.commons.math3.util.FastMath;

public class TholeTensorGlobal
extends CoulombTensorGlobal {
    private static final double threeFifths = 0.6;
    private static final double oneThirtyFifth = 0.02857142857142857;
    private double thole;
    private double AiAk;
    private boolean directDamping;

    public TholeTensorGlobal(int order, double thole, double AiAk) {
        super(order);
        this.thole = thole;
        this.AiAk = AiAk;
        this.operator = Operator.THOLE_FIELD;
        assert (order <= 4);
    }

    public TholeTensorGlobal(int order, double thole, double AiAk, boolean directDamping) {
        this(order, thole, AiAk);
        this.directDamping = directDamping;
        if (directDamping) {
            this.operator = Operator.THOLE_DIRECT_FIELD;
        }
    }

    public void setThole(double thole, double AiAk) {
        this.thole = thole;
        this.AiAk = AiAk;
    }

    public boolean checkThole(double r) {
        return TholeTensorGlobal.checkThole(this.thole, this.AiAk, r);
    }

    protected static boolean checkThole(double thole, double AiAk, double r) {
        double rAiAk = r * AiAk;
        return -thole * rAiAk * rAiAk * rAiAk > -50.0;
    }

    @Override
    protected void source(double[] T000) {
        super.source(T000);
        TholeTensorGlobal.tholeSource(this.thole, this.AiAk, this.R, this.directDamping, T000);
    }

    protected static void tholeSource(double thole, double AiAk, double R, boolean direct, double[] T000) {
        if (!direct) {
            double u = R * AiAk;
            double u3 = thole * u * u * u;
            double u6 = u3 * u3;
            double u9 = u6 * u3;
            double expU3 = FastMath.exp((double)(-u3));
            T000[0] = 0.0;
            T000[1] = T000[1] * expU3;
            T000[2] = T000[2] * ((1.0 + u3) * expU3);
            T000[3] = T000[3] * ((1.0 + u3 + 0.6 * u6) * expU3);
            T000[4] = T000[4] * ((1.0 + u3 + (18.0 * u6 + 9.0 * u9) * 0.02857142857142857) * expU3);
        } else {
            double u = R * AiAk;
            double u32 = thole * Math.pow(u, 1.5);
            double u62 = u32 * u32;
            double expU32 = FastMath.exp((double)(-u32));
            T000[0] = 0.0;
            T000[1] = T000[1] * (1.0 - expU32);
            T000[2] = T000[2] * (1.0 - (1.0 + 0.5 * u32) * expU32);
            T000[3] = T000[3] * (1.0 - (1.0 + (39.0 * u32 + 9.0 * u62) / 60.0) * expU32);
            T000[4] = T000[4] * (1.0 - (1.0 + (609.0 * u32 + 189.0 * u62 + 27.0 * u62 * u32) / 840.0) * expU32);
        }
    }
}

