/*
 * Decompiled with CFR 0.152.
 */
package ffx.numerics.multipole;

import ffx.numerics.multipole.PolarizableMultipoleSIMD;
import java.util.Arrays;
import jdk.incubator.vector.DoubleVector;
import jdk.incubator.vector.Vector;
import jdk.incubator.vector.VectorMask;
import jdk.incubator.vector.VectorSpecies;

public class QIFrameSIMD {
    private DoubleVector r00Vec;
    private DoubleVector r01Vec;
    private DoubleVector r02Vec;
    private DoubleVector r10Vec;
    private DoubleVector r11Vec;
    private DoubleVector r12Vec;
    private DoubleVector r20Vec;
    private DoubleVector r21Vec;
    private DoubleVector r22Vec;
    private DoubleVector ir00Vec;
    private DoubleVector ir01Vec;
    private DoubleVector ir02Vec;
    private DoubleVector ir10Vec;
    private DoubleVector ir11Vec;
    private DoubleVector ir12Vec;
    private DoubleVector ir20Vec;
    private DoubleVector ir21Vec;
    private DoubleVector ir22Vec;

    public QIFrameSIMD() {
        DoubleVector zero = DoubleVector.broadcast((VectorSpecies)DoubleVector.SPECIES_PREFERRED, (double)0.0);
        this.setQIVector(zero, zero, zero);
    }

    public QIFrameSIMD(DoubleVector dx, DoubleVector dy, DoubleVector dz) {
        this.setQIVector(dx, dy, dz);
    }

    public QIFrameSIMD(DoubleVector[] r) {
        this.setQIVector(r[0], r[1], r[2]);
    }

    public void setQIVector(DoubleVector[] r) {
        this.setQIVector(r[0], r[1], r[2]);
    }

    public final void setQIVector(DoubleVector dx, DoubleVector dy, DoubleVector dz) {
        DoubleVector[] zAxis = new DoubleVector[]{dx, dy, dz};
        DoubleVector[] xAxis = Arrays.copyOf(zAxis, 3);
        VectorMask qiVectorIsXAxis = dz.eq(0.0).and(dy.eq(0.0));
        xAxis[1] = xAxis[1].add(1.0, qiVectorIsXAxis);
        xAxis[0] = xAxis[0].add(1.0, qiVectorIsXAxis.not());
        QIFrameSIMD.normalizeVec(zAxis, zAxis);
        this.ir02Vec = zAxis[0];
        this.ir12Vec = zAxis[1];
        this.ir22Vec = zAxis[2];
        DoubleVector dot = QIFrameSIMD.dotVec(xAxis, zAxis);
        QIFrameSIMD.scaleVec(zAxis, dot, zAxis);
        QIFrameSIMD.subVec(xAxis, zAxis, xAxis);
        QIFrameSIMD.normalizeVec(xAxis, xAxis);
        this.ir00Vec = xAxis[0];
        this.ir10Vec = xAxis[1];
        this.ir20Vec = xAxis[2];
        this.ir01Vec = this.ir20Vec.mul((Vector)this.ir12Vec).sub((Vector)this.ir10Vec.mul((Vector)this.ir22Vec));
        this.ir11Vec = this.ir00Vec.mul((Vector)this.ir22Vec).sub((Vector)this.ir20Vec.mul((Vector)this.ir02Vec));
        this.ir21Vec = this.ir10Vec.mul((Vector)this.ir02Vec).sub((Vector)this.ir00Vec.mul((Vector)this.ir12Vec));
        this.r00Vec = this.ir00Vec;
        this.r11Vec = this.ir11Vec;
        this.r22Vec = this.ir22Vec;
        this.r01Vec = this.ir10Vec;
        this.r02Vec = this.ir20Vec;
        this.r10Vec = this.ir01Vec;
        this.r12Vec = this.ir21Vec;
        this.r20Vec = this.ir02Vec;
        this.r21Vec = this.ir12Vec;
    }

    public static DoubleVector dotVec(DoubleVector[] a, DoubleVector[] b) {
        return a[0].fma((Vector)b[0], (Vector)a[1].fma((Vector)b[1], (Vector)a[2].mul((Vector)b[2])));
    }

    public static DoubleVector[] scaleVec(DoubleVector[] a, DoubleVector scale, DoubleVector[] ret) {
        ret[0] = a[0].mul((Vector)scale);
        ret[1] = a[1].mul((Vector)scale);
        ret[2] = a[2].mul((Vector)scale);
        return ret;
    }

    public static DoubleVector[] subVec(DoubleVector[] a, DoubleVector[] b, DoubleVector[] ret) {
        ret[0] = a[0].sub((Vector)b[0]);
        ret[1] = a[1].sub((Vector)b[1]);
        ret[2] = a[2].sub((Vector)b[2]);
        return ret;
    }

    public static DoubleVector[] normalizeVec(DoubleVector[] n, DoubleVector[] ret) {
        return QIFrameSIMD.scaleVec(n, DoubleVector.broadcast((VectorSpecies)DoubleVector.SPECIES_PREFERRED, (double)1.0).div((Vector)QIFrameSIMD.dotVec(n, n).sqrt()), ret);
    }

    public void setAndRotate(DoubleVector[] r, PolarizableMultipoleSIMD mI, PolarizableMultipoleSIMD mK) {
        this.setAndRotate(r[0], r[1], r[2], mI, mK);
    }

    public void setAndRotate(DoubleVector dx, DoubleVector dy, DoubleVector dz, PolarizableMultipoleSIMD mI, PolarizableMultipoleSIMD mK) {
        this.setQIVector(dx, dy, dz);
        this.rotatePolarizableMultipole(mI);
        this.rotatePolarizableMultipole(mK);
    }

    public void rotatePolarizableMultipole(PolarizableMultipoleSIMD m) {
        this.rotatePermanentMultipole(m);
        this.rotateInducedDipoles(m);
    }

    public void rotatePermanentMultipole(PolarizableMultipoleSIMD m) {
        DoubleVector dx = m.dx;
        DoubleVector dy = m.dy;
        DoubleVector dz = m.dz;
        m.dx = this.r00Vec.mul((Vector)dx).add((Vector)this.r01Vec.mul((Vector)dy)).add((Vector)this.r02Vec.mul((Vector)dz));
        m.dy = this.r10Vec.mul((Vector)dx).add((Vector)this.r11Vec.mul((Vector)dy)).add((Vector)this.r12Vec.mul((Vector)dz));
        m.dz = this.r20Vec.mul((Vector)dx).add((Vector)this.r21Vec.mul((Vector)dy)).add((Vector)this.r22Vec.mul((Vector)dz));
        DoubleVector qxx = m.qxx;
        DoubleVector qyy = m.qyy;
        DoubleVector qzz = m.qzz;
        DoubleVector qxy = m.qxy.mul(0.5);
        DoubleVector qxz = m.qxz.mul(0.5);
        DoubleVector qyz = m.qyz.mul(0.5);
        m.qxx = this.r00Vec.mul((Vector)this.r00Vec.mul((Vector)qxx).add((Vector)this.r01Vec.mul((Vector)qxy)).add((Vector)this.r02Vec.mul((Vector)qxz))).add((Vector)this.r01Vec.mul((Vector)this.r00Vec.mul((Vector)qxy).add((Vector)this.r01Vec.mul((Vector)qyy)).add((Vector)this.r02Vec.mul((Vector)qyz)))).add((Vector)this.r02Vec.mul((Vector)this.r00Vec.mul((Vector)qxz).add((Vector)this.r01Vec.mul((Vector)qyz)).add((Vector)this.r02Vec.mul((Vector)qzz))));
        m.qxy = this.r00Vec.mul((Vector)this.r10Vec.mul((Vector)qxx).add((Vector)this.r11Vec.mul((Vector)qxy)).add((Vector)this.r12Vec.mul((Vector)qxz))).add((Vector)this.r01Vec.mul((Vector)this.r10Vec.mul((Vector)qxy).add((Vector)this.r11Vec.mul((Vector)qyy)).add((Vector)this.r12Vec.mul((Vector)qyz)))).add((Vector)this.r02Vec.mul((Vector)this.r10Vec.mul((Vector)qxz).add((Vector)this.r11Vec.mul((Vector)qyz)).add((Vector)this.r12Vec.mul((Vector)qzz))));
        m.qxy = m.qxy.mul(2.0);
        m.qxz = this.r00Vec.mul((Vector)this.r20Vec.mul((Vector)qxx).add((Vector)this.r21Vec.mul((Vector)qxy)).add((Vector)this.r22Vec.mul((Vector)qxz))).add((Vector)this.r01Vec.mul((Vector)this.r20Vec.mul((Vector)qxy).add((Vector)this.r21Vec.mul((Vector)qyy)).add((Vector)this.r22Vec.mul((Vector)qyz)))).add((Vector)this.r02Vec.mul((Vector)this.r20Vec.mul((Vector)qxz).add((Vector)this.r21Vec.mul((Vector)qyz)).add((Vector)this.r22Vec.mul((Vector)qzz))));
        m.qxz = m.qxz.mul(2.0);
        m.qyy = this.r10Vec.mul((Vector)this.r10Vec.mul((Vector)qxx).add((Vector)this.r11Vec.mul((Vector)qxy)).add((Vector)this.r12Vec.mul((Vector)qxz))).add((Vector)this.r11Vec.mul((Vector)this.r10Vec.mul((Vector)qxy).add((Vector)this.r11Vec.mul((Vector)qyy)).add((Vector)this.r12Vec.mul((Vector)qyz)))).add((Vector)this.r12Vec.mul((Vector)this.r10Vec.mul((Vector)qxz).add((Vector)this.r11Vec.mul((Vector)qyz)).add((Vector)this.r12Vec.mul((Vector)qzz))));
        m.qyz = this.r10Vec.mul((Vector)this.r20Vec.mul((Vector)qxx).add((Vector)this.r21Vec.mul((Vector)qxy)).add((Vector)this.r22Vec.mul((Vector)qxz))).add((Vector)this.r11Vec.mul((Vector)this.r20Vec.mul((Vector)qxy).add((Vector)this.r21Vec.mul((Vector)qyy)).add((Vector)this.r22Vec.mul((Vector)qyz)))).add((Vector)this.r12Vec.mul((Vector)this.r20Vec.mul((Vector)qxz).add((Vector)this.r21Vec.mul((Vector)qyz)).add((Vector)this.r22Vec.mul((Vector)qzz))));
        m.qyz = m.qyz.mul(2.0);
        m.qzz = this.r20Vec.mul((Vector)this.r20Vec.mul((Vector)qxx).add((Vector)this.r21Vec.mul((Vector)qxy)).add((Vector)this.r22Vec.mul((Vector)qxz))).add((Vector)this.r21Vec.mul((Vector)this.r20Vec.mul((Vector)qxy).add((Vector)this.r21Vec.mul((Vector)qyy)).add((Vector)this.r22Vec.mul((Vector)qyz)))).add((Vector)this.r22Vec.mul((Vector)this.r20Vec.mul((Vector)qxz).add((Vector)this.r21Vec.mul((Vector)qyz)).add((Vector)this.r22Vec.mul((Vector)qzz))));
    }

    public void rotateInducedDipoles(PolarizableMultipoleSIMD m) {
        DoubleVector dx = m.ux;
        DoubleVector dy = m.uy;
        DoubleVector dz = m.uz;
        m.ux = this.r00Vec.mul((Vector)dx).add((Vector)this.r01Vec.mul((Vector)dy)).add((Vector)this.r02Vec.mul((Vector)dz));
        m.uy = this.r10Vec.mul((Vector)dx).add((Vector)this.r11Vec.mul((Vector)dy)).add((Vector)this.r12Vec.mul((Vector)dz));
        m.uz = this.r20Vec.mul((Vector)dx).add((Vector)this.r21Vec.mul((Vector)dy)).add((Vector)this.r22Vec.mul((Vector)dz));
        dx = m.px;
        dy = m.py;
        dz = m.pz;
        m.px = this.r00Vec.mul((Vector)dx).add((Vector)this.r01Vec.mul((Vector)dy)).add((Vector)this.r02Vec.mul((Vector)dz));
        m.py = this.r10Vec.mul((Vector)dx).add((Vector)this.r11Vec.mul((Vector)dy)).add((Vector)this.r12Vec.mul((Vector)dz));
        m.pz = this.r20Vec.mul((Vector)dx).add((Vector)this.r21Vec.mul((Vector)dy)).add((Vector)this.r22Vec.mul((Vector)dz));
        m.sx = m.ux.add((Vector)m.px).mul(0.5);
        m.sy = m.uy.add((Vector)m.py).mul(0.5);
        m.sz = m.uz.add((Vector)m.pz).mul(0.5);
    }

    public void toGlobal(DoubleVector[] v) {
        DoubleVector vx = v[0];
        DoubleVector vy = v[1];
        DoubleVector vz = v[2];
        v[0] = this.ir00Vec.mul((Vector)vx).add((Vector)this.ir01Vec.mul((Vector)vy)).add((Vector)this.ir02Vec.mul((Vector)vz));
        v[1] = this.ir10Vec.mul((Vector)vx).add((Vector)this.ir11Vec.mul((Vector)vy)).add((Vector)this.ir12Vec.mul((Vector)vz));
        v[2] = this.ir20Vec.mul((Vector)vx).add((Vector)this.ir21Vec.mul((Vector)vy)).add((Vector)this.ir22Vec.mul((Vector)vz));
    }
}

