/*
 * Decompiled with CFR 0.152.
 */
package ffx.numerics.multipole;

import ffx.numerics.math.DoubleMath;
import ffx.numerics.multipole.PolarizableMultipole;
import java.util.Arrays;

public class QIFrame {
    private double r00;
    private double r01;
    private double r02;
    private double r10;
    private double r11;
    private double r12;
    private double r20;
    private double r21;
    private double r22;
    private double ir00;
    private double ir01;
    private double ir02;
    private double ir10;
    private double ir11;
    private double ir12;
    private double ir20;
    private double ir21;
    private double ir22;

    public QIFrame() {
        this.setQIVector(0.0, 0.0, 1.0);
    }

    public QIFrame(double dx, double dy, double dz) {
        this.setQIVector(dx, dy, dz);
    }

    public QIFrame(double[] r) {
        this.setQIVector(r[0], r[1], r[2]);
    }

    public void setQIVector(double[] r) {
        this.setQIVector(r[0], r[1], r[2]);
    }

    public final void setQIVector(double dx, double dy, double dz) {
        double[] zAxis = new double[]{dx, dy, dz};
        double[] xAxis = Arrays.copyOf(zAxis, 3);
        if (dy != 0.0 || dz != 0.0) {
            xAxis[0] = xAxis[0] + 1.0;
        } else {
            xAxis[1] = xAxis[1] + 1.0;
        }
        DoubleMath.normalize(zAxis, zAxis);
        this.ir02 = zAxis[0];
        this.ir12 = zAxis[1];
        this.ir22 = zAxis[2];
        double dot = DoubleMath.dot(xAxis, zAxis);
        DoubleMath.scale(zAxis, dot, zAxis);
        DoubleMath.sub(xAxis, zAxis, xAxis);
        DoubleMath.normalize(xAxis, xAxis);
        this.ir00 = xAxis[0];
        this.ir10 = xAxis[1];
        this.ir20 = xAxis[2];
        this.ir01 = this.ir20 * this.ir12 - this.ir10 * this.ir22;
        this.ir11 = this.ir00 * this.ir22 - this.ir20 * this.ir02;
        this.ir21 = this.ir10 * this.ir02 - this.ir00 * this.ir12;
        this.r00 = this.ir00;
        this.r11 = this.ir11;
        this.r22 = this.ir22;
        this.r01 = this.ir10;
        this.r02 = this.ir20;
        this.r10 = this.ir01;
        this.r12 = this.ir21;
        this.r20 = this.ir02;
        this.r21 = this.ir12;
    }

    public void setAndRotate(double[] r, PolarizableMultipole mI, PolarizableMultipole mK) {
        this.setAndRotate(r[0], r[1], r[2], mI, mK);
    }

    public void setAndRotate(double dx, double dy, double dz, PolarizableMultipole mI, PolarizableMultipole mK) {
        this.setQIVector(dx, dy, dz);
        this.rotatePolarizableMultipole(mI);
        this.rotatePolarizableMultipole(mK);
    }

    public void rotatePolarizableMultipole(PolarizableMultipole m) {
        this.rotatePermanentMultipole(m);
        this.rotateInducedDipoles(m);
    }

    public void rotatePermanentMultipole(PolarizableMultipole m) {
        double dx = m.dx;
        double dy = m.dy;
        double dz = m.dz;
        m.dx = this.r00 * dx + this.r01 * dy + this.r02 * dz;
        m.dy = this.r10 * dx + this.r11 * dy + this.r12 * dz;
        m.dz = this.r20 * dx + this.r21 * dy + this.r22 * dz;
        double qxx = m.qxx;
        double qyy = m.qyy;
        double qzz = m.qzz;
        double qxy = m.qxy * 0.5;
        double qxz = m.qxz * 0.5;
        double qyz = m.qyz * 0.5;
        m.qxx = this.r00 * (this.r00 * qxx + this.r01 * qxy + this.r02 * qxz) + this.r01 * (this.r00 * qxy + this.r01 * qyy + this.r02 * qyz) + this.r02 * (this.r00 * qxz + this.r01 * qyz + this.r02 * qzz);
        m.qxy = this.r00 * (this.r10 * qxx + this.r11 * qxy + this.r12 * qxz) + this.r01 * (this.r10 * qxy + this.r11 * qyy + this.r12 * qyz) + this.r02 * (this.r10 * qxz + this.r11 * qyz + this.r12 * qzz);
        m.qxy *= 2.0;
        m.qxz = this.r00 * (this.r20 * qxx + this.r21 * qxy + this.r22 * qxz) + this.r01 * (this.r20 * qxy + this.r21 * qyy + this.r22 * qyz) + this.r02 * (this.r20 * qxz + this.r21 * qyz + this.r22 * qzz);
        m.qxz *= 2.0;
        m.qyy = this.r10 * (this.r10 * qxx + this.r11 * qxy + this.r12 * qxz) + this.r11 * (this.r10 * qxy + this.r11 * qyy + this.r12 * qyz) + this.r12 * (this.r10 * qxz + this.r11 * qyz + this.r12 * qzz);
        m.qyz = this.r10 * (this.r20 * qxx + this.r21 * qxy + this.r22 * qxz) + this.r11 * (this.r20 * qxy + this.r21 * qyy + this.r22 * qyz) + this.r12 * (this.r20 * qxz + this.r21 * qyz + this.r22 * qzz);
        m.qyz *= 2.0;
        m.qzz = this.r20 * (this.r20 * qxx + this.r21 * qxy + this.r22 * qxz) + this.r21 * (this.r20 * qxy + this.r21 * qyy + this.r22 * qyz) + this.r22 * (this.r20 * qxz + this.r21 * qyz + this.r22 * qzz);
    }

    public void rotateInducedDipoles(PolarizableMultipole m) {
        double dx = m.ux;
        double dy = m.uy;
        double dz = m.uz;
        m.ux = this.r00 * dx + this.r01 * dy + this.r02 * dz;
        m.uy = this.r10 * dx + this.r11 * dy + this.r12 * dz;
        m.uz = this.r20 * dx + this.r21 * dy + this.r22 * dz;
        dx = m.px;
        dy = m.py;
        dz = m.pz;
        m.px = this.r00 * dx + this.r01 * dy + this.r02 * dz;
        m.py = this.r10 * dx + this.r11 * dy + this.r12 * dz;
        m.pz = this.r20 * dx + this.r21 * dy + this.r22 * dz;
        m.sx = (m.ux + m.px) * 0.5;
        m.sy = (m.uy + m.py) * 0.5;
        m.sz = (m.uz + m.pz) * 0.5;
    }

    public void toGlobal(double[] v) {
        double vx = v[0];
        double vy = v[1];
        double vz = v[2];
        v[0] = this.ir00 * vx + this.ir01 * vy + this.ir02 * vz;
        v[1] = this.ir10 * vx + this.ir11 * vy + this.ir12 * vz;
        v[2] = this.ir20 * vx + this.ir21 * vy + this.ir22 * vz;
    }
}

