/*
 * Decompiled with CFR 0.152.
 */
package ffx.numerics.multipole;

import jdk.incubator.vector.DoubleVector;
import jdk.incubator.vector.Vector;
import jdk.incubator.vector.VectorSpecies;

public class PolarizableMultipoleSIMD {
    private static final double oneThird = 0.3333333333333333;
    private static final double twoThirds = 0.6666666666666666;
    protected DoubleVector q;
    protected DoubleVector dx;
    protected DoubleVector dy;
    protected DoubleVector dz;
    protected DoubleVector qxx;
    protected DoubleVector qyy;
    protected DoubleVector qzz;
    protected DoubleVector qxy;
    protected DoubleVector qxz;
    protected DoubleVector qyz;
    protected DoubleVector ux;
    protected DoubleVector uy;
    protected DoubleVector uz;
    protected DoubleVector px;
    protected DoubleVector py;
    protected DoubleVector pz;
    protected DoubleVector sx;
    protected DoubleVector sy;
    protected DoubleVector sz;

    public PolarizableMultipoleSIMD() {
    }

    public PolarizableMultipoleSIMD(double[][] Q, double[][] u, double[][] uCR) {
        this.setPermanentMultipole(Q);
        this.setInducedDipole(u, uCR);
    }

    public void set(double[][] Q, double[][] u, double[][] uCR) {
        this.setPermanentMultipole(Q);
        this.setInducedDipole(u, uCR);
    }

    public final void setPermanentMultipole(double[][] Q) {
        this.q = DoubleVector.fromArray((VectorSpecies)DoubleVector.SPECIES_PREFERRED, (double[])Q[0], (int)0);
        this.dx = DoubleVector.fromArray((VectorSpecies)DoubleVector.SPECIES_PREFERRED, (double[])Q[1], (int)0);
        this.dy = DoubleVector.fromArray((VectorSpecies)DoubleVector.SPECIES_PREFERRED, (double[])Q[2], (int)0);
        this.dz = DoubleVector.fromArray((VectorSpecies)DoubleVector.SPECIES_PREFERRED, (double[])Q[3], (int)0);
        this.qxx = DoubleVector.fromArray((VectorSpecies)DoubleVector.SPECIES_PREFERRED, (double[])Q[4], (int)0).mul(0.3333333333333333);
        this.qyy = DoubleVector.fromArray((VectorSpecies)DoubleVector.SPECIES_PREFERRED, (double[])Q[5], (int)0).mul(0.3333333333333333);
        this.qzz = DoubleVector.fromArray((VectorSpecies)DoubleVector.SPECIES_PREFERRED, (double[])Q[6], (int)0).mul(0.3333333333333333);
        this.qxy = DoubleVector.fromArray((VectorSpecies)DoubleVector.SPECIES_PREFERRED, (double[])Q[7], (int)0).mul(0.6666666666666666);
        this.qxz = DoubleVector.fromArray((VectorSpecies)DoubleVector.SPECIES_PREFERRED, (double[])Q[8], (int)0).mul(0.6666666666666666);
        this.qyz = DoubleVector.fromArray((VectorSpecies)DoubleVector.SPECIES_PREFERRED, (double[])Q[9], (int)0).mul(0.6666666666666666);
    }

    public final void setInducedDipole(double[][] u, double[][] uCR) {
        this.ux = DoubleVector.fromArray((VectorSpecies)DoubleVector.SPECIES_PREFERRED, (double[])u[0], (int)0);
        this.uy = DoubleVector.fromArray((VectorSpecies)DoubleVector.SPECIES_PREFERRED, (double[])u[1], (int)0);
        this.uz = DoubleVector.fromArray((VectorSpecies)DoubleVector.SPECIES_PREFERRED, (double[])u[2], (int)0);
        this.px = DoubleVector.fromArray((VectorSpecies)DoubleVector.SPECIES_PREFERRED, (double[])uCR[0], (int)0);
        this.py = DoubleVector.fromArray((VectorSpecies)DoubleVector.SPECIES_PREFERRED, (double[])uCR[1], (int)0);
        this.pz = DoubleVector.fromArray((VectorSpecies)DoubleVector.SPECIES_PREFERRED, (double[])uCR[2], (int)0);
        this.sx = this.ux.add((Vector)this.px).mul(0.5);
        this.sy = this.uy.add((Vector)this.py).mul(0.5);
        this.sz = this.uz.add((Vector)this.pz).mul(0.5);
    }

    public final void applyMasks(DoubleVector scaleInduction, DoubleVector scaleEnergy) {
        this.sx = this.ux.mul((Vector)scaleEnergy).add((Vector)this.px.mul((Vector)scaleInduction)).mul(0.5);
        this.sy = this.uy.mul((Vector)scaleEnergy).add((Vector)this.py.mul((Vector)scaleInduction)).mul(0.5);
        this.sz = this.uz.mul((Vector)scaleEnergy).add((Vector)this.pz.mul((Vector)scaleInduction)).mul(0.5);
    }
}

