/*
 * Decompiled with CFR 0.152.
 */
package ffx.numerics.multipole;

public class PolarizableMultipole {
    private static final double oneThird = 0.3333333333333333;
    private static final double twoThirds = 0.6666666666666666;
    protected double q;
    protected double dx;
    protected double dy;
    protected double dz;
    protected double qxx;
    protected double qyy;
    protected double qzz;
    protected double qxy;
    protected double qxz;
    protected double qyz;
    protected double ux;
    protected double uy;
    protected double uz;
    protected double px;
    protected double py;
    protected double pz;
    protected double sx;
    protected double sy;
    protected double sz;
    protected double Z;

    public PolarizableMultipole() {
    }

    public PolarizableMultipole(double[] Q, double[] u, double[] uCR) {
        this.setPermanentMultipole(Q);
        this.setInducedDipole(u, uCR);
    }

    public PolarizableMultipole(double[] Q, double[] u, double[] uCR, double Z) {
        this.setPermanentMultipole(Q);
        this.setInducedDipole(u, uCR);
        this.Z = Z;
        this.q = -Z + this.q;
    }

    public void set(double[] Q, double[] u, double[] uCR) {
        this.setPermanentMultipole(Q);
        this.setInducedDipole(u, uCR);
    }

    public final void setPermanentMultipole(double[] Q) {
        this.q = Q[0];
        this.dx = Q[1];
        this.dy = Q[2];
        this.dz = Q[3];
        this.qxx = Q[4] * 0.3333333333333333;
        this.qyy = Q[5] * 0.3333333333333333;
        this.qzz = Q[6] * 0.3333333333333333;
        this.qxy = Q[7] * 0.6666666666666666;
        this.qxz = Q[8] * 0.6666666666666666;
        this.qyz = Q[9] * 0.6666666666666666;
    }

    public final void setInducedDipole(double[] u, double[] uCR) {
        this.ux = u[0];
        this.uy = u[1];
        this.uz = u[2];
        this.px = uCR[0];
        this.py = uCR[1];
        this.pz = uCR[2];
        this.sx = 0.5 * (this.ux + this.px);
        this.sy = 0.5 * (this.uy + this.py);
        this.sz = 0.5 * (this.uz + this.pz);
    }

    public void clearInducedDipoles() {
        this.ux = 0.0;
        this.uy = 0.0;
        this.uz = 0.0;
        this.px = 0.0;
        this.py = 0.0;
        this.pz = 0.0;
        this.sx = 0.0;
        this.sy = 0.0;
        this.sz = 0.0;
    }

    public final void applyMasks(double scaleInduction, double scaleEnergy) {
        this.sx = 0.5 * (this.ux * scaleEnergy + this.px * scaleInduction);
        this.sy = 0.5 * (this.uy * scaleEnergy + this.py * scaleInduction);
        this.sz = 0.5 * (this.uz * scaleEnergy + this.pz * scaleInduction);
    }
}

