/*
 * Decompiled with CFR 0.152.
 */
package ffx.numerics.multipole;

import ffx.numerics.math.ScalarMath;
import ffx.numerics.multipole.CoordinateSystem;
import ffx.numerics.multipole.MultipoleUtilities;
import ffx.numerics.multipole.Operator;
import ffx.numerics.multipole.PolarizableMultipole;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.math3.util.FastMath;

public abstract class MultipoleTensor {
    private static final Logger logger = Logger.getLogger(MultipoleTensor.class.getName());
    protected final int order;
    protected final int o1;
    protected final int il;
    protected final int im;
    protected final int in;
    protected final int size;
    protected Operator operator;
    protected final double[] coulombSource;
    protected final double[] work;
    protected final double[] T000;
    protected final CoordinateSystem coordinates;
    protected double R;
    protected double r2;
    protected double x;
    protected double y;
    protected double z;
    private double dEdZ = 0.0;
    private double d2EdZ2 = 0.0;
    double E000;
    double E100;
    double E010;
    double E001;
    double E200;
    double E020;
    double E002;
    double E110;
    double E101;
    double E011;
    double E300;
    double E030;
    double E003;
    double E210;
    double E201;
    double E120;
    double E021;
    double E102;
    double E012;
    double E111;
    double R000;
    double R100;
    double R010;
    double R001;
    double R200;
    double R020;
    double R002;
    double R110;
    double R101;
    double R011;
    double R300;
    double R030;
    double R003;
    double R210;
    double R201;
    double R120;
    double R021;
    double R102;
    double R012;
    double R111;
    double R400;
    double R040;
    double R004;
    double R310;
    double R301;
    double R130;
    double R031;
    double R103;
    double R013;
    double R220;
    double R202;
    double R022;
    double R211;
    double R121;
    double R112;
    double R500;
    double R050;
    double R005;
    double R410;
    double R401;
    double R140;
    double R041;
    double R104;
    double R014;
    double R320;
    double R302;
    double R230;
    double R032;
    double R203;
    double R023;
    double R311;
    double R131;
    double R113;
    double R221;
    double R212;
    double R122;
    double R006;
    double R402;
    double R042;
    double R204;
    double R024;
    double R222;
    double R600;
    double R060;
    double R510;
    double R501;
    double R150;
    double R051;
    double R105;
    double R015;
    double R420;
    double R240;
    double R411;
    double R141;
    double R114;
    double R330;
    double R303;
    double R033;
    double R321;
    double R231;
    double R213;
    double R312;
    double R132;
    double R123;
    protected final int t000;
    protected final int t100;
    protected final int t010;
    protected final int t001;
    protected final int t200;
    protected final int t020;
    protected final int t002;
    protected final int t110;
    protected final int t101;
    protected final int t011;
    protected final int t300;
    protected final int t030;
    protected final int t003;
    protected final int t210;
    protected final int t201;
    protected final int t120;
    protected final int t021;
    protected final int t102;
    protected final int t012;
    protected final int t111;
    protected final int t400;
    protected final int t040;
    protected final int t004;
    protected final int t310;
    protected final int t301;
    protected final int t130;
    protected final int t031;
    protected final int t103;
    protected final int t013;
    protected final int t220;
    protected final int t202;
    protected final int t022;
    protected final int t211;
    protected final int t121;
    protected final int t112;
    protected final int t500;
    protected final int t050;
    protected final int t005;
    protected final int t410;
    protected final int t401;
    protected final int t140;
    protected final int t041;
    protected final int t104;
    protected final int t014;
    protected final int t320;
    protected final int t302;
    protected final int t230;
    protected final int t032;
    protected final int t203;
    protected final int t023;
    protected final int t311;
    protected final int t131;
    protected final int t113;
    protected final int t221;
    protected final int t212;
    protected final int t122;
    protected final int t600;
    protected final int t060;
    protected final int t006;
    protected final int t510;
    protected final int t501;
    protected final int t150;
    protected final int t051;
    protected final int t105;
    protected final int t015;
    protected final int t420;
    protected final int t402;
    protected final int t240;
    protected final int t042;
    protected final int t204;
    protected final int t024;
    protected final int t411;
    protected final int t141;
    protected final int t114;
    protected final int t330;
    protected final int t303;
    protected final int t033;
    protected final int t321;
    protected final int t231;
    protected final int t213;
    protected final int t312;
    protected final int t132;
    protected final int t123;
    protected final int t222;

    public MultipoleTensor(CoordinateSystem coordinates, int order) {
        assert (order > 0);
        this.il = this.o1 = order + 1;
        this.im = this.il * this.o1;
        this.in = this.im * this.o1;
        this.size = (order + 1) * (order + 2) * (order + 3) / 6;
        this.work = new double[this.in * this.o1];
        this.order = order;
        this.coordinates = coordinates;
        this.operator = Operator.COULOMB;
        this.coulombSource = new double[this.o1];
        for (int n = 0; n <= order; n = (int)((short)(n + 1))) {
            this.coulombSource[n] = FastMath.pow((double)-1.0, (int)n) * (double)ScalarMath.doubleFactorial(2 * n - 1);
        }
        this.T000 = new double[order + 1];
        this.t000 = MultipoleUtilities.ti(0, 0, 0, order);
        this.t100 = MultipoleUtilities.ti(1, 0, 0, order);
        this.t010 = MultipoleUtilities.ti(0, 1, 0, order);
        this.t001 = MultipoleUtilities.ti(0, 0, 1, order);
        this.t200 = MultipoleUtilities.ti(2, 0, 0, order);
        this.t020 = MultipoleUtilities.ti(0, 2, 0, order);
        this.t002 = MultipoleUtilities.ti(0, 0, 2, order);
        this.t110 = MultipoleUtilities.ti(1, 1, 0, order);
        this.t101 = MultipoleUtilities.ti(1, 0, 1, order);
        this.t011 = MultipoleUtilities.ti(0, 1, 1, order);
        this.t300 = MultipoleUtilities.ti(3, 0, 0, order);
        this.t030 = MultipoleUtilities.ti(0, 3, 0, order);
        this.t003 = MultipoleUtilities.ti(0, 0, 3, order);
        this.t210 = MultipoleUtilities.ti(2, 1, 0, order);
        this.t201 = MultipoleUtilities.ti(2, 0, 1, order);
        this.t120 = MultipoleUtilities.ti(1, 2, 0, order);
        this.t021 = MultipoleUtilities.ti(0, 2, 1, order);
        this.t102 = MultipoleUtilities.ti(1, 0, 2, order);
        this.t012 = MultipoleUtilities.ti(0, 1, 2, order);
        this.t111 = MultipoleUtilities.ti(1, 1, 1, order);
        this.t400 = MultipoleUtilities.ti(4, 0, 0, order);
        this.t040 = MultipoleUtilities.ti(0, 4, 0, order);
        this.t004 = MultipoleUtilities.ti(0, 0, 4, order);
        this.t310 = MultipoleUtilities.ti(3, 1, 0, order);
        this.t301 = MultipoleUtilities.ti(3, 0, 1, order);
        this.t130 = MultipoleUtilities.ti(1, 3, 0, order);
        this.t031 = MultipoleUtilities.ti(0, 3, 1, order);
        this.t103 = MultipoleUtilities.ti(1, 0, 3, order);
        this.t013 = MultipoleUtilities.ti(0, 1, 3, order);
        this.t220 = MultipoleUtilities.ti(2, 2, 0, order);
        this.t202 = MultipoleUtilities.ti(2, 0, 2, order);
        this.t022 = MultipoleUtilities.ti(0, 2, 2, order);
        this.t211 = MultipoleUtilities.ti(2, 1, 1, order);
        this.t121 = MultipoleUtilities.ti(1, 2, 1, order);
        this.t112 = MultipoleUtilities.ti(1, 1, 2, order);
        this.t500 = MultipoleUtilities.ti(5, 0, 0, order);
        this.t050 = MultipoleUtilities.ti(0, 5, 0, order);
        this.t005 = MultipoleUtilities.ti(0, 0, 5, order);
        this.t410 = MultipoleUtilities.ti(4, 1, 0, order);
        this.t401 = MultipoleUtilities.ti(4, 0, 1, order);
        this.t140 = MultipoleUtilities.ti(1, 4, 0, order);
        this.t041 = MultipoleUtilities.ti(0, 4, 1, order);
        this.t104 = MultipoleUtilities.ti(1, 0, 4, order);
        this.t014 = MultipoleUtilities.ti(0, 1, 4, order);
        this.t320 = MultipoleUtilities.ti(3, 2, 0, order);
        this.t302 = MultipoleUtilities.ti(3, 0, 2, order);
        this.t230 = MultipoleUtilities.ti(2, 3, 0, order);
        this.t032 = MultipoleUtilities.ti(0, 3, 2, order);
        this.t203 = MultipoleUtilities.ti(2, 0, 3, order);
        this.t023 = MultipoleUtilities.ti(0, 2, 3, order);
        this.t311 = MultipoleUtilities.ti(3, 1, 1, order);
        this.t131 = MultipoleUtilities.ti(1, 3, 1, order);
        this.t113 = MultipoleUtilities.ti(1, 1, 3, order);
        this.t221 = MultipoleUtilities.ti(2, 2, 1, order);
        this.t212 = MultipoleUtilities.ti(2, 1, 2, order);
        this.t122 = MultipoleUtilities.ti(1, 2, 2, order);
        this.t600 = MultipoleUtilities.ti(6, 0, 0, order);
        this.t060 = MultipoleUtilities.ti(0, 6, 0, order);
        this.t006 = MultipoleUtilities.ti(0, 0, 6, order);
        this.t510 = MultipoleUtilities.ti(5, 1, 0, order);
        this.t501 = MultipoleUtilities.ti(5, 0, 1, order);
        this.t150 = MultipoleUtilities.ti(1, 5, 0, order);
        this.t051 = MultipoleUtilities.ti(0, 5, 1, order);
        this.t105 = MultipoleUtilities.ti(1, 0, 5, order);
        this.t015 = MultipoleUtilities.ti(0, 1, 5, order);
        this.t420 = MultipoleUtilities.ti(4, 2, 0, order);
        this.t402 = MultipoleUtilities.ti(4, 0, 2, order);
        this.t240 = MultipoleUtilities.ti(2, 4, 0, order);
        this.t042 = MultipoleUtilities.ti(0, 4, 2, order);
        this.t204 = MultipoleUtilities.ti(2, 0, 4, order);
        this.t024 = MultipoleUtilities.ti(0, 2, 4, order);
        this.t411 = MultipoleUtilities.ti(4, 1, 1, order);
        this.t141 = MultipoleUtilities.ti(1, 4, 1, order);
        this.t114 = MultipoleUtilities.ti(1, 1, 4, order);
        this.t330 = MultipoleUtilities.ti(3, 3, 0, order);
        this.t303 = MultipoleUtilities.ti(3, 0, 3, order);
        this.t033 = MultipoleUtilities.ti(0, 3, 3, order);
        this.t321 = MultipoleUtilities.ti(3, 2, 1, order);
        this.t231 = MultipoleUtilities.ti(2, 3, 1, order);
        this.t213 = MultipoleUtilities.ti(2, 1, 3, order);
        this.t312 = MultipoleUtilities.ti(3, 1, 2, order);
        this.t132 = MultipoleUtilities.ti(1, 3, 2, order);
        this.t123 = MultipoleUtilities.ti(1, 2, 3, order);
        this.t222 = MultipoleUtilities.ti(2, 2, 2, order);
    }

    public double getd2EdZ2() {
        return this.d2EdZ2;
    }

    public double getdEdZ() {
        return this.dEdZ;
    }

    public void log(double[] tensor) {
        MultipoleTensor.log(this.operator, this.order, tensor);
    }

    public double multipoleEnergy(PolarizableMultipole mI, PolarizableMultipole mK) {
        this.multipoleIPotentialAtK(mI, 2);
        return this.multipoleEnergy(mK);
    }

    public double multipoleEnergyAndGradient(PolarizableMultipole mI, PolarizableMultipole mK, double[] Gi, double[] Gk, double[] Ti, double[] Tk) {
        this.multipoleIPotentialAtK(mI, 3);
        double energy = this.multipoleEnergy(mK);
        this.multipoleGradient(mK, Gk);
        Gi[0] = -Gk[0];
        Gi[1] = -Gk[1];
        Gi[2] = -Gk[2];
        this.multipoleTorque(mK, Tk);
        this.multipoleKPotentialAtI(mK, 2);
        this.multipoleTorque(mI, Ti);
        return energy;
    }

    public double polarizationEnergy(PolarizableMultipole mI, PolarizableMultipole mK, double scaleEnergy) {
        if (mI.Z != 0.0 && mK.Z != 0.0 && this.operator == Operator.THOLE_DIRECT_FIELD) {
            mI.q += mI.Z;
            mK.q += mK.Z;
        }
        this.multipoleIPotentialAtK(mI, 1);
        double eK = this.polarizationEnergy(mK);
        this.multipoleKPotentialAtI(mK, 1);
        double eI = this.polarizationEnergy(mI);
        if (mI.Z != 0.0 && mK.Z != 0.0 && this.operator == Operator.THOLE_DIRECT_FIELD) {
            mI.q -= mI.Z;
            mK.q -= mK.Z;
        }
        return scaleEnergy * (eI + eK);
    }

    public double polarizationEnergyAndGradient(PolarizableMultipole mI, PolarizableMultipole mK, double inductionMask, double energyMask, double mutualMask, double[] Gi, double[] Ti, double[] Tk) {
        if (mI.Z != 0.0 && mK.Z != 0.0) {
            mI.q += mI.Z;
            mK.q += mK.Z;
        }
        mI.applyMasks(inductionMask, energyMask);
        mK.applyMasks(inductionMask, energyMask);
        this.multipoleIPotentialAtK(mI, 2);
        double eK = this.polarizationEnergy(mK);
        Gi[0] = -(mK.sx * this.E200 + mK.sy * this.E110 + mK.sz * this.E101);
        Gi[1] = -(mK.sx * this.E110 + mK.sy * this.E020 + mK.sz * this.E011);
        Gi[2] = -(mK.sx * this.E101 + mK.sy * this.E011 + mK.sz * this.E002);
        this.multipoleKPotentialAtI(mK, 2);
        double eI = this.polarizationEnergy(mI);
        Gi[0] = Gi[0] + (mI.sx * this.E200 + mI.sy * this.E110 + mI.sz * this.E101);
        Gi[1] = Gi[1] + (mI.sx * this.E110 + mI.sy * this.E020 + mI.sz * this.E011);
        Gi[2] = Gi[2] + (mI.sx * this.E101 + mI.sy * this.E011 + mI.sz * this.E002);
        double energy = energyMask * (eI + eK);
        if (mutualMask != 0.0) {
            this.dipoleIPotentialAtK(mI.ux, mI.uy, mI.uz, 2);
            Gi[0] = Gi[0] - 0.5 * mutualMask * (mK.px * this.E200 + mK.py * this.E110 + mK.pz * this.E101);
            Gi[1] = Gi[1] - 0.5 * mutualMask * (mK.px * this.E110 + mK.py * this.E020 + mK.pz * this.E011);
            Gi[2] = Gi[2] - 0.5 * mutualMask * (mK.px * this.E101 + mK.py * this.E011 + mK.pz * this.E002);
            this.dipoleKPotentialAtI(mK.ux, mK.uy, mK.uz, 2);
            Gi[0] = Gi[0] + 0.5 * mutualMask * (mI.px * this.E200 + mI.py * this.E110 + mI.pz * this.E101);
            Gi[1] = Gi[1] + 0.5 * mutualMask * (mI.px * this.E110 + mI.py * this.E020 + mI.pz * this.E011);
            Gi[2] = Gi[2] + 0.5 * mutualMask * (mI.px * this.E101 + mI.py * this.E011 + mI.pz * this.E002);
        }
        this.dipoleIPotentialAtK(mI.sx, mI.sy, mI.sz, 2);
        this.multipoleTorque(mK, Tk);
        this.dipoleKPotentialAtI(mK.sx, mK.sy, mK.sz, 2);
        this.multipoleTorque(mI, Ti);
        if (mI.Z != 0.0 && mK.Z != 0.0) {
            mI.q -= mI.Z;
            mK.q -= mK.Z;
        }
        return energy;
    }

    public double totalEnergy(PolarizableMultipole mI, PolarizableMultipole mK, double scaleEnergy, double[] energyComponents) {
        this.multipoleIPotentialAtK(mI, 2);
        double permanentEnergy = this.multipoleEnergy(mK);
        double eK = -(mK.ux * this.E100 + mK.uy * this.E010 + mK.uz * this.E001);
        this.multipoleKPotentialAtI(mK, 2);
        double eI = -(mI.ux * this.E100 + mI.uy * this.E010 + mI.uz * this.E001);
        double inducedEnergy = -0.5 * scaleEnergy * (eI + eK);
        energyComponents[0] = permanentEnergy;
        energyComponents[1] = inducedEnergy;
        return permanentEnergy + inducedEnergy;
    }

    public final void setR(double[] r) {
        this.setR(r[0], r[1], r[2]);
    }

    public abstract void setR(double var1, double var3, double var5);

    public final void generateTensor(double[] r) {
        this.setR(r);
        this.generateTensor();
    }

    public void generateTensor() {
        switch (this.order) {
            case 1: {
                this.order1();
                break;
            }
            case 2: {
                this.order2();
                break;
            }
            case 3: {
                this.order3();
                break;
            }
            case 4: {
                this.order4();
                break;
            }
            case 5: {
                this.order5();
                break;
            }
            case 6: {
                this.order6();
                break;
            }
            default: {
                double[] r = new double[]{this.x, this.y, this.z};
                this.recursion(r, this.work);
            }
        }
    }

    protected abstract void source(double[] var1);

    protected final int ti(int dx, int dy, int dz) {
        return MultipoleUtilities.ti(dx, dy, dz, this.order);
    }

    protected double contractMultipoleI(PolarizableMultipole mI, double[] T, int l, int m, int n) {
        double total = 0.0;
        total += mI.q * T[this.ti(l, m, n)];
        total -= mI.dx * T[this.ti(l + 1, m, n)];
        total -= mI.dy * T[this.ti(l, m + 1, n)];
        total -= mI.dz * T[this.ti(l, m, n + 1)];
        total += mI.qxx * T[this.ti(l + 2, m, n)];
        total += mI.qyy * T[this.ti(l, m + 2, n)];
        total += mI.qzz * T[this.ti(l, m, n + 2)];
        total += mI.qxy * T[this.ti(l + 1, m + 1, n)];
        total += mI.qxz * T[this.ti(l + 1, m, n + 1)];
        return total += mI.qyz * T[this.ti(l, m + 1, n + 1)];
    }

    protected final void potentialMultipoleI(PolarizableMultipole mI, double[] T, int l, int m, int n) {
        this.E000 = this.contractMultipoleI(mI, T, l, m, n);
        this.E100 = this.contractMultipoleI(mI, T, l + 1, m, n);
        this.E010 = this.contractMultipoleI(mI, T, l, m + 1, n);
        this.E001 = this.contractMultipoleI(mI, T, l, m, n + 1);
        this.E200 = this.contractMultipoleI(mI, T, l + 2, m, n);
        this.E020 = this.contractMultipoleI(mI, T, l, m + 2, n);
        this.E002 = this.contractMultipoleI(mI, T, l, m, n + 2);
        this.E110 = this.contractMultipoleI(mI, T, l + 1, n + 1, m);
        this.E101 = this.contractMultipoleI(mI, T, l + 1, m, n + 1);
        this.E011 = this.contractMultipoleI(mI, T, l, m + 1, n + 1);
    }

    protected abstract String codeTensorRecursion(double[] var1, double[] var2);

    private double codeContractMultipoleI(PolarizableMultipole mI, double[] T, int l, int m, int n, StringBuilder sb) {
        double total = 0.0;
        String name = MultipoleUtilities.term(l, m, n);
        sb.append(String.format("double %s = 0.0;\n", name));
        StringBuilder sb1 = new StringBuilder();
        double term = mI.q * T[this.ti(l, m, n)];
        if (term != 0.0) {
            total += term;
            sb1.append(String.format("%s = fma(mI.q, R%s, %s);\n", name, MultipoleUtilities.lmn(l, m, n), name));
        }
        if ((term = mI.dx * T[this.ti(l + 1, m, n)]) != 0.0) {
            total += term;
            sb1.append(String.format("%s = fma(mI.dx, -R%s, %s);\n", name, MultipoleUtilities.lmn(l + 1, m, n), name));
        }
        if ((term = mI.dy * T[this.ti(l, m + 1, n)]) != 0.0) {
            total += term;
            sb1.append(String.format("%s = fma(mI.dy, -R%s, %s);\n", name, MultipoleUtilities.lmn(l, m + 1, n), name));
        }
        if ((term = mI.dz * T[this.ti(l, m, n + 1)]) != 0.0) {
            total += term;
            sb1.append(String.format("%s = fma(mI.dz, -R%s, %s);\n", name, MultipoleUtilities.lmn(l, m, n + 1), name));
        }
        StringBuilder traceSB = new StringBuilder();
        double trace = 0.0;
        term = mI.qxx * T[this.ti(l + 2, m, n)];
        if (term != 0.0) {
            trace += term;
            traceSB.append(String.format("%s = fma(mI.qxx, R%s, %s);\n", name, MultipoleUtilities.lmn(l + 2, m, n), name));
        }
        if ((term = mI.qyy * T[this.ti(l, m + 2, n)]) != 0.0) {
            trace += term;
            traceSB.append(String.format("%s = fma(mI.qyy, R%s, %s);\n", name, MultipoleUtilities.lmn(l, m + 2, n), name));
        }
        if ((term = mI.qzz * T[this.ti(l, m, n + 2)]) != 0.0) {
            trace += term;
            traceSB.append(String.format("%s = fma(mI.qzz, R%s, %s);\n", name, MultipoleUtilities.lmn(l, m, n + 2), name));
        }
        if ((total += trace) != 0.0) {
            sb.append((CharSequence)sb1);
            if (trace != 0.0) {
                sb.append((CharSequence)traceSB);
            }
        }
        if ((term = mI.qxy * T[this.ti(l + 1, m + 1, n)]) != 0.0) {
            total += term;
            sb.append(String.format("%s = fma(mI.qxy, R%s, %s);\n", name, MultipoleUtilities.lmn(l + 1, m + 1, n), name));
        }
        if ((term = mI.qxz * T[this.ti(l + 1, m, n + 1)]) != 0.0) {
            total += term;
            sb.append(String.format("%s = fma(mI.qxz, R%s, %s);\n", name, MultipoleUtilities.lmn(l + 1, m, n + 1), name));
        }
        if ((term = mI.qyz * T[this.ti(l, m + 1, n + 1)]) != 0.0) {
            total += term;
            sb.append(String.format("%s = fma(mI.qyz, R%s, %s);\n", name, MultipoleUtilities.lmn(l, m + 1, n + 1), name));
        }
        return total;
    }

    private double codeContractMultipoleISIMD(PolarizableMultipole mI, double[] T, int l, int m, int n, StringBuilder sb, HashMap<Integer, String> tensorMap) {
        double total = 0.0;
        String name = MultipoleUtilities.term(l, m, n);
        StringBuilder sb1 = new StringBuilder();
        double term = mI.q * T[this.ti(l, m, n)];
        if (term != 0.0) {
            total += term;
            sb1.append(MultipoleUtilities.loadTensor(l, m, n, tensorMap));
            sb1.append(String.format("\tDoubleVector %s = q.mul(t%s);\n", name, MultipoleUtilities.lmn(l, m, n)));
        } else {
            sb.append(String.format("\tDoubleVector %s = zero;\n", name));
        }
        term = mI.dx * T[this.ti(l + 1, m, n)];
        if (term != 0.0) {
            total += term;
            sb1.append(MultipoleUtilities.loadTensor(l + 1, m, n, tensorMap));
            sb1.append(String.format("\t%s = dx.fma(t%s.neg(), %s);\n", name, MultipoleUtilities.lmn(l + 1, m, n), name));
        }
        if ((term = mI.dy * T[this.ti(l, m + 1, n)]) != 0.0) {
            total += term;
            sb1.append(MultipoleUtilities.loadTensor(l, m + 1, n, tensorMap));
            sb1.append(String.format("\t%s = dy.fma(t%s.neg(), %s);\n", name, MultipoleUtilities.lmn(l, m + 1, n), name));
        }
        if ((term = mI.dz * T[this.ti(l, m, n + 1)]) != 0.0) {
            total += term;
            sb1.append(MultipoleUtilities.loadTensor(l, m, n + 1, tensorMap));
            sb1.append(String.format("\t%s = dz.fma(t%s.neg(), %s);\n", name, MultipoleUtilities.lmn(l, m, n + 1), name));
        }
        StringBuilder traceSB = new StringBuilder();
        double trace = 0.0;
        term = mI.qxx * T[this.ti(l + 2, m, n)];
        if (term != 0.0) {
            trace += term;
            traceSB.append(MultipoleUtilities.loadTensor(l + 2, m, n, tensorMap));
            traceSB.append(String.format("\t%s = qxx.fma(t%s, %s);\n", name, MultipoleUtilities.lmn(l + 2, m, n), name));
        }
        if ((term = mI.qyy * T[this.ti(l, m + 2, n)]) != 0.0) {
            trace += term;
            traceSB.append(MultipoleUtilities.loadTensor(l, m + 2, n, tensorMap));
            traceSB.append(String.format("\t%s = qyy.fma(t%s, %s);\n", name, MultipoleUtilities.lmn(l, m + 2, n), name));
        }
        if ((term = mI.qzz * T[this.ti(l, m, n + 2)]) != 0.0) {
            trace += term;
            traceSB.append(MultipoleUtilities.loadTensor(l, m, n + 2, tensorMap));
            traceSB.append(String.format("\t%s = qzz.fma(t%s, %s);\n", name, MultipoleUtilities.lmn(l, m, n + 2), name));
        }
        if ((total += trace) != 0.0) {
            sb.append((CharSequence)sb1);
            if (trace != 0.0) {
                sb.append((CharSequence)traceSB);
            }
        }
        if ((term = mI.qxy * T[this.ti(l + 1, m + 1, n)]) != 0.0) {
            total += term;
            sb.append(MultipoleUtilities.loadTensor(l + 1, m + 1, n, tensorMap));
            sb.append(String.format("\t%s = qxy.fma(t%s, %s);\n", name, MultipoleUtilities.lmn(l + 1, m + 1, n), name));
        }
        if ((term = mI.qxz * T[this.ti(l + 1, m, n + 1)]) != 0.0) {
            total += term;
            sb.append(MultipoleUtilities.loadTensor(l + 1, m, n + 1, tensorMap));
            sb.append(String.format("\t%s = qxz.fma(t%s, %s);\n", name, MultipoleUtilities.lmn(l + 1, m, n + 1), name));
        }
        if ((term = mI.qyz * T[this.ti(l, m + 1, n + 1)]) != 0.0) {
            total += term;
            sb.append(MultipoleUtilities.loadTensor(l, m + 1, n + 1, tensorMap));
            sb.append(String.format("\t%s = qyz.fma(t%s, %s);\n", name, MultipoleUtilities.lmn(l, m + 1, n + 1), name));
        }
        return total;
    }

    private double codeContractMultipoleK(PolarizableMultipole mK, double[] T, int l, int m, int n, StringBuilder sb) {
        double total = 0.0;
        String name = MultipoleUtilities.term(l, m, n);
        sb.append(String.format("double %s = 0.0;\n", name));
        StringBuilder sb1 = new StringBuilder();
        double term = mK.q * T[this.ti(l, m, n)];
        if (term != 0.0) {
            total += term;
            sb1.append(String.format("%s = fma(mK.q, R%s, %s);\n", name, MultipoleUtilities.lmn(l, m, n), name));
        }
        if ((term = mK.dx * T[this.ti(l + 1, m, n)]) != 0.0) {
            total += term;
            sb1.append(String.format("%s = fma(mK.dx, R%s, %s);\n", name, MultipoleUtilities.lmn(l + 1, m, n), name));
        }
        if ((term = mK.dy * T[this.ti(l, m + 1, n)]) != 0.0) {
            total += term;
            sb1.append(String.format("%s = fma(mK.dy, R%s, %s);\n", name, MultipoleUtilities.lmn(l, m + 1, n), name));
        }
        if ((term = mK.dz * T[this.ti(l, m, n + 1)]) != 0.0) {
            total += term;
            sb1.append(String.format("%s = fma(mK.dz, R%s, %s);\n", name, MultipoleUtilities.lmn(l, m, n + 1), name));
        }
        StringBuilder traceSB = new StringBuilder();
        double trace = 0.0;
        term = mK.qxx * T[this.ti(l + 2, m, n)];
        if (term != 0.0) {
            trace += term;
            traceSB.append(String.format("%s = fma(mK.qxx, R%s, %s);\n", name, MultipoleUtilities.lmn(l + 2, m, n), name));
        }
        if ((term = mK.qyy * T[this.ti(l, m + 2, n)]) != 0.0) {
            trace += term;
            traceSB.append(String.format("%s = fma(mK.qyy, R%s, %s);\n", name, MultipoleUtilities.lmn(l, m + 2, n), name));
        }
        if ((term = mK.qzz * T[this.ti(l, m, n + 2)]) != 0.0) {
            trace += term;
            traceSB.append(String.format("%s = fma(mK.qzz, R%s, %s);\n", name, MultipoleUtilities.lmn(l, m, n + 2), name));
        }
        if ((total += trace) != 0.0) {
            sb.append((CharSequence)sb1);
            if (trace != 0.0) {
                sb.append((CharSequence)traceSB);
            }
        }
        if ((term = mK.qxy * T[this.ti(l + 1, m + 1, n)]) != 0.0) {
            total += term;
            sb.append(String.format("%s = fma(mK.qxy, R%s, %s);\n", name, MultipoleUtilities.lmn(l + 1, m + 1, n), name));
        }
        if ((term = mK.qxz * T[this.ti(l + 1, m, n + 1)]) != 0.0) {
            total += term;
            sb.append(String.format("%s = fma(mK.qxz, R%s, %s);\n", name, MultipoleUtilities.lmn(l + 1, m, n + 1), name));
        }
        if ((term = mK.qyz * T[this.ti(l, m + 1, n + 1)]) != 0.0) {
            total += term;
            sb.append(String.format("%s = fma(mK.qyz, R%s, %s);\n", name, MultipoleUtilities.lmn(l, m + 1, n + 1), name));
        }
        return total;
    }

    private double codeContractMultipoleKSIMD(PolarizableMultipole mK, double[] T, int l, int m, int n, StringBuilder sb, HashMap<Integer, String> tensorHash) {
        double total = 0.0;
        String name = MultipoleUtilities.term(l, m, n);
        StringBuilder sb1 = new StringBuilder();
        double term = mK.q * T[this.ti(l, m, n)];
        if (term != 0.0) {
            total += term;
            sb1.append(MultipoleUtilities.loadTensor(l, m, n, tensorHash));
            sb1.append(String.format("\tDoubleVector %s = q.mul(t%s);\n", name, MultipoleUtilities.lmn(l, m, n)));
        } else {
            sb.append(String.format("\tDoubleVector %s = zero;\n", name));
        }
        term = mK.dx * T[this.ti(l + 1, m, n)];
        if (term != 0.0) {
            total += term;
            sb1.append(MultipoleUtilities.loadTensor(l + 1, m, n, tensorHash));
            sb1.append(String.format("\t%s = dx.fma(t%s, %s);\n", name, MultipoleUtilities.lmn(l + 1, m, n), name));
        }
        if ((term = mK.dy * T[this.ti(l, m + 1, n)]) != 0.0) {
            total += term;
            sb1.append(MultipoleUtilities.loadTensor(l, m + 1, n, tensorHash));
            sb1.append(String.format("\t%s = dy.fma(t%s, %s);\n", name, MultipoleUtilities.lmn(l, m + 1, n), name));
        }
        if ((term = mK.dz * T[this.ti(l, m, n + 1)]) != 0.0) {
            total += term;
            sb1.append(MultipoleUtilities.loadTensor(l, m, n + 1, tensorHash));
            sb1.append(String.format("\t%s = dz.fma(t%s, %s);\n", name, MultipoleUtilities.lmn(l, m, n + 1), name));
        }
        StringBuilder traceSB = new StringBuilder();
        double trace = 0.0;
        term = mK.qxx * T[this.ti(l + 2, m, n)];
        if (term != 0.0) {
            trace += term;
            traceSB.append(MultipoleUtilities.loadTensor(l + 2, m, n, tensorHash));
            traceSB.append(String.format("\t%s = qxx.fma(t%s, %s);\n", name, MultipoleUtilities.lmn(l + 2, m, n), name));
        }
        if ((term = mK.qyy * T[this.ti(l, m + 2, n)]) != 0.0) {
            trace += term;
            traceSB.append(MultipoleUtilities.loadTensor(l, m + 2, n, tensorHash));
            traceSB.append(String.format("\t%s = qyy.fma(t%s, %s);\n", name, MultipoleUtilities.lmn(l, m + 2, n), name));
        }
        if ((term = mK.qzz * T[this.ti(l, m, n + 2)]) != 0.0) {
            trace += term;
            traceSB.append(MultipoleUtilities.loadTensor(l, m, n + 2, tensorHash));
            traceSB.append(String.format("\t%s = qzz.fma(t%s, %s);\n", name, MultipoleUtilities.lmn(l, m, n + 2), name));
        }
        if ((total += trace) != 0.0) {
            sb.append((CharSequence)sb1);
            if (trace != 0.0) {
                sb.append((CharSequence)traceSB);
            }
        }
        if ((term = mK.qxy * T[this.ti(l + 1, m + 1, n)]) != 0.0) {
            total += term;
            sb.append(MultipoleUtilities.loadTensor(l + 1, m + 1, n, tensorHash));
            sb.append(String.format("\t%s = qxy.fma(t%s, %s);\n", name, MultipoleUtilities.lmn(l + 1, m + 1, n), name));
        }
        if ((term = mK.qxz * T[this.ti(l + 1, m, n + 1)]) != 0.0) {
            total += term;
            sb.append(MultipoleUtilities.loadTensor(l + 1, m, n + 1, tensorHash));
            sb.append(String.format("\t%s = qxz.fma(t%s, %s);\n", name, MultipoleUtilities.lmn(l + 1, m, n + 1), name));
        }
        if ((term = mK.qyz * T[this.ti(l, m + 1, n + 1)]) != 0.0) {
            total += term;
            sb.append(MultipoleUtilities.loadTensor(l, m + 1, n + 1, tensorHash));
            sb.append(String.format("\t%s = qyz.fma(t%s, %s);\n", name, MultipoleUtilities.lmn(l, m + 1, n + 1), name));
        }
        return total;
    }

    protected void codePotentialMultipoleI(PolarizableMultipole mI, double[] T, int l, int m, int n, StringBuilder sb) {
        this.E000 = this.codeContractMultipoleI(mI, T, l, m, n, sb);
        if (this.E000 != 0.0) {
            sb.append(String.format("E000 = %s;\n", MultipoleUtilities.term(l, m, n)));
        }
        this.E100 = this.codeContractMultipoleI(mI, T, l + 1, m, n, sb);
        if (this.E100 != 0.0) {
            sb.append(String.format("E100 = %s;\n", MultipoleUtilities.term(l + 1, m, n)));
        }
        this.E010 = this.codeContractMultipoleI(mI, T, l, m + 1, n, sb);
        if (this.E100 != 0.0) {
            sb.append(String.format("E010 = %s;\n", MultipoleUtilities.term(l, m + 1, n)));
        }
        this.E001 = this.codeContractMultipoleI(mI, T, l, m, n + 1, sb);
        if (this.E001 != 0.0) {
            sb.append(String.format("E001 = %s;\n", MultipoleUtilities.term(l, m, n + 1)));
        }
        this.E200 = this.codeContractMultipoleI(mI, T, l + 2, m, n, sb);
        if (this.E200 != 0.0) {
            sb.append(String.format("E200 = %s;\n", MultipoleUtilities.term(l + 2, m, n)));
        }
        this.E020 = this.codeContractMultipoleI(mI, T, l, m + 2, n, sb);
        if (this.E020 != 0.0) {
            sb.append(String.format("E020 = %s;\n", MultipoleUtilities.term(l, m + 2, n)));
        }
        this.E002 = this.codeContractMultipoleI(mI, T, l, m, n + 2, sb);
        if (this.E002 != 0.0) {
            sb.append(String.format("E002 = %s;\n", MultipoleUtilities.term(l, m, n + 2)));
        }
        this.E110 = this.codeContractMultipoleI(mI, T, l + 1, m + 1, n, sb);
        if (this.E110 != 0.0) {
            sb.append(String.format("E110 = %s;\n", MultipoleUtilities.term(l + 1, m + 1, n)));
        }
        this.E101 = this.codeContractMultipoleI(mI, T, l + 1, m, n + 1, sb);
        if (this.E101 != 0.0) {
            sb.append(String.format("E101 = %s;\n", MultipoleUtilities.term(l + 1, m, n + 1)));
        }
        this.E011 = this.codeContractMultipoleI(mI, T, l, m + 1, n + 1, sb);
        if (this.E011 != 0.0) {
            sb.append(String.format("E011 = %s;\n", MultipoleUtilities.term(l, m + 1, n + 1)));
        }
        this.E300 = this.codeContractMultipoleI(mI, T, l + 3, m, n, sb);
        if (this.E300 != 0.0) {
            sb.append(String.format("E300 = %s;\n", MultipoleUtilities.term(l + 3, m, n)));
        }
        this.E030 = this.codeContractMultipoleI(mI, T, l, m + 3, n, sb);
        if (this.E030 != 0.0) {
            sb.append(String.format("E030 = %s;\n", MultipoleUtilities.term(l, m + 3, n)));
        }
        this.E003 = this.codeContractMultipoleI(mI, T, l, m, n + 3, sb);
        if (this.E003 != 0.0) {
            sb.append(String.format("E003 = %s;\n", MultipoleUtilities.term(l, m, n + 3)));
        }
        this.E210 = this.codeContractMultipoleI(mI, T, l + 2, m + 1, n, sb);
        if (this.E210 != 0.0) {
            sb.append(String.format("E210 = %s;\n", MultipoleUtilities.term(l + 2, m + 1, n)));
        }
        this.E201 = this.codeContractMultipoleI(mI, T, l + 2, m, n + 1, sb);
        if (this.E201 != 0.0) {
            sb.append(String.format("E201 = %s;\n", MultipoleUtilities.term(l + 2, m, n + 1)));
        }
        this.E120 = this.codeContractMultipoleI(mI, T, l + 1, m + 2, n, sb);
        if (this.E120 != 0.0) {
            sb.append(String.format("E120 = %s;\n", MultipoleUtilities.term(l + 1, m + 2, n)));
        }
        this.E021 = this.codeContractMultipoleI(mI, T, l, m + 2, n + 1, sb);
        if (this.E021 != 0.0) {
            sb.append(String.format("E021 = %s;\n", MultipoleUtilities.term(l, m + 2, n + 1)));
        }
        this.E102 = this.codeContractMultipoleI(mI, T, l + 1, m, n + 2, sb);
        if (this.E102 != 0.0) {
            sb.append(String.format("E102 = %s;\n", MultipoleUtilities.term(l + 1, m, n + 2)));
        }
        this.E012 = this.codeContractMultipoleI(mI, T, l, m + 1, n + 2, sb);
        if (this.E012 != 0.0) {
            sb.append(String.format("E012 = %s;\n", MultipoleUtilities.term(l, m + 1, n + 2)));
        }
        this.E111 = this.codeContractMultipoleI(mI, T, l + 1, m + 1, n + 1, sb);
        if (this.E111 != 0.0) {
            sb.append(String.format("E111 = %s;\n", MultipoleUtilities.term(l + 1, m + 1, n + 1)));
        }
    }

    protected void codePotentialMultipoleISIMD(PolarizableMultipole mI, double[] T, int l, int m, int n, StringBuilder sb) {
        String to = "e";
        HashMap<Integer, String> tensorHash = new HashMap<Integer, String>();
        sb.append("\n// Order 0\n");
        this.E000 = this.codeContractMultipoleISIMD(mI, T, l, m, n, sb, tensorHash);
        if (this.E000 != 0.0) {
            sb.append(MultipoleUtilities.storePotential(to, l, m, n));
        }
        sb.append("\n// Order 1\n");
        this.E100 = this.codeContractMultipoleISIMD(mI, T, l + 1, m, n, sb, tensorHash);
        if (this.E100 != 0.0) {
            sb.append(MultipoleUtilities.storePotential(to, l + 1, m, n));
        }
        this.E010 = this.codeContractMultipoleISIMD(mI, T, l, m + 1, n, sb, tensorHash);
        if (this.E100 != 0.0) {
            sb.append(MultipoleUtilities.storePotential(to, l, m + 1, n));
        }
        this.E001 = this.codeContractMultipoleISIMD(mI, T, l, m, n + 1, sb, tensorHash);
        if (this.E001 != 0.0) {
            sb.append(MultipoleUtilities.storePotential(to, l, m, n + 1));
        }
        sb.append("\n// Order 2\n");
        this.E200 = this.codeContractMultipoleISIMD(mI, T, l + 2, m, n, sb, tensorHash);
        if (this.E200 != 0.0) {
            sb.append(MultipoleUtilities.storePotential(to, l + 2, m, n));
        }
        this.E020 = this.codeContractMultipoleISIMD(mI, T, l, m + 2, n, sb, tensorHash);
        if (this.E020 != 0.0) {
            sb.append(MultipoleUtilities.storePotential(to, l, m + 2, n));
        }
        this.E002 = this.codeContractMultipoleISIMD(mI, T, l, m, n + 2, sb, tensorHash);
        if (this.E002 != 0.0) {
            sb.append(MultipoleUtilities.storePotential(to, l, m, n + 2));
        }
        this.E110 = this.codeContractMultipoleISIMD(mI, T, l + 1, m + 1, n, sb, tensorHash);
        if (this.E110 != 0.0) {
            sb.append(MultipoleUtilities.storePotential(to, l + 1, m + 1, n));
        }
        this.E101 = this.codeContractMultipoleISIMD(mI, T, l + 1, m, n + 1, sb, tensorHash);
        if (this.E101 != 0.0) {
            sb.append(MultipoleUtilities.storePotential(to, l + 1, m, n + 1));
        }
        this.E011 = this.codeContractMultipoleISIMD(mI, T, l, m + 1, n + 1, sb, tensorHash);
        if (this.E011 != 0.0) {
            sb.append(MultipoleUtilities.storePotential(to, l, m + 1, n + 1));
        }
        sb.append("\n// Order 3\n");
        this.E300 = this.codeContractMultipoleISIMD(mI, T, l + 3, m, n, sb, tensorHash);
        if (this.E300 != 0.0) {
            sb.append(MultipoleUtilities.storePotential(to, l + 3, m, n));
        }
        this.E030 = this.codeContractMultipoleISIMD(mI, T, l, m + 3, n, sb, tensorHash);
        if (this.E030 != 0.0) {
            sb.append(MultipoleUtilities.storePotential(to, l, m + 3, n));
        }
        this.E003 = this.codeContractMultipoleISIMD(mI, T, l, m, n + 3, sb, tensorHash);
        if (this.E003 != 0.0) {
            sb.append(MultipoleUtilities.storePotential(to, l, m, n + 3));
        }
        this.E210 = this.codeContractMultipoleISIMD(mI, T, l + 2, m + 1, n, sb, tensorHash);
        if (this.E210 != 0.0) {
            sb.append(MultipoleUtilities.storePotential(to, l + 2, m + 1, n));
        }
        this.E201 = this.codeContractMultipoleISIMD(mI, T, l + 2, m, n + 1, sb, tensorHash);
        if (this.E201 != 0.0) {
            sb.append(MultipoleUtilities.storePotential(to, l + 2, m, n + 1));
        }
        this.E120 = this.codeContractMultipoleISIMD(mI, T, l + 1, m + 2, n, sb, tensorHash);
        if (this.E120 != 0.0) {
            sb.append(MultipoleUtilities.storePotential(to, l + 1, m + 2, n));
        }
        this.E021 = this.codeContractMultipoleISIMD(mI, T, l, m + 2, n + 1, sb, tensorHash);
        if (this.E021 != 0.0) {
            sb.append(MultipoleUtilities.storePotential(to, l, m + 2, n + 1));
        }
        this.E102 = this.codeContractMultipoleISIMD(mI, T, l + 1, m, n + 2, sb, tensorHash);
        if (this.E102 != 0.0) {
            sb.append(MultipoleUtilities.storePotential(to, l + 1, m, n + 2));
        }
        this.E012 = this.codeContractMultipoleISIMD(mI, T, l, m + 1, n + 2, sb, tensorHash);
        if (this.E012 != 0.0) {
            sb.append(MultipoleUtilities.storePotential(to, l, m + 1, n + 2));
        }
        this.E111 = this.codeContractMultipoleISIMD(mI, T, l + 1, m + 1, n + 1, sb, tensorHash);
        if (this.E111 != 0.0) {
            sb.append(MultipoleUtilities.storePotential(to, l + 1, m + 1, n + 1));
        }
    }

    protected void codePotentialMultipoleK(PolarizableMultipole mK, double[] T, int l, int m, int n, StringBuilder sb) {
        this.E000 = this.codeContractMultipoleK(mK, T, l, m, n, sb);
        if (this.E000 != 0.0) {
            sb.append(String.format("E000 = %s;\n", MultipoleUtilities.term(l, m, n)));
        }
        this.E100 = this.codeContractMultipoleK(mK, T, l + 1, m, n, sb);
        if (this.E100 != 0.0) {
            sb.append(String.format("E100 = -%s;\n", MultipoleUtilities.term(l + 1, m, n)));
        }
        this.E010 = this.codeContractMultipoleK(mK, T, l, m + 1, n, sb);
        if (this.E100 != 0.0) {
            sb.append(String.format("E010 = -%s;\n", MultipoleUtilities.term(l, m + 1, n)));
        }
        this.E001 = this.codeContractMultipoleK(mK, T, l, m, n + 1, sb);
        if (this.E001 != 0.0) {
            sb.append(String.format("E001 = -%s;\n", MultipoleUtilities.term(l, m, n + 1)));
        }
        this.E200 = this.codeContractMultipoleK(mK, T, l + 2, m, n, sb);
        if (this.E200 != 0.0) {
            sb.append(String.format("E200 = %s;\n", MultipoleUtilities.term(l + 2, m, n)));
        }
        this.E020 = this.codeContractMultipoleK(mK, T, l, m + 2, n, sb);
        if (this.E020 != 0.0) {
            sb.append(String.format("E020 = %s;\n", MultipoleUtilities.term(l, m + 2, n)));
        }
        this.E002 = this.codeContractMultipoleK(mK, T, l, m, n + 2, sb);
        if (this.E002 != 0.0) {
            sb.append(String.format("E002 = %s;\n", MultipoleUtilities.term(l, m, n + 2)));
        }
        this.E110 = this.codeContractMultipoleK(mK, T, l + 1, m + 1, n, sb);
        if (this.E110 != 0.0) {
            sb.append(String.format("E110 = %s;\n", MultipoleUtilities.term(l + 1, m + 1, n)));
        }
        this.E101 = this.codeContractMultipoleK(mK, T, l + 1, m, n + 1, sb);
        if (this.E101 != 0.0) {
            sb.append(String.format("E101 = %s;\n", MultipoleUtilities.term(l + 1, m, n + 1)));
        }
        this.E011 = this.codeContractMultipoleK(mK, T, l, m + 1, n + 1, sb);
        if (this.E011 != 0.0) {
            sb.append(String.format("E011 = %s;\n", MultipoleUtilities.term(l, m + 1, n + 1)));
        }
        this.E300 = this.codeContractMultipoleK(mK, T, l + 3, m, n, sb);
        if (this.E300 != 0.0) {
            sb.append(String.format("E300 = -%s;\n", MultipoleUtilities.term(l + 3, m, n)));
        }
        this.E030 = this.codeContractMultipoleK(mK, T, l, m + 3, n, sb);
        if (this.E030 != 0.0) {
            sb.append(String.format("E030 = -%s;\n", MultipoleUtilities.term(l, m + 3, n)));
        }
        this.E003 = this.codeContractMultipoleK(mK, T, l, m, n + 3, sb);
        if (this.E003 != 0.0) {
            sb.append(String.format("E003 = -%s;\n", MultipoleUtilities.term(l, m, n + 3)));
        }
        this.E210 = this.codeContractMultipoleK(mK, T, l + 2, m + 1, n, sb);
        if (this.E210 != 0.0) {
            sb.append(String.format("E210 = -%s;\n", MultipoleUtilities.term(l + 2, m + 1, n)));
        }
        this.E201 = this.codeContractMultipoleK(mK, T, l + 2, m, n + 1, sb);
        if (this.E201 != 0.0) {
            sb.append(String.format("E201 = -%s;\n", MultipoleUtilities.term(l + 2, m, n + 1)));
        }
        this.E120 = this.codeContractMultipoleK(mK, T, l + 1, m + 2, n, sb);
        if (this.E120 != 0.0) {
            sb.append(String.format("E120 = -%s;\n", MultipoleUtilities.term(l + 1, m + 2, n)));
        }
        this.E021 = this.codeContractMultipoleK(mK, T, l, m + 2, n + 1, sb);
        if (this.E021 != 0.0) {
            sb.append(String.format("E021 = -%s;\n", MultipoleUtilities.term(l, m + 2, n + 1)));
        }
        this.E102 = this.codeContractMultipoleK(mK, T, l + 1, m, n + 2, sb);
        if (this.E102 != 0.0) {
            sb.append(String.format("E102 = -%s;\n", MultipoleUtilities.term(l + 1, m, n + 2)));
        }
        this.E012 = this.codeContractMultipoleK(mK, T, l, m + 1, n + 2, sb);
        if (this.E012 != 0.0) {
            sb.append(String.format("E012 = -%s;\n", MultipoleUtilities.term(l, m + 1, n + 2)));
        }
        this.E111 = this.codeContractMultipoleK(mK, T, l + 1, m + 1, n + 1, sb);
        if (this.E111 != 0.0) {
            sb.append(String.format("E111 = -%s;\n", MultipoleUtilities.term(l + 1, m + 1, n + 1)));
        }
    }

    protected void codePotentialMultipoleKSIMD(PolarizableMultipole mK, double[] T, int l, int m, int n, StringBuilder sb) {
        String to = "e";
        sb.append("\n// Order 0\n");
        HashMap<Integer, String> tensorHash = new HashMap<Integer, String>();
        this.E000 = this.codeContractMultipoleKSIMD(mK, T, l, m, n, sb, tensorHash);
        if (this.E000 != 0.0) {
            sb.append(MultipoleUtilities.storePotential(to, l, m, n));
        }
        sb.append("\n// Order 1\n");
        this.E100 = this.codeContractMultipoleKSIMD(mK, T, l + 1, m, n, sb, tensorHash);
        if (this.E100 != 0.0) {
            sb.append(MultipoleUtilities.storePotentialNeg(to, l + 1, m, n));
        }
        this.E010 = this.codeContractMultipoleKSIMD(mK, T, l, m + 1, n, sb, tensorHash);
        if (this.E010 != 0.0) {
            sb.append(MultipoleUtilities.storePotentialNeg(to, l, m + 1, n));
        }
        this.E001 = this.codeContractMultipoleKSIMD(mK, T, l, m, n + 1, sb, tensorHash);
        if (this.E001 != 0.0) {
            sb.append(MultipoleUtilities.storePotentialNeg(to, l, m, n + 1));
        }
        sb.append("\n// Order 2\n");
        this.E200 = this.codeContractMultipoleKSIMD(mK, T, l + 2, m, n, sb, tensorHash);
        if (this.E200 != 0.0) {
            sb.append(MultipoleUtilities.storePotential(to, l + 2, m, n));
        }
        this.E020 = this.codeContractMultipoleKSIMD(mK, T, l, m + 2, n, sb, tensorHash);
        if (this.E020 != 0.0) {
            sb.append(MultipoleUtilities.storePotential(to, l, m + 2, n));
        }
        this.E002 = this.codeContractMultipoleKSIMD(mK, T, l, m, n + 2, sb, tensorHash);
        if (this.E002 != 0.0) {
            sb.append(MultipoleUtilities.storePotential(to, l, m, n + 2));
        }
        this.E110 = this.codeContractMultipoleKSIMD(mK, T, l + 1, m + 1, n, sb, tensorHash);
        if (this.E110 != 0.0) {
            sb.append(MultipoleUtilities.storePotential(to, l + 1, m + 1, n));
        }
        this.E101 = this.codeContractMultipoleKSIMD(mK, T, l + 1, m, n + 1, sb, tensorHash);
        if (this.E101 != 0.0) {
            sb.append(MultipoleUtilities.storePotential(to, l + 1, m, n + 1));
        }
        this.E011 = this.codeContractMultipoleKSIMD(mK, T, l, m + 1, n + 1, sb, tensorHash);
        if (this.E011 != 0.0) {
            sb.append(MultipoleUtilities.storePotential(to, l, m + 1, n + 1));
        }
        sb.append("\n// Order 3\n");
        this.E300 = this.codeContractMultipoleKSIMD(mK, T, l + 3, m, n, sb, tensorHash);
        if (this.E300 != 0.0) {
            sb.append(MultipoleUtilities.storePotentialNeg(to, l + 3, m, n));
        }
        this.E030 = this.codeContractMultipoleKSIMD(mK, T, l, m + 3, n, sb, tensorHash);
        if (this.E030 != 0.0) {
            sb.append(MultipoleUtilities.storePotentialNeg(to, l, m + 3, n));
        }
        this.E003 = this.codeContractMultipoleKSIMD(mK, T, l, m, n + 3, sb, tensorHash);
        if (this.E003 != 0.0) {
            sb.append(MultipoleUtilities.storePotentialNeg(to, l, m, n + 3));
        }
        this.E210 = this.codeContractMultipoleKSIMD(mK, T, l + 2, m + 1, n, sb, tensorHash);
        if (this.E210 != 0.0) {
            sb.append(MultipoleUtilities.storePotentialNeg(to, l + 2, m + 1, n));
        }
        this.E201 = this.codeContractMultipoleKSIMD(mK, T, l + 2, m, n + 1, sb, tensorHash);
        if (this.E201 != 0.0) {
            sb.append(MultipoleUtilities.storePotentialNeg(to, l + 2, m, n + 1));
        }
        this.E120 = this.codeContractMultipoleKSIMD(mK, T, l + 1, m + 2, n, sb, tensorHash);
        if (this.E120 != 0.0) {
            sb.append(MultipoleUtilities.storePotentialNeg(to, l + 1, m + 2, n));
        }
        this.E021 = this.codeContractMultipoleKSIMD(mK, T, l, m + 2, n + 1, sb, tensorHash);
        if (this.E021 != 0.0) {
            sb.append(MultipoleUtilities.storePotentialNeg(to, l, m + 2, n + 1));
        }
        this.E102 = this.codeContractMultipoleKSIMD(mK, T, l + 1, m, n + 2, sb, tensorHash);
        if (this.E102 != 0.0) {
            sb.append(MultipoleUtilities.storePotentialNeg(to, l + 1, m, n + 2));
        }
        this.E012 = this.codeContractMultipoleKSIMD(mK, T, l, m + 1, n + 2, sb, tensorHash);
        if (this.E012 != 0.0) {
            sb.append(MultipoleUtilities.storePotentialNeg(to, l, m + 1, n + 2));
        }
        this.E111 = this.codeContractMultipoleKSIMD(mK, T, l + 1, m + 1, n + 1, sb, tensorHash);
        if (this.E111 != 0.0) {
            sb.append(MultipoleUtilities.storePotentialNeg(to, l + 1, m + 1, n + 1));
        }
    }

    protected final double multipoleEnergy(PolarizableMultipole m) {
        double total = m.q * this.E000;
        total = Math.fma(m.dx, this.E100, total);
        total = Math.fma(m.dy, this.E010, total);
        total = Math.fma(m.dz, this.E001, total);
        total = Math.fma(m.qxx, this.E200, total);
        total = Math.fma(m.qyy, this.E020, total);
        total = Math.fma(m.qzz, this.E002, total);
        total = Math.fma(m.qxy, this.E110, total);
        total = Math.fma(m.qxz, this.E101, total);
        total = Math.fma(m.qyz, this.E011, total);
        return total;
    }

    protected final void multipoleGradient(PolarizableMultipole m, double[] g) {
        double total = m.q * this.E100;
        total = Math.fma(m.dx, this.E200, total);
        total = Math.fma(m.dy, this.E110, total);
        total = Math.fma(m.dz, this.E101, total);
        total = Math.fma(m.qxx, this.E300, total);
        total = Math.fma(m.qyy, this.E120, total);
        total = Math.fma(m.qzz, this.E102, total);
        total = Math.fma(m.qxy, this.E210, total);
        total = Math.fma(m.qxz, this.E201, total);
        g[0] = total = Math.fma(m.qyz, this.E111, total);
        total = m.q * this.E010;
        total = Math.fma(m.dx, this.E110, total);
        total = Math.fma(m.dy, this.E020, total);
        total = Math.fma(m.dz, this.E011, total);
        total = Math.fma(m.qxx, this.E210, total);
        total = Math.fma(m.qyy, this.E030, total);
        total = Math.fma(m.qzz, this.E012, total);
        total = Math.fma(m.qxy, this.E120, total);
        total = Math.fma(m.qxz, this.E111, total);
        g[1] = total = Math.fma(m.qyz, this.E021, total);
        total = m.q * this.E001;
        total = Math.fma(m.dx, this.E101, total);
        total = Math.fma(m.dy, this.E011, total);
        total = Math.fma(m.dz, this.E002, total);
        total = Math.fma(m.qxx, this.E201, total);
        total = Math.fma(m.qyy, this.E021, total);
        total = Math.fma(m.qzz, this.E003, total);
        total = Math.fma(m.qxy, this.E111, total);
        total = Math.fma(m.qxz, this.E102, total);
        g[2] = total = Math.fma(m.qyz, this.E012, total);
    }

    protected final void multipoleTorque(PolarizableMultipole m, double[] torque) {
        double dx = m.dy * this.E001 - m.dz * this.E010;
        double dy = m.dz * this.E100 - m.dx * this.E001;
        double dz = m.dx * this.E010 - m.dy * this.E100;
        double qx = m.qxy * this.E101 + 2.0 * m.qyy * this.E011 + m.qyz * this.E002 - (m.qxz * this.E110 + m.qyz * this.E020 + 2.0 * m.qzz * this.E011);
        double qy = m.qxz * this.E200 + m.qyz * this.E110 + 2.0 * m.qzz * this.E101 - (2.0 * m.qxx * this.E101 + m.qxy * this.E011 + m.qxz * this.E002);
        double qz = 2.0 * m.qxx * this.E110 + m.qxy * this.E020 + m.qxz * this.E011 - (m.qxy * this.E200 + 2.0 * m.qyy * this.E110 + m.qyz * this.E101);
        torque[0] = torque[0] - (dx + qx);
        torque[1] = torque[1] - (dy + qy);
        torque[2] = torque[2] - (dz + qz);
    }

    protected final void dipoleTorque(PolarizableMultipole m, double[] torque) {
        double dx = m.dy * this.E001 - m.dz * this.E010;
        double dy = m.dz * this.E100 - m.dx * this.E001;
        double dz = m.dx * this.E010 - m.dy * this.E100;
        torque[0] = torque[0] - dx;
        torque[1] = torque[1] - dy;
        torque[2] = torque[2] - dz;
    }

    protected final void quadrupoleTorque(PolarizableMultipole m, double[] torque) {
        double qx = m.qxy * this.E101 + 2.0 * m.qyy * this.E011 + m.qyz * this.E002 - (m.qxz * this.E110 + m.qyz * this.E020 + 2.0 * m.qzz * this.E011);
        double qy = m.qxz * this.E200 + m.qyz * this.E110 + 2.0 * m.qzz * this.E101 - (2.0 * m.qxx * this.E101 + m.qxy * this.E011 + m.qxz * this.E002);
        double qz = 2.0 * m.qxx * this.E110 + m.qxy * this.E020 + m.qxz * this.E011 - (m.qxy * this.E200 + 2.0 * m.qyy * this.E110 + m.qyz * this.E101);
        torque[0] = torque[0] - qx;
        torque[1] = torque[1] - qy;
        torque[2] = torque[2] - qz;
    }

    protected final double polarizationEnergy(PolarizableMultipole m) {
        return 0.5 * (m.ux * this.E100 + m.uy * this.E010 + m.uz * this.E001);
    }

    protected final double polarizationEnergyS(PolarizableMultipole m) {
        return 0.5 * (m.sx * this.E100 + m.sy * this.E010 + m.sz * this.E001);
    }

    protected final void getTensor(double[] T) {
        switch (this.order) {
            default: {
                T[this.t500] = this.R500;
                T[this.t050] = this.R050;
                T[this.t005] = this.R005;
                T[this.t410] = this.R410;
                T[this.t401] = this.R401;
                T[this.t140] = this.R140;
                T[this.t041] = this.R041;
                T[this.t104] = this.R104;
                T[this.t014] = this.R014;
                T[this.t320] = this.R320;
                T[this.t302] = this.R302;
                T[this.t230] = this.R230;
                T[this.t032] = this.R032;
                T[this.t203] = this.R203;
                T[this.t023] = this.R023;
                T[this.t311] = this.R311;
                T[this.t131] = this.R131;
                T[this.t113] = this.R113;
                T[this.t221] = this.R221;
                T[this.t212] = this.R212;
                T[this.t122] = this.R122;
            }
            case 4: {
                T[this.t400] = this.R400;
                T[this.t040] = this.R040;
                T[this.t004] = this.R004;
                T[this.t310] = this.R310;
                T[this.t301] = this.R301;
                T[this.t130] = this.R130;
                T[this.t031] = this.R031;
                T[this.t103] = this.R103;
                T[this.t013] = this.R013;
                T[this.t220] = this.R220;
                T[this.t202] = this.R202;
                T[this.t022] = this.R022;
                T[this.t211] = this.R211;
                T[this.t121] = this.R121;
                T[this.t112] = this.R112;
            }
            case 3: {
                T[this.t300] = this.R300;
                T[this.t030] = this.R030;
                T[this.t003] = this.R003;
                T[this.t210] = this.R210;
                T[this.t201] = this.R201;
                T[this.t120] = this.R120;
                T[this.t021] = this.R021;
                T[this.t102] = this.R102;
                T[this.t012] = this.R012;
                T[this.t111] = this.R111;
            }
            case 2: {
                T[this.t200] = this.R200;
                T[this.t020] = this.R020;
                T[this.t002] = this.R002;
                T[this.t110] = this.R110;
                T[this.t101] = this.R101;
                T[this.t011] = this.R011;
            }
            case 1: {
                T[this.t100] = this.R100;
                T[this.t010] = this.R010;
                T[this.t001] = this.R001;
            }
            case 0: 
        }
        T[this.t000] = this.R000;
    }

    protected final void setTensor(double[] T) {
        switch (this.order) {
            case 5: {
                this.R500 = T[this.t500];
                this.R050 = T[this.t050];
                this.R005 = T[this.t005];
                this.R410 = T[this.t410];
                this.R401 = T[this.t401];
                this.R140 = T[this.t140];
                this.R041 = T[this.t041];
                this.R104 = T[this.t104];
                this.R014 = T[this.t014];
                this.R320 = T[this.t320];
                this.R302 = T[this.t302];
                this.R230 = T[this.t230];
                this.R032 = T[this.t032];
                this.R203 = T[this.t203];
                this.R023 = T[this.t023];
                this.R311 = T[this.t311];
                this.R131 = T[this.t131];
                this.R113 = T[this.t113];
                this.R221 = T[this.t221];
                this.R212 = T[this.t212];
                this.R122 = T[this.t122];
            }
            case 4: {
                this.R400 = T[this.t400];
                this.R040 = T[this.t040];
                this.R004 = T[this.t004];
                this.R310 = T[this.t310];
                this.R301 = T[this.t301];
                this.R130 = T[this.t130];
                this.R031 = T[this.t031];
                this.R103 = T[this.t103];
                this.R013 = T[this.t013];
                this.R220 = T[this.t220];
                this.R202 = T[this.t202];
                this.R022 = T[this.t022];
                this.R211 = T[this.t211];
                this.R121 = T[this.t121];
                this.R112 = T[this.t112];
            }
            case 3: {
                this.R300 = T[this.t300];
                this.R030 = T[this.t030];
                this.R003 = T[this.t003];
                this.R210 = T[this.t210];
                this.R201 = T[this.t201];
                this.R120 = T[this.t120];
                this.R021 = T[this.t021];
                this.R102 = T[this.t102];
                this.R012 = T[this.t012];
                this.R111 = T[this.t111];
            }
            case 2: {
                this.R200 = T[this.t200];
                this.R020 = T[this.t020];
                this.R002 = T[this.t002];
                this.R110 = T[this.t110];
                this.R101 = T[this.t101];
                this.R011 = T[this.t011];
            }
            case 1: {
                this.R100 = T[this.t100];
                this.R010 = T[this.t010];
                this.R001 = T[this.t001];
            }
            case 0: {
                this.R000 = T[this.t000];
            }
        }
    }

    protected abstract void noStorageRecursion(double[] var1);

    protected abstract void noStorageRecursion(double[] var1, double[] var2);

    protected abstract double Tlmnj(int var1, int var2, int var3, int var4, double[] var5, double[] var6);

    protected abstract void recursion(double[] var1);

    protected abstract void recursion(double[] var1, double[] var2);

    protected abstract void order1();

    protected abstract void order2();

    protected abstract void order3();

    protected abstract void order4();

    protected abstract void order5();

    protected abstract void order6();

    protected abstract void multipoleIPotentialAtK(PolarizableMultipole var1, int var2);

    protected abstract void chargeIPotentialAtK(PolarizableMultipole var1, int var2);

    protected abstract void dipoleIPotentialAtK(double var1, double var3, double var5, int var7);

    protected abstract void quadrupoleIPotentialAtK(PolarizableMultipole var1, int var2);

    protected abstract void multipoleKPotentialAtI(PolarizableMultipole var1, int var2);

    protected abstract void chargeKPotentialAtI(PolarizableMultipole var1, int var2);

    protected abstract void dipoleKPotentialAtI(double var1, double var3, double var5, int var7);

    protected abstract void quadrupoleKPotentialAtI(PolarizableMultipole var1, int var2);

    private static void log(Operator operator, int order, double[] tensor) {
        int l;
        int o1 = order + 1;
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("\n %s Operator to order %d:", new Object[]{operator, order}));
        sb.append(String.format("\n%5s %4s %4s %4s %12s\n", "Index", "d/dx", "d/dy", "d/dz", "Tensor"));
        sb.append(String.format("%5d %4d %4d %4d %12.8f\n", 0, 0, 0, 0, tensor[0]));
        int count = 1;
        for (l = 1; l <= order; ++l) {
            double value = tensor[MultipoleUtilities.ti(l, 0, 0, order)];
            if (value == 0.0) continue;
            sb.append(String.format("%5d %4d %4d %4d %12.8f\n", MultipoleUtilities.ti(l, 0, 0, order), l, 0, 0, value));
            ++count;
        }
        for (l = 0; l <= o1; ++l) {
            for (int m = 1; m <= order - l; ++m) {
                double value = tensor[MultipoleUtilities.ti(l, m, 0, order)];
                if (value == 0.0) continue;
                sb.append(String.format("%5d %4d %4d %4d %12.8f\n", MultipoleUtilities.ti(l, m, 0, order), l, m, 0, value));
                ++count;
            }
        }
        for (l = 0; l <= o1; ++l) {
            for (int m = 0; m <= o1 - l; ++m) {
                for (int n = 1; n <= order - l - m; ++n) {
                    double value = tensor[MultipoleUtilities.ti(l, m, n, order)];
                    if (value == 0.0) continue;
                    sb.append(String.format("%5d %4d %4d %4d %12.8f\n", MultipoleUtilities.ti(l, m, n, order), l, m, n, value));
                    ++count;
                }
            }
        }
        sb.append(String.format("\n Total number of active tensors: %d\n", count));
        logger.log(Level.INFO, sb.toString());
    }
}

