/*
 * Decompiled with CFR 0.152.
 */
package ffx.numerics.multipole;

import ffx.numerics.multipole.CoulombTensorQISIMD;
import ffx.numerics.multipole.GKMultipoleOrder;
import ffx.numerics.multipole.GKSource;
import ffx.numerics.multipole.GKSourceSIMD;
import ffx.numerics.multipole.PolarizableMultipoleSIMD;
import jdk.incubator.vector.DoubleVector;
import jdk.incubator.vector.Vector;
import jdk.incubator.vector.VectorSpecies;

public class GKTensorQISIMD
extends CoulombTensorQISIMD {
    protected final GKMultipoleOrder multipoleOrder;
    private final double c;
    private final GKSourceSIMD gkSource;
    private final DoubleVector zero = DoubleVector.zero((VectorSpecies)DoubleVector.SPECIES_PREFERRED);

    public GKTensorQISIMD(GKMultipoleOrder multipoleOrder, int order, GKSourceSIMD gkSource, double Eh, double Es) {
        super(order);
        this.multipoleOrder = multipoleOrder;
        this.gkSource = gkSource;
        this.c = GKSource.cn(multipoleOrder.getOrder(), Eh, Es);
    }

    @Override
    public DoubleVector multipoleEnergy(PolarizableMultipoleSIMD mI, PolarizableMultipoleSIMD mK) {
        return switch (this.multipoleOrder) {
            default -> {
                this.chargeIPotentialAtK(mI, 2);
                DoubleVector eK = this.multipoleEnergy(mK);
                this.chargeKPotentialAtI(mK, 2);
                DoubleVector eI = this.multipoleEnergy(mI);
                yield eK.add((Vector)eI).mul(this.c * 0.5);
            }
            case GKMultipoleOrder.DIPOLE -> {
                this.dipoleIPotentialAtK(mI.dx, mI.dy, mI.dz, 2);
                DoubleVector eK = this.multipoleEnergy(mK);
                this.dipoleKPotentialAtI(mK.dx, mK.dy, mK.dz, 2);
                DoubleVector eI = this.multipoleEnergy(mI);
                yield eK.add((Vector)eI).mul(this.c * 0.5);
            }
            case GKMultipoleOrder.QUADRUPOLE -> {
                this.quadrupoleIPotentialAtK(mI, 2);
                DoubleVector eK = this.multipoleEnergy(mK);
                this.quadrupoleKPotentialAtI(mK, 2);
                DoubleVector eI = this.multipoleEnergy(mI);
                yield eK.add((Vector)eI).mul(this.c * 0.5);
            }
        };
    }

    @Override
    public DoubleVector multipoleEnergyAndGradient(PolarizableMultipoleSIMD mI, PolarizableMultipoleSIMD mK, DoubleVector[] Gi, DoubleVector[] Gk, DoubleVector[] Ti, DoubleVector[] Tk) {
        return switch (this.multipoleOrder) {
            default -> this.monopoleEnergyAndGradient(mI, mK, Gi, Gk, Ti, Tk);
            case GKMultipoleOrder.DIPOLE -> this.dipoleEnergyAndGradient(mI, mK, Gi, Gk, Ti, Tk);
            case GKMultipoleOrder.QUADRUPOLE -> this.quadrupoleEnergyAndGradient(mI, mK, Gi, Gk, Ti, Tk);
        };
    }

    protected DoubleVector monopoleEnergyAndGradient(PolarizableMultipoleSIMD mI, PolarizableMultipoleSIMD mK, DoubleVector[] Gi, DoubleVector[] Gk, DoubleVector[] Ti, DoubleVector[] Tk) {
        this.chargeIPotentialAtK(mI, 3);
        DoubleVector eK = this.multipoleEnergy(mK);
        this.multipoleGradient(mK, Gk);
        this.multipoleTorque(mK, Tk);
        this.chargeKPotentialAtI(mK, 3);
        DoubleVector eI = this.multipoleEnergy(mI);
        this.multipoleGradient(mI, Gi);
        this.multipoleTorque(mI, Ti);
        double scale = this.c * 0.5;
        Gi[0] = Gi[0].sub((Vector)Gk[0]).mul(scale);
        Gi[1] = Gi[1].sub((Vector)Gk[1]).mul(scale);
        Gi[2] = Gi[2].sub((Vector)Gk[2]).mul(scale);
        Gk[0] = Gi[0].neg();
        Gk[1] = Gi[1].neg();
        Gk[2] = Gi[2].neg();
        Ti[0] = Ti[0].mul(scale);
        Ti[1] = Ti[1].mul(scale);
        Ti[2] = Ti[2].mul(scale);
        Tk[0] = Tk[0].mul(scale);
        Tk[1] = Tk[1].mul(scale);
        Tk[2] = Tk[2].mul(scale);
        return eK.add((Vector)eI).mul(scale);
    }

    protected DoubleVector dipoleEnergyAndGradient(PolarizableMultipoleSIMD mI, PolarizableMultipoleSIMD mK, DoubleVector[] Gi, DoubleVector[] Gk, DoubleVector[] Ti, DoubleVector[] Tk) {
        this.dipoleIPotentialAtK(mI.dx, mI.dy, mI.dz, 3);
        DoubleVector eK = this.multipoleEnergy(mK);
        this.multipoleGradient(mK, Gk);
        this.multipoleTorque(mK, Tk);
        this.multipoleKPotentialAtI(mK, 1);
        this.dipoleTorque(mI, Ti);
        this.dipoleKPotentialAtI(mK.dx, mK.dy, mK.dz, 3);
        DoubleVector eI = this.multipoleEnergy(mI);
        this.multipoleGradient(mI, Gi);
        this.multipoleTorque(mI, Ti);
        this.multipoleIPotentialAtK(mI, 1);
        this.dipoleTorque(mK, Tk);
        double scale = this.c * 0.5;
        Gi[0] = Gi[0].sub((Vector)Gk[0]).mul(scale);
        Gi[1] = Gi[1].sub((Vector)Gk[1]).mul(scale);
        Gi[2] = Gi[2].sub((Vector)Gk[2]).mul(scale);
        Gk[0] = Gi[0].neg();
        Gk[1] = Gi[1].neg();
        Gk[2] = Gi[2].neg();
        Ti[0] = Ti[0].mul(scale);
        Ti[1] = Ti[1].mul(scale);
        Ti[2] = Ti[2].mul(scale);
        Tk[0] = Tk[0].mul(scale);
        Tk[1] = Tk[1].mul(scale);
        Tk[2] = Tk[2].mul(scale);
        return eK.add((Vector)eI).mul(scale);
    }

    protected DoubleVector quadrupoleEnergyAndGradient(PolarizableMultipoleSIMD mI, PolarizableMultipoleSIMD mK, DoubleVector[] Gi, DoubleVector[] Gk, DoubleVector[] Ti, DoubleVector[] Tk) {
        this.quadrupoleIPotentialAtK(mI, 3);
        DoubleVector eK = this.multipoleEnergy(mK);
        this.multipoleGradient(mK, Gk);
        this.multipoleTorque(mK, Tk);
        this.multipoleKPotentialAtI(mK, 2);
        this.quadrupoleTorque(mI, Ti);
        this.quadrupoleKPotentialAtI(mK, 3);
        DoubleVector eI = this.multipoleEnergy(mI);
        this.multipoleGradient(mI, Gi);
        this.multipoleTorque(mI, Ti);
        this.multipoleIPotentialAtK(mI, 2);
        this.quadrupoleTorque(mK, Tk);
        double scale = this.c * 0.5;
        Gi[0] = Gi[0].sub((Vector)Gk[0]).mul(scale);
        Gi[1] = Gi[1].sub((Vector)Gk[1]).mul(scale);
        Gi[2] = Gi[2].sub((Vector)Gk[2]).mul(scale);
        Gk[0] = Gi[0].neg();
        Gk[1] = Gi[1].neg();
        Gk[2] = Gi[2].neg();
        Ti[0] = Ti[0].mul(scale);
        Ti[1] = Ti[1].mul(scale);
        Ti[2] = Ti[2].mul(scale);
        Tk[0] = Tk[0].mul(scale);
        Tk[1] = Tk[1].mul(scale);
        Tk[2] = Tk[2].mul(scale);
        return eK.add((Vector)eI).mul(scale);
    }

    public DoubleVector multipoleEnergyBornGrad(PolarizableMultipoleSIMD mI, PolarizableMultipoleSIMD mK) {
        return this.multipoleEnergy(mI, mK);
    }

    public DoubleVector polarizationEnergy(PolarizableMultipoleSIMD mI, PolarizableMultipoleSIMD mK, DoubleVector scaleEnergy) {
        return this.polarizationEnergy(mI, mK);
    }

    public DoubleVector polarizationEnergy(PolarizableMultipoleSIMD mI, PolarizableMultipoleSIMD mK) {
        return switch (this.multipoleOrder) {
            default -> {
                this.chargeIPotentialAtK(mI, 1);
                DoubleVector eK = this.polarizationEnergy(mK);
                this.chargeKPotentialAtI(mK, 1);
                DoubleVector eI = this.polarizationEnergy(mI);
                yield eK.add((Vector)eI).mul(this.c * 0.5);
            }
            case GKMultipoleOrder.DIPOLE -> {
                this.dipoleIPotentialAtK(mI.dx, mI.dy, mI.dz, 1);
                DoubleVector eK = this.polarizationEnergy(mK);
                this.dipoleIPotentialAtK(mI.ux, mI.uy, mI.uz, 2);
                eK = this.multipoleEnergy(mK).mul(0.5).add((Vector)eK);
                this.dipoleKPotentialAtI(mK.dx, mK.dy, mK.dz, 1);
                DoubleVector eI = this.polarizationEnergy(mI);
                this.dipoleKPotentialAtI(mK.ux, mK.uy, mK.uz, 2);
                eI = this.multipoleEnergy(mI).mul(0.5).add((Vector)eI);
                yield eK.add((Vector)eI).mul(this.c * 0.5);
            }
            case GKMultipoleOrder.QUADRUPOLE -> {
                this.quadrupoleIPotentialAtK(mI, 1);
                DoubleVector eK = this.polarizationEnergy(mK);
                this.quadrupoleKPotentialAtI(mK, 1);
                DoubleVector eI = this.polarizationEnergy(mI);
                yield eK.add((Vector)eI).mul(this.c * 0.5);
            }
        };
    }

    public DoubleVector polarizationEnergyBorn(PolarizableMultipoleSIMD mI, PolarizableMultipoleSIMD mK) {
        return switch (this.multipoleOrder) {
            default -> {
                this.chargeIPotentialAtK(mI, 1);
                DoubleVector eK = this.polarizationEnergyS(mK);
                this.chargeKPotentialAtI(mK, 1);
                DoubleVector eI = this.polarizationEnergyS(mI);
                yield eK.add((Vector)eI).mul(this.c * 0.5);
            }
            case GKMultipoleOrder.DIPOLE -> {
                this.dipoleIPotentialAtK(mI.dx, mI.dy, mI.dz, 1);
                DoubleVector eK = this.polarizationEnergyS(mK);
                this.dipoleIPotentialAtK(mI.sx, mI.sy, mI.sz, 2);
                eK = this.multipoleEnergy(mK).mul(0.5).add((Vector)eK);
                this.dipoleKPotentialAtI(mK.dx, mK.dy, mK.dz, 1);
                DoubleVector eI = this.polarizationEnergyS(mI);
                this.dipoleKPotentialAtI(mK.sx, mK.sy, mK.sz, 2);
                eI = this.multipoleEnergy(mI).mul(0.5).add((Vector)eI);
                yield eK.add((Vector)eI).mul(this.c * 0.5);
            }
            case GKMultipoleOrder.QUADRUPOLE -> {
                this.quadrupoleIPotentialAtK(mI, 1);
                DoubleVector eK = this.polarizationEnergyS(mK);
                this.quadrupoleKPotentialAtI(mK, 1);
                DoubleVector eI = this.polarizationEnergyS(mI);
                yield eK.add((Vector)eI).mul(this.c * 0.5);
            }
        };
    }

    @Override
    public DoubleVector polarizationEnergyAndGradient(PolarizableMultipoleSIMD mI, PolarizableMultipoleSIMD mK, DoubleVector inductionMask, DoubleVector energyMask, DoubleVector mutualMask, DoubleVector[] Gi, DoubleVector[] Ti, DoubleVector[] Tk) {
        return switch (this.multipoleOrder) {
            default -> this.monopolePolarizationEnergyAndGradient(mI, mK, Gi);
            case GKMultipoleOrder.DIPOLE -> this.dipolePolarizationEnergyAndGradient(mI, mK, mutualMask, Gi, Ti, Tk);
            case GKMultipoleOrder.QUADRUPOLE -> this.quadrupolePolarizationEnergyAndGradient(mI, mK, Gi, Ti, Tk);
        };
    }

    public DoubleVector monopolePolarizationEnergyAndGradient(PolarizableMultipoleSIMD mI, PolarizableMultipoleSIMD mK, DoubleVector[] Gi) {
        this.chargeIPotentialAtK(mI, 2);
        DoubleVector eK = this.polarizationEnergy(mK);
        Gi[0] = mK.sx.mul((Vector)this.E200).add((Vector)mK.sy.mul((Vector)this.E110)).add((Vector)mK.sz.mul((Vector)this.E101)).neg();
        Gi[1] = mK.sx.mul((Vector)this.E110).add((Vector)mK.sy.mul((Vector)this.E020)).add((Vector)mK.sz.mul((Vector)this.E011)).neg();
        Gi[2] = mK.sx.mul((Vector)this.E101).add((Vector)mK.sy.mul((Vector)this.E011)).add((Vector)mK.sz.mul((Vector)this.E002)).neg();
        this.chargeKPotentialAtI(mK, 2);
        DoubleVector eI = this.polarizationEnergy(mI);
        Gi[0] = Gi[0].add((Vector)mI.sx.mul((Vector)this.E200)).add((Vector)mI.sy.mul((Vector)this.E110)).add((Vector)mI.sz.mul((Vector)this.E101));
        Gi[1] = Gi[1].add((Vector)mI.sx.mul((Vector)this.E110)).add((Vector)mI.sy.mul((Vector)this.E020)).add((Vector)mI.sz.mul((Vector)this.E011));
        Gi[2] = Gi[2].add((Vector)mI.sx.mul((Vector)this.E101)).add((Vector)mI.sy.mul((Vector)this.E011)).add((Vector)mI.sz.mul((Vector)this.E002));
        double scale = this.c * 0.5;
        Gi[0] = Gi[0].mul(scale);
        Gi[1] = Gi[1].mul(scale);
        Gi[2] = Gi[2].mul(scale);
        return eI.add((Vector)eK).mul(scale);
    }

    public DoubleVector dipolePolarizationEnergyAndGradient(PolarizableMultipoleSIMD mI, PolarizableMultipoleSIMD mK, DoubleVector mutualMask, DoubleVector[] Gi, DoubleVector[] Ti, DoubleVector[] Tk) {
        this.dipoleIPotentialAtK(mI.dx, mI.dy, mI.dz, 2);
        DoubleVector eK = this.polarizationEnergy(mK);
        Gi[0] = mK.sx.mul((Vector)this.E200).add((Vector)mK.sy.mul((Vector)this.E110)).add((Vector)mK.sz.mul((Vector)this.E101)).neg();
        Gi[1] = mK.sx.mul((Vector)this.E110).add((Vector)mK.sy.mul((Vector)this.E020)).add((Vector)mK.sz.mul((Vector)this.E011)).neg();
        Gi[2] = mK.sx.mul((Vector)this.E101).add((Vector)mK.sy.mul((Vector)this.E011)).add((Vector)mK.sz.mul((Vector)this.E002)).neg();
        this.dipoleIPotentialAtK(mI.sx, mI.sy, mI.sz, 2);
        this.dipoleTorque(mK, Tk);
        this.dipoleIPotentialAtK(mI.ux, mI.uy, mI.uz, 3);
        eK = eK.add((Vector)this.multipoleEnergy(mK).mul(0.5));
        DoubleVector[] G = new DoubleVector[3];
        this.multipoleGradient(mK, G);
        Gi[0] = Gi[0].sub((Vector)G[0]);
        Gi[1] = Gi[1].sub((Vector)G[1]);
        Gi[2] = Gi[2].sub((Vector)G[2]);
        this.multipoleTorque(mK, Tk);
        this.dipoleKPotentialAtI(mK.dx, mK.dy, mK.dz, 2);
        DoubleVector eI = this.polarizationEnergy(mI);
        Gi[0] = Gi[0].add((Vector)mI.sx.mul((Vector)this.E200)).add((Vector)mI.sy.mul((Vector)this.E110)).add((Vector)mI.sz.mul((Vector)this.E101));
        Gi[1] = Gi[1].add((Vector)mI.sx.mul((Vector)this.E110)).add((Vector)mI.sy.mul((Vector)this.E020)).add((Vector)mI.sz.mul((Vector)this.E011));
        Gi[2] = Gi[2].add((Vector)mI.sx.mul((Vector)this.E101)).add((Vector)mI.sy.mul((Vector)this.E011)).add((Vector)mI.sz.mul((Vector)this.E002));
        this.dipoleKPotentialAtI(mK.sx, mK.sy, mK.sz, 2);
        this.dipoleTorque(mI, Ti);
        this.dipoleKPotentialAtI(mK.ux, mK.uy, mK.uz, 3);
        eI = eI.add((Vector)this.multipoleEnergy(mI).mul(0.5));
        this.multipoleGradient(mI, G);
        Gi[0] = Gi[0].add((Vector)G[0]);
        Gi[1] = Gi[1].add((Vector)G[1]);
        Gi[2] = Gi[2].add((Vector)G[2]);
        this.multipoleTorque(mI, Ti);
        if (!mutualMask.eq((Vector)this.zero).allTrue()) {
            this.dipoleIPotentialAtK(mI.ux, mI.uy, mI.uz, 2);
            Gi[0] = Gi[0].sub((Vector)mK.px.mul((Vector)this.E200).add((Vector)mK.py.mul((Vector)this.E110)).add((Vector)mK.pz.mul((Vector)this.E101)).mul((Vector)mutualMask));
            Gi[1] = Gi[1].sub((Vector)mK.px.mul((Vector)this.E110).add((Vector)mK.py.mul((Vector)this.E020)).add((Vector)mK.pz.mul((Vector)this.E011)).mul((Vector)mutualMask));
            Gi[2] = Gi[2].sub((Vector)mK.px.mul((Vector)this.E101).add((Vector)mK.py.mul((Vector)this.E011)).add((Vector)mK.pz.mul((Vector)this.E002)).mul((Vector)mutualMask));
            this.dipoleKPotentialAtI(mK.ux, mK.uy, mK.uz, 2);
            Gi[0] = Gi[0].sub((Vector)mI.px.mul((Vector)this.E200).add((Vector)mI.py.mul((Vector)this.E110)).add((Vector)mI.pz.mul((Vector)this.E101)).mul((Vector)mutualMask));
            Gi[1] = Gi[1].sub((Vector)mI.px.mul((Vector)this.E110).add((Vector)mI.py.mul((Vector)this.E020)).add((Vector)mI.pz.mul((Vector)this.E011)).mul((Vector)mutualMask));
            Gi[2] = Gi[2].sub((Vector)mI.px.mul((Vector)this.E101).add((Vector)mI.py.mul((Vector)this.E011)).add((Vector)mI.pz.mul((Vector)this.E002)).mul((Vector)mutualMask));
        }
        double scale = this.c * 0.5;
        DoubleVector energy = eI.add((Vector)eK).mul(scale);
        Gi[0] = Gi[0].mul(scale);
        Gi[1] = Gi[1].mul(scale);
        Gi[2] = Gi[2].mul(scale);
        Ti[0] = Ti[0].mul(scale);
        Ti[1] = Ti[1].mul(scale);
        Ti[2] = Ti[2].mul(scale);
        Tk[0] = Tk[0].mul(scale);
        Tk[1] = Tk[1].mul(scale);
        Tk[2] = Tk[2].mul(scale);
        return energy;
    }

    public DoubleVector quadrupolePolarizationEnergyAndGradient(PolarizableMultipoleSIMD mI, PolarizableMultipoleSIMD mK, DoubleVector[] Gi, DoubleVector[] Ti, DoubleVector[] Tk) {
        this.quadrupoleIPotentialAtK(mI, 2);
        DoubleVector eK = this.polarizationEnergy(mK);
        Gi[0] = mK.sx.mul((Vector)this.E200).add((Vector)mK.sy.mul((Vector)this.E110)).add((Vector)mK.sz.mul((Vector)this.E101)).neg();
        Gi[1] = mK.sx.mul((Vector)this.E110).add((Vector)mK.sy.mul((Vector)this.E020)).add((Vector)mK.sz.mul((Vector)this.E011)).neg();
        Gi[2] = mK.sx.mul((Vector)this.E101).add((Vector)mK.sy.mul((Vector)this.E011)).add((Vector)mK.sz.mul((Vector)this.E002)).neg();
        this.quadrupoleKPotentialAtI(mK, 2);
        DoubleVector eI = this.polarizationEnergy(mI);
        Gi[0] = Gi[0].add((Vector)mI.sx.mul((Vector)this.E200)).add((Vector)mI.sy.mul((Vector)this.E110)).add((Vector)mI.sz.mul((Vector)this.E101));
        Gi[1] = Gi[1].add((Vector)mI.sx.mul((Vector)this.E110)).add((Vector)mI.sy.mul((Vector)this.E020)).add((Vector)mI.sz.mul((Vector)this.E011));
        Gi[2] = Gi[2].add((Vector)mI.sx.mul((Vector)this.E101)).add((Vector)mI.sy.mul((Vector)this.E011)).add((Vector)mI.sz.mul((Vector)this.E002));
        double scale = this.c * 0.5;
        Gi[0] = Gi[0].mul(scale);
        Gi[1] = Gi[1].mul(scale);
        Gi[2] = Gi[2].mul(scale);
        this.dipoleIPotentialAtK(mI.sx.mul(scale), mI.sy.mul(scale), mI.sz.mul(scale), 2);
        this.quadrupoleTorque(mK, Tk);
        this.dipoleKPotentialAtI(mK.sx.mul(scale), mK.sy.mul(scale), mK.sz.mul(scale), 2);
        this.quadrupoleTorque(mI, Ti);
        return eI.add((Vector)eK).mul(scale);
    }

    public DoubleVector polarizationEnergyBornGrad(PolarizableMultipoleSIMD mI, PolarizableMultipoleSIMD mK) {
        return this.polarizationEnergyBorn(mI, mK).mul(2.0);
    }

    public DoubleVector mutualPolarizationEnergyBornGrad(PolarizableMultipoleSIMD mI, PolarizableMultipoleSIMD mK) {
        DoubleVector db = this.zero;
        if (this.multipoleOrder == GKMultipoleOrder.DIPOLE) {
            this.dipoleIPotentialAtK(mI.ux, mI.uy, mI.uz, 2);
            db = mK.px.mul((Vector)this.E100).add((Vector)mK.py.mul((Vector)this.E010)).add((Vector)mK.pz.mul((Vector)this.E001)).mul(0.5);
            this.dipoleKPotentialAtI(mK.ux, mK.uy, mK.uz, 2);
            db = db.add((Vector)mI.px.mul((Vector)this.E100).add((Vector)mI.py.mul((Vector)this.E010)).add((Vector)mI.pz.mul((Vector)this.E001)).mul(0.5));
        }
        return db.mul(this.c);
    }

    @Override
    protected void source(DoubleVector[] work) {
        this.gkSource.source(work, this.multipoleOrder);
    }
}

