/*
 * Decompiled with CFR 0.152.
 */
package ffx.numerics.multipole;

import ffx.numerics.multipole.GKMultipoleOrder;
import ffx.numerics.multipole.GKSourceSIMD;
import ffx.numerics.multipole.GKTensorMode;
import ffx.numerics.multipole.GKTensorQISIMD;
import ffx.numerics.multipole.PolarizableMultipoleSIMD;
import jdk.incubator.vector.DoubleVector;
import jdk.incubator.vector.Vector;
import jdk.incubator.vector.VectorSpecies;

public class GKEnergyQISIMD {
    private final GKSourceSIMD gkSource;
    private final GKTensorQISIMD gkMonopole;
    private final GKTensorQISIMD gkDipole;
    private final GKTensorQISIMD gkQuadrupole;
    private final DoubleVector one = DoubleVector.zero((VectorSpecies)DoubleVector.SPECIES_PREFERRED).add(1.0);

    public GKEnergyQISIMD(double soluteDielectric, double solventDielectric, double gkc, boolean gradient) {
        int monopoleOrder = 2;
        int dipoleOrder = 3;
        int quadrupoleOrder = 4;
        if (gradient) {
            monopoleOrder = 3;
            dipoleOrder = 4;
            quadrupoleOrder = 5;
        }
        this.gkSource = new GKSourceSIMD(quadrupoleOrder, gkc);
        this.gkMonopole = new GKTensorQISIMD(GKMultipoleOrder.MONOPOLE, monopoleOrder, this.gkSource, soluteDielectric, solventDielectric);
        this.gkDipole = new GKTensorQISIMD(GKMultipoleOrder.DIPOLE, dipoleOrder, this.gkSource, soluteDielectric, solventDielectric);
        this.gkQuadrupole = new GKTensorQISIMD(GKMultipoleOrder.QUADRUPOLE, quadrupoleOrder, this.gkSource, soluteDielectric, solventDielectric);
    }

    public void initPotential(DoubleVector[] r, DoubleVector r2, DoubleVector rbi, DoubleVector rbk) {
        this.gkSource.generateSource(GKTensorMode.POTENTIAL, GKMultipoleOrder.QUADRUPOLE, r2, rbi, rbk);
        this.gkMonopole.setR(r);
        this.gkDipole.setR(r);
        this.gkQuadrupole.setR(r);
        this.gkMonopole.generateTensor();
        this.gkDipole.generateTensor();
        this.gkQuadrupole.generateTensor();
    }

    public void initBorn(DoubleVector[] r, DoubleVector r2, DoubleVector rbi, DoubleVector rbk) {
        this.gkSource.generateSource(GKTensorMode.BORN, GKMultipoleOrder.QUADRUPOLE, r2, rbi, rbk);
        this.gkMonopole.setR(r);
        this.gkDipole.setR(r);
        this.gkQuadrupole.setR(r);
        this.gkMonopole.generateTensor();
        this.gkDipole.generateTensor();
        this.gkQuadrupole.generateTensor();
    }

    public DoubleVector multipoleEnergy(PolarizableMultipoleSIMD mI, PolarizableMultipoleSIMD mK) {
        DoubleVector em = this.gkMonopole.multipoleEnergy(mI, mK);
        DoubleVector ed = this.gkDipole.multipoleEnergy(mI, mK);
        DoubleVector eq = this.gkQuadrupole.multipoleEnergy(mI, mK);
        return em.add((Vector)ed).add((Vector)eq);
    }

    public DoubleVector polarizationEnergy(PolarizableMultipoleSIMD mI, PolarizableMultipoleSIMD mK) {
        DoubleVector emp = this.gkMonopole.polarizationEnergy(mI, mK);
        DoubleVector edp = this.gkDipole.polarizationEnergy(mI, mK);
        DoubleVector eqp = this.gkQuadrupole.polarizationEnergy(mI, mK);
        return emp.add((Vector)edp).add((Vector)eqp);
    }

    public DoubleVector multipoleEnergyAndGradient(PolarizableMultipoleSIMD mI, PolarizableMultipoleSIMD mK, DoubleVector[] gI, DoubleVector[] tI, DoubleVector[] tK) {
        DoubleVector[] gK = new DoubleVector[3];
        DoubleVector em = this.gkMonopole.multipoleEnergyAndGradient(mI, mK, gI, gK, tI, tK);
        DoubleVector ed = this.gkDipole.multipoleEnergyAndGradient(mI, mK, gI, gK, tI, tK);
        DoubleVector eq = this.gkQuadrupole.multipoleEnergyAndGradient(mI, mK, gI, gK, tI, tK);
        return em.add((Vector)ed).add((Vector)eq);
    }

    public DoubleVector polarizationEnergyAndGradient(PolarizableMultipoleSIMD mI, PolarizableMultipoleSIMD mK, DoubleVector mutualMask, DoubleVector[] gI, DoubleVector[] tI, DoubleVector[] tK) {
        DoubleVector emp = this.gkMonopole.polarizationEnergyAndGradient(mI, mK, this.one, this.one, mutualMask, gI, tI, tK);
        DoubleVector edp = this.gkDipole.polarizationEnergyAndGradient(mI, mK, this.one, this.one, mutualMask, gI, tI, tK);
        DoubleVector eqp = this.gkQuadrupole.polarizationEnergyAndGradient(mI, mK, this.one, this.one, mutualMask, gI, tI, tK);
        return emp.add((Vector)edp).add((Vector)eqp);
    }

    public DoubleVector multipoleEnergyBornGrad(PolarizableMultipoleSIMD mI, PolarizableMultipoleSIMD mK) {
        DoubleVector db = this.gkMonopole.multipoleEnergyBornGrad(mI, mK);
        db = db.add((Vector)this.gkDipole.multipoleEnergyBornGrad(mI, mK));
        db = db.add((Vector)this.gkQuadrupole.multipoleEnergyBornGrad(mI, mK));
        return db;
    }

    public DoubleVector polarizationEnergyBornGrad(PolarizableMultipoleSIMD mI, PolarizableMultipoleSIMD mK, boolean mutual) {
        DoubleVector db = this.gkMonopole.polarizationEnergyBornGrad(mI, mK);
        db = db.add((Vector)this.gkDipole.polarizationEnergyBornGrad(mI, mK));
        db = db.add((Vector)this.gkQuadrupole.polarizationEnergyBornGrad(mI, mK));
        if (mutual) {
            db = db.add((Vector)this.gkDipole.mutualPolarizationEnergyBornGrad(mI, mK));
        }
        return db;
    }
}

