/*
 * Decompiled with CFR 0.152.
 */
package ffx.numerics.multipole;

import ffx.numerics.multipole.CoulombTensorQI;
import ffx.numerics.multipole.EwaldTensorGlobal;
import ffx.numerics.multipole.Operator;

public class EwaldTensorQI
extends CoulombTensorQI {
    private final double[] ewaldSource;
    private final double beta;

    public EwaldTensorQI(int order, double beta) {
        super(order);
        this.beta = beta;
        this.operator = Operator.SCREENED_COULOMB;
        this.ewaldSource = new double[this.o1];
        EwaldTensorGlobal.initEwaldSource(order, beta, this.ewaldSource);
    }

    @Override
    protected void source(double[] T000) {
        if (this.beta > 0.0) {
            EwaldTensorGlobal.fillEwaldSource(this.order, this.beta, this.ewaldSource, this.R, T000);
        } else {
            super.source(T000);
        }
    }
}

