/*
 * Decompiled with CFR 0.152.
 */
package ffx.numerics.multipole;

import ffx.numerics.multipole.CoordinateSystem;
import ffx.numerics.multipole.MultipoleTensor;
import ffx.numerics.multipole.MultipoleUtilities;
import ffx.numerics.multipole.Operator;
import ffx.numerics.multipole.PolarizableMultipole;
import org.apache.commons.math3.util.FastMath;

public class CoulombTensorQI
extends MultipoleTensor {
    public CoulombTensorQI(int order) {
        super(CoordinateSystem.QI, order);
        this.operator = Operator.COULOMB;
    }

    @Override
    public void setR(double dx, double dy, double dz) {
        this.x = 0.0;
        this.y = 0.0;
        this.r2 = dx * dx + dy * dy + dz * dz;
        this.R = this.z = FastMath.sqrt((double)this.r2);
    }

    @Override
    protected void source(double[] T000) {
        double ir = 1.0 / this.R;
        double ir2 = ir * ir;
        for (int n = 0; n < this.o1; ++n) {
            T000[n] = this.coulombSource[n] * ir;
            ir *= ir2;
        }
    }

    @Override
    protected void order1() {
        this.source(this.work);
        double term0000 = this.work[0];
        double term0001 = this.work[1];
        this.R000 = term0000;
        this.R001 = this.z * term0001;
    }

    @Override
    protected void order2() {
        this.source(this.work);
        double term0000 = this.work[0];
        double term0001 = this.work[1];
        double term0002 = this.work[2];
        this.R000 = term0000;
        this.R200 = term0001;
        this.R020 = term0001;
        this.R001 = this.z * term0001;
        double term0011 = this.z * term0002;
        this.R002 = Math.fma(this.z, term0011, term0001);
    }

    @Override
    protected void order3() {
        this.source(this.work);
        double term0000 = this.work[0];
        double term0001 = this.work[1];
        double term0002 = this.work[2];
        double term0003 = this.work[3];
        this.R000 = term0000;
        this.R200 = term0001;
        double term2001 = term0002;
        this.R020 = term0001;
        double term0201 = term0002;
        this.R001 = this.z * term0001;
        double term0011 = this.z * term0002;
        this.R002 = Math.fma(this.z, term0011, term0001);
        double term0012 = this.z * term0003;
        double term0021 = Math.fma(this.z, term0012, term0002);
        this.R003 = Math.fma(this.z, term0021, 2.0 * term0011);
        this.R021 = this.z * term0201;
        this.R201 = this.z * term2001;
    }

    @Override
    protected void order4() {
        this.source(this.work);
        double term0000 = this.work[0];
        double term0001 = this.work[1];
        double term0002 = this.work[2];
        double term0003 = this.work[3];
        double term0004 = this.work[4];
        this.R000 = term0000;
        this.R200 = term0001;
        double term2001 = term0002;
        double term2002 = term0003;
        this.R400 = 3.0 * term2001;
        this.R020 = term0001;
        double term0201 = term0002;
        double term0202 = term0003;
        this.R040 = 3.0 * term0201;
        this.R220 = term2001;
        this.R001 = this.z * term0001;
        double term0011 = this.z * term0002;
        this.R002 = Math.fma(this.z, term0011, term0001);
        double term0012 = this.z * term0003;
        double term0021 = Math.fma(this.z, term0012, term0002);
        this.R003 = Math.fma(this.z, term0021, 2.0 * term0011);
        double term0013 = this.z * term0004;
        double term0022 = Math.fma(this.z, term0013, term0003);
        double term0031 = Math.fma(this.z, term0022, 2.0 * term0012);
        this.R004 = Math.fma(this.z, term0031, 3.0 * term0021);
        this.R021 = this.z * term0201;
        double term0211 = this.z * term0202;
        this.R022 = Math.fma(this.z, term0211, term0201);
        this.R201 = this.z * term2001;
        double term2011 = this.z * term2002;
        this.R202 = Math.fma(this.z, term2011, term2001);
    }

    @Override
    protected void order5() {
        this.source(this.work);
        double term0000 = this.work[0];
        double term0001 = this.work[1];
        double term0002 = this.work[2];
        double term0003 = this.work[3];
        double term0004 = this.work[4];
        double term0005 = this.work[5];
        this.R000 = term0000;
        this.R200 = term0001;
        double term2001 = term0002;
        double term2002 = term0003;
        this.R400 = 3.0 * term2001;
        double term2003 = term0004;
        double term4001 = 3.0 * term2002;
        this.R020 = term0001;
        double term0201 = term0002;
        double term0202 = term0003;
        this.R040 = 3.0 * term0201;
        double term0203 = term0004;
        double term0401 = 3.0 * term0202;
        this.R220 = term2001;
        double term2201 = term2002;
        this.R001 = this.z * term0001;
        double term0011 = this.z * term0002;
        this.R002 = Math.fma(this.z, term0011, term0001);
        double term0012 = this.z * term0003;
        double term0021 = Math.fma(this.z, term0012, term0002);
        this.R003 = Math.fma(this.z, term0021, 2.0 * term0011);
        double term0013 = this.z * term0004;
        double term0022 = Math.fma(this.z, term0013, term0003);
        double term0031 = Math.fma(this.z, term0022, 2.0 * term0012);
        this.R004 = Math.fma(this.z, term0031, 3.0 * term0021);
        double term0014 = this.z * term0005;
        double term0023 = Math.fma(this.z, term0014, term0004);
        double term0032 = Math.fma(this.z, term0023, 2.0 * term0013);
        double term0041 = Math.fma(this.z, term0032, 3.0 * term0022);
        this.R005 = Math.fma(this.z, term0041, 4.0 * term0031);
        this.R021 = this.z * term0201;
        double term0211 = this.z * term0202;
        this.R022 = Math.fma(this.z, term0211, term0201);
        double term0212 = this.z * term0203;
        double term0221 = Math.fma(this.z, term0212, term0202);
        this.R023 = Math.fma(this.z, term0221, 2.0 * term0211);
        this.R041 = this.z * term0401;
        this.R201 = this.z * term2001;
        double term2011 = this.z * term2002;
        this.R202 = Math.fma(this.z, term2011, term2001);
        double term2012 = this.z * term2003;
        double term2021 = Math.fma(this.z, term2012, term2002);
        this.R203 = Math.fma(this.z, term2021, 2.0 * term2011);
        this.R221 = this.z * term2201;
        this.R401 = this.z * term4001;
    }

    @Override
    protected void order6() {
        this.source(this.work);
        double term0000 = this.work[0];
        double term0001 = this.work[1];
        double term0002 = this.work[2];
        double term0003 = this.work[3];
        double term0004 = this.work[4];
        double term0005 = this.work[5];
        double term0006 = this.work[6];
        this.R000 = term0000;
        this.R200 = term0001;
        double term2001 = term0002;
        double term2002 = term0003;
        this.R400 = 3.0 * term2001;
        double term2003 = term0004;
        double term4001 = 3.0 * term2002;
        double term2004 = term0005;
        double term4002 = 3.0 * term2003;
        this.R600 = 5.0 * term4001;
        this.R020 = term0001;
        double term0201 = term0002;
        double term0202 = term0003;
        this.R040 = 3.0 * term0201;
        double term0203 = term0004;
        double term0401 = 3.0 * term0202;
        double term0204 = term0005;
        double term0402 = 3.0 * term0203;
        this.R060 = 5.0 * term0401;
        this.R220 = term2001;
        double term2201 = term2002;
        double term2202 = term2003;
        this.R240 = 3.0 * term2201;
        this.R420 = term4001;
        this.R001 = this.z * term0001;
        double term0011 = this.z * term0002;
        this.R002 = Math.fma(this.z, term0011, term0001);
        double term0012 = this.z * term0003;
        double term0021 = Math.fma(this.z, term0012, term0002);
        this.R003 = Math.fma(this.z, term0021, 2.0 * term0011);
        double term0013 = this.z * term0004;
        double term0022 = Math.fma(this.z, term0013, term0003);
        double term0031 = Math.fma(this.z, term0022, 2.0 * term0012);
        this.R004 = Math.fma(this.z, term0031, 3.0 * term0021);
        double term0014 = this.z * term0005;
        double term0023 = Math.fma(this.z, term0014, term0004);
        double term0032 = Math.fma(this.z, term0023, 2.0 * term0013);
        double term0041 = Math.fma(this.z, term0032, 3.0 * term0022);
        this.R005 = Math.fma(this.z, term0041, 4.0 * term0031);
        double term0015 = this.z * term0006;
        double term0024 = Math.fma(this.z, term0015, term0005);
        double term0033 = Math.fma(this.z, term0024, 2.0 * term0014);
        double term0042 = Math.fma(this.z, term0033, 3.0 * term0023);
        double term0051 = Math.fma(this.z, term0042, 4.0 * term0032);
        this.R006 = Math.fma(this.z, term0051, 5.0 * term0041);
        this.R021 = this.z * term0201;
        double term0211 = this.z * term0202;
        this.R022 = Math.fma(this.z, term0211, term0201);
        double term0212 = this.z * term0203;
        double term0221 = Math.fma(this.z, term0212, term0202);
        this.R023 = Math.fma(this.z, term0221, 2.0 * term0211);
        double term0213 = this.z * term0204;
        double term0222 = Math.fma(this.z, term0213, term0203);
        double term0231 = Math.fma(this.z, term0222, 2.0 * term0212);
        this.R024 = Math.fma(this.z, term0231, 3.0 * term0221);
        this.R041 = this.z * term0401;
        double term0411 = this.z * term0402;
        this.R042 = Math.fma(this.z, term0411, term0401);
        this.R201 = this.z * term2001;
        double term2011 = this.z * term2002;
        this.R202 = Math.fma(this.z, term2011, term2001);
        double term2012 = this.z * term2003;
        double term2021 = Math.fma(this.z, term2012, term2002);
        this.R203 = Math.fma(this.z, term2021, 2.0 * term2011);
        double term2013 = this.z * term2004;
        double term2022 = Math.fma(this.z, term2013, term2003);
        double term2031 = Math.fma(this.z, term2022, 2.0 * term2012);
        this.R204 = Math.fma(this.z, term2031, 3.0 * term2021);
        this.R221 = this.z * term2201;
        double term2211 = this.z * term2202;
        this.R222 = Math.fma(this.z, term2211, term2201);
        this.R401 = this.z * term4001;
        double term4011 = this.z * term4002;
        this.R402 = Math.fma(this.z, term4011, term4001);
    }

    @Override
    protected void multipoleIPotentialAtK(PolarizableMultipole mI, int order) {
        switch (order) {
            default: {
                double term300 = 0.0;
                term300 = Math.fma(mI.dx, -this.R400, term300);
                this.E300 = term300 = Math.fma(mI.qxz, this.R401, term300);
                double term030 = 0.0;
                term030 = Math.fma(mI.dy, -this.R040, term030);
                this.E030 = term030 = Math.fma(mI.qyz, this.R041, term030);
                double term003 = 0.0;
                term003 = Math.fma(mI.q, this.R003, term003);
                term003 = Math.fma(mI.dz, -this.R004, term003);
                term003 = Math.fma(mI.qxx, this.R203, term003);
                term003 = Math.fma(mI.qyy, this.R023, term003);
                this.E003 = term003 = Math.fma(mI.qzz, this.R005, term003);
                double term210 = 0.0;
                term210 = Math.fma(mI.dy, -this.R220, term210);
                this.E210 = term210 = Math.fma(mI.qyz, this.R221, term210);
                double term201 = 0.0;
                term201 = Math.fma(mI.q, this.R201, term201);
                term201 = Math.fma(mI.dz, -this.R202, term201);
                term201 = Math.fma(mI.qxx, this.R401, term201);
                term201 = Math.fma(mI.qyy, this.R221, term201);
                this.E201 = term201 = Math.fma(mI.qzz, this.R203, term201);
                double term120 = 0.0;
                term120 = Math.fma(mI.dx, -this.R220, term120);
                this.E120 = term120 = Math.fma(mI.qxz, this.R221, term120);
                double term021 = 0.0;
                term021 = Math.fma(mI.q, this.R021, term021);
                term021 = Math.fma(mI.dz, -this.R022, term021);
                term021 = Math.fma(mI.qxx, this.R221, term021);
                term021 = Math.fma(mI.qyy, this.R041, term021);
                this.E021 = term021 = Math.fma(mI.qzz, this.R023, term021);
                double term102 = 0.0;
                term102 = Math.fma(mI.dx, -this.R202, term102);
                this.E102 = term102 = Math.fma(mI.qxz, this.R203, term102);
                double term012 = 0.0;
                term012 = Math.fma(mI.dy, -this.R022, term012);
                this.E012 = term012 = Math.fma(mI.qyz, this.R023, term012);
                double term111 = 0.0;
                this.E111 = term111 = Math.fma(mI.qxy, this.R221, term111);
            }
            case 2: {
                double term200 = 0.0;
                term200 = Math.fma(mI.q, this.R200, term200);
                term200 = Math.fma(mI.dz, -this.R201, term200);
                term200 = Math.fma(mI.qxx, this.R400, term200);
                term200 = Math.fma(mI.qyy, this.R220, term200);
                this.E200 = term200 = Math.fma(mI.qzz, this.R202, term200);
                double term020 = 0.0;
                term020 = Math.fma(mI.q, this.R020, term020);
                term020 = Math.fma(mI.dz, -this.R021, term020);
                term020 = Math.fma(mI.qxx, this.R220, term020);
                term020 = Math.fma(mI.qyy, this.R040, term020);
                this.E020 = term020 = Math.fma(mI.qzz, this.R022, term020);
                double term002 = 0.0;
                term002 = Math.fma(mI.q, this.R002, term002);
                term002 = Math.fma(mI.dz, -this.R003, term002);
                term002 = Math.fma(mI.qxx, this.R202, term002);
                term002 = Math.fma(mI.qyy, this.R022, term002);
                this.E002 = term002 = Math.fma(mI.qzz, this.R004, term002);
                double term110 = 0.0;
                this.E110 = term110 = Math.fma(mI.qxy, this.R220, term110);
                double term101 = 0.0;
                term101 = Math.fma(mI.dx, -this.R201, term101);
                this.E101 = term101 = Math.fma(mI.qxz, this.R202, term101);
                double term011 = 0.0;
                term011 = Math.fma(mI.dy, -this.R021, term011);
                this.E011 = term011 = Math.fma(mI.qyz, this.R022, term011);
            }
            case 1: {
                double term100 = 0.0;
                term100 = Math.fma(mI.dx, -this.R200, term100);
                this.E100 = term100 = Math.fma(mI.qxz, this.R201, term100);
                double term010 = 0.0;
                term010 = Math.fma(mI.dy, -this.R020, term010);
                this.E010 = term010 = Math.fma(mI.qyz, this.R021, term010);
                double term001 = 0.0;
                term001 = Math.fma(mI.q, this.R001, term001);
                term001 = Math.fma(mI.dz, -this.R002, term001);
                term001 = Math.fma(mI.qxx, this.R201, term001);
                term001 = Math.fma(mI.qyy, this.R021, term001);
                this.E001 = term001 = Math.fma(mI.qzz, this.R003, term001);
            }
            case 0: 
        }
        double term000 = 0.0;
        term000 = Math.fma(mI.q, this.R000, term000);
        term000 = Math.fma(mI.dz, -this.R001, term000);
        term000 = Math.fma(mI.qxx, this.R200, term000);
        term000 = Math.fma(mI.qyy, this.R020, term000);
        this.E000 = term000 = Math.fma(mI.qzz, this.R002, term000);
    }

    @Override
    protected void chargeIPotentialAtK(PolarizableMultipole mI, int order) {
        switch (order) {
            default: {
                this.E300 = 0.0;
                this.E030 = 0.0;
                this.E003 = mI.q * this.R003;
                this.E210 = 0.0;
                this.E201 = mI.q * this.R201;
                this.E120 = 0.0;
                this.E021 = mI.q * this.R021;
                this.E102 = 0.0;
                this.E012 = 0.0;
                this.E111 = 0.0;
            }
            case 2: {
                this.E200 = mI.q * this.R200;
                this.E020 = mI.q * this.R020;
                this.E002 = mI.q * this.R002;
                this.E110 = 0.0;
                this.E101 = 0.0;
                this.E011 = 0.0;
            }
            case 1: {
                this.E100 = 0.0;
                this.E010 = 0.0;
                this.E001 = mI.q * this.R001;
            }
            case 0: 
        }
        this.E000 = mI.q * this.R000;
    }

    @Override
    protected void dipoleIPotentialAtK(double uxi, double uyi, double uzi, int order) {
        switch (order) {
            default: {
                this.E300 = -uxi * this.R400;
                this.E030 = -uyi * this.R040;
                this.E003 = -uzi * this.R004;
                this.E210 = -uyi * this.R220;
                this.E201 = -uzi * this.R202;
                this.E120 = -uxi * this.R220;
                this.E021 = -uzi * this.R022;
                this.E102 = -uxi * this.R202;
                this.E012 = -uyi * this.R022;
                this.E111 = 0.0;
            }
            case 2: {
                this.E200 = -uzi * this.R201;
                this.E020 = -uzi * this.R021;
                this.E002 = -uzi * this.R003;
                this.E110 = 0.0;
                this.E101 = -uxi * this.R201;
                this.E011 = -uyi * this.R021;
            }
            case 1: {
                this.E100 = -uxi * this.R200;
                this.E010 = -uyi * this.R020;
                this.E001 = -uzi * this.R002;
            }
            case 0: 
        }
        this.E000 = -uzi * this.R001;
    }

    @Override
    protected void quadrupoleIPotentialAtK(PolarizableMultipole mI, int order) {
        switch (order) {
            default: {
                this.E300 = mI.qxz * this.R401;
                this.E030 = mI.qyz * this.R041;
                double term003 = 0.0;
                term003 = Math.fma(mI.qxx, this.R203, term003);
                term003 = Math.fma(mI.qyy, this.R023, term003);
                this.E003 = term003 = Math.fma(mI.qzz, this.R005, term003);
                this.E210 = mI.qyz * this.R221;
                double term201 = 0.0;
                term201 = Math.fma(mI.qxx, this.R401, term201);
                term201 = Math.fma(mI.qyy, this.R221, term201);
                this.E201 = term201 = Math.fma(mI.qzz, this.R203, term201);
                this.E120 = mI.qxz * this.R221;
                double term021 = 0.0;
                term021 = Math.fma(mI.qxx, this.R221, term021);
                term021 = Math.fma(mI.qyy, this.R041, term021);
                this.E021 = term021 = Math.fma(mI.qzz, this.R023, term021);
                this.E102 = mI.qxz * this.R203;
                this.E012 = mI.qyz * this.R023;
                this.E111 = mI.qxy * this.R221;
            }
            case 2: {
                double term200 = 0.0;
                term200 = Math.fma(mI.qxx, this.R400, term200);
                term200 = Math.fma(mI.qyy, this.R220, term200);
                this.E200 = term200 = Math.fma(mI.qzz, this.R202, term200);
                double term020 = 0.0;
                term020 = Math.fma(mI.qxx, this.R220, term020);
                term020 = Math.fma(mI.qyy, this.R040, term020);
                this.E020 = term020 = Math.fma(mI.qzz, this.R022, term020);
                double term002 = 0.0;
                term002 = Math.fma(mI.qxx, this.R202, term002);
                term002 = Math.fma(mI.qyy, this.R022, term002);
                this.E002 = term002 = Math.fma(mI.qzz, this.R004, term002);
                this.E110 = mI.qxy * this.R220;
                this.E101 = mI.qxz * this.R202;
                this.E011 = mI.qyz * this.R022;
            }
            case 1: {
                this.E100 = mI.qxz * this.R201;
                this.E010 = mI.qyz * this.R021;
                double term001 = 0.0;
                term001 = Math.fma(mI.qxx, this.R201, term001);
                term001 = Math.fma(mI.qyy, this.R021, term001);
                this.E001 = term001 = Math.fma(mI.qzz, this.R003, term001);
            }
            case 0: 
        }
        double term000 = 0.0;
        term000 = Math.fma(mI.qxx, this.R200, term000);
        term000 = Math.fma(mI.qyy, this.R020, term000);
        this.E000 = term000 = Math.fma(mI.qzz, this.R002, term000);
    }

    @Override
    protected void multipoleKPotentialAtI(PolarizableMultipole mK, int order) {
        switch (order) {
            default: {
                double term300 = 0.0;
                term300 = Math.fma(mK.dx, this.R400, term300);
                term300 = Math.fma(mK.qxz, this.R401, term300);
                this.E300 = -term300;
                double term030 = 0.0;
                term030 = Math.fma(mK.dy, this.R040, term030);
                term030 = Math.fma(mK.qyz, this.R041, term030);
                this.E030 = -term030;
                double term003 = 0.0;
                term003 = Math.fma(mK.q, this.R003, term003);
                term003 = Math.fma(mK.dz, this.R004, term003);
                term003 = Math.fma(mK.qxx, this.R203, term003);
                term003 = Math.fma(mK.qyy, this.R023, term003);
                term003 = Math.fma(mK.qzz, this.R005, term003);
                this.E003 = -term003;
                double term210 = 0.0;
                term210 = Math.fma(mK.dy, this.R220, term210);
                term210 = Math.fma(mK.qyz, this.R221, term210);
                this.E210 = -term210;
                double term201 = 0.0;
                term201 = Math.fma(mK.q, this.R201, term201);
                term201 = Math.fma(mK.dz, this.R202, term201);
                term201 = Math.fma(mK.qxx, this.R401, term201);
                term201 = Math.fma(mK.qyy, this.R221, term201);
                term201 = Math.fma(mK.qzz, this.R203, term201);
                this.E201 = -term201;
                double term120 = 0.0;
                term120 = Math.fma(mK.dx, this.R220, term120);
                term120 = Math.fma(mK.qxz, this.R221, term120);
                this.E120 = -term120;
                double term021 = 0.0;
                term021 = Math.fma(mK.q, this.R021, term021);
                term021 = Math.fma(mK.dz, this.R022, term021);
                term021 = Math.fma(mK.qxx, this.R221, term021);
                term021 = Math.fma(mK.qyy, this.R041, term021);
                term021 = Math.fma(mK.qzz, this.R023, term021);
                this.E021 = -term021;
                double term102 = 0.0;
                term102 = Math.fma(mK.dx, this.R202, term102);
                term102 = Math.fma(mK.qxz, this.R203, term102);
                this.E102 = -term102;
                double term012 = 0.0;
                term012 = Math.fma(mK.dy, this.R022, term012);
                term012 = Math.fma(mK.qyz, this.R023, term012);
                this.E012 = -term012;
                double term111 = 0.0;
                term111 = Math.fma(mK.qxy, this.R221, term111);
                this.E111 = -term111;
            }
            case 2: {
                double term200 = 0.0;
                term200 = Math.fma(mK.q, this.R200, term200);
                term200 = Math.fma(mK.dz, this.R201, term200);
                term200 = Math.fma(mK.qxx, this.R400, term200);
                term200 = Math.fma(mK.qyy, this.R220, term200);
                this.E200 = term200 = Math.fma(mK.qzz, this.R202, term200);
                double term020 = 0.0;
                term020 = Math.fma(mK.q, this.R020, term020);
                term020 = Math.fma(mK.dz, this.R021, term020);
                term020 = Math.fma(mK.qxx, this.R220, term020);
                term020 = Math.fma(mK.qyy, this.R040, term020);
                this.E020 = term020 = Math.fma(mK.qzz, this.R022, term020);
                double term002 = 0.0;
                term002 = Math.fma(mK.q, this.R002, term002);
                term002 = Math.fma(mK.dz, this.R003, term002);
                term002 = Math.fma(mK.qxx, this.R202, term002);
                term002 = Math.fma(mK.qyy, this.R022, term002);
                this.E002 = term002 = Math.fma(mK.qzz, this.R004, term002);
                double term110 = 0.0;
                this.E110 = term110 = Math.fma(mK.qxy, this.R220, term110);
                double term101 = 0.0;
                term101 = Math.fma(mK.dx, this.R201, term101);
                this.E101 = term101 = Math.fma(mK.qxz, this.R202, term101);
                double term011 = 0.0;
                term011 = Math.fma(mK.dy, this.R021, term011);
                this.E011 = term011 = Math.fma(mK.qyz, this.R022, term011);
            }
            case 1: {
                double term100 = 0.0;
                term100 = Math.fma(mK.dx, this.R200, term100);
                term100 = Math.fma(mK.qxz, this.R201, term100);
                this.E100 = -term100;
                double term010 = 0.0;
                term010 = Math.fma(mK.dy, this.R020, term010);
                term010 = Math.fma(mK.qyz, this.R021, term010);
                this.E010 = -term010;
                double term001 = 0.0;
                term001 = Math.fma(mK.q, this.R001, term001);
                term001 = Math.fma(mK.dz, this.R002, term001);
                term001 = Math.fma(mK.qxx, this.R201, term001);
                term001 = Math.fma(mK.qyy, this.R021, term001);
                term001 = Math.fma(mK.qzz, this.R003, term001);
                this.E001 = -term001;
            }
            case 0: 
        }
        double term000 = 0.0;
        term000 = Math.fma(mK.q, this.R000, term000);
        term000 = Math.fma(mK.dz, this.R001, term000);
        term000 = Math.fma(mK.qxx, this.R200, term000);
        term000 = Math.fma(mK.qyy, this.R020, term000);
        this.E000 = term000 = Math.fma(mK.qzz, this.R002, term000);
    }

    @Override
    protected void chargeKPotentialAtI(PolarizableMultipole mK, int order) {
        switch (order) {
            default: {
                this.E300 = 0.0;
                this.E030 = 0.0;
                this.E003 = -mK.q * this.R003;
                this.E210 = 0.0;
                this.E201 = -mK.q * this.R201;
                this.E120 = 0.0;
                this.E021 = -mK.q * this.R021;
                this.E102 = 0.0;
                this.E012 = 0.0;
                this.E111 = 0.0;
            }
            case 2: {
                this.E200 = mK.q * this.R200;
                this.E020 = mK.q * this.R020;
                this.E002 = mK.q * this.R002;
                this.E110 = 0.0;
                this.E101 = 0.0;
                this.E011 = 0.0;
            }
            case 1: {
                this.E100 = 0.0;
                this.E010 = 0.0;
                this.E001 = -mK.q * this.R001;
            }
            case 0: 
        }
        this.E000 = mK.q * this.R000;
    }

    @Override
    protected void dipoleKPotentialAtI(double uxk, double uyk, double uzk, int order) {
        switch (order) {
            default: {
                this.E300 = -uxk * this.R400;
                this.E030 = -uyk * this.R040;
                this.E003 = -uzk * this.R004;
                this.E210 = -uyk * this.R220;
                this.E201 = -uzk * this.R202;
                this.E120 = -uxk * this.R220;
                this.E021 = -uzk * this.R022;
                this.E102 = -uxk * this.R202;
                this.E012 = -uyk * this.R022;
                this.E111 = 0.0;
            }
            case 2: {
                this.E200 = uzk * this.R201;
                this.E020 = uzk * this.R021;
                this.E002 = uzk * this.R003;
                this.E110 = 0.0;
                this.E101 = uxk * this.R201;
                this.E011 = uyk * this.R021;
            }
            case 1: {
                this.E100 = -uxk * this.R200;
                this.E010 = -uyk * this.R020;
                this.E001 = -uzk * this.R002;
            }
            case 0: 
        }
        this.E000 = uzk * this.R001;
    }

    @Override
    protected void quadrupoleKPotentialAtI(PolarizableMultipole mK, int order) {
        switch (order) {
            default: {
                this.E300 = -mK.qxz * this.R401;
                this.E030 = -mK.qyz * this.R041;
                double term003 = 0.0;
                term003 = Math.fma(mK.qxx, this.R203, term003);
                term003 = Math.fma(mK.qyy, this.R023, term003);
                term003 = Math.fma(mK.qzz, this.R005, term003);
                this.E003 = -term003;
                this.E210 = -mK.qyz * this.R221;
                double term201 = 0.0;
                term201 = Math.fma(mK.qxx, this.R401, term201);
                term201 = Math.fma(mK.qyy, this.R221, term201);
                term201 = Math.fma(mK.qzz, this.R203, term201);
                this.E201 = -term201;
                this.E120 = -mK.qxz * this.R221;
                double term021 = 0.0;
                term021 = Math.fma(mK.qxx, this.R221, term021);
                term021 = Math.fma(mK.qyy, this.R041, term021);
                term021 = Math.fma(mK.qzz, this.R023, term021);
                this.E021 = -term021;
                this.E102 = -mK.qxz * this.R203;
                this.E012 = -mK.qyz * this.R023;
                this.E111 = -mK.qxy * this.R221;
            }
            case 2: {
                double term200 = 0.0;
                term200 = Math.fma(mK.qxx, this.R400, term200);
                term200 = Math.fma(mK.qyy, this.R220, term200);
                this.E200 = term200 = Math.fma(mK.qzz, this.R202, term200);
                double term020 = 0.0;
                term020 = Math.fma(mK.qxx, this.R220, term020);
                term020 = Math.fma(mK.qyy, this.R040, term020);
                this.E020 = term020 = Math.fma(mK.qzz, this.R022, term020);
                double term002 = 0.0;
                term002 = Math.fma(mK.qxx, this.R202, term002);
                term002 = Math.fma(mK.qyy, this.R022, term002);
                this.E002 = term002 = Math.fma(mK.qzz, this.R004, term002);
                this.E110 = mK.qxy * this.R220;
                this.E101 = mK.qxz * this.R202;
                this.E011 = mK.qyz * this.R022;
            }
            case 1: {
                this.E100 = -mK.qxz * this.R201;
                this.E010 = -mK.qyz * this.R021;
                double term001 = 0.0;
                term001 = Math.fma(mK.qxx, this.R201, term001);
                term001 = Math.fma(mK.qyy, this.R021, term001);
                term001 = Math.fma(mK.qzz, this.R003, term001);
                this.E001 = -term001;
            }
            case 0: 
        }
        double term000 = 0.0;
        term000 = Math.fma(mK.qxx, this.R200, term000);
        term000 = Math.fma(mK.qyy, this.R020, term000);
        this.E000 = term000 = Math.fma(mK.qzz, this.R002, term000);
    }

    @Override
    protected double Tlmnj(int l, int m, int n, int j, double[] r, double[] T000) {
        double z = r[2];
        assert (r[0] == 0.0 && r[1] == 0.0);
        if (m == 0 && n == 0) {
            if (l > 1) {
                return (double)(l - 1) * this.Tlmnj(l - 2, 0, 0, j + 1, r, T000);
            }
            if (l == 1) {
                return 0.0;
            }
            return T000[j];
        }
        if (n == 0) {
            if (m > 1) {
                return (double)(m - 1) * this.Tlmnj(l, m - 2, 0, j + 1, r, T000);
            }
            return 0.0;
        }
        if (n > 1) {
            return z * this.Tlmnj(l, m, n - 1, j + 1, r, T000) + (double)(n - 1) * this.Tlmnj(l, m, n - 2, j + 1, r, T000);
        }
        return z * this.Tlmnj(l, m, 0, j + 1, r, T000);
    }

    @Override
    protected void noStorageRecursion(double[] r, double[] tensor) {
        this.setR(r);
        this.noStorageRecursion(tensor);
    }

    @Override
    protected void noStorageRecursion(double[] tensor) {
        int m;
        int l;
        assert (this.x == 0.0 && this.y == 0.0);
        double[] r = new double[]{this.x, this.y, this.z};
        this.source(this.T000);
        tensor[0] = this.T000[0];
        for (l = 1; l <= this.order; ++l) {
            tensor[this.ti((int)l, (int)0, (int)0)] = this.Tlmnj(l, 0, 0, 0, r, this.T000);
        }
        for (l = 0; l <= this.o1; ++l) {
            for (m = 1; m <= this.order - l; ++m) {
                tensor[this.ti((int)l, (int)m, (int)0)] = this.Tlmnj(l, m, 0, 0, r, this.T000);
            }
        }
        for (l = 0; l <= this.o1; ++l) {
            for (m = 0; m <= this.o1 - l; ++m) {
                for (int n = 1; n <= this.order - l - m; ++n) {
                    tensor[this.ti((int)l, (int)m, (int)n)] = this.Tlmnj(l, m, n, 0, r, this.T000);
                }
            }
        }
    }

    @Override
    protected void recursion(double[] r, double[] tensor) {
        this.setR(r);
        this.recursion(tensor);
    }

    @Override
    protected void recursion(double[] tensor) {
        int m;
        double current;
        int l;
        assert (this.x == 0.0 && this.y == 0.0);
        this.source(this.work);
        tensor[0] = this.work[0];
        double previous = this.work[1];
        tensor[this.ti((int)1, (int)0, (int)0)] = 0.0;
        for (l = 2; l < this.o1; ++l) {
            current = 0.0;
            int iw = this.il + l - 1;
            this.work[iw] = current;
            for (int a = 1; a < l - 1; ++a) {
                current = (double)a * this.work[iw - this.il];
                this.work[iw += this.il - 1] = current;
            }
            tensor[this.ti((int)l, (int)0, (int)0)] = (double)(l - 1) * previous;
            previous = current;
        }
        for (l = 0; l < this.order; ++l) {
            previous = this.work[l * this.il + 1];
            tensor[this.ti((int)l, (int)1, (int)0)] = 0.0;
            m = 2;
            while (m + l < this.o1) {
                int iw = l * this.il + m;
                current = 0.0;
                this.work[iw += this.im - 1] = current;
                for (int a = 1; a < m - 1; ++a) {
                    current = (double)a * this.work[iw - this.im];
                    this.work[iw += this.im - 1] = current;
                }
                tensor[this.ti((int)l, (int)m, (int)0)] = (double)(m - 1) * previous;
                previous = current;
                ++m;
            }
        }
        for (l = 0; l < this.order; ++l) {
            m = 0;
            while (m + l < this.order) {
                int lm = m + l;
                int lilmim = l * this.il + m * this.im;
                previous = this.work[lilmim + 1];
                tensor[this.ti((int)l, (int)m, (int)1)] = this.z * previous;
                int n = 2;
                while (lm + n < this.o1) {
                    int iw = lilmim + n;
                    current = this.z * this.work[iw];
                    this.work[iw += this.in - 1] = current;
                    int n1 = n - 1;
                    for (int a = 1; a < n1; ++a) {
                        current = this.z * current + (double)a * this.work[iw - this.in];
                        this.work[iw += this.in - 1] = current;
                    }
                    tensor[this.ti((int)l, (int)m, (int)n)] = this.z * current + (double)n1 * previous;
                    previous = current;
                    ++n;
                }
                ++m;
            }
        }
    }

    @Override
    protected String codeTensorRecursion(double[] r, double[] tensor) {
        int m;
        double current;
        int l;
        this.setR(r);
        assert (this.x == 0.0 && this.y == 0.0);
        this.source(this.work);
        StringBuilder sb = new StringBuilder();
        tensor[0] = this.work[0];
        if (this.work[0] > 0.0) {
            sb.append(String.format("%s = %s;\n", MultipoleUtilities.rlmn(0, 0, 0), MultipoleUtilities.term(0, 0, 0, 0)));
        }
        double previous = this.work[1];
        tensor[this.ti((int)1, (int)0, (int)0)] = 0.0;
        for (l = 2; l < this.o1; ++l) {
            current = 0.0;
            int iw = this.il + (l - 1);
            this.work[iw] = current;
            for (int a = 1; a < l - 1; ++a) {
                current = (double)a * this.work[iw - this.il];
                this.work[iw += this.il - 1] = current;
                if (current == 0.0) continue;
                if (a > 2) {
                    sb.append(String.format("double %s = %d * %s;\n", MultipoleUtilities.term(a + 1, 0, 0, l - a - 1), a, MultipoleUtilities.term(a - 1, 0, 0, l - a)));
                    continue;
                }
                sb.append(String.format("double %s = %s;\n", MultipoleUtilities.term(a + 1, 0, 0, l - a - 1), MultipoleUtilities.term(a - 1, 0, 0, l - a)));
            }
            int index = this.ti(l, 0, 0);
            tensor[index] = (double)(l - 1) * previous;
            previous = current;
            if (tensor[index] == 0.0) continue;
            if (l > 2) {
                sb.append(String.format("%s = %d * %s;\n", MultipoleUtilities.rlmn(l, 0, 0), l - 1, MultipoleUtilities.term(l - 2, 0, 0, 1)));
                continue;
            }
            sb.append(String.format("%s = %s;\n", MultipoleUtilities.rlmn(l, 0, 0), MultipoleUtilities.term(l - 2, 0, 0, 1)));
        }
        for (l = 0; l < this.order; ++l) {
            previous = this.work[l * this.il + 1];
            tensor[this.ti((int)l, (int)1, (int)0)] = 0.0;
            m = 2;
            while (m + l < this.o1) {
                int iw = l * this.il + m;
                current = 0.0;
                this.work[iw += this.im - 1] = current;
                for (int a = 1; a < m - 1; ++a) {
                    current = (double)a * this.work[iw - this.im];
                    this.work[iw += this.im - 1] = current;
                    if (current == 0.0) continue;
                    if (a > 1) {
                        sb.append(String.format("double %s = %d * %s;\n", MultipoleUtilities.term(l, a + 1, 0, m - a - 1), a, MultipoleUtilities.term(l, a - 1, 0, m - a)));
                        continue;
                    }
                    sb.append(String.format("double %s = %s;\n", MultipoleUtilities.term(l, a + 1, 0, m - a - 1), MultipoleUtilities.term(l, a - 1, 0, m - a)));
                }
                int index = this.ti(l, m, 0);
                tensor[index] = (double)(m - 1) * previous;
                previous = current;
                if (tensor[index] != 0.0) {
                    if (m > 2) {
                        sb.append(String.format("%s = %d * %s;\n", MultipoleUtilities.rlmn(l, m, 0), m - 1, MultipoleUtilities.term(l, m - 2, 0, 1)));
                    } else {
                        sb.append(String.format("%s = %s;\n", MultipoleUtilities.rlmn(l, m, 0), MultipoleUtilities.term(l, m - 2, 0, 1)));
                    }
                }
                ++m;
            }
        }
        for (l = 0; l < this.order; ++l) {
            m = 0;
            while (m + l < this.order) {
                int lm = m + l;
                int lilmim = l * this.il + m * this.im;
                previous = this.work[lilmim + 1];
                int index = this.ti(l, m, 1);
                tensor[index] = this.z * previous;
                if (tensor[index] != 0.0) {
                    sb.append(String.format("%s = z * %s;\n", MultipoleUtilities.rlmn(l, m, 1), MultipoleUtilities.term(l, m, 0, 1)));
                }
                int n = 2;
                while (lm + n < this.o1) {
                    int iw = lilmim + n;
                    current = this.z * this.work[iw];
                    this.work[iw += this.in - 1] = current;
                    if (current != 0.0) {
                        sb.append(String.format("double %s = z * %s;\n", MultipoleUtilities.term(l, m, 1, n - 1), MultipoleUtilities.term(l, m, 0, n)));
                    }
                    int n1 = n - 1;
                    for (int a = 1; a < n1; ++a) {
                        current = this.z * current + (double)a * this.work[iw - this.in];
                        this.work[iw += this.in - 1] = current;
                        if (current == 0.0) continue;
                        if (a > 1) {
                            sb.append(String.format("double %s = fma(z, %s, %d * %s);\n", MultipoleUtilities.term(l, m, a + 1, n - a - 1), MultipoleUtilities.term(l, m, a, n - a), a, MultipoleUtilities.term(l, m, a - 1, n - a)));
                            continue;
                        }
                        sb.append(String.format("double %s = fma(z, %s, %s);\n", MultipoleUtilities.term(l, m, a + 1, n - a - 1), MultipoleUtilities.term(l, m, a, n - a), MultipoleUtilities.term(l, m, a - 1, n - a)));
                    }
                    index = this.ti(l, m, n);
                    tensor[index] = this.z * current + (double)n1 * previous;
                    previous = current;
                    if (tensor[index] != 0.0) {
                        if (n > 2) {
                            sb.append(String.format("%s = fma(z, %s, %d * %s);\n", MultipoleUtilities.rlmn(l, m, n), MultipoleUtilities.term(l, m, n - 1, 1), n - 1, MultipoleUtilities.term(l, m, n - 2, 1)));
                        } else {
                            sb.append(String.format("%s = fma(z, %s, %s);\n", MultipoleUtilities.rlmn(l, m, n), MultipoleUtilities.term(l, m, n - 1, 1), MultipoleUtilities.term(l, m, n - 2, 1)));
                        }
                    }
                    ++n;
                }
                ++m;
            }
        }
        return sb.toString();
    }

    protected String codeVectorTensorRecursion(double[] r, double[] tensor) {
        int m;
        double current;
        int l;
        this.setR(r);
        assert (this.x == 0.0 && this.y == 0.0);
        this.source(this.work);
        StringBuilder sb = new StringBuilder();
        tensor[0] = this.work[0];
        if (this.work[0] > 0.0) {
            sb.append(String.format("%s = %s;\n", MultipoleUtilities.rlmn(0, 0, 0), MultipoleUtilities.term(0, 0, 0, 0)));
        }
        double previous = this.work[1];
        tensor[this.ti((int)1, (int)0, (int)0)] = 0.0;
        for (l = 2; l < this.o1; ++l) {
            current = 0.0;
            int iw = this.il + (l - 1);
            this.work[iw] = current;
            for (int a = 1; a < l - 1; ++a) {
                current = (double)a * this.work[iw - this.il];
                this.work[iw += this.il - 1] = current;
                if (current == 0.0) continue;
                if (a > 2) {
                    sb.append(String.format("DoubleVector %s = %s.mul(%d);\n", MultipoleUtilities.term(a + 1, 0, 0, l - a - 1), MultipoleUtilities.term(a - 1, 0, 0, l - a), a));
                    continue;
                }
                sb.append(String.format("DoubleVector %s = %s;\n", MultipoleUtilities.term(a + 1, 0, 0, l - a - 1), MultipoleUtilities.term(a - 1, 0, 0, l - a)));
            }
            int index = this.ti(l, 0, 0);
            tensor[index] = (double)(l - 1) * previous;
            previous = current;
            if (tensor[index] == 0.0) continue;
            if (l > 2) {
                sb.append(String.format("%s = %s.mul(%d);\n", MultipoleUtilities.rlmn(l, 0, 0), MultipoleUtilities.term(l - 2, 0, 0, 1), l - 1));
                continue;
            }
            sb.append(String.format("%s = %s;\n", MultipoleUtilities.rlmn(l, 0, 0), MultipoleUtilities.term(0, 0, 0, 1)));
        }
        for (l = 0; l < this.order; ++l) {
            previous = this.work[l * this.il + 1];
            tensor[this.ti((int)l, (int)1, (int)0)] = 0.0;
            m = 2;
            while (m + l < this.o1) {
                int iw = l * this.il + m;
                current = 0.0;
                this.work[iw += this.im - 1] = current;
                for (int a = 1; a < m - 1; ++a) {
                    current = (double)a * this.work[iw - this.im];
                    this.work[iw += this.im - 1] = current;
                    if (current == 0.0) continue;
                    if (a > 1) {
                        sb.append(String.format("DoubleVector %s = %s.mul(%d);\n", MultipoleUtilities.term(l, a + 1, 0, m - a - 1), MultipoleUtilities.term(l, a - 1, 0, m - a), a));
                        continue;
                    }
                    sb.append(String.format("DoubleVector %s = %s;\n", MultipoleUtilities.term(l, a + 1, 0, m - a - 1), MultipoleUtilities.term(l, 0, 0, m - a)));
                }
                int index = this.ti(l, m, 0);
                tensor[index] = (double)(m - 1) * previous;
                previous = current;
                if (tensor[index] != 0.0) {
                    if (m > 2) {
                        sb.append(String.format("%s = %s.mul(%d);\n", MultipoleUtilities.rlmn(l, m, 0), MultipoleUtilities.term(l, m - 2, 0, 1), m - 1));
                    } else {
                        sb.append(String.format("%s = %s;\n", MultipoleUtilities.rlmn(l, m, 0), MultipoleUtilities.term(l, m - 2, 0, 1)));
                    }
                }
                ++m;
            }
        }
        for (l = 0; l < this.order; ++l) {
            m = 0;
            while (m + l < this.order) {
                int lm = m + l;
                int lilmim = l * this.il + m * this.im;
                previous = this.work[lilmim + 1];
                int index = this.ti(l, m, 1);
                tensor[index] = this.z * previous;
                if (tensor[index] != 0.0) {
                    sb.append(String.format("%s = z.mul(%s);\n", MultipoleUtilities.rlmn(l, m, 1), MultipoleUtilities.term(l, m, 0, 1)));
                }
                int n = 2;
                while (lm + n < this.o1) {
                    int iw = lilmim + n;
                    current = this.z * this.work[iw];
                    this.work[iw += this.in - 1] = current;
                    if (current != 0.0) {
                        sb.append(String.format("DoubleVector %s = z.mul(%s);\n", MultipoleUtilities.term(l, m, 1, n - 1), MultipoleUtilities.term(l, m, 0, n)));
                    }
                    int n1 = n - 1;
                    for (int a = 1; a < n1; ++a) {
                        current = this.z * current + (double)a * this.work[iw - this.in];
                        this.work[iw += this.in - 1] = current;
                        if (current == 0.0) continue;
                        if (a > 1) {
                            sb.append(String.format("DoubleVector %s = z.fma(%s, %s.mul(%d));\n", MultipoleUtilities.term(l, m, a + 1, n - a - 1), MultipoleUtilities.term(l, m, a, n - a), MultipoleUtilities.term(l, m, a - 1, n - a), a));
                            continue;
                        }
                        sb.append(String.format("DoubleVector %s = z.fma(%s, %s);\n", MultipoleUtilities.term(l, m, a + 1, n - a - 1), MultipoleUtilities.term(l, m, a, n - a), MultipoleUtilities.term(l, m, 0, n - a)));
                    }
                    index = this.ti(l, m, n);
                    tensor[index] = this.z * current + (double)n1 * previous;
                    previous = current;
                    if (tensor[index] != 0.0) {
                        if (n > 2) {
                            sb.append(String.format("%s = z.fma(%s, %s.mul(%d));\n", MultipoleUtilities.rlmn(l, m, n), MultipoleUtilities.term(l, m, n - 1, 1), MultipoleUtilities.term(l, m, n - 2, 1), n - 1));
                        } else {
                            sb.append(String.format("%s = z.fma(%s, %s);\n", MultipoleUtilities.rlmn(l, m, n), MultipoleUtilities.term(l, m, n - 1, 1), MultipoleUtilities.term(l, m, n - 2, 1)));
                        }
                    }
                    ++n;
                }
                ++m;
            }
        }
        return sb.toString();
    }
}

