/*
 * Decompiled with CFR 0.152.
 */
package ffx.numerics.multipole;

import ffx.numerics.multipole.CoordinateSystem;
import ffx.numerics.multipole.MultipoleTensor;
import ffx.numerics.multipole.MultipoleUtilities;
import ffx.numerics.multipole.Operator;
import ffx.numerics.multipole.PolarizableMultipole;
import org.apache.commons.math3.util.FastMath;

public class CoulombTensorGlobal
extends MultipoleTensor {
    public CoulombTensorGlobal(int order) {
        super(CoordinateSystem.GLOBAL, order);
        this.operator = Operator.COULOMB;
    }

    @Override
    public double getd2EdZ2() {
        return 0.0;
    }

    @Override
    public double getdEdZ() {
        return 0.0;
    }

    @Override
    public void setR(double dx, double dy, double dz) {
        this.x = dx;
        this.y = dy;
        this.z = dz;
        this.r2 = this.x * this.x + this.y * this.y + this.z * this.z;
        this.R = FastMath.sqrt((double)this.r2);
    }

    @Override
    protected void source(double[] T000) {
        double ir = 1.0 / this.R;
        double ir2 = ir * ir;
        for (int n = 0; n < this.o1; ++n) {
            T000[n] = this.coulombSource[n] * ir;
            ir *= ir2;
        }
    }

    @Override
    protected void order1() {
        this.source(this.work);
        double term0000 = this.work[0];
        double term0001 = this.work[1];
        this.R000 = term0000;
        this.R100 = this.x * term0001;
        this.R010 = this.y * term0001;
        this.R001 = this.z * term0001;
    }

    @Override
    protected void order2() {
        this.source(this.work);
        double term0000 = this.work[0];
        double term0001 = this.work[1];
        double term0002 = this.work[2];
        this.R000 = term0000;
        this.R100 = this.x * term0001;
        this.R010 = this.y * term0001;
        this.R001 = this.z * term0001;
        double term1001 = this.x * term0002;
        this.R200 = Math.fma(this.x, term1001, term0001);
        double term0101 = this.y * term0002;
        this.R020 = Math.fma(this.y, term0101, term0001);
        double term0011 = this.z * term0002;
        this.R002 = Math.fma(this.z, term0011, term0001);
        this.R110 = this.y * term1001;
        this.R011 = this.z * term0101;
        this.R101 = this.z * term1001;
    }

    @Override
    protected void order3() {
        this.source(this.work);
        double term0000 = this.work[0];
        double term0001 = this.work[1];
        double term0002 = this.work[2];
        double term0003 = this.work[3];
        this.R000 = term0000;
        this.R100 = this.x * term0001;
        double term1001 = this.x * term0002;
        this.R200 = Math.fma(this.x, term1001, term0001);
        double term1002 = this.x * term0003;
        double term2001 = Math.fma(this.x, term1002, term0002);
        this.R300 = Math.fma(this.x, term2001, 2.0 * term1001);
        this.R010 = this.y * term0001;
        double term0101 = this.y * term0002;
        this.R020 = Math.fma(this.y, term0101, term0001);
        double term0102 = this.y * term0003;
        double term0201 = Math.fma(this.y, term0102, term0002);
        this.R030 = Math.fma(this.y, term0201, 2.0 * term0101);
        this.R110 = this.y * term1001;
        double term1101 = this.y * term1002;
        this.R120 = Math.fma(this.y, term1101, term1001);
        this.R210 = this.y * term2001;
        this.R001 = this.z * term0001;
        double term0011 = this.z * term0002;
        this.R002 = Math.fma(this.z, term0011, term0001);
        double term0012 = this.z * term0003;
        double term0021 = Math.fma(this.z, term0012, term0002);
        this.R003 = Math.fma(this.z, term0021, 2.0 * term0011);
        this.R011 = this.z * term0101;
        double term0111 = this.z * term0102;
        this.R012 = Math.fma(this.z, term0111, term0101);
        this.R021 = this.z * term0201;
        this.R101 = this.z * term1001;
        double term1011 = this.z * term1002;
        this.R102 = Math.fma(this.z, term1011, term1001);
        this.R111 = this.z * term1101;
        this.R201 = this.z * term2001;
    }

    @Override
    protected void order4() {
        this.source(this.work);
        double term0000 = this.work[0];
        double term0001 = this.work[1];
        double term0002 = this.work[2];
        double term0003 = this.work[3];
        double term0004 = this.work[4];
        this.R000 = term0000;
        this.R100 = this.x * term0001;
        double term1001 = this.x * term0002;
        this.R200 = Math.fma(this.x, term1001, term0001);
        double term1002 = this.x * term0003;
        double term2001 = Math.fma(this.x, term1002, term0002);
        this.R300 = Math.fma(this.x, term2001, 2.0 * term1001);
        double term1003 = this.x * term0004;
        double term2002 = Math.fma(this.x, term1003, term0003);
        double term3001 = Math.fma(this.x, term2002, 2.0 * term1002);
        this.R400 = Math.fma(this.x, term3001, 3.0 * term2001);
        this.R010 = this.y * term0001;
        double term0101 = this.y * term0002;
        this.R020 = Math.fma(this.y, term0101, term0001);
        double term0102 = this.y * term0003;
        double term0201 = Math.fma(this.y, term0102, term0002);
        this.R030 = Math.fma(this.y, term0201, 2.0 * term0101);
        double term0103 = this.y * term0004;
        double term0202 = Math.fma(this.y, term0103, term0003);
        double term0301 = Math.fma(this.y, term0202, 2.0 * term0102);
        this.R040 = Math.fma(this.y, term0301, 3.0 * term0201);
        this.R110 = this.y * term1001;
        double term1101 = this.y * term1002;
        this.R120 = Math.fma(this.y, term1101, term1001);
        double term1102 = this.y * term1003;
        double term1201 = Math.fma(this.y, term1102, term1002);
        this.R130 = Math.fma(this.y, term1201, 2.0 * term1101);
        this.R210 = this.y * term2001;
        double term2101 = this.y * term2002;
        this.R220 = Math.fma(this.y, term2101, term2001);
        this.R310 = this.y * term3001;
        this.R001 = this.z * term0001;
        double term0011 = this.z * term0002;
        this.R002 = Math.fma(this.z, term0011, term0001);
        double term0012 = this.z * term0003;
        double term0021 = Math.fma(this.z, term0012, term0002);
        this.R003 = Math.fma(this.z, term0021, 2.0 * term0011);
        double term0013 = this.z * term0004;
        double term0022 = Math.fma(this.z, term0013, term0003);
        double term0031 = Math.fma(this.z, term0022, 2.0 * term0012);
        this.R004 = Math.fma(this.z, term0031, 3.0 * term0021);
        this.R011 = this.z * term0101;
        double term0111 = this.z * term0102;
        this.R012 = Math.fma(this.z, term0111, term0101);
        double term0112 = this.z * term0103;
        double term0121 = Math.fma(this.z, term0112, term0102);
        this.R013 = Math.fma(this.z, term0121, 2.0 * term0111);
        this.R021 = this.z * term0201;
        double term0211 = this.z * term0202;
        this.R022 = Math.fma(this.z, term0211, term0201);
        this.R031 = this.z * term0301;
        this.R101 = this.z * term1001;
        double term1011 = this.z * term1002;
        this.R102 = Math.fma(this.z, term1011, term1001);
        double term1012 = this.z * term1003;
        double term1021 = Math.fma(this.z, term1012, term1002);
        this.R103 = Math.fma(this.z, term1021, 2.0 * term1011);
        this.R111 = this.z * term1101;
        double term1111 = this.z * term1102;
        this.R112 = Math.fma(this.z, term1111, term1101);
        this.R121 = this.z * term1201;
        this.R201 = this.z * term2001;
        double term2011 = this.z * term2002;
        this.R202 = Math.fma(this.z, term2011, term2001);
        this.R211 = this.z * term2101;
        this.R301 = this.z * term3001;
    }

    @Override
    protected void order5() {
        this.source(this.work);
        double term0000 = this.work[0];
        double term0001 = this.work[1];
        double term0002 = this.work[2];
        double term0003 = this.work[3];
        double term0004 = this.work[4];
        double term0005 = this.work[5];
        this.R000 = term0000;
        this.R100 = this.x * term0001;
        double term1001 = this.x * term0002;
        this.R200 = Math.fma(this.x, term1001, term0001);
        double term1002 = this.x * term0003;
        double term2001 = Math.fma(this.x, term1002, term0002);
        this.R300 = Math.fma(this.x, term2001, 2.0 * term1001);
        double term1003 = this.x * term0004;
        double term2002 = Math.fma(this.x, term1003, term0003);
        double term3001 = Math.fma(this.x, term2002, 2.0 * term1002);
        this.R400 = Math.fma(this.x, term3001, 3.0 * term2001);
        double term1004 = this.x * term0005;
        double term2003 = Math.fma(this.x, term1004, term0004);
        double term3002 = Math.fma(this.x, term2003, 2.0 * term1003);
        double term4001 = Math.fma(this.x, term3002, 3.0 * term2002);
        this.R500 = Math.fma(this.x, term4001, 4.0 * term3001);
        this.R010 = this.y * term0001;
        double term0101 = this.y * term0002;
        this.R020 = Math.fma(this.y, term0101, term0001);
        double term0102 = this.y * term0003;
        double term0201 = Math.fma(this.y, term0102, term0002);
        this.R030 = Math.fma(this.y, term0201, 2.0 * term0101);
        double term0103 = this.y * term0004;
        double term0202 = Math.fma(this.y, term0103, term0003);
        double term0301 = Math.fma(this.y, term0202, 2.0 * term0102);
        this.R040 = Math.fma(this.y, term0301, 3.0 * term0201);
        double term0104 = this.y * term0005;
        double term0203 = Math.fma(this.y, term0104, term0004);
        double term0302 = Math.fma(this.y, term0203, 2.0 * term0103);
        double term0401 = Math.fma(this.y, term0302, 3.0 * term0202);
        this.R050 = Math.fma(this.y, term0401, 4.0 * term0301);
        this.R110 = this.y * term1001;
        double term1101 = this.y * term1002;
        this.R120 = Math.fma(this.y, term1101, term1001);
        double term1102 = this.y * term1003;
        double term1201 = Math.fma(this.y, term1102, term1002);
        this.R130 = Math.fma(this.y, term1201, 2.0 * term1101);
        double term1103 = this.y * term1004;
        double term1202 = Math.fma(this.y, term1103, term1003);
        double term1301 = Math.fma(this.y, term1202, 2.0 * term1102);
        this.R140 = Math.fma(this.y, term1301, 3.0 * term1201);
        this.R210 = this.y * term2001;
        double term2101 = this.y * term2002;
        this.R220 = Math.fma(this.y, term2101, term2001);
        double term2102 = this.y * term2003;
        double term2201 = Math.fma(this.y, term2102, term2002);
        this.R230 = Math.fma(this.y, term2201, 2.0 * term2101);
        this.R310 = this.y * term3001;
        double term3101 = this.y * term3002;
        this.R320 = Math.fma(this.y, term3101, term3001);
        this.R410 = this.y * term4001;
        this.R001 = this.z * term0001;
        double term0011 = this.z * term0002;
        this.R002 = Math.fma(this.z, term0011, term0001);
        double term0012 = this.z * term0003;
        double term0021 = Math.fma(this.z, term0012, term0002);
        this.R003 = Math.fma(this.z, term0021, 2.0 * term0011);
        double term0013 = this.z * term0004;
        double term0022 = Math.fma(this.z, term0013, term0003);
        double term0031 = Math.fma(this.z, term0022, 2.0 * term0012);
        this.R004 = Math.fma(this.z, term0031, 3.0 * term0021);
        double term0014 = this.z * term0005;
        double term0023 = Math.fma(this.z, term0014, term0004);
        double term0032 = Math.fma(this.z, term0023, 2.0 * term0013);
        double term0041 = Math.fma(this.z, term0032, 3.0 * term0022);
        this.R005 = Math.fma(this.z, term0041, 4.0 * term0031);
        this.R011 = this.z * term0101;
        double term0111 = this.z * term0102;
        this.R012 = Math.fma(this.z, term0111, term0101);
        double term0112 = this.z * term0103;
        double term0121 = Math.fma(this.z, term0112, term0102);
        this.R013 = Math.fma(this.z, term0121, 2.0 * term0111);
        double term0113 = this.z * term0104;
        double term0122 = Math.fma(this.z, term0113, term0103);
        double term0131 = Math.fma(this.z, term0122, 2.0 * term0112);
        this.R014 = Math.fma(this.z, term0131, 3.0 * term0121);
        this.R021 = this.z * term0201;
        double term0211 = this.z * term0202;
        this.R022 = Math.fma(this.z, term0211, term0201);
        double term0212 = this.z * term0203;
        double term0221 = Math.fma(this.z, term0212, term0202);
        this.R023 = Math.fma(this.z, term0221, 2.0 * term0211);
        this.R031 = this.z * term0301;
        double term0311 = this.z * term0302;
        this.R032 = Math.fma(this.z, term0311, term0301);
        this.R041 = this.z * term0401;
        this.R101 = this.z * term1001;
        double term1011 = this.z * term1002;
        this.R102 = Math.fma(this.z, term1011, term1001);
        double term1012 = this.z * term1003;
        double term1021 = Math.fma(this.z, term1012, term1002);
        this.R103 = Math.fma(this.z, term1021, 2.0 * term1011);
        double term1013 = this.z * term1004;
        double term1022 = Math.fma(this.z, term1013, term1003);
        double term1031 = Math.fma(this.z, term1022, 2.0 * term1012);
        this.R104 = Math.fma(this.z, term1031, 3.0 * term1021);
        this.R111 = this.z * term1101;
        double term1111 = this.z * term1102;
        this.R112 = Math.fma(this.z, term1111, term1101);
        double term1112 = this.z * term1103;
        double term1121 = Math.fma(this.z, term1112, term1102);
        this.R113 = Math.fma(this.z, term1121, 2.0 * term1111);
        this.R121 = this.z * term1201;
        double term1211 = this.z * term1202;
        this.R122 = Math.fma(this.z, term1211, term1201);
        this.R131 = this.z * term1301;
        this.R201 = this.z * term2001;
        double term2011 = this.z * term2002;
        this.R202 = Math.fma(this.z, term2011, term2001);
        double term2012 = this.z * term2003;
        double term2021 = Math.fma(this.z, term2012, term2002);
        this.R203 = Math.fma(this.z, term2021, 2.0 * term2011);
        this.R211 = this.z * term2101;
        double term2111 = this.z * term2102;
        this.R212 = Math.fma(this.z, term2111, term2101);
        this.R221 = this.z * term2201;
        this.R301 = this.z * term3001;
        double term3011 = this.z * term3002;
        this.R302 = Math.fma(this.z, term3011, term3001);
        this.R311 = this.z * term3101;
        this.R401 = this.z * term4001;
    }

    @Override
    protected void order6() {
        this.source(this.work);
        double term0000 = this.work[0];
        double term0001 = this.work[1];
        double term0002 = this.work[2];
        double term0003 = this.work[3];
        double term0004 = this.work[4];
        double term0005 = this.work[5];
        double term0006 = this.work[6];
        this.R000 = term0000;
        this.R100 = this.x * term0001;
        double term1001 = this.x * term0002;
        this.R200 = Math.fma(this.x, term1001, term0001);
        double term1002 = this.x * term0003;
        double term2001 = Math.fma(this.x, term1002, term0002);
        this.R300 = Math.fma(this.x, term2001, 2.0 * term1001);
        double term1003 = this.x * term0004;
        double term2002 = Math.fma(this.x, term1003, term0003);
        double term3001 = Math.fma(this.x, term2002, 2.0 * term1002);
        this.R400 = Math.fma(this.x, term3001, 3.0 * term2001);
        double term1004 = this.x * term0005;
        double term2003 = Math.fma(this.x, term1004, term0004);
        double term3002 = Math.fma(this.x, term2003, 2.0 * term1003);
        double term4001 = Math.fma(this.x, term3002, 3.0 * term2002);
        this.R500 = Math.fma(this.x, term4001, 4.0 * term3001);
        double term1005 = this.x * term0006;
        double term2004 = Math.fma(this.x, term1005, term0005);
        double term3003 = Math.fma(this.x, term2004, 2.0 * term1004);
        double term4002 = Math.fma(this.x, term3003, 3.0 * term2003);
        double term5001 = Math.fma(this.x, term4002, 4.0 * term3002);
        this.R600 = Math.fma(this.x, term5001, 5.0 * term4001);
        this.R010 = this.y * term0001;
        double term0101 = this.y * term0002;
        this.R020 = Math.fma(this.y, term0101, term0001);
        double term0102 = this.y * term0003;
        double term0201 = Math.fma(this.y, term0102, term0002);
        this.R030 = Math.fma(this.y, term0201, 2.0 * term0101);
        double term0103 = this.y * term0004;
        double term0202 = Math.fma(this.y, term0103, term0003);
        double term0301 = Math.fma(this.y, term0202, 2.0 * term0102);
        this.R040 = Math.fma(this.y, term0301, 3.0 * term0201);
        double term0104 = this.y * term0005;
        double term0203 = Math.fma(this.y, term0104, term0004);
        double term0302 = Math.fma(this.y, term0203, 2.0 * term0103);
        double term0401 = Math.fma(this.y, term0302, 3.0 * term0202);
        this.R050 = Math.fma(this.y, term0401, 4.0 * term0301);
        double term0105 = this.y * term0006;
        double term0204 = Math.fma(this.y, term0105, term0005);
        double term0303 = Math.fma(this.y, term0204, 2.0 * term0104);
        double term0402 = Math.fma(this.y, term0303, 3.0 * term0203);
        double term0501 = Math.fma(this.y, term0402, 4.0 * term0302);
        this.R060 = Math.fma(this.y, term0501, 5.0 * term0401);
        this.R110 = this.y * term1001;
        double term1101 = this.y * term1002;
        this.R120 = Math.fma(this.y, term1101, term1001);
        double term1102 = this.y * term1003;
        double term1201 = Math.fma(this.y, term1102, term1002);
        this.R130 = Math.fma(this.y, term1201, 2.0 * term1101);
        double term1103 = this.y * term1004;
        double term1202 = Math.fma(this.y, term1103, term1003);
        double term1301 = Math.fma(this.y, term1202, 2.0 * term1102);
        this.R140 = Math.fma(this.y, term1301, 3.0 * term1201);
        double term1104 = this.y * term1005;
        double term1203 = Math.fma(this.y, term1104, term1004);
        double term1302 = Math.fma(this.y, term1203, 2.0 * term1103);
        double term1401 = Math.fma(this.y, term1302, 3.0 * term1202);
        this.R150 = Math.fma(this.y, term1401, 4.0 * term1301);
        this.R210 = this.y * term2001;
        double term2101 = this.y * term2002;
        this.R220 = Math.fma(this.y, term2101, term2001);
        double term2102 = this.y * term2003;
        double term2201 = Math.fma(this.y, term2102, term2002);
        this.R230 = Math.fma(this.y, term2201, 2.0 * term2101);
        double term2103 = this.y * term2004;
        double term2202 = Math.fma(this.y, term2103, term2003);
        double term2301 = Math.fma(this.y, term2202, 2.0 * term2102);
        this.R240 = Math.fma(this.y, term2301, 3.0 * term2201);
        this.R310 = this.y * term3001;
        double term3101 = this.y * term3002;
        this.R320 = Math.fma(this.y, term3101, term3001);
        double term3102 = this.y * term3003;
        double term3201 = Math.fma(this.y, term3102, term3002);
        this.R330 = Math.fma(this.y, term3201, 2.0 * term3101);
        this.R410 = this.y * term4001;
        double term4101 = this.y * term4002;
        this.R420 = Math.fma(this.y, term4101, term4001);
        this.R510 = this.y * term5001;
        this.R001 = this.z * term0001;
        double term0011 = this.z * term0002;
        this.R002 = Math.fma(this.z, term0011, term0001);
        double term0012 = this.z * term0003;
        double term0021 = Math.fma(this.z, term0012, term0002);
        this.R003 = Math.fma(this.z, term0021, 2.0 * term0011);
        double term0013 = this.z * term0004;
        double term0022 = Math.fma(this.z, term0013, term0003);
        double term0031 = Math.fma(this.z, term0022, 2.0 * term0012);
        this.R004 = Math.fma(this.z, term0031, 3.0 * term0021);
        double term0014 = this.z * term0005;
        double term0023 = Math.fma(this.z, term0014, term0004);
        double term0032 = Math.fma(this.z, term0023, 2.0 * term0013);
        double term0041 = Math.fma(this.z, term0032, 3.0 * term0022);
        this.R005 = Math.fma(this.z, term0041, 4.0 * term0031);
        double term0015 = this.z * term0006;
        double term0024 = Math.fma(this.z, term0015, term0005);
        double term0033 = Math.fma(this.z, term0024, 2.0 * term0014);
        double term0042 = Math.fma(this.z, term0033, 3.0 * term0023);
        double term0051 = Math.fma(this.z, term0042, 4.0 * term0032);
        this.R006 = Math.fma(this.z, term0051, 5.0 * term0041);
        this.R011 = this.z * term0101;
        double term0111 = this.z * term0102;
        this.R012 = Math.fma(this.z, term0111, term0101);
        double term0112 = this.z * term0103;
        double term0121 = Math.fma(this.z, term0112, term0102);
        this.R013 = Math.fma(this.z, term0121, 2.0 * term0111);
        double term0113 = this.z * term0104;
        double term0122 = Math.fma(this.z, term0113, term0103);
        double term0131 = Math.fma(this.z, term0122, 2.0 * term0112);
        this.R014 = Math.fma(this.z, term0131, 3.0 * term0121);
        double term0114 = this.z * term0105;
        double term0123 = Math.fma(this.z, term0114, term0104);
        double term0132 = Math.fma(this.z, term0123, 2.0 * term0113);
        double term0141 = Math.fma(this.z, term0132, 3.0 * term0122);
        this.R015 = Math.fma(this.z, term0141, 4.0 * term0131);
        this.R021 = this.z * term0201;
        double term0211 = this.z * term0202;
        this.R022 = Math.fma(this.z, term0211, term0201);
        double term0212 = this.z * term0203;
        double term0221 = Math.fma(this.z, term0212, term0202);
        this.R023 = Math.fma(this.z, term0221, 2.0 * term0211);
        double term0213 = this.z * term0204;
        double term0222 = Math.fma(this.z, term0213, term0203);
        double term0231 = Math.fma(this.z, term0222, 2.0 * term0212);
        this.R024 = Math.fma(this.z, term0231, 3.0 * term0221);
        this.R031 = this.z * term0301;
        double term0311 = this.z * term0302;
        this.R032 = Math.fma(this.z, term0311, term0301);
        double term0312 = this.z * term0303;
        double term0321 = Math.fma(this.z, term0312, term0302);
        this.R033 = Math.fma(this.z, term0321, 2.0 * term0311);
        this.R041 = this.z * term0401;
        double term0411 = this.z * term0402;
        this.R042 = Math.fma(this.z, term0411, term0401);
        this.R051 = this.z * term0501;
        this.R101 = this.z * term1001;
        double term1011 = this.z * term1002;
        this.R102 = Math.fma(this.z, term1011, term1001);
        double term1012 = this.z * term1003;
        double term1021 = Math.fma(this.z, term1012, term1002);
        this.R103 = Math.fma(this.z, term1021, 2.0 * term1011);
        double term1013 = this.z * term1004;
        double term1022 = Math.fma(this.z, term1013, term1003);
        double term1031 = Math.fma(this.z, term1022, 2.0 * term1012);
        this.R104 = Math.fma(this.z, term1031, 3.0 * term1021);
        double term1014 = this.z * term1005;
        double term1023 = Math.fma(this.z, term1014, term1004);
        double term1032 = Math.fma(this.z, term1023, 2.0 * term1013);
        double term1041 = Math.fma(this.z, term1032, 3.0 * term1022);
        this.R105 = Math.fma(this.z, term1041, 4.0 * term1031);
        this.R111 = this.z * term1101;
        double term1111 = this.z * term1102;
        this.R112 = Math.fma(this.z, term1111, term1101);
        double term1112 = this.z * term1103;
        double term1121 = Math.fma(this.z, term1112, term1102);
        this.R113 = Math.fma(this.z, term1121, 2.0 * term1111);
        double term1113 = this.z * term1104;
        double term1122 = Math.fma(this.z, term1113, term1103);
        double term1131 = Math.fma(this.z, term1122, 2.0 * term1112);
        this.R114 = Math.fma(this.z, term1131, 3.0 * term1121);
        this.R121 = this.z * term1201;
        double term1211 = this.z * term1202;
        this.R122 = Math.fma(this.z, term1211, term1201);
        double term1212 = this.z * term1203;
        double term1221 = Math.fma(this.z, term1212, term1202);
        this.R123 = Math.fma(this.z, term1221, 2.0 * term1211);
        this.R131 = this.z * term1301;
        double term1311 = this.z * term1302;
        this.R132 = Math.fma(this.z, term1311, term1301);
        this.R141 = this.z * term1401;
        this.R201 = this.z * term2001;
        double term2011 = this.z * term2002;
        this.R202 = Math.fma(this.z, term2011, term2001);
        double term2012 = this.z * term2003;
        double term2021 = Math.fma(this.z, term2012, term2002);
        this.R203 = Math.fma(this.z, term2021, 2.0 * term2011);
        double term2013 = this.z * term2004;
        double term2022 = Math.fma(this.z, term2013, term2003);
        double term2031 = Math.fma(this.z, term2022, 2.0 * term2012);
        this.R204 = Math.fma(this.z, term2031, 3.0 * term2021);
        this.R211 = this.z * term2101;
        double term2111 = this.z * term2102;
        this.R212 = Math.fma(this.z, term2111, term2101);
        double term2112 = this.z * term2103;
        double term2121 = Math.fma(this.z, term2112, term2102);
        this.R213 = Math.fma(this.z, term2121, 2.0 * term2111);
        this.R221 = this.z * term2201;
        double term2211 = this.z * term2202;
        this.R222 = Math.fma(this.z, term2211, term2201);
        this.R231 = this.z * term2301;
        this.R301 = this.z * term3001;
        double term3011 = this.z * term3002;
        this.R302 = Math.fma(this.z, term3011, term3001);
        double term3012 = this.z * term3003;
        double term3021 = Math.fma(this.z, term3012, term3002);
        this.R303 = Math.fma(this.z, term3021, 2.0 * term3011);
        this.R311 = this.z * term3101;
        double term3111 = this.z * term3102;
        this.R312 = Math.fma(this.z, term3111, term3101);
        this.R321 = this.z * term3201;
        this.R401 = this.z * term4001;
        double term4011 = this.z * term4002;
        this.R402 = Math.fma(this.z, term4011, term4001);
        this.R411 = this.z * term4101;
        this.R501 = this.z * term5001;
    }

    @Override
    protected void multipoleIPotentialAtK(PolarizableMultipole mI, int order) {
        switch (order) {
            default: {
                double term300 = 0.0;
                term300 = Math.fma(mI.q, this.R300, term300);
                term300 = Math.fma(mI.dx, -this.R400, term300);
                term300 = Math.fma(mI.dy, -this.R310, term300);
                term300 = Math.fma(mI.dz, -this.R301, term300);
                term300 = Math.fma(mI.qxx, this.R500, term300);
                term300 = Math.fma(mI.qyy, this.R320, term300);
                term300 = Math.fma(mI.qzz, this.R302, term300);
                term300 = Math.fma(mI.qxy, this.R410, term300);
                term300 = Math.fma(mI.qxz, this.R401, term300);
                this.E300 = term300 = Math.fma(mI.qyz, this.R311, term300);
                double term030 = 0.0;
                term030 = Math.fma(mI.q, this.R030, term030);
                term030 = Math.fma(mI.dx, -this.R130, term030);
                term030 = Math.fma(mI.dy, -this.R040, term030);
                term030 = Math.fma(mI.dz, -this.R031, term030);
                term030 = Math.fma(mI.qxx, this.R230, term030);
                term030 = Math.fma(mI.qyy, this.R050, term030);
                term030 = Math.fma(mI.qzz, this.R032, term030);
                term030 = Math.fma(mI.qxy, this.R140, term030);
                term030 = Math.fma(mI.qxz, this.R131, term030);
                this.E030 = term030 = Math.fma(mI.qyz, this.R041, term030);
                double term003 = 0.0;
                term003 = Math.fma(mI.q, this.R003, term003);
                term003 = Math.fma(mI.dx, -this.R103, term003);
                term003 = Math.fma(mI.dy, -this.R013, term003);
                term003 = Math.fma(mI.dz, -this.R004, term003);
                term003 = Math.fma(mI.qxx, this.R203, term003);
                term003 = Math.fma(mI.qyy, this.R023, term003);
                term003 = Math.fma(mI.qzz, this.R005, term003);
                term003 = Math.fma(mI.qxy, this.R113, term003);
                term003 = Math.fma(mI.qxz, this.R104, term003);
                this.E003 = term003 = Math.fma(mI.qyz, this.R014, term003);
                double term210 = 0.0;
                term210 = Math.fma(mI.q, this.R210, term210);
                term210 = Math.fma(mI.dx, -this.R310, term210);
                term210 = Math.fma(mI.dy, -this.R220, term210);
                term210 = Math.fma(mI.dz, -this.R211, term210);
                term210 = Math.fma(mI.qxx, this.R410, term210);
                term210 = Math.fma(mI.qyy, this.R230, term210);
                term210 = Math.fma(mI.qzz, this.R212, term210);
                term210 = Math.fma(mI.qxy, this.R320, term210);
                term210 = Math.fma(mI.qxz, this.R311, term210);
                this.E210 = term210 = Math.fma(mI.qyz, this.R221, term210);
                double term201 = 0.0;
                term201 = Math.fma(mI.q, this.R201, term201);
                term201 = Math.fma(mI.dx, -this.R301, term201);
                term201 = Math.fma(mI.dy, -this.R211, term201);
                term201 = Math.fma(mI.dz, -this.R202, term201);
                term201 = Math.fma(mI.qxx, this.R401, term201);
                term201 = Math.fma(mI.qyy, this.R221, term201);
                term201 = Math.fma(mI.qzz, this.R203, term201);
                term201 = Math.fma(mI.qxy, this.R311, term201);
                term201 = Math.fma(mI.qxz, this.R302, term201);
                this.E201 = term201 = Math.fma(mI.qyz, this.R212, term201);
                double term120 = 0.0;
                term120 = Math.fma(mI.q, this.R120, term120);
                term120 = Math.fma(mI.dx, -this.R220, term120);
                term120 = Math.fma(mI.dy, -this.R130, term120);
                term120 = Math.fma(mI.dz, -this.R121, term120);
                term120 = Math.fma(mI.qxx, this.R320, term120);
                term120 = Math.fma(mI.qyy, this.R140, term120);
                term120 = Math.fma(mI.qzz, this.R122, term120);
                term120 = Math.fma(mI.qxy, this.R230, term120);
                term120 = Math.fma(mI.qxz, this.R221, term120);
                this.E120 = term120 = Math.fma(mI.qyz, this.R131, term120);
                double term021 = 0.0;
                term021 = Math.fma(mI.q, this.R021, term021);
                term021 = Math.fma(mI.dx, -this.R121, term021);
                term021 = Math.fma(mI.dy, -this.R031, term021);
                term021 = Math.fma(mI.dz, -this.R022, term021);
                term021 = Math.fma(mI.qxx, this.R221, term021);
                term021 = Math.fma(mI.qyy, this.R041, term021);
                term021 = Math.fma(mI.qzz, this.R023, term021);
                term021 = Math.fma(mI.qxy, this.R131, term021);
                term021 = Math.fma(mI.qxz, this.R122, term021);
                this.E021 = term021 = Math.fma(mI.qyz, this.R032, term021);
                double term102 = 0.0;
                term102 = Math.fma(mI.q, this.R102, term102);
                term102 = Math.fma(mI.dx, -this.R202, term102);
                term102 = Math.fma(mI.dy, -this.R112, term102);
                term102 = Math.fma(mI.dz, -this.R103, term102);
                term102 = Math.fma(mI.qxx, this.R302, term102);
                term102 = Math.fma(mI.qyy, this.R122, term102);
                term102 = Math.fma(mI.qzz, this.R104, term102);
                term102 = Math.fma(mI.qxy, this.R212, term102);
                term102 = Math.fma(mI.qxz, this.R203, term102);
                this.E102 = term102 = Math.fma(mI.qyz, this.R113, term102);
                double term012 = 0.0;
                term012 = Math.fma(mI.q, this.R012, term012);
                term012 = Math.fma(mI.dx, -this.R112, term012);
                term012 = Math.fma(mI.dy, -this.R022, term012);
                term012 = Math.fma(mI.dz, -this.R013, term012);
                term012 = Math.fma(mI.qxx, this.R212, term012);
                term012 = Math.fma(mI.qyy, this.R032, term012);
                term012 = Math.fma(mI.qzz, this.R014, term012);
                term012 = Math.fma(mI.qxy, this.R122, term012);
                term012 = Math.fma(mI.qxz, this.R113, term012);
                this.E012 = term012 = Math.fma(mI.qyz, this.R023, term012);
                double term111 = 0.0;
                term111 = Math.fma(mI.q, this.R111, term111);
                term111 = Math.fma(mI.dx, -this.R211, term111);
                term111 = Math.fma(mI.dy, -this.R121, term111);
                term111 = Math.fma(mI.dz, -this.R112, term111);
                term111 = Math.fma(mI.qxx, this.R311, term111);
                term111 = Math.fma(mI.qyy, this.R131, term111);
                term111 = Math.fma(mI.qzz, this.R113, term111);
                term111 = Math.fma(mI.qxy, this.R221, term111);
                term111 = Math.fma(mI.qxz, this.R212, term111);
                this.E111 = term111 = Math.fma(mI.qyz, this.R122, term111);
            }
            case 2: {
                double term200 = 0.0;
                term200 = Math.fma(mI.q, this.R200, term200);
                term200 = Math.fma(mI.dx, -this.R300, term200);
                term200 = Math.fma(mI.dy, -this.R210, term200);
                term200 = Math.fma(mI.dz, -this.R201, term200);
                term200 = Math.fma(mI.qxx, this.R400, term200);
                term200 = Math.fma(mI.qyy, this.R220, term200);
                term200 = Math.fma(mI.qzz, this.R202, term200);
                term200 = Math.fma(mI.qxy, this.R310, term200);
                term200 = Math.fma(mI.qxz, this.R301, term200);
                this.E200 = term200 = Math.fma(mI.qyz, this.R211, term200);
                double term020 = 0.0;
                term020 = Math.fma(mI.q, this.R020, term020);
                term020 = Math.fma(mI.dx, -this.R120, term020);
                term020 = Math.fma(mI.dy, -this.R030, term020);
                term020 = Math.fma(mI.dz, -this.R021, term020);
                term020 = Math.fma(mI.qxx, this.R220, term020);
                term020 = Math.fma(mI.qyy, this.R040, term020);
                term020 = Math.fma(mI.qzz, this.R022, term020);
                term020 = Math.fma(mI.qxy, this.R130, term020);
                term020 = Math.fma(mI.qxz, this.R121, term020);
                this.E020 = term020 = Math.fma(mI.qyz, this.R031, term020);
                double term002 = 0.0;
                term002 = Math.fma(mI.q, this.R002, term002);
                term002 = Math.fma(mI.dx, -this.R102, term002);
                term002 = Math.fma(mI.dy, -this.R012, term002);
                term002 = Math.fma(mI.dz, -this.R003, term002);
                term002 = Math.fma(mI.qxx, this.R202, term002);
                term002 = Math.fma(mI.qyy, this.R022, term002);
                term002 = Math.fma(mI.qzz, this.R004, term002);
                term002 = Math.fma(mI.qxy, this.R112, term002);
                term002 = Math.fma(mI.qxz, this.R103, term002);
                this.E002 = term002 = Math.fma(mI.qyz, this.R013, term002);
                double term110 = 0.0;
                term110 = Math.fma(mI.q, this.R110, term110);
                term110 = Math.fma(mI.dx, -this.R210, term110);
                term110 = Math.fma(mI.dy, -this.R120, term110);
                term110 = Math.fma(mI.dz, -this.R111, term110);
                term110 = Math.fma(mI.qxx, this.R310, term110);
                term110 = Math.fma(mI.qyy, this.R130, term110);
                term110 = Math.fma(mI.qzz, this.R112, term110);
                term110 = Math.fma(mI.qxy, this.R220, term110);
                term110 = Math.fma(mI.qxz, this.R211, term110);
                this.E110 = term110 = Math.fma(mI.qyz, this.R121, term110);
                double term101 = 0.0;
                term101 = Math.fma(mI.q, this.R101, term101);
                term101 = Math.fma(mI.dx, -this.R201, term101);
                term101 = Math.fma(mI.dy, -this.R111, term101);
                term101 = Math.fma(mI.dz, -this.R102, term101);
                term101 = Math.fma(mI.qxx, this.R301, term101);
                term101 = Math.fma(mI.qyy, this.R121, term101);
                term101 = Math.fma(mI.qzz, this.R103, term101);
                term101 = Math.fma(mI.qxy, this.R211, term101);
                term101 = Math.fma(mI.qxz, this.R202, term101);
                this.E101 = term101 = Math.fma(mI.qyz, this.R112, term101);
                double term011 = 0.0;
                term011 = Math.fma(mI.q, this.R011, term011);
                term011 = Math.fma(mI.dx, -this.R111, term011);
                term011 = Math.fma(mI.dy, -this.R021, term011);
                term011 = Math.fma(mI.dz, -this.R012, term011);
                term011 = Math.fma(mI.qxx, this.R211, term011);
                term011 = Math.fma(mI.qyy, this.R031, term011);
                term011 = Math.fma(mI.qzz, this.R013, term011);
                term011 = Math.fma(mI.qxy, this.R121, term011);
                term011 = Math.fma(mI.qxz, this.R112, term011);
                this.E011 = term011 = Math.fma(mI.qyz, this.R022, term011);
            }
            case 1: {
                double term100 = 0.0;
                term100 = Math.fma(mI.q, this.R100, term100);
                term100 = Math.fma(mI.dx, -this.R200, term100);
                term100 = Math.fma(mI.dy, -this.R110, term100);
                term100 = Math.fma(mI.dz, -this.R101, term100);
                term100 = Math.fma(mI.qxx, this.R300, term100);
                term100 = Math.fma(mI.qyy, this.R120, term100);
                term100 = Math.fma(mI.qzz, this.R102, term100);
                term100 = Math.fma(mI.qxy, this.R210, term100);
                term100 = Math.fma(mI.qxz, this.R201, term100);
                this.E100 = term100 = Math.fma(mI.qyz, this.R111, term100);
                double term010 = 0.0;
                term010 = Math.fma(mI.q, this.R010, term010);
                term010 = Math.fma(mI.dx, -this.R110, term010);
                term010 = Math.fma(mI.dy, -this.R020, term010);
                term010 = Math.fma(mI.dz, -this.R011, term010);
                term010 = Math.fma(mI.qxx, this.R210, term010);
                term010 = Math.fma(mI.qyy, this.R030, term010);
                term010 = Math.fma(mI.qzz, this.R012, term010);
                term010 = Math.fma(mI.qxy, this.R120, term010);
                term010 = Math.fma(mI.qxz, this.R111, term010);
                this.E010 = term010 = Math.fma(mI.qyz, this.R021, term010);
                double term001 = 0.0;
                term001 = Math.fma(mI.q, this.R001, term001);
                term001 = Math.fma(mI.dx, -this.R101, term001);
                term001 = Math.fma(mI.dy, -this.R011, term001);
                term001 = Math.fma(mI.dz, -this.R002, term001);
                term001 = Math.fma(mI.qxx, this.R201, term001);
                term001 = Math.fma(mI.qyy, this.R021, term001);
                term001 = Math.fma(mI.qzz, this.R003, term001);
                term001 = Math.fma(mI.qxy, this.R111, term001);
                term001 = Math.fma(mI.qxz, this.R102, term001);
                this.E001 = term001 = Math.fma(mI.qyz, this.R012, term001);
            }
            case 0: 
        }
        double term000 = 0.0;
        term000 = Math.fma(mI.q, this.R000, term000);
        term000 = Math.fma(mI.dx, -this.R100, term000);
        term000 = Math.fma(mI.dy, -this.R010, term000);
        term000 = Math.fma(mI.dz, -this.R001, term000);
        term000 = Math.fma(mI.qxx, this.R200, term000);
        term000 = Math.fma(mI.qyy, this.R020, term000);
        term000 = Math.fma(mI.qzz, this.R002, term000);
        term000 = Math.fma(mI.qxy, this.R110, term000);
        term000 = Math.fma(mI.qxz, this.R101, term000);
        this.E000 = term000 = Math.fma(mI.qyz, this.R011, term000);
    }

    @Override
    protected void chargeIPotentialAtK(PolarizableMultipole mI, int order) {
        switch (order) {
            default: {
                this.E300 = mI.q * this.R300;
                this.E030 = mI.q * this.R030;
                this.E003 = mI.q * this.R003;
                this.E210 = mI.q * this.R210;
                this.E201 = mI.q * this.R201;
                this.E120 = mI.q * this.R120;
                this.E021 = mI.q * this.R021;
                this.E102 = mI.q * this.R102;
                this.E012 = mI.q * this.R012;
                this.E111 = mI.q * this.R111;
            }
            case 2: {
                this.E200 = mI.q * this.R200;
                this.E020 = mI.q * this.R020;
                this.E002 = mI.q * this.R002;
                this.E110 = mI.q * this.R110;
                this.E101 = mI.q * this.R101;
                this.E011 = mI.q * this.R011;
            }
            case 1: {
                this.E100 = mI.q * this.R100;
                this.E010 = mI.q * this.R010;
                this.E001 = mI.q * this.R001;
            }
            case 0: 
        }
        this.E000 = mI.q * this.R000;
    }

    @Override
    protected void dipoleIPotentialAtK(double uxi, double uyi, double uzi, int order) {
        switch (order) {
            case 3: {
                double term300 = 0.0;
                term300 = Math.fma(uxi, -this.R400, term300);
                term300 = Math.fma(uyi, -this.R310, term300);
                this.E300 = term300 = Math.fma(uzi, -this.R301, term300);
                double term030 = 0.0;
                term030 = Math.fma(uxi, -this.R130, term030);
                term030 = Math.fma(uyi, -this.R040, term030);
                this.E030 = term030 = Math.fma(uzi, -this.R031, term030);
                double term003 = 0.0;
                term003 = Math.fma(uxi, -this.R103, term003);
                term003 = Math.fma(uyi, -this.R013, term003);
                this.E003 = term003 = Math.fma(uzi, -this.R004, term003);
                double term210 = 0.0;
                term210 = Math.fma(uxi, -this.R310, term210);
                term210 = Math.fma(uyi, -this.R220, term210);
                this.E210 = term210 = Math.fma(uzi, -this.R211, term210);
                double term201 = 0.0;
                term201 = Math.fma(uxi, -this.R301, term201);
                term201 = Math.fma(uyi, -this.R211, term201);
                this.E201 = term201 = Math.fma(uzi, -this.R202, term201);
                double term120 = 0.0;
                term120 = Math.fma(uxi, -this.R220, term120);
                term120 = Math.fma(uyi, -this.R130, term120);
                this.E120 = term120 = Math.fma(uzi, -this.R121, term120);
                double term021 = 0.0;
                term021 = Math.fma(uxi, -this.R121, term021);
                term021 = Math.fma(uyi, -this.R031, term021);
                this.E021 = term021 = Math.fma(uzi, -this.R022, term021);
                double term102 = 0.0;
                term102 = Math.fma(uxi, -this.R202, term102);
                term102 = Math.fma(uyi, -this.R112, term102);
                this.E102 = term102 = Math.fma(uzi, -this.R103, term102);
                double term012 = 0.0;
                term012 = Math.fma(uxi, -this.R112, term012);
                term012 = Math.fma(uyi, -this.R022, term012);
                this.E012 = term012 = Math.fma(uzi, -this.R013, term012);
                double term111 = 0.0;
                term111 = Math.fma(uxi, -this.R211, term111);
                term111 = Math.fma(uyi, -this.R121, term111);
                this.E111 = term111 = Math.fma(uzi, -this.R112, term111);
            }
            case 2: {
                double term200 = -uxi * this.R300;
                term200 -= uyi * this.R210;
                this.E200 = term200 -= uzi * this.R201;
                double term020 = -uxi * this.R120;
                term020 -= uyi * this.R030;
                this.E020 = term020 -= uzi * this.R021;
                double term002 = -uxi * this.R102;
                term002 -= uyi * this.R012;
                this.E002 = term002 -= uzi * this.R003;
                double term110 = -uxi * this.R210;
                term110 -= uyi * this.R120;
                this.E110 = term110 -= uzi * this.R111;
                double term101 = -uxi * this.R201;
                term101 -= uyi * this.R111;
                this.E101 = term101 -= uzi * this.R102;
                double term011 = -uxi * this.R111;
                term011 -= uyi * this.R021;
                this.E011 = term011 -= uzi * this.R012;
            }
            case 1: {
                double term100 = -uxi * this.R200;
                term100 -= uyi * this.R110;
                this.E100 = term100 -= uzi * this.R101;
                double term010 = -uxi * this.R110;
                term010 -= uyi * this.R020;
                this.E010 = term010 -= uzi * this.R011;
                double term001 = -uxi * this.R101;
                term001 -= uyi * this.R011;
                this.E001 = term001 -= uzi * this.R002;
            }
            case 0: {
                double term000 = -uxi * this.R100;
                term000 -= uyi * this.R010;
                this.E000 = term000 -= uzi * this.R001;
            }
        }
    }

    @Override
    protected void quadrupoleIPotentialAtK(PolarizableMultipole mI, int order) {
        switch (order) {
            default: {
                double term300 = 0.0;
                term300 = Math.fma(mI.qxx, this.R500, term300);
                term300 = Math.fma(mI.qyy, this.R320, term300);
                term300 = Math.fma(mI.qzz, this.R302, term300);
                term300 = Math.fma(mI.qxy, this.R410, term300);
                term300 = Math.fma(mI.qxz, this.R401, term300);
                this.E300 = term300 = Math.fma(mI.qyz, this.R311, term300);
                double term030 = 0.0;
                term030 = Math.fma(mI.qxx, this.R230, term030);
                term030 = Math.fma(mI.qyy, this.R050, term030);
                term030 = Math.fma(mI.qzz, this.R032, term030);
                term030 = Math.fma(mI.qxy, this.R140, term030);
                term030 = Math.fma(mI.qxz, this.R131, term030);
                this.E030 = term030 = Math.fma(mI.qyz, this.R041, term030);
                double term003 = 0.0;
                term003 = Math.fma(mI.qxx, this.R203, term003);
                term003 = Math.fma(mI.qyy, this.R023, term003);
                term003 = Math.fma(mI.qzz, this.R005, term003);
                term003 = Math.fma(mI.qxy, this.R113, term003);
                term003 = Math.fma(mI.qxz, this.R104, term003);
                this.E003 = term003 = Math.fma(mI.qyz, this.R014, term003);
                double term210 = 0.0;
                term210 = Math.fma(mI.qxx, this.R410, term210);
                term210 = Math.fma(mI.qyy, this.R230, term210);
                term210 = Math.fma(mI.qzz, this.R212, term210);
                term210 = Math.fma(mI.qxy, this.R320, term210);
                term210 = Math.fma(mI.qxz, this.R311, term210);
                this.E210 = term210 = Math.fma(mI.qyz, this.R221, term210);
                double term201 = 0.0;
                term201 = Math.fma(mI.qxx, this.R401, term201);
                term201 = Math.fma(mI.qyy, this.R221, term201);
                term201 = Math.fma(mI.qzz, this.R203, term201);
                term201 = Math.fma(mI.qxy, this.R311, term201);
                term201 = Math.fma(mI.qxz, this.R302, term201);
                this.E201 = term201 = Math.fma(mI.qyz, this.R212, term201);
                double term120 = 0.0;
                term120 = Math.fma(mI.qxx, this.R320, term120);
                term120 = Math.fma(mI.qyy, this.R140, term120);
                term120 = Math.fma(mI.qzz, this.R122, term120);
                term120 = Math.fma(mI.qxy, this.R230, term120);
                term120 = Math.fma(mI.qxz, this.R221, term120);
                this.E120 = term120 = Math.fma(mI.qyz, this.R131, term120);
                double term021 = 0.0;
                term021 = Math.fma(mI.qxx, this.R221, term021);
                term021 = Math.fma(mI.qyy, this.R041, term021);
                term021 = Math.fma(mI.qzz, this.R023, term021);
                term021 = Math.fma(mI.qxy, this.R131, term021);
                term021 = Math.fma(mI.qxz, this.R122, term021);
                this.E021 = term021 = Math.fma(mI.qyz, this.R032, term021);
                double term102 = 0.0;
                term102 = Math.fma(mI.qxx, this.R302, term102);
                term102 = Math.fma(mI.qyy, this.R122, term102);
                term102 = Math.fma(mI.qzz, this.R104, term102);
                term102 = Math.fma(mI.qxy, this.R212, term102);
                term102 = Math.fma(mI.qxz, this.R203, term102);
                this.E102 = term102 = Math.fma(mI.qyz, this.R113, term102);
                double term012 = 0.0;
                term012 = Math.fma(mI.qxx, this.R212, term012);
                term012 = Math.fma(mI.qyy, this.R032, term012);
                term012 = Math.fma(mI.qzz, this.R014, term012);
                term012 = Math.fma(mI.qxy, this.R122, term012);
                term012 = Math.fma(mI.qxz, this.R113, term012);
                this.E012 = term012 = Math.fma(mI.qyz, this.R023, term012);
                double term111 = 0.0;
                term111 = Math.fma(mI.qxx, this.R311, term111);
                term111 = Math.fma(mI.qyy, this.R131, term111);
                term111 = Math.fma(mI.qzz, this.R113, term111);
                term111 = Math.fma(mI.qxy, this.R221, term111);
                term111 = Math.fma(mI.qxz, this.R212, term111);
                this.E111 = term111 = Math.fma(mI.qyz, this.R122, term111);
            }
            case 2: {
                double term200 = 0.0;
                term200 = Math.fma(mI.qxx, this.R400, term200);
                term200 = Math.fma(mI.qyy, this.R220, term200);
                term200 = Math.fma(mI.qzz, this.R202, term200);
                term200 = Math.fma(mI.qxy, this.R310, term200);
                term200 = Math.fma(mI.qxz, this.R301, term200);
                this.E200 = term200 = Math.fma(mI.qyz, this.R211, term200);
                double term020 = 0.0;
                term020 = Math.fma(mI.qxx, this.R220, term020);
                term020 = Math.fma(mI.qyy, this.R040, term020);
                term020 = Math.fma(mI.qzz, this.R022, term020);
                term020 = Math.fma(mI.qxy, this.R130, term020);
                term020 = Math.fma(mI.qxz, this.R121, term020);
                this.E020 = term020 = Math.fma(mI.qyz, this.R031, term020);
                double term002 = 0.0;
                term002 = Math.fma(mI.qxx, this.R202, term002);
                term002 = Math.fma(mI.qyy, this.R022, term002);
                term002 = Math.fma(mI.qzz, this.R004, term002);
                term002 = Math.fma(mI.qxy, this.R112, term002);
                term002 = Math.fma(mI.qxz, this.R103, term002);
                this.E002 = term002 = Math.fma(mI.qyz, this.R013, term002);
                double term110 = 0.0;
                term110 = Math.fma(mI.qxx, this.R310, term110);
                term110 = Math.fma(mI.qyy, this.R130, term110);
                term110 = Math.fma(mI.qzz, this.R112, term110);
                term110 = Math.fma(mI.qxy, this.R220, term110);
                term110 = Math.fma(mI.qxz, this.R211, term110);
                this.E110 = term110 = Math.fma(mI.qyz, this.R121, term110);
                double term101 = 0.0;
                term101 = Math.fma(mI.qxx, this.R301, term101);
                term101 = Math.fma(mI.qyy, this.R121, term101);
                term101 = Math.fma(mI.qzz, this.R103, term101);
                term101 = Math.fma(mI.qxy, this.R211, term101);
                term101 = Math.fma(mI.qxz, this.R202, term101);
                this.E101 = term101 = Math.fma(mI.qyz, this.R112, term101);
                double term011 = 0.0;
                term011 = Math.fma(mI.qxx, this.R211, term011);
                term011 = Math.fma(mI.qyy, this.R031, term011);
                term011 = Math.fma(mI.qzz, this.R013, term011);
                term011 = Math.fma(mI.qxy, this.R121, term011);
                term011 = Math.fma(mI.qxz, this.R112, term011);
                this.E011 = term011 = Math.fma(mI.qyz, this.R022, term011);
            }
            case 1: {
                double term100 = 0.0;
                term100 = Math.fma(mI.qxx, this.R300, term100);
                term100 = Math.fma(mI.qyy, this.R120, term100);
                term100 = Math.fma(mI.qzz, this.R102, term100);
                term100 = Math.fma(mI.qxy, this.R210, term100);
                term100 = Math.fma(mI.qxz, this.R201, term100);
                this.E100 = term100 = Math.fma(mI.qyz, this.R111, term100);
                double term010 = 0.0;
                term010 = Math.fma(mI.qxx, this.R210, term010);
                term010 = Math.fma(mI.qyy, this.R030, term010);
                term010 = Math.fma(mI.qzz, this.R012, term010);
                term010 = Math.fma(mI.qxy, this.R120, term010);
                term010 = Math.fma(mI.qxz, this.R111, term010);
                this.E010 = term010 = Math.fma(mI.qyz, this.R021, term010);
                double term001 = 0.0;
                term001 = Math.fma(mI.qxx, this.R201, term001);
                term001 = Math.fma(mI.qyy, this.R021, term001);
                term001 = Math.fma(mI.qzz, this.R003, term001);
                term001 = Math.fma(mI.qxy, this.R111, term001);
                term001 = Math.fma(mI.qxz, this.R102, term001);
                this.E001 = term001 = Math.fma(mI.qyz, this.R012, term001);
            }
            case 0: 
        }
        double term000 = 0.0;
        term000 = Math.fma(mI.qxx, this.R200, term000);
        term000 = Math.fma(mI.qyy, this.R020, term000);
        term000 = Math.fma(mI.qzz, this.R002, term000);
        term000 = Math.fma(mI.qxy, this.R110, term000);
        term000 = Math.fma(mI.qxz, this.R101, term000);
        this.E000 = term000 = Math.fma(mI.qyz, this.R011, term000);
    }

    @Override
    protected void multipoleKPotentialAtI(PolarizableMultipole mK, int order) {
        switch (order) {
            default: {
                double term300 = 0.0;
                term300 = Math.fma(mK.q, this.R300, term300);
                term300 = Math.fma(mK.dx, this.R400, term300);
                term300 = Math.fma(mK.dy, this.R310, term300);
                term300 = Math.fma(mK.dz, this.R301, term300);
                term300 = Math.fma(mK.qxx, this.R500, term300);
                term300 = Math.fma(mK.qyy, this.R320, term300);
                term300 = Math.fma(mK.qzz, this.R302, term300);
                term300 = Math.fma(mK.qxy, this.R410, term300);
                term300 = Math.fma(mK.qxz, this.R401, term300);
                term300 = Math.fma(mK.qyz, this.R311, term300);
                this.E300 = -term300;
                double term030 = 0.0;
                term030 = Math.fma(mK.q, this.R030, term030);
                term030 = Math.fma(mK.dx, this.R130, term030);
                term030 = Math.fma(mK.dy, this.R040, term030);
                term030 = Math.fma(mK.dz, this.R031, term030);
                term030 = Math.fma(mK.qxx, this.R230, term030);
                term030 = Math.fma(mK.qyy, this.R050, term030);
                term030 = Math.fma(mK.qzz, this.R032, term030);
                term030 = Math.fma(mK.qxy, this.R140, term030);
                term030 = Math.fma(mK.qxz, this.R131, term030);
                term030 = Math.fma(mK.qyz, this.R041, term030);
                this.E030 = -term030;
                double term003 = 0.0;
                term003 = Math.fma(mK.q, this.R003, term003);
                term003 = Math.fma(mK.dx, this.R103, term003);
                term003 = Math.fma(mK.dy, this.R013, term003);
                term003 = Math.fma(mK.dz, this.R004, term003);
                term003 = Math.fma(mK.qxx, this.R203, term003);
                term003 = Math.fma(mK.qyy, this.R023, term003);
                term003 = Math.fma(mK.qzz, this.R005, term003);
                term003 = Math.fma(mK.qxy, this.R113, term003);
                term003 = Math.fma(mK.qxz, this.R104, term003);
                term003 = Math.fma(mK.qyz, this.R014, term003);
                this.E003 = -term003;
                double term210 = 0.0;
                term210 = Math.fma(mK.q, this.R210, term210);
                term210 = Math.fma(mK.dx, this.R310, term210);
                term210 = Math.fma(mK.dy, this.R220, term210);
                term210 = Math.fma(mK.dz, this.R211, term210);
                term210 = Math.fma(mK.qxx, this.R410, term210);
                term210 = Math.fma(mK.qyy, this.R230, term210);
                term210 = Math.fma(mK.qzz, this.R212, term210);
                term210 = Math.fma(mK.qxy, this.R320, term210);
                term210 = Math.fma(mK.qxz, this.R311, term210);
                term210 = Math.fma(mK.qyz, this.R221, term210);
                this.E210 = -term210;
                double term201 = 0.0;
                term201 = Math.fma(mK.q, this.R201, term201);
                term201 = Math.fma(mK.dx, this.R301, term201);
                term201 = Math.fma(mK.dy, this.R211, term201);
                term201 = Math.fma(mK.dz, this.R202, term201);
                term201 = Math.fma(mK.qxx, this.R401, term201);
                term201 = Math.fma(mK.qyy, this.R221, term201);
                term201 = Math.fma(mK.qzz, this.R203, term201);
                term201 = Math.fma(mK.qxy, this.R311, term201);
                term201 = Math.fma(mK.qxz, this.R302, term201);
                term201 = Math.fma(mK.qyz, this.R212, term201);
                this.E201 = -term201;
                double term120 = 0.0;
                term120 = Math.fma(mK.q, this.R120, term120);
                term120 = Math.fma(mK.dx, this.R220, term120);
                term120 = Math.fma(mK.dy, this.R130, term120);
                term120 = Math.fma(mK.dz, this.R121, term120);
                term120 = Math.fma(mK.qxx, this.R320, term120);
                term120 = Math.fma(mK.qyy, this.R140, term120);
                term120 = Math.fma(mK.qzz, this.R122, term120);
                term120 = Math.fma(mK.qxy, this.R230, term120);
                term120 = Math.fma(mK.qxz, this.R221, term120);
                term120 = Math.fma(mK.qyz, this.R131, term120);
                this.E120 = -term120;
                double term021 = 0.0;
                term021 = Math.fma(mK.q, this.R021, term021);
                term021 = Math.fma(mK.dx, this.R121, term021);
                term021 = Math.fma(mK.dy, this.R031, term021);
                term021 = Math.fma(mK.dz, this.R022, term021);
                term021 = Math.fma(mK.qxx, this.R221, term021);
                term021 = Math.fma(mK.qyy, this.R041, term021);
                term021 = Math.fma(mK.qzz, this.R023, term021);
                term021 = Math.fma(mK.qxy, this.R131, term021);
                term021 = Math.fma(mK.qxz, this.R122, term021);
                term021 = Math.fma(mK.qyz, this.R032, term021);
                this.E021 = -term021;
                double term102 = 0.0;
                term102 = Math.fma(mK.q, this.R102, term102);
                term102 = Math.fma(mK.dx, this.R202, term102);
                term102 = Math.fma(mK.dy, this.R112, term102);
                term102 = Math.fma(mK.dz, this.R103, term102);
                term102 = Math.fma(mK.qxx, this.R302, term102);
                term102 = Math.fma(mK.qyy, this.R122, term102);
                term102 = Math.fma(mK.qzz, this.R104, term102);
                term102 = Math.fma(mK.qxy, this.R212, term102);
                term102 = Math.fma(mK.qxz, this.R203, term102);
                term102 = Math.fma(mK.qyz, this.R113, term102);
                this.E102 = -term102;
                double term012 = 0.0;
                term012 = Math.fma(mK.q, this.R012, term012);
                term012 = Math.fma(mK.dx, this.R112, term012);
                term012 = Math.fma(mK.dy, this.R022, term012);
                term012 = Math.fma(mK.dz, this.R013, term012);
                term012 = Math.fma(mK.qxx, this.R212, term012);
                term012 = Math.fma(mK.qyy, this.R032, term012);
                term012 = Math.fma(mK.qzz, this.R014, term012);
                term012 = Math.fma(mK.qxy, this.R122, term012);
                term012 = Math.fma(mK.qxz, this.R113, term012);
                term012 = Math.fma(mK.qyz, this.R023, term012);
                this.E012 = -term012;
                double term111 = 0.0;
                term111 = Math.fma(mK.q, this.R111, term111);
                term111 = Math.fma(mK.dx, this.R211, term111);
                term111 = Math.fma(mK.dy, this.R121, term111);
                term111 = Math.fma(mK.dz, this.R112, term111);
                term111 = Math.fma(mK.qxx, this.R311, term111);
                term111 = Math.fma(mK.qyy, this.R131, term111);
                term111 = Math.fma(mK.qzz, this.R113, term111);
                term111 = Math.fma(mK.qxy, this.R221, term111);
                term111 = Math.fma(mK.qxz, this.R212, term111);
                term111 = Math.fma(mK.qyz, this.R122, term111);
                this.E111 = -term111;
            }
            case 2: {
                double term200 = 0.0;
                term200 = Math.fma(mK.q, this.R200, term200);
                term200 = Math.fma(mK.dx, this.R300, term200);
                term200 = Math.fma(mK.dy, this.R210, term200);
                term200 = Math.fma(mK.dz, this.R201, term200);
                term200 = Math.fma(mK.qxx, this.R400, term200);
                term200 = Math.fma(mK.qyy, this.R220, term200);
                term200 = Math.fma(mK.qzz, this.R202, term200);
                term200 = Math.fma(mK.qxy, this.R310, term200);
                term200 = Math.fma(mK.qxz, this.R301, term200);
                this.E200 = term200 = Math.fma(mK.qyz, this.R211, term200);
                double term020 = 0.0;
                term020 = Math.fma(mK.q, this.R020, term020);
                term020 = Math.fma(mK.dx, this.R120, term020);
                term020 = Math.fma(mK.dy, this.R030, term020);
                term020 = Math.fma(mK.dz, this.R021, term020);
                term020 = Math.fma(mK.qxx, this.R220, term020);
                term020 = Math.fma(mK.qyy, this.R040, term020);
                term020 = Math.fma(mK.qzz, this.R022, term020);
                term020 = Math.fma(mK.qxy, this.R130, term020);
                term020 = Math.fma(mK.qxz, this.R121, term020);
                this.E020 = term020 = Math.fma(mK.qyz, this.R031, term020);
                double term002 = 0.0;
                term002 = Math.fma(mK.q, this.R002, term002);
                term002 = Math.fma(mK.dx, this.R102, term002);
                term002 = Math.fma(mK.dy, this.R012, term002);
                term002 = Math.fma(mK.dz, this.R003, term002);
                term002 = Math.fma(mK.qxx, this.R202, term002);
                term002 = Math.fma(mK.qyy, this.R022, term002);
                term002 = Math.fma(mK.qzz, this.R004, term002);
                term002 = Math.fma(mK.qxy, this.R112, term002);
                term002 = Math.fma(mK.qxz, this.R103, term002);
                this.E002 = term002 = Math.fma(mK.qyz, this.R013, term002);
                double term110 = 0.0;
                term110 = Math.fma(mK.q, this.R110, term110);
                term110 = Math.fma(mK.dx, this.R210, term110);
                term110 = Math.fma(mK.dy, this.R120, term110);
                term110 = Math.fma(mK.dz, this.R111, term110);
                term110 = Math.fma(mK.qxx, this.R310, term110);
                term110 = Math.fma(mK.qyy, this.R130, term110);
                term110 = Math.fma(mK.qzz, this.R112, term110);
                term110 = Math.fma(mK.qxy, this.R220, term110);
                term110 = Math.fma(mK.qxz, this.R211, term110);
                this.E110 = term110 = Math.fma(mK.qyz, this.R121, term110);
                double term101 = 0.0;
                term101 = Math.fma(mK.q, this.R101, term101);
                term101 = Math.fma(mK.dx, this.R201, term101);
                term101 = Math.fma(mK.dy, this.R111, term101);
                term101 = Math.fma(mK.dz, this.R102, term101);
                term101 = Math.fma(mK.qxx, this.R301, term101);
                term101 = Math.fma(mK.qyy, this.R121, term101);
                term101 = Math.fma(mK.qzz, this.R103, term101);
                term101 = Math.fma(mK.qxy, this.R211, term101);
                term101 = Math.fma(mK.qxz, this.R202, term101);
                this.E101 = term101 = Math.fma(mK.qyz, this.R112, term101);
                double term011 = 0.0;
                term011 = Math.fma(mK.q, this.R011, term011);
                term011 = Math.fma(mK.dx, this.R111, term011);
                term011 = Math.fma(mK.dy, this.R021, term011);
                term011 = Math.fma(mK.dz, this.R012, term011);
                term011 = Math.fma(mK.qxx, this.R211, term011);
                term011 = Math.fma(mK.qyy, this.R031, term011);
                term011 = Math.fma(mK.qzz, this.R013, term011);
                term011 = Math.fma(mK.qxy, this.R121, term011);
                term011 = Math.fma(mK.qxz, this.R112, term011);
                this.E011 = term011 = Math.fma(mK.qyz, this.R022, term011);
            }
            case 1: {
                double term100 = 0.0;
                term100 = Math.fma(mK.q, this.R100, term100);
                term100 = Math.fma(mK.dx, this.R200, term100);
                term100 = Math.fma(mK.dy, this.R110, term100);
                term100 = Math.fma(mK.dz, this.R101, term100);
                term100 = Math.fma(mK.qxx, this.R300, term100);
                term100 = Math.fma(mK.qyy, this.R120, term100);
                term100 = Math.fma(mK.qzz, this.R102, term100);
                term100 = Math.fma(mK.qxy, this.R210, term100);
                term100 = Math.fma(mK.qxz, this.R201, term100);
                term100 = Math.fma(mK.qyz, this.R111, term100);
                this.E100 = -term100;
                double term010 = 0.0;
                term010 = Math.fma(mK.q, this.R010, term010);
                term010 = Math.fma(mK.dx, this.R110, term010);
                term010 = Math.fma(mK.dy, this.R020, term010);
                term010 = Math.fma(mK.dz, this.R011, term010);
                term010 = Math.fma(mK.qxx, this.R210, term010);
                term010 = Math.fma(mK.qyy, this.R030, term010);
                term010 = Math.fma(mK.qzz, this.R012, term010);
                term010 = Math.fma(mK.qxy, this.R120, term010);
                term010 = Math.fma(mK.qxz, this.R111, term010);
                term010 = Math.fma(mK.qyz, this.R021, term010);
                this.E010 = -term010;
                double term001 = 0.0;
                term001 = Math.fma(mK.q, this.R001, term001);
                term001 = Math.fma(mK.dx, this.R101, term001);
                term001 = Math.fma(mK.dy, this.R011, term001);
                term001 = Math.fma(mK.dz, this.R002, term001);
                term001 = Math.fma(mK.qxx, this.R201, term001);
                term001 = Math.fma(mK.qyy, this.R021, term001);
                term001 = Math.fma(mK.qzz, this.R003, term001);
                term001 = Math.fma(mK.qxy, this.R111, term001);
                term001 = Math.fma(mK.qxz, this.R102, term001);
                term001 = Math.fma(mK.qyz, this.R012, term001);
                this.E001 = -term001;
            }
            case 0: 
        }
        double term000 = 0.0;
        term000 = Math.fma(mK.q, this.R000, term000);
        term000 = Math.fma(mK.dx, this.R100, term000);
        term000 = Math.fma(mK.dy, this.R010, term000);
        term000 = Math.fma(mK.dz, this.R001, term000);
        term000 = Math.fma(mK.qxx, this.R200, term000);
        term000 = Math.fma(mK.qyy, this.R020, term000);
        term000 = Math.fma(mK.qzz, this.R002, term000);
        term000 = Math.fma(mK.qxy, this.R110, term000);
        term000 = Math.fma(mK.qxz, this.R101, term000);
        this.E000 = term000 = Math.fma(mK.qyz, this.R011, term000);
    }

    @Override
    protected void chargeKPotentialAtI(PolarizableMultipole mK, int order) {
        switch (order) {
            default: {
                this.E300 = -mK.q * this.R300;
                this.E030 = -mK.q * this.R030;
                this.E003 = -mK.q * this.R003;
                this.E210 = -mK.q * this.R210;
                this.E201 = -mK.q * this.R201;
                this.E120 = -mK.q * this.R120;
                this.E021 = -mK.q * this.R021;
                this.E102 = -mK.q * this.R102;
                this.E012 = -mK.q * this.R012;
                this.E111 = -mK.q * this.R111;
            }
            case 2: {
                this.E200 = mK.q * this.R200;
                this.E020 = mK.q * this.R020;
                this.E002 = mK.q * this.R002;
                this.E110 = mK.q * this.R110;
                this.E101 = mK.q * this.R101;
                this.E011 = mK.q * this.R011;
            }
            case 1: {
                this.E100 = -mK.q * this.R100;
                this.E010 = -mK.q * this.R010;
                this.E001 = -mK.q * this.R001;
            }
            case 0: 
        }
        this.E000 = mK.q * this.R000;
    }

    @Override
    protected void dipoleKPotentialAtI(double uxk, double uyk, double uzk, int order) {
        switch (order) {
            case 3: {
                double term300 = 0.0;
                term300 = Math.fma(uxk, this.R400, term300);
                term300 = Math.fma(uyk, this.R310, term300);
                term300 = Math.fma(uzk, this.R301, term300);
                this.E300 = -term300;
                double term030 = 0.0;
                term030 = Math.fma(uxk, this.R130, term030);
                term030 = Math.fma(uyk, this.R040, term030);
                term030 = Math.fma(uzk, this.R031, term030);
                this.E030 = -term030;
                double term003 = 0.0;
                term003 = Math.fma(uxk, this.R103, term003);
                term003 = Math.fma(uyk, this.R013, term003);
                term003 = Math.fma(uzk, this.R004, term003);
                this.E003 = -term003;
                double term210 = 0.0;
                term210 = Math.fma(uxk, this.R310, term210);
                term210 = Math.fma(uyk, this.R220, term210);
                term210 = Math.fma(uzk, this.R211, term210);
                this.E210 = -term210;
                double term201 = 0.0;
                term201 = Math.fma(uxk, this.R301, term201);
                term201 = Math.fma(uyk, this.R211, term201);
                term201 = Math.fma(uzk, this.R202, term201);
                this.E201 = -term201;
                double term120 = 0.0;
                term120 = Math.fma(uxk, this.R220, term120);
                term120 = Math.fma(uyk, this.R130, term120);
                term120 = Math.fma(uzk, this.R121, term120);
                this.E120 = -term120;
                double term021 = 0.0;
                term021 = Math.fma(uxk, this.R121, term021);
                term021 = Math.fma(uyk, this.R031, term021);
                term021 = Math.fma(uzk, this.R022, term021);
                this.E021 = -term021;
                double term102 = 0.0;
                term102 = Math.fma(uxk, this.R202, term102);
                term102 = Math.fma(uyk, this.R112, term102);
                term102 = Math.fma(uzk, this.R103, term102);
                this.E102 = -term102;
                double term012 = 0.0;
                term012 = Math.fma(uxk, this.R112, term012);
                term012 = Math.fma(uyk, this.R022, term012);
                term012 = Math.fma(uzk, this.R013, term012);
                this.E012 = -term012;
                double term111 = 0.0;
                term111 = Math.fma(uxk, this.R211, term111);
                term111 = Math.fma(uyk, this.R121, term111);
                term111 = Math.fma(uzk, this.R112, term111);
                this.E111 = -term111;
            }
            case 2: {
                double term200 = uxk * this.R300;
                term200 += uyk * this.R210;
                this.E200 = term200 += uzk * this.R201;
                double term020 = uxk * this.R120;
                term020 += uyk * this.R030;
                this.E020 = term020 += uzk * this.R021;
                double term002 = uxk * this.R102;
                term002 += uyk * this.R012;
                this.E002 = term002 += uzk * this.R003;
                double term110 = uxk * this.R210;
                term110 += uyk * this.R120;
                this.E110 = term110 += uzk * this.R111;
                double term101 = uxk * this.R201;
                term101 += uyk * this.R111;
                this.E101 = term101 += uzk * this.R102;
                double term011 = uxk * this.R111;
                term011 += uyk * this.R021;
                this.E011 = term011 += uzk * this.R012;
            }
            case 1: {
                double term100 = uxk * this.R200;
                term100 += uyk * this.R110;
                this.E100 = -(term100 += uzk * this.R101);
                double term010 = uxk * this.R110;
                term010 += uyk * this.R020;
                this.E010 = -(term010 += uzk * this.R011);
                double term001 = uxk * this.R101;
                term001 += uyk * this.R011;
                this.E001 = -(term001 += uzk * this.R002);
            }
            case 0: {
                double term000 = uxk * this.R100;
                term000 += uyk * this.R010;
                this.E000 = term000 += uzk * this.R001;
            }
        }
    }

    @Override
    protected void quadrupoleKPotentialAtI(PolarizableMultipole mK, int order) {
        switch (order) {
            default: {
                double term300 = 0.0;
                term300 = Math.fma(mK.qxx, this.R500, term300);
                term300 = Math.fma(mK.qyy, this.R320, term300);
                term300 = Math.fma(mK.qzz, this.R302, term300);
                term300 = Math.fma(mK.qxy, this.R410, term300);
                term300 = Math.fma(mK.qxz, this.R401, term300);
                term300 = Math.fma(mK.qyz, this.R311, term300);
                this.E300 = -term300;
                double term030 = 0.0;
                term030 = Math.fma(mK.qxx, this.R230, term030);
                term030 = Math.fma(mK.qyy, this.R050, term030);
                term030 = Math.fma(mK.qzz, this.R032, term030);
                term030 = Math.fma(mK.qxy, this.R140, term030);
                term030 = Math.fma(mK.qxz, this.R131, term030);
                term030 = Math.fma(mK.qyz, this.R041, term030);
                this.E030 = -term030;
                double term003 = 0.0;
                term003 = Math.fma(mK.qxx, this.R203, term003);
                term003 = Math.fma(mK.qyy, this.R023, term003);
                term003 = Math.fma(mK.qzz, this.R005, term003);
                term003 = Math.fma(mK.qxy, this.R113, term003);
                term003 = Math.fma(mK.qxz, this.R104, term003);
                term003 = Math.fma(mK.qyz, this.R014, term003);
                this.E003 = -term003;
                double term210 = 0.0;
                term210 = Math.fma(mK.qxx, this.R410, term210);
                term210 = Math.fma(mK.qyy, this.R230, term210);
                term210 = Math.fma(mK.qzz, this.R212, term210);
                term210 = Math.fma(mK.qxy, this.R320, term210);
                term210 = Math.fma(mK.qxz, this.R311, term210);
                term210 = Math.fma(mK.qyz, this.R221, term210);
                this.E210 = -term210;
                double term201 = 0.0;
                term201 = Math.fma(mK.qxx, this.R401, term201);
                term201 = Math.fma(mK.qyy, this.R221, term201);
                term201 = Math.fma(mK.qzz, this.R203, term201);
                term201 = Math.fma(mK.qxy, this.R311, term201);
                term201 = Math.fma(mK.qxz, this.R302, term201);
                term201 = Math.fma(mK.qyz, this.R212, term201);
                this.E201 = -term201;
                double term120 = 0.0;
                term120 = Math.fma(mK.qxx, this.R320, term120);
                term120 = Math.fma(mK.qyy, this.R140, term120);
                term120 = Math.fma(mK.qzz, this.R122, term120);
                term120 = Math.fma(mK.qxy, this.R230, term120);
                term120 = Math.fma(mK.qxz, this.R221, term120);
                term120 = Math.fma(mK.qyz, this.R131, term120);
                this.E120 = -term120;
                double term021 = 0.0;
                term021 = Math.fma(mK.qxx, this.R221, term021);
                term021 = Math.fma(mK.qyy, this.R041, term021);
                term021 = Math.fma(mK.qzz, this.R023, term021);
                term021 = Math.fma(mK.qxy, this.R131, term021);
                term021 = Math.fma(mK.qxz, this.R122, term021);
                term021 = Math.fma(mK.qyz, this.R032, term021);
                this.E021 = -term021;
                double term102 = 0.0;
                term102 = Math.fma(mK.qxx, this.R302, term102);
                term102 = Math.fma(mK.qyy, this.R122, term102);
                term102 = Math.fma(mK.qzz, this.R104, term102);
                term102 = Math.fma(mK.qxy, this.R212, term102);
                term102 = Math.fma(mK.qxz, this.R203, term102);
                term102 = Math.fma(mK.qyz, this.R113, term102);
                this.E102 = -term102;
                double term012 = 0.0;
                term012 = Math.fma(mK.qxx, this.R212, term012);
                term012 = Math.fma(mK.qyy, this.R032, term012);
                term012 = Math.fma(mK.qzz, this.R014, term012);
                term012 = Math.fma(mK.qxy, this.R122, term012);
                term012 = Math.fma(mK.qxz, this.R113, term012);
                term012 = Math.fma(mK.qyz, this.R023, term012);
                this.E012 = -term012;
                double term111 = 0.0;
                term111 = Math.fma(mK.qxx, this.R311, term111);
                term111 = Math.fma(mK.qyy, this.R131, term111);
                term111 = Math.fma(mK.qzz, this.R113, term111);
                term111 = Math.fma(mK.qxy, this.R221, term111);
                term111 = Math.fma(mK.qxz, this.R212, term111);
                term111 = Math.fma(mK.qyz, this.R122, term111);
                this.E111 = -term111;
            }
            case 2: {
                double term200 = 0.0;
                term200 = Math.fma(mK.qxx, this.R400, term200);
                term200 = Math.fma(mK.qyy, this.R220, term200);
                term200 = Math.fma(mK.qzz, this.R202, term200);
                term200 = Math.fma(mK.qxy, this.R310, term200);
                term200 = Math.fma(mK.qxz, this.R301, term200);
                this.E200 = term200 = Math.fma(mK.qyz, this.R211, term200);
                double term020 = 0.0;
                term020 = Math.fma(mK.qxx, this.R220, term020);
                term020 = Math.fma(mK.qyy, this.R040, term020);
                term020 = Math.fma(mK.qzz, this.R022, term020);
                term020 = Math.fma(mK.qxy, this.R130, term020);
                term020 = Math.fma(mK.qxz, this.R121, term020);
                this.E020 = term020 = Math.fma(mK.qyz, this.R031, term020);
                double term002 = 0.0;
                term002 = Math.fma(mK.qxx, this.R202, term002);
                term002 = Math.fma(mK.qyy, this.R022, term002);
                term002 = Math.fma(mK.qzz, this.R004, term002);
                term002 = Math.fma(mK.qxy, this.R112, term002);
                term002 = Math.fma(mK.qxz, this.R103, term002);
                this.E002 = term002 = Math.fma(mK.qyz, this.R013, term002);
                double term110 = 0.0;
                term110 = Math.fma(mK.qxx, this.R310, term110);
                term110 = Math.fma(mK.qyy, this.R130, term110);
                term110 = Math.fma(mK.qzz, this.R112, term110);
                term110 = Math.fma(mK.qxy, this.R220, term110);
                term110 = Math.fma(mK.qxz, this.R211, term110);
                this.E110 = term110 = Math.fma(mK.qyz, this.R121, term110);
                double term101 = 0.0;
                term101 = Math.fma(mK.qxx, this.R301, term101);
                term101 = Math.fma(mK.qyy, this.R121, term101);
                term101 = Math.fma(mK.qzz, this.R103, term101);
                term101 = Math.fma(mK.qxy, this.R211, term101);
                term101 = Math.fma(mK.qxz, this.R202, term101);
                this.E101 = term101 = Math.fma(mK.qyz, this.R112, term101);
                double term011 = 0.0;
                term011 = Math.fma(mK.qxx, this.R211, term011);
                term011 = Math.fma(mK.qyy, this.R031, term011);
                term011 = Math.fma(mK.qzz, this.R013, term011);
                term011 = Math.fma(mK.qxy, this.R121, term011);
                term011 = Math.fma(mK.qxz, this.R112, term011);
                this.E011 = term011 = Math.fma(mK.qyz, this.R022, term011);
            }
            case 1: {
                double term100 = 0.0;
                term100 = Math.fma(mK.qxx, this.R300, term100);
                term100 = Math.fma(mK.qyy, this.R120, term100);
                term100 = Math.fma(mK.qzz, this.R102, term100);
                term100 = Math.fma(mK.qxy, this.R210, term100);
                term100 = Math.fma(mK.qxz, this.R201, term100);
                term100 = Math.fma(mK.qyz, this.R111, term100);
                this.E100 = -term100;
                double term010 = 0.0;
                term010 = Math.fma(mK.qxx, this.R210, term010);
                term010 = Math.fma(mK.qyy, this.R030, term010);
                term010 = Math.fma(mK.qzz, this.R012, term010);
                term010 = Math.fma(mK.qxy, this.R120, term010);
                term010 = Math.fma(mK.qxz, this.R111, term010);
                term010 = Math.fma(mK.qyz, this.R021, term010);
                this.E010 = -term010;
                double term001 = 0.0;
                term001 = Math.fma(mK.qxx, this.R201, term001);
                term001 = Math.fma(mK.qyy, this.R021, term001);
                term001 = Math.fma(mK.qzz, this.R003, term001);
                term001 = Math.fma(mK.qxy, this.R111, term001);
                term001 = Math.fma(mK.qxz, this.R102, term001);
                term001 = Math.fma(mK.qyz, this.R012, term001);
                this.E001 = -term001;
            }
            case 0: 
        }
        double term000 = 0.0;
        term000 = Math.fma(mK.qxx, this.R200, term000);
        term000 = Math.fma(mK.qyy, this.R020, term000);
        term000 = Math.fma(mK.qzz, this.R002, term000);
        term000 = Math.fma(mK.qxy, this.R110, term000);
        term000 = Math.fma(mK.qxz, this.R101, term000);
        this.E000 = term000 = Math.fma(mK.qyz, this.R011, term000);
    }

    @Override
    protected double Tlmnj(int l, int m, int n, int j, double[] r, double[] T000) {
        if (m == 0 && n == 0) {
            if (l > 1) {
                return r[0] * this.Tlmnj(l - 1, 0, 0, j + 1, r, T000) + (double)(l - 1) * this.Tlmnj(l - 2, 0, 0, j + 1, r, T000);
            }
            if (l == 1) {
                return r[0] * this.Tlmnj(0, 0, 0, j + 1, r, T000);
            }
            return T000[j];
        }
        if (n == 0) {
            if (m > 1) {
                return r[1] * this.Tlmnj(l, m - 1, 0, j + 1, r, T000) + (double)(m - 1) * this.Tlmnj(l, m - 2, 0, j + 1, r, T000);
            }
            return r[1] * this.Tlmnj(l, 0, 0, j + 1, r, T000);
        }
        if (n > 1) {
            return r[2] * this.Tlmnj(l, m, n - 1, j + 1, r, T000) + (double)(n - 1) * this.Tlmnj(l, m, n - 2, j + 1, r, T000);
        }
        return r[2] * this.Tlmnj(l, m, 0, j + 1, r, T000);
    }

    @Override
    protected void noStorageRecursion(double[] r, double[] tensor) {
        this.setR(r);
        this.noStorageRecursion(tensor);
    }

    @Override
    protected void noStorageRecursion(double[] tensor) {
        int m;
        int l;
        this.source(this.T000);
        double[] r = new double[]{this.x, this.y, this.z};
        tensor[0] = this.T000[0];
        for (l = 1; l <= this.order; ++l) {
            tensor[this.ti((int)l, (int)0, (int)0)] = this.Tlmnj(l, 0, 0, 0, r, this.T000);
        }
        for (l = 0; l <= this.o1; ++l) {
            for (m = 1; m <= this.order - l; ++m) {
                tensor[this.ti((int)l, (int)m, (int)0)] = this.Tlmnj(l, m, 0, 0, r, this.T000);
            }
        }
        for (l = 0; l <= this.o1; ++l) {
            for (m = 0; m <= this.o1 - l; ++m) {
                for (int n = 1; n <= this.order - l - m; ++n) {
                    tensor[this.ti((int)l, (int)m, (int)n)] = this.Tlmnj(l, m, n, 0, r, this.T000);
                }
            }
        }
    }

    @Override
    protected void recursion(double[] r, double[] tensor) {
        this.setR(r);
        this.recursion(tensor);
    }

    @Override
    protected void recursion(double[] tensor) {
        int m;
        double current;
        int l;
        this.source(this.work);
        tensor[0] = this.work[0];
        double previous = this.work[1];
        tensor[this.ti((int)1, (int)0, (int)0)] = this.x * previous;
        for (l = 2; l < this.o1; ++l) {
            current = this.x * this.work[l];
            int iw = this.il + l - 1;
            this.work[iw] = current;
            for (int a = 1; a < l - 1; ++a) {
                current = this.x * current + (double)a * this.work[iw - this.il];
                this.work[iw += this.il - 1] = current;
            }
            tensor[this.ti((int)l, (int)0, (int)0)] = this.x * current + (double)(l - 1) * previous;
            previous = current;
        }
        for (l = 0; l < this.order; ++l) {
            previous = this.work[l * this.il + 1];
            tensor[this.ti((int)l, (int)1, (int)0)] = this.y * previous;
            m = 2;
            while (m + l < this.o1) {
                int iw = l * this.il + m;
                current = this.y * this.work[iw];
                this.work[iw += this.im - 1] = current;
                for (int a = 1; a < m - 1; ++a) {
                    current = this.y * current + (double)a * this.work[iw - this.im];
                    this.work[iw += this.im - 1] = current;
                }
                tensor[this.ti((int)l, (int)m, (int)0)] = this.y * current + (double)(m - 1) * previous;
                previous = current;
                ++m;
            }
        }
        for (l = 0; l < this.order; ++l) {
            m = 0;
            while (m + l < this.order) {
                int lm = m + l;
                int lilmim = l * this.il + m * this.im;
                previous = this.work[lilmim + 1];
                tensor[this.ti((int)l, (int)m, (int)1)] = this.z * previous;
                int n = 2;
                while (lm + n < this.o1) {
                    int iw = lilmim + n;
                    current = this.z * this.work[iw];
                    this.work[iw += this.in - 1] = current;
                    int n1 = n - 1;
                    for (int a = 1; a < n1; ++a) {
                        current = this.z * current + (double)a * this.work[iw - this.in];
                        this.work[iw += this.in - 1] = current;
                    }
                    tensor[this.ti((int)l, (int)m, (int)n)] = this.z * current + (double)n1 * previous;
                    previous = current;
                    ++n;
                }
                ++m;
            }
        }
    }

    @Override
    protected String codeTensorRecursion(double[] r, double[] tensor) {
        int m;
        double current;
        int l;
        this.setR(r);
        this.source(this.work);
        StringBuilder sb = new StringBuilder();
        tensor[0] = this.work[0];
        if (this.work[0] > 0.0) {
            sb.append(String.format("%s = %s;\n", MultipoleUtilities.rlmn(0, 0, 0), MultipoleUtilities.term(0, 0, 0, 0)));
        }
        double previous = this.work[1];
        tensor[this.ti((int)1, (int)0, (int)0)] = this.x * previous;
        sb.append(String.format("%s = x * %s;\n", MultipoleUtilities.rlmn(1, 0, 0), MultipoleUtilities.term(0, 0, 0, 1)));
        for (l = 2; l < this.o1; ++l) {
            current = this.x * this.work[l];
            int iw = this.il + l - 1;
            this.work[iw] = current;
            sb.append(String.format("double %s = x * %s;\n", MultipoleUtilities.term(1, 0, 0, l - 1), MultipoleUtilities.term(0, 0, 0, l)));
            for (int a = 1; a < l - 1; ++a) {
                current = this.x * current + (double)a * this.work[iw - this.il];
                this.work[iw += this.il - 1] = current;
                if (a > 1) {
                    sb.append(String.format("double %s = fma(x, %s, %d * %s);\n", MultipoleUtilities.term(a + 1, 0, 0, l - a - 1), MultipoleUtilities.term(a, 0, 0, l - a), a, MultipoleUtilities.term(a - 1, 0, 0, l - a)));
                    continue;
                }
                sb.append(String.format("double %s = fma(x, %s, %s);\n", MultipoleUtilities.term(a + 1, 0, 0, l - a - 1), MultipoleUtilities.term(a, 0, 0, l - a), MultipoleUtilities.term(a - 1, 0, 0, l - a)));
            }
            tensor[this.ti((int)l, (int)0, (int)0)] = this.x * current + (double)(l - 1) * previous;
            previous = current;
            if (l > 2) {
                sb.append(String.format("%s = fma(x, %s, %d * %s);\n", MultipoleUtilities.rlmn(l, 0, 0), MultipoleUtilities.term(l - 1, 0, 0, 1), l - 1, MultipoleUtilities.term(l - 2, 0, 0, 1)));
                continue;
            }
            sb.append(String.format("%s = fma(x, %s, %s);\n", MultipoleUtilities.rlmn(l, 0, 0), MultipoleUtilities.term(l - 1, 0, 0, 1), MultipoleUtilities.term(l - 2, 0, 0, 1)));
        }
        for (l = 0; l < this.order; ++l) {
            previous = this.work[l * this.il + 1];
            tensor[this.ti((int)l, (int)1, (int)0)] = this.y * previous;
            sb.append(String.format("%s = y * %s;\n", MultipoleUtilities.rlmn(l, 1, 0), MultipoleUtilities.term(l, 0, 0, 1)));
            m = 2;
            while (m + l < this.o1) {
                int iw = l * this.il + m;
                current = this.y * this.work[iw];
                this.work[iw += this.im - 1] = current;
                sb.append(String.format("double %s = y * %s;\n", MultipoleUtilities.term(l, 1, 0, m - 1), MultipoleUtilities.term(l, 0, 0, m)));
                for (int a = 1; a < m - 1; ++a) {
                    current = this.y * current + (double)a * this.work[iw - this.im];
                    this.work[iw += this.im - 1] = current;
                    if (a > 1) {
                        sb.append(String.format("double %s = fma(y, %s, %d * %s);\n", MultipoleUtilities.term(l, a + 1, 0, m - a - 1), MultipoleUtilities.term(l, a, 0, m - a), a, MultipoleUtilities.term(l, a - 1, 0, m - a)));
                        continue;
                    }
                    sb.append(String.format("double %s = fma(y, %s, %s);\n", MultipoleUtilities.term(l, a + 1, 0, m - a - 1), MultipoleUtilities.term(l, a, 0, m - a), MultipoleUtilities.term(l, a - 1, 0, m - a)));
                }
                tensor[this.ti((int)l, (int)m, (int)0)] = this.y * current + (double)(m - 1) * previous;
                previous = current;
                if (m > 2) {
                    sb.append(String.format("%s = fma(y, %s, %d * %s);\n", MultipoleUtilities.rlmn(l, m, 0), MultipoleUtilities.term(l, m - 1, 0, 1), m - 1, MultipoleUtilities.term(l, m - 2, 0, 1)));
                } else {
                    sb.append(String.format("%s = fma(y, %s, %s);\n", MultipoleUtilities.rlmn(l, m, 0), MultipoleUtilities.term(l, m - 1, 0, 1), MultipoleUtilities.term(l, m - 2, 0, 1)));
                }
                ++m;
            }
        }
        for (l = 0; l < this.order; ++l) {
            m = 0;
            while (m + l < this.order) {
                int lm = m + l;
                int lilmim = l * this.il + m * this.im;
                previous = this.work[lilmim + 1];
                tensor[this.ti((int)l, (int)m, (int)1)] = this.z * previous;
                sb.append(String.format("%s = z * %s;\n", MultipoleUtilities.rlmn(l, m, 1), MultipoleUtilities.term(l, m, 0, 1)));
                int n = 2;
                while (lm + n < this.o1) {
                    int iw = lilmim + n;
                    current = this.z * this.work[iw];
                    this.work[iw += this.in - 1] = current;
                    sb.append(String.format("double %s = z * %s;\n", MultipoleUtilities.term(l, m, 1, n - 1), MultipoleUtilities.term(l, m, 0, n)));
                    int n1 = n - 1;
                    for (int a = 1; a < n1; ++a) {
                        current = this.z * current + (double)a * this.work[iw - this.in];
                        this.work[iw += this.in - 1] = current;
                        if (a > 1) {
                            sb.append(String.format("double %s = fma(z, %s, %d * %s);\n", MultipoleUtilities.term(l, m, a + 1, n - a - 1), MultipoleUtilities.term(l, m, a, n - a), a, MultipoleUtilities.term(l, m, a - 1, n - a)));
                            continue;
                        }
                        sb.append(String.format("double %s = fma(z, %s, %s);\n", MultipoleUtilities.term(l, m, a + 1, n - a - 1), MultipoleUtilities.term(l, m, a, n - a), MultipoleUtilities.term(l, m, a - 1, n - a)));
                    }
                    tensor[this.ti((int)l, (int)m, (int)n)] = this.z * current + (double)n1 * previous;
                    previous = current;
                    if (n > 2) {
                        sb.append(String.format("%s = fma(z, %s, %d * %s);\n", MultipoleUtilities.rlmn(l, m, n), MultipoleUtilities.term(l, m, n - 1, 1), n - 1, MultipoleUtilities.term(l, m, n - 2, 1)));
                    } else {
                        sb.append(String.format("%s = fma(z, %s, %s);\n", MultipoleUtilities.rlmn(l, m, n), MultipoleUtilities.term(l, m, n - 1, 1), MultipoleUtilities.term(l, m, n - 2, 1)));
                    }
                    ++n;
                }
                ++m;
            }
        }
        return sb.toString();
    }

    private static String store(int order, int l, int m, int n, String ret) {
        if (order < 0 || l + m + n == order) {
            return ret;
        }
        return "";
    }

    private static String emit(int order, int l, int m, int n, int j, String ret) {
        if (order < 0 || l + m + n + j == order) {
            return ret;
        }
        return "";
    }

    protected String codeVectorTensorRecursion() {
        return this.codeVectorTensorRecursion(-1);
    }

    protected String codeVectorTensorRecursion(int order) {
        int m;
        int l;
        StringBuilder sb = new StringBuilder();
        int lmn = 0;
        String s = String.format("%s.intoArray(t, T%s);\n", MultipoleUtilities.term(0, 0, 0, 0), MultipoleUtilities.lmn(0, 0, 0));
        sb.append(CoulombTensorGlobal.store(order, 0, 0, 0, s));
        if (order == lmn) {
            return sb.toString();
        }
        s = String.format("x.mul(%s).intoArray(t, T%s);\n", MultipoleUtilities.term(0, 0, 0, 1), MultipoleUtilities.lmn(1, 0, 0));
        sb.append(CoulombTensorGlobal.store(order, 1, 0, 0, s));
        for (l = 2; l < this.o1; ++l) {
            s = String.format("DoubleVector %s = x.mul(%s);\n", MultipoleUtilities.term(1, 0, 0, l - 1), MultipoleUtilities.term(0, 0, 0, l));
            sb.append(CoulombTensorGlobal.emit(order, 1, 0, 0, l - 1, s));
            for (int a = 1; a < l - 1; ++a) {
                s = a > 1 ? String.format("DoubleVector %s = x.fma(%s, %s.mul(%d));\n", MultipoleUtilities.term(a + 1, 0, 0, l - a - 1), MultipoleUtilities.term(a, 0, 0, l - a), MultipoleUtilities.term(a - 1, 0, 0, l - a), a) : String.format("DoubleVector %s = x.fma(%s, %s);\n", MultipoleUtilities.term(a + 1, 0, 0, l - a - 1), MultipoleUtilities.term(a, 0, 0, l - a), MultipoleUtilities.term(0, 0, 0, l - a));
                sb.append(CoulombTensorGlobal.emit(order, a + 1, 0, 0, l - a - 1, s));
            }
            s = l > 2 ? String.format("x.fma(%s, %s.mul(%d)).intoArray(t, T%s);\n", MultipoleUtilities.term(l - 1, 0, 0, 1), MultipoleUtilities.term(l - 2, 0, 0, 1), l - 1, MultipoleUtilities.lmn(l, 0, 0)) : String.format("x.fma(%s, %s).intoArray(t, T%s);\n", MultipoleUtilities.term(l - 1, 0, 0, 1), MultipoleUtilities.term(0, 0, 0, 1), MultipoleUtilities.lmn(l, 0, 0));
            sb.append(CoulombTensorGlobal.store(order, l, 0, 0, s));
        }
        for (l = 0; l < order; ++l) {
            s = String.format("y.mul(%s).intoArray(t, T%s);\n", MultipoleUtilities.term(l, 0, 0, 1), MultipoleUtilities.lmn(l, 1, 0));
            sb.append(CoulombTensorGlobal.store(order, l, 1, 0, s));
            m = 2;
            while (m + l < this.o1) {
                s = String.format("DoubleVector %s = y.mul(%s);\n", MultipoleUtilities.term(l, 1, 0, m - 1), MultipoleUtilities.term(l, 0, 0, m));
                sb.append(CoulombTensorGlobal.emit(order, l, 1, 0, m - 1, s));
                for (int a = 1; a < m - 1; ++a) {
                    s = a > 1 ? String.format("DoubleVector %s = y.fma(%s, %s.mul(%d));\n", MultipoleUtilities.term(l, a + 1, 0, m - a - 1), MultipoleUtilities.term(l, a, 0, m - a), MultipoleUtilities.term(l, a - 1, 0, m - a), a) : String.format("DoubleVector %s = y.fma(%s, %s);\n", MultipoleUtilities.term(l, a + 1, 0, m - a - 1), MultipoleUtilities.term(l, a, 0, m - a), MultipoleUtilities.term(l, 0, 0, m - a));
                    sb.append(CoulombTensorGlobal.emit(order, l, a + 1, 0, m - a - 1, s));
                }
                s = m > 2 ? String.format("y.fma(%s, %s.mul(%d)).intoArray(t, T%s);\n", MultipoleUtilities.term(l, m - 1, 0, 1), MultipoleUtilities.term(l, m - 2, 0, 1), m - 1, MultipoleUtilities.lmn(l, m, 0)) : String.format("y.fma(%s, %s).intoArray(t, T%s);\n", MultipoleUtilities.term(l, m - 1, 0, 1), MultipoleUtilities.term(l, m - 2, 0, 1), MultipoleUtilities.lmn(l, m, 0));
                sb.append(CoulombTensorGlobal.store(order, l, m, 0, s));
                ++m;
            }
        }
        for (l = 0; l < order; ++l) {
            m = 0;
            while (m + l < order) {
                s = String.format("z.mul(%s).intoArray(t, T%s);\n", MultipoleUtilities.term(l, m, 0, 1), MultipoleUtilities.lmn(l, m, 1));
                sb.append(CoulombTensorGlobal.store(order, l, m, 1, s));
                int n = 2;
                while (m + l + n < this.o1) {
                    s = String.format("DoubleVector %s = z.mul(%s);\n", MultipoleUtilities.term(l, m, 1, n - 1), MultipoleUtilities.term(l, m, 0, n));
                    sb.append(CoulombTensorGlobal.emit(order, l, m, 1, n - 1, s));
                    int n1 = n - 1;
                    for (int a = 1; a < n1; ++a) {
                        s = a > 1 ? String.format("DoubleVector %s = z.fma(%s, %s.mul(%d));\n", MultipoleUtilities.term(l, m, a + 1, n - a - 1), MultipoleUtilities.term(l, m, a, n - a), MultipoleUtilities.term(l, m, a - 1, n - a), a) : String.format("DoubleVector %s = z.fma(%s, %s);\n", MultipoleUtilities.term(l, m, a + 1, n - a - 1), MultipoleUtilities.term(l, m, a, n - a), MultipoleUtilities.term(l, m, 0, n - a));
                        sb.append(CoulombTensorGlobal.emit(order, l, m, a + 1, n - a - 1, s));
                    }
                    s = n > 2 ? String.format("z.fma(%s, %s.mul(%d)).intoArray(t, T%s);\n", MultipoleUtilities.term(l, m, n - 1, 1), MultipoleUtilities.term(l, m, n - 2, 1), n - 1, MultipoleUtilities.lmn(l, m, n)) : String.format("z.fma(%s, %s).intoArray(t, T%s);\n", MultipoleUtilities.term(l, m, n - 1, 1), MultipoleUtilities.term(l, m, n - 2, 1), MultipoleUtilities.lmn(l, m, n));
                    sb.append(CoulombTensorGlobal.store(order, l, m, n, s));
                    ++n;
                }
                ++m;
            }
        }
        return sb.toString();
    }
}

