/*
 * Decompiled with CFR 0.152.
 */
package ffx.numerics.multipole;

import ffx.numerics.multipole.CoulombTensorGlobal;

public class CombinedTensorGlobal
extends CoulombTensorGlobal {
    private double[] termsToAdd;
    private double multiplier = 1.0;
    private double[] termsToAddSep;

    public CombinedTensorGlobal(int order) {
        super(order);
        this.termsToAdd = new double[order + 1];
        this.termsToAddSep = new double[order + 1];
    }

    public void addTerms(double[] terms) {
        assert (terms.length <= this.termsToAdd.length);
        for (int i = 0; i < terms.length; ++i) {
            int n = i;
            this.termsToAdd[n] = this.termsToAdd[n] + terms[i];
        }
    }

    public void resetSource() {
        this.termsToAdd = new double[this.termsToAdd.length];
        this.termsToAddSep = new double[this.termsToAdd.length];
    }

    @Override
    protected void source(double[] T000) {
        super.source(T000);
        for (int i = 0; i < this.termsToAdd.length; ++i) {
            int n = i;
            T000[n] = T000[n] * (1.0 * this.multiplier + this.termsToAdd[i]);
            int n2 = i;
            T000[n2] = T000[n2] + this.termsToAddSep[i];
        }
    }

    public void addCoulombMultiplier(double multiplier) {
        this.multiplier = multiplier;
    }

    public void addTermsSeparate(double[] terms) {
        assert (terms.length <= this.termsToAddSep.length);
        for (int i = 0; i < terms.length; ++i) {
            int n = i;
            this.termsToAddSep[n] = this.termsToAddSep[n] + terms[i];
        }
    }
}

