/*
 * Decompiled with CFR 0.152.
 */
package ffx.numerics.multipole;

import ffx.numerics.multipole.CoulombTensorGlobal;
import ffx.numerics.multipole.Operator;
import org.apache.commons.math3.util.FastMath;

public class AmoebaPlusOverlapTensorGlobal
extends CoulombTensorGlobal {
    private double aI;
    private double aK;
    private double A;
    private double B;

    public AmoebaPlusOverlapTensorGlobal(int order, double alphaI, double alphaK) {
        super(order);
        this.operator = Operator.AMOEBA_PLUS_OVERLAP_FIELD;
        this.aI = alphaI;
        this.aK = alphaK;
        this.A = this.aK * this.aK / (this.aK * this.aK - this.aI * this.aI);
        this.B = this.aI * this.aI / (this.aI * this.aI - this.aK * this.aK);
        assert (order <= 6);
    }

    @Override
    protected void source(double[] T000) {
        super.source(T000);
        AmoebaPlusOverlapTensorGlobal.overlapSource(this.aI, this.aK, this.A, this.B, this.R, T000);
    }

    protected static void overlapSource(double aI, double aK, double A, double B, double R, double[] T000) {
        if (Math.abs(aI - aK) < 1.0E-7) {
            double alpha = aI;
            double alphaR = alpha * R;
            double alphaR2 = alphaR * alphaR;
            double alphaR4 = alphaR2 * alphaR2;
            double expAR = FastMath.exp((double)(-alphaR));
            T000[0] = T000[0] * (1.0 - (1.0 + alphaR / 2.0) * expAR);
            T000[1] = T000[1] * (1.0 - (1.0 + alphaR + alphaR2 / 2.0) * expAR);
            T000[2] = T000[2] * (1.0 - (1.0 + alphaR + alphaR2 / 2.0 + alphaR2 * alphaR / 6.0) * expAR);
            T000[3] = T000[3] * (1.0 - (1.0 + alphaR + alphaR2 / 2.0 + alphaR2 * alphaR / 6.0 + alphaR2 * alphaR2 / 30.0) * expAR);
            T000[4] = T000[4] * (1.0 - (1.0 + alphaR + alphaR2 / 2.0 + alphaR2 * alphaR / 6.0 + 4.0 * alphaR4 / 105.0 + alphaR4 * alphaR / 210.0) * expAR);
            T000[5] = T000[5] * (1.0 - (1.0 + alphaR + alphaR2 * 0.5 + alphaR2 * alphaR / 6.0 + 5.0 * alphaR4 / 126.0 + 2.0 * alphaR4 * alphaR / 315.0 + alphaR4 * alphaR2 / 1890.0) * expAR);
        } else {
            assert (A != Double.POSITIVE_INFINITY && B != Double.POSITIVE_INFINITY);
            double aIR = aI * R;
            double aIR2 = aIR * aIR;
            double aKR = aK * R;
            double aKR2 = aKR * aKR;
            double expAI = A * FastMath.exp((double)(-aIR));
            double expAK = B * FastMath.exp((double)(-aKR));
            T000[0] = T000[0] * (1.0 - expAI - expAK);
            T000[1] = T000[1] * (1.0 - (1.0 + aIR) * expAI - (1.0 + aKR) * expAK);
            T000[2] = T000[2] * (1.0 - (1.0 + aIR + aIR2 / 3.0) * expAI - (1.0 + aKR + aKR2 / 3.0) * expAK);
            T000[3] = T000[3] * (1.0 - (1.0 + aIR + 2.0 * aIR2 / 5.0 + aIR * aIR2 / 15.0) * expAI - (1.0 + aKR + 2.0 * aKR2 / 5.0 + aKR * aKR2 / 15.0) * expAK);
            T000[4] = T000[4] * (1.0 - (1.0 + aIR + 3.0 * aIR2 / 7.0 + 2.0 * aIR * aIR2 / 21.0 + aIR2 * aIR2 / 105.0) * expAI - (1.0 + aKR + 3.0 * aKR2 / 7.0 + 2.0 * aKR * aKR2 / 21.0 + aKR2 * aKR2 / 105.0) * expAK);
            T000[5] = T000[5] * (1.0 - (1.0 + aIR + 4.0 * aIR2 / 9.0 + aIR2 * aI / 9.0 + aIR2 * aIR2 / 63.0 + aIR2 * aIR2 * aIR / 945.0) * expAI - (1.0 + aKR + 4.0 * aKR2 / 9.0 + aKR2 * aKR / 9.0 + aKR2 * aKR2 / 63.0 + aKR2 * aKR2 * aKR / 945.0) * expAK);
        }
    }
}

