/*
 * Decompiled with CFR 0.152.
 */
package ffx.numerics.multipole;

import ffx.numerics.multipole.CoulombTensorGlobal;
import ffx.numerics.multipole.EwaldTensorGlobal;
import ffx.numerics.multipole.Operator;
import ffx.numerics.multipole.PolarizableMultipole;
import java.util.Arrays;
import org.apache.commons.math3.util.FastMath;

public class AmoebaPlusDampTensorGlobal
extends CoulombTensorGlobal {
    private double beta = 0.0;
    private double alpha;
    private double alpha2;
    private static final double oneThird = 0.3333333333333333;
    private double[] ewaldSource;

    public AmoebaPlusDampTensorGlobal(int order, double alpha1, double alpha2) {
        super(order);
        this.alpha = alpha1;
        this.alpha2 = alpha2;
        Operator operator = this.operator = Math.abs(this.alpha - alpha2) < 1.0E-5 ? Operator.AMOEBA_PLUS_SYM_DAMP_FIELD : Operator.AMOEBA_PLUS_DAMP_FIELD;
        assert (order <= 3);
    }

    public AmoebaPlusDampTensorGlobal(int order, double alpha1, double alpha2, double ewaldA) {
        this(order, alpha1, alpha2);
        this.beta = ewaldA;
    }

    @Override
    protected void source(double[] T000) {
        super.source(T000);
        double[] copy = Arrays.copyOf(T000, this.o1);
        AmoebaPlusDampTensorGlobal.dampSource(this.alpha, this.R, T000);
        if (this.beta > 0.001) {
            this.ewaldSource = new double[this.order + 1];
            EwaldTensorGlobal.fillEwaldSource(this.order, this.beta, EwaldTensorGlobal.initEwaldSource(this.order, this.beta, new double[this.o1]), this.R, this.ewaldSource);
            for (int i = 0; i < this.ewaldSource.length; ++i) {
                int n = i;
                T000[n] = T000[n] + (this.ewaldSource[i] - copy[i]);
            }
        }
    }

    protected static void dampSource(double alpha, double R, double[] T000) {
        double alphaR = alpha * R;
        double alphaR2 = alphaR * alphaR;
        double expAR = FastMath.exp((double)(-alphaR));
        T000[0] = T000[0] * (1.0 - expAR);
        T000[1] = T000[1] * (1.0 - (1.0 + alphaR) * expAR);
        T000[2] = T000[2] * (1.0 - (1.0 + alphaR + 0.3333333333333333 * alphaR2) * expAR);
        T000[3] = T000[3] * (1.0 - (1.0 + alphaR + 0.4 * alphaR2 + alphaR2 * alphaR / 15.0) * expAR);
    }

    public double coreInteraction(PolarizableMultipole mI, PolarizableMultipole mK) {
        double energy = this.beta >= 0.001 ? mK.Z * mI.Z * this.ewaldSource[0] : mK.Z * mI.Z / this.R;
        this.multipoleIPotentialAtK(mI, 0);
        energy += mK.Z * this.E000;
        if (this.operator != Operator.AMOEBA_PLUS_SYM_DAMP_FIELD) {
            double temp = this.alpha;
            this.alpha = this.alpha2;
            this.alpha2 = temp;
            this.generateTensor();
            temp = this.alpha;
            this.alpha = this.alpha2;
            this.alpha2 = temp;
        }
        this.multipoleKPotentialAtI(mK, 0);
        return energy += mI.Z * this.E000;
    }

    public double coreInteractionAndGradient(PolarizableMultipole mI, PolarizableMultipole mK, double[] Gi, double[] Gk) {
        double energy = this.beta >= 0.001 ? mK.Z * mI.Z * this.ewaldSource[0] : mK.Z * mI.Z / this.R;
        double tensorElement = this.beta >= 0.001 ? this.ewaldSource[1] : -FastMath.pow((double)this.R, (int)-3);
        Gk[0] = mK.Z * mI.Z * this.x * tensorElement;
        Gk[1] = mK.Z * mI.Z * this.y * tensorElement;
        Gk[2] = mK.Z * mI.Z * this.z * tensorElement;
        this.multipoleIPotentialAtK(mI, 1);
        energy += mK.Z * this.E000;
        Gk[0] = Gk[0] + mK.Z * this.E100;
        Gk[1] = Gk[1] + mK.Z * this.E010;
        Gk[2] = Gk[2] + mK.Z * this.E001;
        if (this.operator != Operator.AMOEBA_PLUS_SYM_DAMP_FIELD) {
            double temp = this.alpha;
            this.alpha = this.alpha2;
            this.alpha2 = temp;
            this.generateTensor();
            temp = this.alpha;
            this.alpha = this.alpha2;
            this.alpha2 = temp;
        }
        this.multipoleKPotentialAtI(mK, 1);
        energy += mI.Z * this.E000;
        Gk[0] = Gk[0] - mI.Z * this.E100;
        Gk[1] = Gk[1] - mI.Z * this.E010;
        Gk[2] = Gk[2] - mI.Z * this.E001;
        Gi[0] = -Gk[0];
        Gi[1] = -Gk[1];
        Gi[2] = -Gk[2];
        return energy;
    }
}

