/*
 * Decompiled with CFR 0.152.
 */
package ffx.numerics.math;

import ffx.numerics.math.RunningStatistics;
import java.util.Arrays;
import javax.annotation.Nullable;
import org.apache.commons.math3.distribution.TDistribution;
import org.apache.commons.math3.util.FastMath;

public class SummaryStatistics {
    public final double mean;
    public final double var;
    public final double varPopulation;
    public final double sd;
    public final double sdPopulation;
    public final double sumWeights;
    public final double min;
    public final double max;
    public final long count;
    public final double sum;
    public final long dof;
    private final TDistribution tDist;
    private final String descString;

    public SummaryStatistics(RunningStatistics rs) {
        this.mean = rs.getMean();
        this.var = rs.getVariance();
        this.varPopulation = rs.getPopulationVariance();
        this.sumWeights = rs.getWeight();
        this.min = rs.getMin();
        this.max = rs.getMax();
        this.count = rs.getCount();
        this.sum = rs.getSum();
        this.dof = rs.getDOF();
        this.tDist = this.dof > 0L ? new TDistribution((double)this.dof) : null;
        this.sd = rs.getStandardDeviation();
        this.sdPopulation = rs.getPopulationStandardDeviation();
        this.descString = String.format(" Summary of %d observations: sum is %17.14g, mean is %17.14g, min is %17.14g, max is %17.14g, and the sum of weights is %17.14g\nSample standard deviation: %17.14g (dof = %d)\nPopulation standard deviation: %17.14g (dof = %d)", this.count, this.sum, this.mean, this.min, this.max, this.sumWeights, this.sd, this.dof, this.sdPopulation, this.count);
    }

    public SummaryStatistics(double[] values) {
        this(values, null, 0, values.length, 1);
    }

    public SummaryStatistics(double[] values, int first) {
        this(values, null, first, values.length, 1);
    }

    public SummaryStatistics(double[] values, int first, int last) {
        this(values, null, first, last, 1);
    }

    public SummaryStatistics(double[] values, int first, int last, int stride) {
        this(values, null, first, last, stride);
    }

    public SummaryStatistics(@Nullable double[] values, @Nullable double[] weights, int first, int last, int stride) {
        int tempCount;
        if (values == null) {
            throw new IllegalArgumentException(" Cannot have null values!");
        }
        int nVals = values.length;
        if (first < 0 || first > nVals - 1) {
            throw new IllegalArgumentException(String.format(" First entry %d was not in valid range 0-%d (0 to length of values - 1)", first, nVals - 1));
        }
        if (last <= first || last > nVals) {
            throw new IllegalArgumentException(String.format(" Last entry %d was not in valid range %d-%d (first+1 to length of values", last, first + 1, nVals));
        }
        if (weights == null) {
            weights = new double[nVals];
            Arrays.fill(weights, 1.0);
        }
        this.count = (tempCount = last - first) % stride == 0 ? (long)(tempCount / stride) : (long)(tempCount / stride + 1);
        assert (this.count > 0L);
        if (this.count == 1L) {
            this.mean = values[first];
            this.var = Double.NaN;
            this.varPopulation = 0.0;
            this.sd = Double.NaN;
            this.sdPopulation = 0.0;
            this.min = this.mean;
            this.max = this.mean;
            this.sum = this.mean;
            this.sumWeights = weights[first];
            this.dof = 0L;
            this.tDist = null;
            this.descString = String.format(" Summary of single observation: value is %17.14g", this.mean);
        } else {
            double meanAcc = 0.0;
            double varAcc = 0.0;
            double minAcc = Double.MAX_VALUE;
            double maxAcc = Double.MIN_VALUE;
            double sumAcc = 0.0;
            double comp = 0.0;
            double weightAcc = 0.0;
            int i = 0;
            while ((long)i < this.count) {
                int ii = first + i * stride;
                assert (ii < last);
                double val = values[ii];
                double priorMean = meanAcc;
                double weight = weights[ii];
                weightAcc += weight;
                double y = val - comp;
                double t = sumAcc + y;
                comp = t - sumAcc - y;
                sumAcc = t;
                minAcc = FastMath.min((double)minAcc, (double)val);
                maxAcc = FastMath.max((double)maxAcc, (double)val);
                double invCount = weight / weightAcc;
                meanAcc += (val - meanAcc) * invCount;
                varAcc += (val - priorMean) * (val - meanAcc) * weight;
                ++i;
            }
            this.min = minAcc;
            this.max = maxAcc;
            this.mean = meanAcc;
            this.sum = sumAcc;
            this.sumWeights = weightAcc;
            assert (FastMath.abs((double)(this.mean - this.sum / (double)this.count)) < 1.0E-11);
            this.varPopulation = varAcc / (double)this.count;
            this.sdPopulation = FastMath.sqrt((double)this.varPopulation);
            this.dof = this.count - 1L;
            this.var = varAcc / (double)this.dof;
            this.sd = FastMath.sqrt((double)this.var);
            this.tDist = new TDistribution((double)this.dof);
            this.descString = String.format(" Summary of %d observations: sum is %17.14g, mean is %17.14g, min is %17.14g, max is %17.14g, and the sum of weights is %17.14g\nSample standard deviation: %17.14g (dof = %d)\nPopulation standard deviation: %17.14g (dof = %d)", this.count, this.sum, this.mean, this.min, this.max, this.sumWeights, this.sd, this.dof, this.sdPopulation, this.count);
        }
    }

    public double confidenceInterval() {
        return this.confidenceInterval(0.05);
    }

    public double confidenceInterval(double alpha) {
        if (this.dof == 0L) {
            throw new IllegalArgumentException(" Cannot calculate confidence intervals when there are no degrees of freedom!");
        }
        double critVal = this.tDist.inverseCumulativeProbability(0.5 * (1.0 - alpha));
        return critVal * this.sd / FastMath.sqrt((double)this.count);
    }

    public double getMean() {
        return this.mean;
    }

    public double getSd() {
        return this.sd;
    }

    public double getVar() {
        return this.var;
    }

    public String toString() {
        return this.descString;
    }

    public String describe() {
        return String.format(" Mean: %12.6f +/-%12.6f, Min/Max: %12.6f/%12.6f", this.mean, this.sd, this.min, this.max);
    }
}

