/*
 * Decompiled with CFR 0.152.
 */
package ffx.numerics.math;

import org.apache.commons.math3.util.FastMath;

public class ScalarMath {
    private static final double eightPi2 = 78.95683520871486;

    private ScalarMath() {
    }

    public static double b2u(double b) {
        return b / 78.95683520871486;
    }

    public static long binomial(long n, long k) {
        return ScalarMath.factorial(n) / (ScalarMath.factorial(n - k) * ScalarMath.factorial(k));
    }

    public static long doubleFactorial(long n) {
        if (n < -1L) {
            throw new RuntimeException("Underflow error in doubleFactorial");
        }
        if (n == -1L || n == 0L || n == 1L) {
            return 1L;
        }
        return n * ScalarMath.doubleFactorial(n - 2L);
    }

    public static long factorial(long n) {
        if (n < 0L) {
            throw new RuntimeException("Underflow error in factorial");
        }
        if (n > 20L) {
            throw new RuntimeException("Overflow error in factorial");
        }
        if (n == 0L) {
            return 1L;
        }
        return n * ScalarMath.factorial(n - 1L);
    }

    public static double fermiFunction(double x) {
        return 1.0 / (1.0 + FastMath.exp((double)x));
    }

    public static double mod(double a, double b) {
        double res = a % b;
        if (res < 0.0) {
            res += b;
        }
        return res;
    }

    public static int mod(int a, int b) {
        int res = a % b;
        if (res < 0) {
            res += b;
        }
        return res;
    }

    public static double modToRange(double value, double lb, double ub) {
        value -= lb;
        double range = ub - lb;
        value = ScalarMath.mod(value, range);
        return value += lb;
    }

    public static double u2b(double u) {
        return u * 78.95683520871486;
    }

    public static double quadForm(double[] v, double[][] mat) {
        return v[0] * (v[0] * mat[0][0] + 2.0 * (v[1] * mat[0][1] + v[2] * mat[0][2])) + v[1] * (v[1] * mat[1][1] + 2.0 * (v[2] * mat[1][2])) + v[2] * v[2] * mat[2][2];
    }

    public static double mirrorRadians(double angle) {
        double angleDegrees = angle * 180.0 / Math.PI;
        return ScalarMath.mirrorDegrees(angleDegrees) * Math.PI / 180.0;
    }

    public static double mirrorDegrees(double angle) {
        if (angle > 180.0) {
            angle = 180.0 - (angle - 180.0);
        } else if (angle < 0.0) {
            angle = 0.0 - angle;
        }
        return angle;
    }
}

