/*
 * Decompiled with CFR 0.152.
 */
package ffx.numerics.math;

import java.util.Random;
import org.apache.commons.math3.util.FastMath;

public class SSETest {
    public final double[][] A;
    public final double[] x;
    private final double[] flatA;

    private SSETest(int m, int n) {
        this.A = new double[m][n];
        this.flatA = new double[m * n];
        this.x = new double[n];
    }

    public static void main(String[] args) {
        int j;
        double[] y;
        int i;
        int m = 500;
        int n = 500;
        if (args != null && args.length > 0) {
            m = Integer.parseInt(args[0]);
            n = Integer.parseInt(args[1]);
        }
        SSETest test = new SSETest(m, n);
        int nLoops = 100000;
        test.init(m, n);
        Random r = new Random(0L);
        double temp = 0.0;
        long time = 0L;
        for (i = 1; i <= nLoops; ++i) {
            time -= System.nanoTime();
            y = test.matVec(test.A, test.x, m, n);
            time += System.nanoTime();
            j = (int)FastMath.floor((double)((double)m * r.nextDouble()));
            temp += y[j];
            if (i % 10000 != 0) continue;
            System.out.println(" Nested: " + temp + " " + (double)time * 1.0E-9);
            time = 0L;
        }
        test.init(m, n);
        r = new Random(0L);
        temp = 0.0;
        time = 0L;
        for (i = 1; i <= nLoops; ++i) {
            time -= System.nanoTime();
            y = test.matVec(test.flatA, test.x, m, n);
            time += System.nanoTime();
            j = (int)FastMath.floor((double)((double)m * r.nextDouble()));
            temp += y[j];
            if (i % 10000 != 0) continue;
            System.out.println(" Flat: " + temp + " " + (double)time * 1.0E-9);
            time = 0L;
        }
    }

    private void init(int n, int m) {
        Random r = new Random(0L);
        for (int i = 0; i < m; ++i) {
            int idx = i * n;
            for (int j = 0; j < n; ++j) {
                this.A[i][j] = r.nextDouble();
                this.flatA[idx + j] = this.A[i][j];
            }
        }
        for (int j = 0; j < n; ++j) {
            this.x[j] = r.nextDouble();
        }
    }

    private double[] matVec(double[][] A, double[] x, int m, int n) {
        double[] y = new double[m];
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                int n2 = i;
                y[n2] = y[n2] + A[i][j] * x[j];
            }
        }
        return y;
    }

    private double[] matVec(double[] A, double[] x, int m, int n) {
        double[] y = new double[m];
        int extra = n - n % 8;
        int ub = n / 8 * 8 - 1;
        int idx = 0;
        for (int i = 0; i < m; ++i) {
            int j;
            double acc = 0.0;
            for (j = 0; j < ub; j += 8) {
                int ptr = idx + j;
                int n2 = i;
                y[n2] = y[n2] + (A[ptr] * x[j] + A[ptr + 1] * x[j + 1] + A[ptr + 2] * x[j + 2] + A[ptr + 3] * x[j + 3]);
                acc += A[ptr + 4] * x[j + 4] + A[ptr + 5] * x[j + 5] + A[ptr + 6] * x[j + 6] + A[ptr + 7] * x[j + 7];
            }
            int n3 = i;
            y[n3] = y[n3] + acc;
            for (j = extra; j < n; ++j) {
                int n4 = i;
                y[n4] = y[n4] + A[idx + j] * x[j];
            }
            idx += n;
        }
        return y;
    }
}

