/*
 * Decompiled with CFR 0.152.
 */
package ffx.numerics.math;

import ffx.numerics.math.SummaryStatistics;
import org.apache.commons.math3.util.FastMath;

public class RunningStatistics {
    private double mean = 0.0;
    private double var = 0.0;
    private double weight = 0.0;
    private double min = Double.MAX_VALUE;
    private double max = Double.MIN_VALUE;
    private long count = 0L;
    private double sum = 0.0;
    private long dof = -1L;
    private double comp = 0.0;

    public void addValue(double val) {
        this.addValue(val, 1.0);
    }

    public void addValue(double val, double weight) {
        assert (Double.isFinite(val));
        assert (Double.isFinite(weight));
        assert (weight > 0.0);
        ++this.count;
        ++this.dof;
        double priorMean = this.mean;
        this.weight += weight;
        double y = val - this.comp;
        double t = this.sum + y;
        this.comp = t - this.sum - y;
        this.sum = t;
        this.min = FastMath.min((double)this.min, (double)val);
        this.max = FastMath.max((double)this.max, (double)val);
        double invCount = 1.0 / this.weight;
        this.mean += (val - this.mean) * invCount;
        this.var += (val - priorMean) * (val - this.mean) * weight;
        if (Double.isNaN(this.var)) {
            throw new IllegalArgumentException(String.format(" Val %.5f w/ wt %.3f resulted in NaN varAcc; current state %s", val, weight, new SummaryStatistics(this)));
        }
    }

    public void reset() {
        this.mean = 0.0;
        this.var = 0.0;
        this.weight = 0.0;
        this.min = Double.MAX_VALUE;
        this.max = Double.MIN_VALUE;
        this.count = 0L;
        this.sum = 0.0;
        this.dof = -1L;
        this.comp = 0.0;
    }

    public long getCount() {
        return this.count;
    }

    public long getDOF() {
        return this.dof;
    }

    public double getMax() {
        return this.max;
    }

    public double getMean() {
        return this.mean;
    }

    public double getMin() {
        return this.min;
    }

    public double getPopulationStandardDeviation() {
        return FastMath.sqrt((double)this.getPopulationVariance());
    }

    public double getPopulationVariance() {
        return this.var / (double)this.count;
    }

    public double getStandardDeviation() {
        return FastMath.sqrt((double)this.getVariance());
    }

    public double getSum() {
        return this.sum;
    }

    public double getVariance() {
        return this.var / (double)this.dof;
    }

    public double getWeight() {
        return this.weight;
    }

    public String describe() {
        return String.format(" Mean: %12.6f +/-%12.6f, Min/Max: %12.6f/%12.6f", this.mean, this.getStandardDeviation(), this.min, this.max);
    }
}

