/*
 * Decompiled with CFR 0.152.
 */
package ffx.numerics.math;

import java.math.BigInteger;
import java.util.Arrays;
import org.apache.commons.math3.util.FastMath;

public class HilbertCurveTransforms {
    private HilbertCurveTransforms() {
    }

    private static int adjust_rotation(int rotation, int nDims, int bits) {
        long nd1Ones = HilbertCurveTransforms.ones(nDims) >> 1;
        bits &= (int)((long)(-bits) & nd1Ones);
        while (bits != 0) {
            bits >>= 1;
            ++rotation;
        }
        if (rotation >= nDims) {
            rotation -= nDims;
        }
        return rotation;
    }

    private static long ones(int k) {
        return (2L << k - 1) - 1L;
    }

    private static long rotateLeft(long arg, int nRots, int nDims) {
        return (arg << nRots | arg >> nDims - nRots) & HilbertCurveTransforms.ones(nDims);
    }

    private static long rotateRight(long arg, int nRots, int nDims) {
        return (arg >> nRots | arg << nDims - nRots) & HilbertCurveTransforms.ones(nDims);
    }

    private static long bitTranspose(int nDims, int nBits, long inCoords) {
        int utB;
        int nDims1 = nDims - 1;
        int inB = nBits;
        long inFieldEnds = 1L;
        long inMask = HilbertCurveTransforms.ones(inB);
        long coords = 0L;
        while ((utB = inB / 2) != 0) {
            int shiftAmt = nDims1 * utB;
            long utFieldEnds = inFieldEnds | inFieldEnds << shiftAmt + utB;
            long utMask = (utFieldEnds << utB) - utFieldEnds;
            long utCoords = 0L;
            if (inB % 2 == 1) {
                long inFieldStarts = inFieldEnds << inB - 1;
                int oddShift = 2 * shiftAmt;
                for (d = 0; d < nDims; ++d) {
                    long in = inCoords & inMask;
                    inCoords >>= inB;
                    coords |= (in & inFieldStarts) << oddShift++;
                    in &= inFieldStarts ^ 0xFFFFFFFFFFFFFFFFL;
                    in = (in | in << shiftAmt) & utMask;
                    utCoords |= in << d * utB;
                }
            } else {
                for (d = 0; d < nDims; ++d) {
                    long in = inCoords & inMask;
                    inCoords >>= inB;
                    in = (in | in << shiftAmt) & utMask;
                    utCoords |= in << d * utB;
                }
            }
            inCoords = utCoords;
            inB = utB;
            inFieldEnds = utFieldEnds;
            inMask = utMask;
        }
        return coords |= inCoords;
    }

    public static long[] hilbertIndexToCoordinates(int nBonds, int nBitsPerDim, long index) {
        long[] coord = new long[nBonds];
        if (nBonds > 1) {
            long coords;
            int nbOnes = (int)HilbertCurveTransforms.ones(nBitsPerDim);
            if (nBitsPerDim > 1) {
                int nDimsBits = nBonds * nBitsPerDim;
                int ndOnes = (int)HilbertCurveTransforms.ones(nBonds);
                int nd1Ones = ndOnes >> 1;
                int b = nDimsBits;
                int rotation = 0;
                int flipBit = 0;
                long nthbits = HilbertCurveTransforms.ones(nDimsBits) / (long)ndOnes;
                index ^= (index ^ nthbits) >> 1;
                coords = 0L;
                do {
                    int bits = (int)(index >> (b -= nBonds) & (long)ndOnes);
                    coords <<= nBonds;
                    coords |= HilbertCurveTransforms.rotateLeft(bits, rotation, nBonds) ^ (long)flipBit;
                    flipBit = 1 << rotation;
                    rotation = HilbertCurveTransforms.adjust_rotation(rotation, nBonds, bits);
                } while (b > 0);
                for (b = nBonds; b < nDimsBits; b *= 2) {
                    coords ^= coords >> b;
                }
                coords = HilbertCurveTransforms.bitTranspose(nBitsPerDim, nBonds, coords);
            } else {
                coords = index ^ index >> 1;
            }
            for (int d = 0; d < nBonds; ++d) {
                coord[d] = coords & (long)nbOnes;
                coords >>= nBitsPerDim;
            }
        } else {
            coord[0] = index;
        }
        return coord;
    }

    private static long coordinatesToHilbertIndex(int nDims, int nBits, long[] coord) {
        long index;
        if (nDims > 1) {
            int nDimsBits = nDims * nBits;
            long coords = 0L;
            int d = nDims;
            while (d-- > 0) {
                coords <<= nBits;
                coords |= coord[d];
            }
            if (nBits > 1) {
                long ndOnes = HilbertCurveTransforms.ones(nDims);
                long nd1Ones = ndOnes >> 1;
                int b = nDimsBits;
                int rotation = 0;
                long flipBit = 0L;
                long nthbits = HilbertCurveTransforms.ones(nDimsBits) / ndOnes;
                coords = HilbertCurveTransforms.bitTranspose(nDims, nBits, coords);
                coords ^= coords >> nDims;
                index = 0L;
                do {
                    long bits = coords >> (b -= nDims) & ndOnes;
                    bits = HilbertCurveTransforms.rotateRight(flipBit ^ bits, rotation, nDims);
                    index <<= nDims;
                    index |= bits;
                    flipBit = 1L << rotation;
                    rotation = HilbertCurveTransforms.adjust_rotation(rotation, nDims, (int)bits);
                } while (b > 0);
                index ^= nthbits >> 1;
            } else {
                index = coords;
            }
            for (d = 1; d < nDimsBits; d *= 2) {
                index ^= index >> d;
            }
        } else {
            index = coord[0];
        }
        return index;
    }

    public static void main(String[] args) {
        int nBonds = 2;
        int nTorsions = 4;
        int nBits = (int)Math.ceil(FastMath.log((double)2.0, (double)nTorsions));
        BigInteger maxIndex = BigInteger.valueOf(2L).pow(nBonds * nBits).subtract(BigInteger.ONE);
        BigInteger numConfigs = BigInteger.valueOf(nTorsions).pow(nBonds);
        System.out.println("Maximum index: " + String.valueOf(maxIndex));
        System.out.println("Number of configurations: " + String.valueOf(numConfigs));
        BigInteger index = BigInteger.ZERO;
        int counter = 0;
        while (index.longValue() <= maxIndex.longValue()) {
            long[] coordinates = HilbertCurveTransforms.hilbertIndexToCoordinates(nBonds, nBits, index.longValue());
            long convertedIndex = HilbertCurveTransforms.coordinatesToHilbertIndex(nBonds, nBits, coordinates);
            boolean valid = true;
            for (long coord : coordinates) {
                if (coord <= (long)(nTorsions - 1)) continue;
                valid = false;
                break;
            }
            System.out.println("Hilbert index: " + counter + "; Coordinates: " + Arrays.toString(coordinates));
            System.out.println("Converted index: " + convertedIndex);
            ++counter;
            index = index.add(BigInteger.ONE);
        }
        System.out.println("Number of valid configurations: " + counter);
    }
}

