/*
 * Decompiled with CFR 0.152.
 */
package ffx.numerics.math;

import java.util.logging.Logger;
import javax.annotation.Nullable;
import org.apache.commons.math3.util.FastMath;

public final class DoubleMath {
    private static final Logger logger = Logger.getLogger(DoubleMath.class.getName());

    private DoubleMath() {
    }

    public static double[] fma(double[] a, double b, double[] c) {
        return DoubleMath.fma(a, b, c, new double[3]);
    }

    public static double[] fma(double[] a, double b, double[] c, double[] ret) {
        ret[0] = Math.fma(a[0], b, c[0]);
        ret[1] = Math.fma(a[1], b, c[1]);
        ret[2] = Math.fma(a[2], b, c[2]);
        return ret;
    }

    public static double[] X(double[] a, double[] b) {
        return DoubleMath.X(a, b, new double[3]);
    }

    public static double[] X(double[] a, double[] b, double[] ret) {
        ret[0] = a[1] * b[2] - a[2] * b[1];
        ret[1] = a[2] * b[0] - a[0] * b[2];
        ret[2] = a[0] * b[1] - a[1] * b[0];
        return ret;
    }

    public static double[] add(double[] a, double[] b) {
        return DoubleMath.add(a, b, new double[3]);
    }

    public static double[] add(double[] a, double[] b, double[] ret) {
        ret[0] = a[0] + b[0];
        ret[1] = a[1] + b[1];
        ret[2] = a[2] + b[2];
        return ret;
    }

    public static double angle(double[] i, double[] j) {
        double x = DoubleMath.dot(DoubleMath.normalize(i), DoubleMath.normalize(j));
        if (FastMath.abs((double)x) > 1.0) {
            x = x > 0.0 ? 1.0 : -1.0;
        }
        return FastMath.acos((double)x);
    }

    public static double bondAngle(double[] i, double[] j, double[] k) {
        return DoubleMath.angle(DoubleMath.sub(i, j), DoubleMath.sub(k, j));
    }

    public static double dihedralAngle(double[] ab, double[] bc, double[] cd) {
        double ru;
        double[] t = DoubleMath.X(ab, bc);
        double[] u = DoubleMath.X(bc, cd);
        double rt = DoubleMath.dot(t, t);
        double rtu = FastMath.sqrt((double)(rt * (ru = DoubleMath.dot(u, u))));
        if (rtu != 0.0) {
            double rcb = DoubleMath.length(bc);
            double cosine = DoubleMath.dot(t, u) / rtu;
            double[] tu = DoubleMath.X(t, u);
            double sine = DoubleMath.dot(bc, tu) / (rcb * rtu);
            cosine = FastMath.min((double)1.0, (double)FastMath.max((double)-1.0, (double)cosine));
            double angle = FastMath.acos((double)cosine);
            if (sine < 0.0) {
                angle = -angle;
            }
            return angle;
        }
        return 0.0;
    }

    public static double dihedralAngle(double[] a, double[] b, double[] c, double[] d) {
        return DoubleMath.dihedralAngle(DoubleMath.sub(b, a), DoubleMath.sub(c, b), DoubleMath.sub(d, c));
    }

    public static double dist(double[] a, double[] b) {
        return FastMath.sqrt((double)DoubleMath.dist2(a, b));
    }

    public static double dist2(double[] a, double[] b) {
        double dx = a[0] - b[0];
        double dy = a[1] - b[1];
        double dz = a[2] - b[2];
        return Math.fma(dx, dx, Math.fma(dy, dy, dz * dz));
    }

    public static double dot(double[] a, double[] b) {
        return Math.fma(a[0], b[0], Math.fma(a[1], b[1], a[2] * b[2]));
    }

    public static double length(double[] d) {
        return FastMath.sqrt((double)DoubleMath.length2(d));
    }

    public static double length2(double[] d) {
        return Math.fma(d[0], d[0], Math.fma(d[1], d[1], d[2] * d[2]));
    }

    public static void log(double[] v) {
        logger.info(DoubleMath.toString(v));
    }

    public static void log(double[] v, String label) {
        logger.info(DoubleMath.toString(v, label));
    }

    public static double[] normalize(double[] n) {
        return DoubleMath.scale(n, 1.0 / DoubleMath.length(n), new double[3]);
    }

    public static double[] normalize(double[] n, double[] ret) {
        return DoubleMath.scale(n, 1.0 / DoubleMath.length(n), ret);
    }

    public static double[] scale(double[] n, double a) {
        return DoubleMath.scale(n, a, new double[3]);
    }

    public static double[] scale(double[] n, double a, double[] ret) {
        ret[0] = n[0] * a;
        ret[1] = n[1] * a;
        ret[2] = n[2] * a;
        return ret;
    }

    public static double[] square(double[] n) {
        return DoubleMath.square(n, new double[3]);
    }

    public static double[] square(double[] n, double[] ret) {
        ret[0] = n[0] * n[0];
        ret[1] = n[1] * n[1];
        ret[2] = n[2] * n[2];
        return ret;
    }

    public static double[] squareRoot(double[] n) {
        return DoubleMath.squareRoot(n, new double[3]);
    }

    public static double[] squareRoot(double[] n, double[] ret) {
        ret[0] = FastMath.sqrt((double)n[0]);
        ret[1] = FastMath.sqrt((double)n[1]);
        ret[2] = FastMath.sqrt((double)n[2]);
        return ret;
    }

    public static double[] sub(double[] a, double[] b) {
        return DoubleMath.sub(a, b, new double[3]);
    }

    public static double[] sub(double[] a, double[] b, double[] ret) {
        ret[0] = a[0] - b[0];
        ret[1] = a[1] - b[1];
        ret[2] = a[2] - b[2];
        return ret;
    }

    public static String toString(double[] v) {
        StringBuilder sb = new StringBuilder(" [ ");
        for (double d : v) {
            sb.append(String.format("%16.8f ", d));
        }
        sb.append("]");
        return sb.toString();
    }

    public static String toString(@Nullable double[] v, @Nullable String label) {
        if (v == null) {
            return null;
        }
        if (label == null) {
            label = "v";
        }
        StringBuilder sb = new StringBuilder(String.format(" %16s = [", label));
        for (double value : v) {
            sb.append(String.format(" %16.8f", value));
        }
        sb.append(" ]");
        return sb.toString();
    }
}

