/*
 * Decompiled with CFR 0.152.
 */
package ffx.numerics.math;

import ffx.numerics.math.DoubleMath;

public class Double3 {
    private final double[] a;

    public Double3() {
        this.a = new double[]{0.0, 0.0, 0.0};
    }

    public Double3(double x, double y, double z) {
        this.a = new double[]{x, y, z};
    }

    public Double3(double[] a) {
        this.a = new double[]{a[0], a[1], a[2]};
    }

    public Double3 fma(double b, Double3 c) {
        Double3 ret = new Double3();
        DoubleMath.fma(this.a, b, c.get(), ret.get());
        return ret;
    }

    public Double3 fmaI(double b, Double3 c) {
        DoubleMath.fma(this.a, b, c.get(), this.a);
        return this;
    }

    public Double3 X(Double3 b) {
        Double3 ret = new Double3();
        DoubleMath.X(this.a, b.get(), ret.get());
        return ret;
    }

    public Double3 XI(Double3 b) {
        return this.set(this.X(b));
    }

    public Double3 add(Double3 b) {
        Double3 ret = new Double3();
        DoubleMath.add(this.a, b.get(), ret.get());
        return ret;
    }

    public Double3 addI(Double3 b) {
        DoubleMath.add(this.a, b.get(), this.a);
        return this;
    }

    public double angle(Double3 b) {
        return DoubleMath.angle(this.a, b.get());
    }

    public Double3 copy() {
        return new Double3(this.a);
    }

    public double dist(Double3 b) {
        return DoubleMath.dist(this.a, b.get());
    }

    public double dist2(Double3 b) {
        return DoubleMath.dist2(this.a, b.get());
    }

    public double dot(Double3 b) {
        return DoubleMath.dot(this.a, b.get());
    }

    public double[] get() {
        return this.a;
    }

    public double get(int i) {
        return this.a[i];
    }

    public double length() {
        return DoubleMath.length(this.a);
    }

    public double length2() {
        return DoubleMath.length2(this.a);
    }

    public void log() {
        DoubleMath.log(this.a);
    }

    public Double3 normalize() {
        Double3 ret = new Double3();
        DoubleMath.normalize(this.a, ret.get());
        return ret;
    }

    public Double3 normalizeI() {
        DoubleMath.normalize(this.a, this.a);
        return this;
    }

    public Double3 scale(double d) {
        Double3 ret = new Double3();
        DoubleMath.scale(this.a, d, ret.get());
        return ret;
    }

    public Double3 scaleI(double d) {
        DoubleMath.scale(this.a, d, this.a);
        return this;
    }

    public Double3 square() {
        Double3 ret = new Double3();
        DoubleMath.square(this.a, ret.get());
        return ret;
    }

    public Double3 squareI() {
        DoubleMath.square(this.a, this.a);
        return this;
    }

    public Double3 sqrt() {
        Double3 ret = new Double3();
        DoubleMath.squareRoot(this.a, ret.get());
        return ret;
    }

    public Double3 sqrtI() {
        DoubleMath.squareRoot(this.a, this.a);
        return this;
    }

    public Double3 set(double x, double y, double z) {
        this.a[0] = x;
        this.a[1] = y;
        this.a[2] = z;
        return this;
    }

    public Double3 set(double[] b) {
        System.arraycopy(b, 0, this.a, 0, 3);
        return this;
    }

    public Double3 set(Double3 b) {
        System.arraycopy(b.get(), 0, this.a, 0, 3);
        return this;
    }

    public Double3 sub(Double3 b) {
        Double3 ret = new Double3();
        DoubleMath.sub(this.a, b.get(), ret.get());
        return ret;
    }

    public Double3 subI(Double3 b) {
        DoubleMath.sub(this.a, b.get(), this.a);
        return this;
    }

    public String toString() {
        return DoubleMath.toString(this.a);
    }

    public double x() {
        return this.a[0];
    }

    public double y() {
        return this.a[1];
    }

    public double z() {
        return this.a[2];
    }
}

