/*
 * Decompiled with CFR 0.152.
 */
package ffx.numerics.integrate;

import ffx.numerics.integrate.FunctionDataCurve;

public class PolynomialCurve
extends FunctionDataCurve {
    private final double[] coefficients;

    public PolynomialCurve(double[] x, double[] coefficients) {
        this(x, false, coefficients);
    }

    public PolynomialCurve(double[] x, boolean halfWidthEnds, double[] coefficients) {
        int nPoints = x.length;
        this.points = new double[nPoints];
        this.coefficients = new double[coefficients.length];
        System.arraycopy(coefficients, 0, this.coefficients, 0, coefficients.length);
        this.halfWidthEnd = halfWidthEnds;
        for (int i = 0; i < this.points.length; ++i) {
            this.points[i] = this.polynomialAt(x[i]);
        }
        this.lb = x[0];
        this.ub = x[nPoints - 1];
        this.x = new double[x.length];
        System.arraycopy(x, 0, this.x, 0, x.length);
    }

    @Override
    public double fX(double x) {
        return this.polynomialAt(x);
    }

    @Override
    public double integralAt(double x) {
        double total = 0.0;
        for (int i = 0; i < this.coefficients.length; ++i) {
            double val = 1.0 / ((double)i + 1.0);
            val *= this.coefficients[i];
            for (int j = 0; j <= i; ++j) {
                val *= x;
            }
            total += val;
        }
        return total;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("Polynomial curve of degree ");
        sb.append(this.coefficients.length).append(String.format(" with %d points from lower bound %9.3g and upper bound %9.3g", this.points.length, this.lb, this.ub));
        if (this.halfWidthEnd) {
            sb.append(" and half-width start/end bins");
        }
        sb.append(".\nCoefficients: ");
        if (this.coefficients.length > 0) {
            sb.append(this.coefficients[0]);
        }
        for (int i = 1; i < this.coefficients.length; ++i) {
            sb.append(",").append(this.coefficients[i]);
        }
        return sb.toString();
    }

    private double polynomialAt(double x) {
        double total = 0.0;
        for (int i = 0; i < this.coefficients.length; ++i) {
            double val = this.coefficients[i];
            for (int j = 0; j < i; ++j) {
                val *= x;
            }
            total += val;
        }
        return total;
    }
}

