/*
 * Decompiled with CFR 0.152.
 */
package ffx.numerics.integrate;

import java.text.DecimalFormat;
import org.apache.commons.math3.util.FastMath;

public class Integration {
    private static final double[] x = new double[202];

    private Integration() {
    }

    public static double averageIntegral(double leftInt, double rightInt) {
        return (leftInt + rightInt) / 2.0;
    }

    public static double[] generateTestData_v1() {
        double[] y = new double[202];
        for (int i = 0; i < 202; ++i) {
            y[i] = 10.0 * FastMath.sin((double)(6.0 * x[i])) - 7.0 * FastMath.cos((double)(5.0 * x[i])) + 11.0 * FastMath.sin((double)(8.0 * x[i]));
        }
        return y;
    }

    public static double halfBinComposite(double[] inputData, int mode, String side) {
        int n = inputData.length;
        double halfBinComposite = 0.0;
        if (side.equalsIgnoreCase("left")) {
            double lowerHalfBin = (inputData[1] + inputData[0]) / 2.0 * (x[1] - x[0]);
            halfBinComposite += lowerHalfBin;
            switch (mode) {
                case 1: {
                    double upperTrapArea = (inputData[n - 3] + inputData[n - 2]) / 2.0 * (x[n - 2] - x[n - 3]);
                    halfBinComposite += upperTrapArea;
                    break;
                }
                case 2: {
                    double upperSimpson = 0.3333333333333333 * (x[n - 4] - x[n - 5]) * (inputData[n - 5] + 4.0 * inputData[n - 4] + inputData[n - 3]);
                    halfBinComposite += upperSimpson;
                    double upperTrapArea = (inputData[n - 3] + inputData[n - 2]) / 2.0 * (x[n - 2] - x[n - 3]);
                    halfBinComposite += upperTrapArea;
                }
            }
        } else if (side.equalsIgnoreCase("right")) {
            double upperHalfBin = (inputData[n - 1] + inputData[n - 2]) / 2.0 * (x[n - 1] - x[n - 2]);
            halfBinComposite += upperHalfBin;
            switch (mode) {
                case 1: {
                    double lowerTrapArea = (inputData[1] + inputData[2]) / 2.0 * (x[2] - x[1]);
                    halfBinComposite += lowerTrapArea;
                    break;
                }
                case 2: {
                    double lowerTrapArea = (inputData[1] + inputData[2]) / 2.0 * (x[2] - x[1]);
                    halfBinComposite += lowerTrapArea;
                    double lowerSimpson = 0.3333333333333333 * (x[3] - x[2]) * (inputData[2] + 4.0 * inputData[3] + inputData[4]);
                    halfBinComposite += lowerSimpson;
                }
            }
        }
        return halfBinComposite;
    }

    public static double leftBoole(double[] inputData) {
        int n = inputData.length;
        double normalBoole = 0.0;
        for (int a = 1; a < n - 5; a += 4) {
            double area = 0.044444444444444446 * (x[a + 1] - x[a]) * (7.0 * inputData[a] + 32.0 * inputData[a + 1] + 12.0 * inputData[a + 2] + 32.0 * inputData[a + 3] + 7.0 * inputData[a + 4]);
            normalBoole += area;
        }
        return normalBoole;
    }

    public static double leftRectangularMethod(double[] inputData) {
        int n = inputData.length;
        double[] y = Integration.generateTestData_v1();
        double rectangularIntegral = 0.0;
        for (int a = 0; a < n - 2; ++a) {
            double area = (x[a + 1] - x[a]) * y[a];
            rectangularIntegral += area;
        }
        return rectangularIntegral;
    }

    public static double leftSimpsons(double[] inputData) {
        int n = inputData.length;
        double normalSimpsons = 0.0;
        for (int a = 1; a < n - 4; a += 2) {
            double area = 0.3333333333333333 * (x[a + 1] - x[a]) * (inputData[a] + 4.0 * inputData[a + 1] + inputData[a + 2]);
            normalSimpsons += area;
        }
        return normalSimpsons;
    }

    public static double leftTrapInput(double[] inputData) {
        int n = x.length;
        double sum = 0.0;
        double total = 0.0;
        double trapIntegral = 0.0;
        for (int a = 0; a < n - 2; ++a) {
            if (a > 0) {
                double area = (inputData[a + 1] + inputData[a]) / 2.0 * (x[a + 1] - x[a]);
                total = sum = area + total;
            }
            if (a == n - 3) {
                trapIntegral = sum;
            }
            if (a != 0) continue;
            total = (inputData[a + 1] + inputData[a]) / 2.0 * (x[a + 1] - x[a]);
        }
        return trapIntegral;
    }

    public static void main(String[] args) {
        DecimalFormat decimalFormat = new DecimalFormat("#.00");
        double testAnswer = 2.98393938659796;
        System.out.print(" The test case answer is " + testAnswer + "\n\n");
        double testRect = Integration.leftRectangularMethod(Integration.generateTestData_v1());
        double testRectRight = Integration.rightRectangularMethod(Integration.generateTestData_v1());
        double avgRect = (testRect + testRectRight) / 2.0;
        double avgRectError = FastMath.abs((double)(testAnswer - avgRect)) / testAnswer * 100.0;
        double testTrap = Integration.leftTrapInput(Integration.generateTestData_v1());
        double testTrapRight = Integration.rightTrapInput(Integration.generateTestData_v1());
        double avgTrap = (testTrap + testTrapRight) / 2.0;
        double avgTrapError = FastMath.abs((double)(avgTrap - testAnswer)) / testAnswer * 100.0;
        double testSimp = Integration.leftSimpsons(Integration.generateTestData_v1()) + Integration.halfBinComposite(Integration.generateTestData_v1(), 1, "left");
        double testSimpRight = Integration.rightSimpsons(Integration.generateTestData_v1()) + Integration.halfBinComposite(Integration.generateTestData_v1(), 1, "right");
        double avgSimp = (testSimp + testSimpRight) / 2.0;
        double avgSimpError = FastMath.abs((double)(testAnswer - avgSimp)) / testAnswer * 100.0;
        double testBoole = Integration.leftBoole(Integration.generateTestData_v1()) + Integration.halfBinComposite(Integration.generateTestData_v1(), 2, "left");
        double testBooleRight = Integration.rightBoole(Integration.generateTestData_v1()) + Integration.halfBinComposite(Integration.generateTestData_v1(), 2, "right");
        double avgBoole = (testBoole + testBooleRight) / 2.0;
        double avgBooleError = FastMath.abs((double)(testAnswer - avgBoole)) / testAnswer * 100.0;
        System.out.print(" Average integrals \n\n");
        System.out.print(" Average rectangular " + avgRect + "\n");
        System.out.print(" Average trap " + avgTrap + "\n");
        System.out.print(" Average Simpsons " + avgSimp + "\n");
        System.out.print(" Average Boole " + avgBoole + "\n");
        System.out.print("\n Average integral error \n\n");
        System.out.print(" Average rectangular error " + decimalFormat.format(avgRectError) + "%\n");
        System.out.print(" Average Trapezoidal error  " + decimalFormat.format(avgTrapError) + "%\n");
        System.out.print(" Average Simpsons error " + decimalFormat.format(avgSimpError) + "%\n");
        System.out.print(" Average Boole error " + decimalFormat.format(avgBooleError) + "%\n");
    }

    public static double rightBoole(double[] inputData) {
        int n = inputData.length;
        double normalBoole = 0.0;
        for (int a = 4; a < n - 5; a += 4) {
            double area = 0.044444444444444446 * (x[a + 1] - x[a]) * (7.0 * inputData[a] + 32.0 * inputData[a + 1] + 12.0 * inputData[a + 2] + 32.0 * inputData[a + 3] + 7.0 * inputData[a + 4]);
            normalBoole += area;
        }
        return normalBoole;
    }

    public static double rightRectangularMethod(double[] inputData) {
        int n = inputData.length;
        double rectangularIntegral = 0.0;
        double[] y = Integration.generateTestData_v1();
        for (int a = 1; a < n - 1; ++a) {
            double area = (x[a + 1] - x[a]) * y[a];
            rectangularIntegral += area;
        }
        return rectangularIntegral;
    }

    public static double rightSimpsons(double[] inputData) {
        int n = inputData.length;
        double normalSimpsons = 0.0;
        for (int a = 2; a < n - 3; a += 2) {
            double area = 0.3333333333333333 * (x[a + 1] - x[a]) * (inputData[a] + 4.0 * inputData[a + 1] + inputData[a + 2]);
            normalSimpsons += area;
        }
        return normalSimpsons;
    }

    public static double rightTrapInput(double[] inputData) {
        int n = x.length;
        double sum = 0.0;
        double total = 0.0;
        double trapIntegral = 0.0;
        for (int a = 1; a < n - 1; ++a) {
            if (a > 1) {
                double area = (inputData[a + 1] + inputData[a]) / 2.0 * (x[a + 1] - x[a]);
                total = sum = area + total;
            }
            if (a == n - 2) {
                trapIntegral = sum;
            }
            if (a != 1) continue;
            total = (inputData[a + 1] + inputData[a]) / 2.0 * (x[a + 1] - x[a]);
        }
        return trapIntegral;
    }

    static {
        Integration.x[0] = 0.0;
        for (int i = 1; i < 201; ++i) {
            Integration.x[i] = 0.0025 + 0.005 * (double)(i - 1);
        }
        Integration.x[201] = 1.0;
    }
}

