/*
 * Decompiled with CFR 0.152.
 */
package ffx.numerics.integrate;

import ffx.numerics.integrate.DataSet;
import java.util.logging.Logger;
import java.util.stream.IntStream;

public class Integrate1DNumeric {
    private static final Logger logger = Logger.getLogger(Integrate1DNumeric.class.getName());
    private static final double ONE_THIRD = 0.3333333333333333;
    private static final double BOOLE_FACTOR = 0.044444444444444446;

    private Integrate1DNumeric() {
    }

    public static double booles(DataSet data, IntegrationSide side) {
        double area = 0.0;
        int lb = 0;
        int ub = data.numPoints() - 1;
        if (data.halfWidthEnds()) {
            area = Integrate1DNumeric.trapezoidalEnds(data, side);
            ++lb;
            --ub;
        }
        return area += Integrate1DNumeric.booles(data, side, lb, ub);
    }

    public static double booles(DataSet data, IntegrationSide side, int lb, int ub) {
        double area = 0.0;
        double width = data.binWidth();
        double[] points = data.getAllFxPoints();
        int increment = 4;
        int nBins = (ub - lb) / increment;
        int lowerNeglected = 0;
        int upperNeglected = 0;
        switch (side.ordinal()) {
            case 1: {
                for (int i = ub; i > lb + increment - 1; i -= increment) {
                    area += 7.0 * points[i] + 32.0 * points[i - 1] + 12.0 * points[i - 2] + 32.0 * points[i - 3] + 7.0 * points[i - 4];
                }
                lowerNeglected = lb;
                upperNeglected = ub - increment * nBins;
                break;
            }
            case 0: {
                for (int i = lb; i < ub - increment + 1; i += increment) {
                    area += 7.0 * points[i] + 32.0 * points[i + 1] + 12.0 * points[i + 2] + 32.0 * points[i + 3] + 7.0 * points[i + 4];
                }
                lowerNeglected = lb + increment * nBins;
                upperNeglected = ub;
            }
        }
        area *= 0.044444444444444446;
        area *= width;
        return area += Integrate1DNumeric.finishIntegration(data, side, lowerNeglected, upperNeglected, IntegrationType.BOOLE);
    }

    public static double boolesParallel(DataSet data, IntegrationSide side) {
        double area = 0.0;
        int lb = 0;
        int ub = data.numPoints() - 1;
        if (data.halfWidthEnds()) {
            area = Integrate1DNumeric.trapezoidalEnds(data, side);
            ++lb;
            --ub;
        }
        return area += Integrate1DNumeric.boolesParallel(data, side, lb, ub);
    }

    public static double boolesParallel(DataSet data, IntegrationSide side, int lb, int ub) {
        double area = 0.0;
        double width = data.binWidth();
        double[] points = data.getAllFxPoints();
        int increment = 4;
        int nBins = (ub - lb) / increment;
        int lowerNeglected = 0;
        int upperNeglected = 0;
        switch (side.ordinal()) {
            case 1: {
                lowerNeglected = lb;
                upperNeglected = ub - increment * nBins;
                area = IntStream.range(0, nBins).parallel().mapToDouble(i -> {
                    int fromPoint = ub - increment * i;
                    return 7.0 * points[fromPoint - 4] + 32.0 * points[fromPoint - 3] + 12.0 * points[fromPoint - 2] + 32.0 * points[fromPoint - 1] + 7.0 * points[fromPoint];
                }).sum();
                break;
            }
            case 0: {
                lowerNeglected = lb + increment * nBins;
                upperNeglected = ub;
                area = IntStream.range(0, nBins).parallel().mapToDouble(i -> {
                    int fromPoint = lb + increment * i;
                    return 7.0 * points[fromPoint] + 32.0 * points[fromPoint + 1] + 12.0 * points[fromPoint + 2] + 32.0 * points[fromPoint + 3] + 7.0 * points[fromPoint + 4];
                }).sum();
            }
        }
        area *= 0.044444444444444446;
        area *= width;
        return area += Integrate1DNumeric.finishIntegration(data, side, lowerNeglected, upperNeglected, IntegrationType.BOOLE);
    }

    public static double[] generateXPoints(double lb, double ub, int nPoints, boolean halfWidthEnds) {
        if (lb >= ub) {
            throw new IllegalArgumentException("ub must be greater than lb");
        }
        double[] points = new double[nPoints];
        int sepDivisor = halfWidthEnds ? nPoints - 2 : nPoints - 1;
        double sep = (ub - lb) / (double)sepDivisor;
        if (halfWidthEnds) {
            points[0] = lb;
            points[nPoints - 1] = ub;
            for (int i = 1; i < nPoints - 1; ++i) {
                points[i] = lb + (double)i * sep - 0.5 * sep;
            }
        } else {
            for (int i = 0; i < nPoints; ++i) {
                points[i] = lb + (double)i * sep;
            }
        }
        return points;
    }

    public static double[] integrateByBins(DataSet data, IntegrationSide side, IntegrationType maxType) {
        boolean halfWide = data.halfWidthEnds();
        double[] fX = data.getAllFxPoints();
        int numPoints = data.numPoints();
        double width = data.binWidth();
        double[] values = new double[numPoints];
        int lb = halfWide ? 1 : 0;
        int ub = halfWide ? numPoints - 2 : numPoints - 1;
        int increment = maxType.pointsNeeded() - 1;
        increment = Math.max(1, increment);
        switch (side.ordinal()) {
            case 1: {
                values[ub] = width * fX[ub];
                for (int i = ub - 1; i >= lb; --i) {
                    int fromUB = ub - i - 1;
                    fromUB /= increment;
                    int lastBegin = ub - (fromUB *= increment);
                    double val = Integrate1DNumeric.finishIntegration(data, side, i, lastBegin, maxType);
                    values[i] = val -= Integrate1DNumeric.finishIntegration(data, side, i + 1, lastBegin, maxType);
                }
                int n = ub - 1;
                values[n] = values[n] - values[ub];
                if (!halfWide) break;
                if (maxType == IntegrationType.RECTANGULAR) {
                    values[1] = values[1] + 0.5 * width * fX[1];
                    values[numPoints - 1] = 0.5 * width * fX[numPoints - 1];
                    break;
                }
                values[0] = 0.25 * width * fX[0];
                values[1] = values[1] + 0.25 * width * fX[1];
                int n2 = numPoints - 2;
                values[n2] = values[n2] + 0.25 * width * fX[numPoints - 2];
                values[numPoints - 1] = 0.25 * width * fX[numPoints - 1];
                break;
            }
            case 0: {
                int shift = halfWide ? 1 : 0;
                values[lb] = width * fX[lb];
                for (int i = lb + 1; i <= ub; ++i) {
                    int lastBegin = (i - 1 - shift) / increment;
                    lastBegin *= increment;
                    double val = Integrate1DNumeric.finishIntegration(data, side, lastBegin += shift, i, maxType);
                    values[i] = val -= Integrate1DNumeric.finishIntegration(data, side, lastBegin, i - 1, maxType);
                }
                int n = lb + 1;
                values[n] = values[n] - values[lb];
                if (!halfWide) break;
                if (maxType == IntegrationType.RECTANGULAR) {
                    values[0] = 0.5 * width * fX[0];
                    int n3 = numPoints - 2;
                    values[n3] = values[n3] + 0.5 * width * fX[numPoints - 2];
                    break;
                }
                values[0] = 0.25 * width * fX[0];
                values[1] = values[1] + 0.25 * width * fX[1];
                int n4 = numPoints - 2;
                values[n4] = values[n4] + 0.25 * width * fX[numPoints - 2];
                values[numPoints - 1] = 0.25 * width * fX[numPoints - 1];
            }
        }
        return values;
    }

    public static double integrateData(DataSet data, IntegrationSide side, IntegrationType type) {
        switch (type.ordinal()) {
            case 0: {
                return Integrate1DNumeric.rectangular(data, side);
            }
            case 1: {
                return Integrate1DNumeric.trapezoidal(data, side);
            }
            case 2: {
                return Integrate1DNumeric.simpsons(data, side);
            }
            case 3: {
                return Integrate1DNumeric.booles(data, side);
            }
        }
        logger.warning(String.format(" Integration type %s not recognized! Defaulting to Simpson's integration", new Object[]{type}));
        return Integrate1DNumeric.simpsons(data, side);
    }

    public static double rectangular(DataSet data, IntegrationSide side) {
        double area = 0.0;
        int lb = 0;
        int ub = data.numPoints() - 1;
        if (data.halfWidthEnds()) {
            area = Integrate1DNumeric.rectangularEnds(data, side);
            ++lb;
            --ub;
        }
        return area += Integrate1DNumeric.rectangular(data, side, lb, ub);
    }

    public static double rectangular(DataSet data, IntegrationSide side, int lb, int ub) {
        double area = 0.0;
        double width = data.binWidth();
        double[] points = data.getAllFxPoints();
        assert (ub > lb);
        assert (ub < points.length);
        switch (side.ordinal()) {
            case 1: {
                for (int i = ub; i > lb; --i) {
                    area += width * points[i];
                }
                break;
            }
            case 0: {
                for (int i = lb; i < ub; ++i) {
                    area += width * points[i];
                }
                break;
            }
        }
        return area;
    }

    public static double rectangularEnds(DataSet data, IntegrationSide side) {
        double width = 0.5 * data.binWidth();
        double area = 0.0;
        int nPoints = data.numPoints();
        switch (side.ordinal()) {
            case 0: {
                area = data.getFxPoint(0) * width;
                area += data.getFxPoint(nPoints - 2) * width;
                break;
            }
            case 1: {
                area = data.getFxPoint(1) * width;
                area += data.getFxPoint(nPoints - 1) * width;
            }
        }
        return area;
    }

    public static double rectangularParallel(DataSet data, IntegrationSide side) {
        double area = 0.0;
        int lb = 0;
        int ub = data.numPoints() - 1;
        if (data.halfWidthEnds()) {
            area = Integrate1DNumeric.rectangularEnds(data, side);
            ++lb;
            --ub;
        }
        return area += Integrate1DNumeric.rectangularParallel(data, side, lb, ub);
    }

    public static double rectangularParallel(DataSet data, IntegrationSide side, int lb, int ub) {
        double width = data.binWidth();
        double[] points = data.getAllFxPoints();
        assert (ub > lb);
        assert (ub < points.length);
        if (side == IntegrationSide.RIGHT) {
            ++ub;
            ++lb;
        }
        return IntStream.range(lb, ub).parallel().mapToDouble(i -> points[i] * width).sum();
    }

    public static double simpsons(DataSet data, IntegrationSide side) {
        double area = 0.0;
        int lb = 0;
        int ub = data.numPoints() - 1;
        if (data.halfWidthEnds()) {
            area = Integrate1DNumeric.trapezoidalEnds(data, side);
            ++lb;
            --ub;
        }
        return area += Integrate1DNumeric.simpsons(data, side, lb, ub);
    }

    public static double simpsons(DataSet data, IntegrationSide side, int lb, int ub) {
        double area = 0.0;
        double width = data.binWidth();
        double[] points = data.getAllFxPoints();
        int increment = 2;
        int nBins = (ub - lb) / increment;
        int lowerNeglected = 0;
        int upperNeglected = 0;
        switch (side.ordinal()) {
            case 1: {
                for (int i = ub; i > lb + increment - 1; i -= increment) {
                    area += points[i] + 4.0 * points[i - 1] + points[i - 2];
                }
                lowerNeglected = lb;
                upperNeglected = ub - increment * nBins;
                break;
            }
            case 0: {
                for (int i = lb; i < ub - increment + 1; i += increment) {
                    area += points[i] + 4.0 * points[i + 1] + points[i + 2];
                }
                lowerNeglected = lb + increment * nBins;
                upperNeglected = ub;
            }
        }
        area *= 0.3333333333333333;
        area *= width;
        return area += Integrate1DNumeric.finishIntegration(data, side, lowerNeglected, upperNeglected, IntegrationType.SIMPSONS);
    }

    public static double simpsonsParallel(DataSet data, IntegrationSide side) {
        double area = 0.0;
        int lb = 0;
        int ub = data.numPoints() - 1;
        if (data.halfWidthEnds()) {
            area = Integrate1DNumeric.trapezoidalEnds(data, side);
            ++lb;
            --ub;
        }
        return area += Integrate1DNumeric.simpsonsParallel(data, side, lb, ub);
    }

    public static double simpsonsParallel(DataSet data, IntegrationSide side, int lb, int ub) {
        double area = 0.0;
        double width = data.binWidth();
        double[] points = data.getAllFxPoints();
        int increment = 2;
        int nBins = (ub - lb) / increment;
        int lowerNeglected = 0;
        int upperNeglected = 0;
        switch (side.ordinal()) {
            case 1: {
                lowerNeglected = lb;
                upperNeglected = ub - increment * nBins;
                area = IntStream.range(0, nBins).parallel().mapToDouble(i -> {
                    int fromPoint = ub - increment * i;
                    return points[fromPoint - 2] + 4.0 * points[fromPoint - 1] + points[fromPoint];
                }).sum();
                break;
            }
            case 0: {
                area = IntStream.range(0, nBins).parallel().mapToDouble(i -> {
                    int fromPoint = lb + increment * i;
                    return points[fromPoint] + 4.0 * points[fromPoint + 1] + points[fromPoint + 2];
                }).sum();
                lowerNeglected = lb + increment * nBins;
                upperNeglected = ub;
            }
        }
        area *= 0.3333333333333333;
        area *= width;
        return area += Integrate1DNumeric.finishIntegration(data, side, lowerNeglected, upperNeglected, IntegrationType.SIMPSONS);
    }

    public static double trapezoidal(DataSet data, IntegrationSide side) {
        double area = 0.0;
        int lb = 0;
        int ub = data.numPoints() - 1;
        if (data.halfWidthEnds()) {
            area = Integrate1DNumeric.trapezoidalEnds(data, side);
            ++lb;
            --ub;
        }
        return area += Integrate1DNumeric.trapezoidal(data, side, lb, ub);
    }

    public static double trapezoidal(DataSet data, IntegrationSide side, int lb, int ub) {
        double width = data.binWidth();
        double[] points = data.getAllFxPoints();
        double area = 0.5 * points[lb];
        area += 0.5 * points[ub];
        for (int i = lb + 1; i < ub; ++i) {
            area += points[i];
        }
        return area *= width;
    }

    public static double trapezoidalEnds(DataSet data, IntegrationSide side) {
        double width = 0.5 * data.binWidth();
        int nPts = data.numPoints();
        double area = data.getFxPoint(0) + data.getFxPoint(1) + data.getFxPoint(nPts - 2) + data.getFxPoint(nPts - 1);
        return area *= 0.5 * width;
    }

    public static double trapezoidalParallel(DataSet data, IntegrationSide side) {
        double area = 0.0;
        int lb = 0;
        int ub = data.numPoints() - 1;
        if (data.halfWidthEnds()) {
            area = Integrate1DNumeric.trapezoidalEnds(data, side);
            ++lb;
            --ub;
        }
        return area += Integrate1DNumeric.trapezoidalParallel(data, side, lb, ub);
    }

    public static double trapezoidalParallel(DataSet data, IntegrationSide side, int lb, int ub) {
        double width = data.binWidth();
        double[] points = data.getAllFxPoints();
        double area = 0.5 * points[lb];
        area += 0.5 * points[ub];
        area += IntStream.range(lb + 1, ub).parallel().mapToDouble(i -> points[i]).sum();
        return area *= width;
    }

    private static double finishIntegration(DataSet data, IntegrationSide side, int lb, int ub, IntegrationType type) {
        int totPoints = ub - lb;
        int perBin = type.pointsNeeded();
        int increment = perBin - 1;
        increment = Math.max(1, increment);
        int nBins = totPoints / increment;
        int remainder = totPoints % increment;
        IntegrateWindow intMode = switch (type.ordinal()) {
            default -> throw new MatchException(null, null);
            case 3 -> Integrate1DNumeric::booles;
            case 2 -> Integrate1DNumeric::simpsons;
            case 0 -> Integrate1DNumeric::rectangular;
            case 1 -> Integrate1DNumeric::trapezoidal;
        };
        double area = 0.0;
        switch (side.ordinal()) {
            case 1: {
                for (int i = ub; i > lb - 1 + increment; i -= increment) {
                    area += intMode.toArea(data, side, i - increment, i);
                }
                ub -= nBins * increment;
                break;
            }
            case 0: {
                for (int i = lb; i < ub + 1 - increment; i += increment) {
                    area += intMode.toArea(data, side, i, i + increment);
                }
                lb += nBins * increment;
            }
        }
        assert (remainder == ub - lb);
        switch (remainder) {
            case 0: {
                break;
            }
            case 1: {
                area += Integrate1DNumeric.trapezoidal(data, side, lb, ub);
                break;
            }
            case 2: 
            case 3: {
                area += Integrate1DNumeric.simpsons(data, side, lb, ub);
                break;
            }
            default: {
                throw new IllegalArgumentException("This should not be currently possible.");
            }
        }
        return area;
    }

    public static enum IntegrationSide {
        LEFT,
        RIGHT;

    }

    public static enum IntegrationType {
        RECTANGULAR(1),
        TRAPEZOIDAL(2),
        SIMPSONS(3),
        BOOLE(5);

        private final int pointsNeeded;

        private IntegrationType(int points) {
            this.pointsNeeded = points;
        }

        public final int pointsNeeded() {
            return this.pointsNeeded;
        }
    }

    @FunctionalInterface
    private static interface IntegrateWindow {
        public double toArea(DataSet var1, IntegrationSide var2, int var3, int var4);
    }
}

