/*
 * Decompiled with CFR 0.152.
 */
package ffx.numerics.integrate;

import ffx.numerics.integrate.DataSet;
import ffx.numerics.integrate.FunctionDataCurve;

public class DoublesDataSet
implements DataSet {
    private final double[] x;
    private final double[] fX;
    private final double lb;
    private final double ub;
    private final int nX;
    private final double sep;
    private final boolean halfWidthEnd;

    public DoublesDataSet(double[] x, double[] fX) {
        this(x, fX, false);
    }

    public DoublesDataSet(double[] x, double[] fX, boolean halvedEnds) {
        this.nX = x.length;
        assert (this.nX == fX.length);
        this.x = new double[this.nX];
        System.arraycopy(x, 0, this.x, 0, this.nX);
        this.fX = new double[this.nX];
        System.arraycopy(fX, 0, this.fX, 0, this.nX);
        this.lb = x[0];
        this.ub = x[this.nX - 1];
        this.halfWidthEnd = halvedEnds;
        double sepDist = this.ub - this.lb;
        this.sep = this.halfWidthEnd ? sepDist / ((double)this.nX - 2.0) : sepDist / ((double)this.nX - 1.0);
        this.assertXIntegrity(this.x);
    }

    public DoublesDataSet(DataSet set) {
        this.nX = set.numPoints();
        this.x = new double[this.nX];
        System.arraycopy(set.getX(), 0, this.x, 0, this.nX);
        this.fX = new double[this.nX];
        System.arraycopy(set.getAllFxPoints(), 0, this.fX, 0, this.nX);
        this.lb = this.x[0];
        this.ub = this.x[this.nX - 1];
        this.halfWidthEnd = set.halfWidthEnds();
        this.sep = set.binWidth();
        this.assertXIntegrity(this.x);
    }

    @Override
    public double binWidth() {
        return this.sep;
    }

    @Override
    public double[] getAllFxPoints() {
        double[] pts = new double[this.nX];
        System.arraycopy(this.fX, 0, pts, 0, this.nX);
        return pts;
    }

    @Override
    public double getFxPoint(int index) {
        return this.fX[index];
    }

    @Override
    public double[] getX() {
        double[] copyX = new double[this.x.length];
        System.arraycopy(this.x, 0, copyX, 0, this.x.length);
        return copyX;
    }

    @Override
    public boolean halfWidthEnds() {
        return this.halfWidthEnd;
    }

    @Override
    public double lowerBound() {
        return this.lb;
    }

    @Override
    public int numPoints() {
        return this.x.length;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(String.format("Data set with %d points from lower bound %9.3g and upper bound %9.3g", this.nX, this.lb, this.ub));
        if (this.halfWidthEnd) {
            sb.append(" and half-width start/end bins");
        }
        sb.append(".");
        return sb.toString();
    }

    @Override
    public double upperBound() {
        return this.ub;
    }

    private void assertXIntegrity(double[] x) {
        assert (this.ub > this.lb);
        if (this.halfWidthEnd) {
            assert (x.length == this.nX);
            assert (this.lb == x[0]);
            assert (this.ub == x[this.nX - 1]);
            assert (FunctionDataCurve.approxEquals(x[1], this.lb + 0.5 * this.sep));
            assert (FunctionDataCurve.approxEquals(x[this.nX - 2], this.ub - 0.5 * this.sep));
            for (int i = 2; i < this.nX - 2; ++i) {
                double target = this.lb + 0.5 * this.sep;
                assert (FunctionDataCurve.approxEquals(x[i], target += (double)(i - 1) * this.sep));
            }
        } else {
            for (int i = 0; i < x.length; ++i) {
                assert (FunctionDataCurve.approxEquals(x[i], x[0] + (double)i * this.sep));
            }
        }
    }
}

