/*
 * Decompiled with CFR 0.152.
 */
package ffx.numerics.integrate;

import ffx.numerics.integrate.FunctionDataCurve;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;

public class CompositeCurve
extends FunctionDataCurve {
    private final FunctionDataCurve[] curves;
    private final double[] coefficients;
    private final int nCurves;

    public CompositeCurve(List<FunctionDataCurve> componentCurves, @Nullable List<Double> coefficients) {
        assert (!componentCurves.isEmpty());
        this.nCurves = componentCurves.size();
        this.curves = new FunctionDataCurve[this.nCurves];
        componentCurves.toArray(this.curves);
        assert (coefficients == null || this.nCurves == coefficients.size());
        if (coefficients == null) {
            this.coefficients = new double[this.nCurves];
            Arrays.fill(this.coefficients, 1.0);
        } else {
            this.coefficients = coefficients.stream().mapToDouble(Double::doubleValue).toArray();
        }
        FunctionDataCurve curve0 = this.curves[0];
        this.lb = curve0.lowerBound();
        this.ub = curve0.upperBound();
        this.halfWidthEnd = curve0.halfWidthEnds();
        this.x = curve0.getX();
        double sep = curve0.binWidth();
        boolean isInvalid = Arrays.stream(this.curves).anyMatch(c -> {
            if (this.lb != c.lowerBound()) {
                return true;
            }
            if (this.ub != c.upperBound()) {
                return true;
            }
            if (this.halfWidthEnd != c.halfWidthEnds()) {
                return true;
            }
            return sep != c.binWidth();
        });
        if (isInvalid) {
            throw new IllegalArgumentException(" Not all curves passed to CompositeCurve had the same x[] points!");
        }
        int nPoints = curve0.numPoints();
        this.points = new double[nPoints];
        for (int i = 0; i < nPoints; ++i) {
            this.points[i] = 0.0;
            for (int j = 0; j < this.nCurves; ++j) {
                int n = i;
                this.points[n] = this.points[n] + this.coefficients[j] * this.curves[j].getFxPoint(i);
            }
        }
    }

    @Override
    public double fX(double x) {
        return this.valAt(x);
    }

    public List<FunctionDataCurve> getSubCurves() {
        return Arrays.asList(this.curves);
    }

    public double[] getWeights() {
        return Arrays.copyOf(this.coefficients, this.coefficients.length);
    }

    @Override
    public double integralAt(double x) {
        double val = 0.0;
        for (int i = 0; i < this.nCurves; ++i) {
            val += this.curves[i].integralAt(x) * this.coefficients[i];
        }
        return val;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(String.format("Composite curve with %d points from lower bound %9.3g and upper bound %9.3g", this.points.length, this.lb, this.ub));
        if (this.halfWidthEnd) {
            sb.append(" and half-width start/end bins.\nComponent curves:\n");
        }
        for (FunctionDataCurve curve : this.curves) {
            sb.append(curve.toString());
        }
        return sb.toString();
    }

    private double valAt(double x) {
        double val = 0.0;
        for (int i = 0; i < this.nCurves; ++i) {
            val += this.curves[i].fX(x) * this.coefficients[i];
        }
        return val;
    }
}

