/*
 * Decompiled with CFR 0.152.
 */
package ffx.numerics.func1d;

import ffx.numerics.func1d.UnivariateDiffFunction;
import ffx.numerics.math.ScalarMath;
import org.apache.commons.math3.util.FastMath;

public class QuasiLinearThetaMap
implements UnivariateDiffFunction {
    private final double theta0;
    private final double r;
    private final double a;
    private final double b;
    private final double c;
    private final double piMinusTheta0;
    private final double negPiPlusTheta0;
    private final double halfR;

    public QuasiLinearThetaMap() {
        this(0.1);
    }

    public QuasiLinearThetaMap(double theta0) {
        if (theta0 <= 0.0 || theta0 >= Math.PI) {
            throw new IllegalArgumentException(String.format(" QuasiLinearThetaMap must receive theta0 from (0 to +pi), received %11.5g", theta0));
        }
        double sinT = FastMath.sin((double)theta0);
        double cosT = FastMath.cos((double)theta0);
        this.r = 1.0 / (1.0 - cosT + 0.5 * sinT * (Math.PI - 2.0 * theta0));
        this.theta0 = theta0;
        this.piMinusTheta0 = Math.PI - theta0;
        this.negPiPlusTheta0 = -3.041592653589793;
        this.b = this.r * 0.5 * (1.0 - cosT - theta0 * sinT);
        this.halfR = 0.5 * this.r;
        this.a = this.r * sinT * 0.5;
        double temp = FastMath.sin((double)(this.piMinusTheta0 * 0.5));
        this.c = this.r * 0.5 * sinT * this.piMinusTheta0 + this.b - this.r * (temp * temp);
    }

    @Override
    public double firstDerivative(double x) throws IllegalArgumentException {
        return this.fd(ScalarMath.modToRange(x, -Math.PI, Math.PI));
    }

    @Override
    public double nthDerivative(double x, int order) throws IllegalArgumentException {
        x = ScalarMath.modToRange(x, -Math.PI, Math.PI);
        return switch (order) {
            case 0 -> this.val(x);
            case 1 -> this.fd(x);
            case 2 -> this.sd(x);
            default -> this.nd(x, order);
        };
    }

    @Override
    public double secondDerivative(double x) throws IllegalArgumentException {
        return this.sd(ScalarMath.modToRange(x, -Math.PI, Math.PI));
    }

    @Override
    public double valueAt(double x) throws IllegalArgumentException {
        return this.val(ScalarMath.modToRange(x, -Math.PI, Math.PI));
    }

    final double[] getConstants() {
        return new double[]{this.r, this.a, this.b, this.c};
    }

    Branch getBranch(double x) {
        assert (x >= -Math.PI && x <= Math.PI);
        if (x < this.negPiPlusTheta0) {
            return Branch.D;
        }
        if (x < -1.0 * this.theta0) {
            return Branch.C;
        }
        if (x <= this.theta0) {
            return Branch.A;
        }
        if (x < this.piMinusTheta0) {
            return Branch.B;
        }
        return Branch.D;
    }

    private double val(double x) throws IllegalArgumentException {
        return this.val(x, this.getBranch(x));
    }

    double val(double x, Branch branch) throws IllegalArgumentException {
        switch (branch.ordinal()) {
            case 0: {
                double sinT = FastMath.sin((double)(x * 0.5));
                return this.r * sinT * sinT;
            }
            case 1: {
                return this.b + this.a * x;
            }
            case 2: {
                return this.b - this.a * x;
            }
            case 3: {
                double sinT = FastMath.sin((double)(x * 0.5));
                return this.r * sinT * sinT + this.c;
            }
        }
        throw new IllegalArgumentException("Could not pick a branch! Should be impossible!");
    }

    private double fd(double x) throws IllegalArgumentException {
        return this.fd(x, this.getBranch(x));
    }

    double fd(double x, Branch branch) throws IllegalArgumentException {
        switch (branch.ordinal()) {
            case 0: 
            case 3: {
                return this.halfR * FastMath.sin((double)x);
            }
            case 1: {
                return this.a;
            }
            case 2: {
                return -1.0 * this.a;
            }
        }
        throw new IllegalArgumentException("Could not pick a branch! Should be impossible!");
    }

    private double sd(double x) throws IllegalArgumentException {
        return this.sd(x, this.getBranch(x));
    }

    double sd(double x, Branch branch) throws IllegalArgumentException {
        switch (branch.ordinal()) {
            case 0: 
            case 3: {
                return this.halfR * FastMath.cos((double)x);
            }
            case 1: 
            case 2: {
                return 0.0;
            }
        }
        throw new IllegalArgumentException("Could not pick a branch! Should be impossible!");
    }

    private double nd(double x, int order) throws IllegalArgumentException {
        Branch br = this.getBranch(x);
        if (order < 3) {
            throw new IllegalArgumentException(" Order was " + order + ", must be > 2!");
        }
        switch (br.ordinal()) {
            case 1: 
            case 2: {
                return 0.0;
            }
        }
        switch (order % 4) {
            case 0: {
                return this.halfR * FastMath.sin((double)x);
            }
            case 1: {
                return this.halfR * FastMath.cos((double)x);
            }
            case 2: {
                return -1.0 * this.halfR * FastMath.sin((double)x);
            }
            case 3: {
                return -1.0 * this.halfR * FastMath.cos((double)x);
            }
        }
        throw new ArithmeticException(String.format(" Value %d modulo 4 somehow not 0-3!", order));
    }

    static enum Branch {
        A,
        B,
        C,
        D;

    }
}

