/*
 * Decompiled with CFR 0.152.
 */
package ffx.numerics.fft;

import ffx.numerics.tornado.FFXTornado;
import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;
import uk.ac.manchester.tornado.api.common.TornadoDevice;
import uk.ac.manchester.tornado.api.math.TornadoMath;
import uk.ac.manchester.tornado.api.runtime.TornadoRuntimeProvider;

public class TornadoDFT {
    float[] inReal;
    float[] inImag;
    float[] outReal;
    float[] outImag;
    long time;

    public TornadoDFT(int size) {
        this.inReal = new float[size];
        this.inImag = new float[size];
        this.outReal = new float[size];
        this.outImag = new float[size];
        for (int i = 0; i < size; ++i) {
            this.inReal[i] = 1.0f / (float)(i + 2);
            this.inImag[i] = 1.0f / (float)(i + 2);
        }
    }

    public static void computeDft(float[] inreal, float[] inimag, float[] outreal, float[] outimag) {
        int n = inreal.length;
        for (int k = 0; k < n; ++k) {
            float sumReal = 0.0f;
            float simImag = 0.0f;
            for (int t = 0; t < n; ++t) {
                float angle = 2.0f * TornadoMath.floatPI() * (float)t * (float)k / (float)n;
                sumReal += inreal[t] * TornadoMath.cos((float)angle) + inimag[t] * TornadoMath.sin((float)angle);
                simImag += -inreal[t] * TornadoMath.sin((float)angle) + inimag[t] * TornadoMath.cos((float)angle);
            }
            outreal[k] = sumReal;
            outimag[k] = simImag;
        }
    }

    public void execute(TornadoDevice device) {
        TaskGraph graph = new TaskGraph("DFT").transferToDevice(1, new Object[]{this.inReal, this.inImag}).task("t0", TornadoDFT::computeDft, (Object)this.inReal, (Object)this.inImag, (Object)this.outReal, (Object)this.outImag).transferToHost(1, new Object[]{this.outReal, this.outImag});
        ImmutableTaskGraph itg = graph.snapshot();
        TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{itg});
        executionPlan.withWarmUp().withDevice(device);
        this.time = -System.nanoTime();
        executionPlan.execute();
        this.time += System.nanoTime();
    }

    public void execute() {
        TornadoDevice device = TornadoRuntimeProvider.getTornadoRuntime().getDefaultDevice();
        this.execute(device);
    }

    public void validate(int deviceID) {
        TornadoDevice device = FFXTornado.getDevice(deviceID);
        this.validate(device);
    }

    public void validate(TornadoDevice device) {
        this.execute(device);
        long javaTime = -System.nanoTime();
        TornadoDFT.computeDft(this.inReal, this.inImag, this.outReal, this.outImag);
        System.out.println(" ");
        FFXTornado.logDevice(device);
        double speedUp = (double)(javaTime += System.nanoTime()) / (double)this.time;
        System.out.printf(" %12s %8.6f (sec)\n %12s %8.6f (sec) Speed-Up %8.6f%n", " Java", 1.0E-9 * (double)javaTime, " OpenCL", 1.0E-9 * (double)this.time, speedUp);
    }
}

