/*
 * Decompiled with CFR 0.152.
 */
package ffx.numerics.fft;

import edu.rit.pj.IntegerForLoop;
import edu.rit.pj.IntegerSchedule;
import edu.rit.pj.ParallelRegion;
import edu.rit.pj.ParallelTeam;
import ffx.numerics.fft.Complex;
import ffx.numerics.fft.Real;
import ffx.numerics.fft.Real3D;
import java.util.Objects;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

public class Real3DParallel {
    private static final Logger logger = Logger.getLogger(Real3DParallel.class.getName());
    private final int nX;
    private final int nY;
    private final int nZ;
    private final int nZ2;
    private final int nX1;
    private final int n;
    private final int nextX;
    private final int nextY;
    private final int nextZ;
    private final ParallelTeam parallelTeam;
    private final int threadCount;
    private final ParallelIFFT parallelIFFT;
    private final ParallelFFT parallelFFT;
    private final ParallelConvolution parallelConvolution;
    private final double[] recip;
    private final IntegerSchedule schedule;

    public Real3DParallel(int nX, int nY, int nZ, ParallelTeam parallelTeam) {
        this.nX = nX / 2;
        this.nY = nY;
        this.nZ = nZ;
        this.parallelTeam = parallelTeam;
        this.n = nX;
        this.nX1 = this.nX + 1;
        this.nZ2 = this.nZ * 2;
        this.nextX = 2;
        this.nextY = this.n + 2;
        this.nextZ = this.nextY * nY;
        this.recip = new double[this.nX1 * nY * nZ];
        this.threadCount = parallelTeam.getThreadCount();
        this.parallelFFT = new ParallelFFT(this);
        this.parallelIFFT = new ParallelIFFT(this);
        this.parallelConvolution = new ParallelConvolution(this);
        this.schedule = IntegerSchedule.fixed();
    }

    public Real3DParallel(int nX, int nY, int nZ, ParallelTeam parallelTeam, @Nullable IntegerSchedule integerSchedule) {
        this.nX = nX / 2;
        this.nY = nY;
        this.nZ = nZ;
        this.parallelTeam = parallelTeam;
        this.n = nX;
        this.nX1 = this.nX + 1;
        this.nZ2 = this.nZ * 2;
        this.nextX = 2;
        this.nextY = this.n + 2;
        this.nextZ = this.nextY * nY;
        this.recip = new double[this.nX1 * nY * nZ];
        this.threadCount = parallelTeam.getThreadCount();
        this.schedule = Objects.requireNonNullElseGet(integerSchedule, IntegerSchedule::fixed);
        this.parallelFFT = new ParallelFFT(this);
        this.parallelIFFT = new ParallelIFFT(this);
        this.parallelConvolution = new ParallelConvolution(this);
    }

    public static void main(String[] args) {
        int dimNotFinal = 128;
        int nCPU = ParallelTeam.getDefaultThreadCount();
        int reps = 5;
        try {
            dimNotFinal = Integer.parseInt(args[0]);
            if (dimNotFinal < 1) {
                dimNotFinal = 100;
            }
            if ((nCPU = Integer.parseInt(args[1])) < 1) {
                nCPU = ParallelTeam.getDefaultThreadCount();
            }
            if ((reps = Integer.parseInt(args[2])) < 1) {
                reps = 5;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (dimNotFinal % 2 != 0) {
            ++dimNotFinal;
        }
        final int dim = dimNotFinal;
        System.out.printf("Initializing a %d cubed grid for %d CPUs.\nThe best timing out of %d repetitions will be used.%n", dim, nCPU, reps);
        Real3D real3D = new Real3D(dim, dim, dim);
        ParallelTeam parallelTeam = new ParallelTeam(nCPU);
        Real3DParallel real3DParallel = new Real3DParallel(dim, dim, dim, parallelTeam);
        int dimCubed = (dim + 2) * dim * dim;
        final double[] data = new double[dimCubed];
        double[] work = new double[dimCubed];
        try {
            parallelTeam.execute(new ParallelRegion(){

                public void run() {
                    try {
                        this.execute(0, dim - 1, new IntegerForLoop(this){
                            {
                                Objects.requireNonNull(this$0);
                            }

                            public void run(int lb, int ub) {
                                Random randomNumberGenerator = new Random(1L);
                                int index = dim * dim * lb;
                                for (int z = lb; z <= ub; ++z) {
                                    for (int y = 0; y < dim; ++y) {
                                        for (int x = 0; x < dim; ++x) {
                                            double randomNumber;
                                            data[index] = randomNumber = randomNumberGenerator.nextDouble();
                                            ++index;
                                        }
                                    }
                                }
                            }
                        });
                    }
                    catch (Exception e) {
                        System.out.println(e.getMessage());
                        System.exit(-1);
                    }
                }
            });
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            System.exit(-1);
        }
        double toSeconds = 1.0E-9;
        long parTime = Long.MAX_VALUE;
        long seqTime = Long.MAX_VALUE;
        real3D.setRecip(work);
        real3DParallel.setRecip(work);
        for (int i = 0; i < reps; ++i) {
            System.out.printf("Iteration %d%n", i + 1);
            long time = System.nanoTime();
            real3D.fft(data);
            real3D.ifft(data);
            time = System.nanoTime() - time;
            System.out.printf("Sequential: %8.3f%n", toSeconds * (double)time);
            if (time < seqTime) {
                seqTime = time;
            }
            time = System.nanoTime();
            real3D.convolution(data);
            time = System.nanoTime() - time;
            System.out.printf("Sequential: %8.3f (Convolution)%n", toSeconds * (double)time);
            if (time < seqTime) {
                seqTime = time;
            }
            time = System.nanoTime();
            real3DParallel.fft(data);
            real3DParallel.ifft(data);
            time = System.nanoTime() - time;
            System.out.printf("Parallel:   %8.3f%n", toSeconds * (double)time);
            if (time < parTime) {
                parTime = time;
            }
            time = System.nanoTime();
            real3DParallel.convolution(data);
            time = System.nanoTime() - time;
            System.out.printf("Parallel:   %8.3f (Convolution)\n%n", toSeconds * (double)time);
            if (time >= parTime) continue;
            parTime = time;
        }
        System.out.printf("Best Sequential Time:  %8.3f%n", toSeconds * (double)seqTime);
        System.out.printf("Best Parallel Time:    %8.3f%n", toSeconds * (double)parTime);
        System.out.printf("Speedup: %15.5f%n", (double)seqTime / (double)parTime);
    }

    public void convolution(double[] input) {
        this.parallelConvolution.input = input;
        try {
            this.parallelTeam.execute((ParallelRegion)this.parallelConvolution);
        }
        catch (Exception e) {
            String message = "Fatal exception evaluating a 3D convolution in parallel.\n";
            logger.log(Level.SEVERE, message, e);
            System.exit(-1);
        }
    }

    public void fft(double[] input) {
        this.parallelFFT.input = input;
        try {
            this.parallelTeam.execute((ParallelRegion)this.parallelFFT);
        }
        catch (Exception e) {
            String message = "Fatal exception evaluating real 3D FFT in parallel.\n";
            logger.log(Level.SEVERE, message, e);
            System.exit(-1);
        }
    }

    public void ifft(double[] input) {
        this.parallelIFFT.input = input;
        try {
            this.parallelTeam.execute((ParallelRegion)this.parallelIFFT);
        }
        catch (Exception e) {
            String message = "Fatal exception evaluating real 3D inverse FFT in parallel.\n";
            logger.log(Level.SEVERE, message, e);
            System.exit(-1);
        }
    }

    public void setRecip(double[] recip) {
        int index = 0;
        int offset = 0;
        for (int y = 0; y < this.nY; ++y) {
            int x = 0;
            while (x < this.nX1) {
                int i = 0;
                int z = offset;
                while (i < this.nZ) {
                    this.recip[index++] = recip[z];
                    ++i;
                    z += this.nX1 * this.nY;
                }
                ++x;
                ++offset;
            }
        }
    }

    private class ParallelFFT
    extends ParallelRegion {
        private final int nZm1;
        private final FFTXYLoop[] fftXYLoop;
        private final FFTZLoop[] fftZLoop;
        public double[] input;
        final /* synthetic */ Real3DParallel this$0;

        private ParallelFFT(Real3DParallel real3DParallel) {
            Real3DParallel real3DParallel2 = real3DParallel;
            Objects.requireNonNull(real3DParallel2);
            this.this$0 = real3DParallel2;
            this.nZm1 = real3DParallel.nZ - 1;
            this.fftXYLoop = new FFTXYLoop[real3DParallel.threadCount];
            this.fftZLoop = new FFTZLoop[real3DParallel.threadCount];
            for (int i = 0; i < real3DParallel.threadCount; ++i) {
                this.fftXYLoop[i] = new FFTXYLoop(this);
                this.fftZLoop[i] = new FFTZLoop(this);
            }
        }

        public void run() {
            int threadIndex = this.getThreadIndex();
            this.fftXYLoop[threadIndex].input = this.input;
            this.fftZLoop[threadIndex].input = this.input;
            try {
                this.execute(0, this.nZm1, this.fftXYLoop[threadIndex]);
                this.execute(0, this.this$0.nX, this.fftZLoop[threadIndex]);
            }
            catch (Exception e) {
                logger.severe(e.toString());
            }
        }

        private class FFTXYLoop
        extends IntegerForLoop {
            private final Real fftX;
            private final Complex fftY;
            public double[] input;
            final /* synthetic */ ParallelFFT this$1;

            private FFTXYLoop(ParallelFFT parallelFFT) {
                ParallelFFT parallelFFT2 = parallelFFT;
                Objects.requireNonNull(parallelFFT2);
                this.this$1 = parallelFFT2;
                this.fftY = new Complex(parallelFFT.this$0.nY);
                this.fftX = new Real(parallelFFT.this$0.n);
            }

            public void run(int lb, int ub) {
                for (int z = lb; z <= ub; ++z) {
                    int offset = z * this.this$1.this$0.nextZ;
                    int y = 0;
                    while (y < this.this$1.this$0.nY) {
                        this.fftX.fft(this.input, offset);
                        ++y;
                        offset += this.this$1.this$0.nextY;
                    }
                    offset = z * this.this$1.this$0.nextZ;
                    int x = 0;
                    while (x < this.this$1.this$0.nX1) {
                        this.fftY.fft(this.input, offset, this.this$1.this$0.nextY);
                        ++x;
                        offset += this.this$1.this$0.nextX;
                    }
                }
            }

            public IntegerSchedule schedule() {
                return this.this$1.this$0.schedule;
            }
        }

        private class FFTZLoop
        extends IntegerForLoop {
            private final double[] work;
            private final Complex fft;
            public double[] input;
            final /* synthetic */ ParallelFFT this$1;

            private FFTZLoop(ParallelFFT parallelFFT) {
                ParallelFFT parallelFFT2 = parallelFFT;
                Objects.requireNonNull(parallelFFT2);
                this.this$1 = parallelFFT2;
                this.work = new double[parallelFFT.this$0.nZ2];
                this.fft = new Complex(parallelFFT.this$0.nZ);
            }

            public void run(int lb, int ub) {
                for (int x = lb; x <= ub; ++x) {
                    int offset = x * 2;
                    int y = 0;
                    while (y < this.this$1.this$0.nY) {
                        int z = offset;
                        int i = 0;
                        while (i < this.this$1.this$0.nZ2) {
                            this.work[i] = this.input[z];
                            this.work[i + 1] = this.input[z + 1];
                            i += 2;
                            z += this.this$1.this$0.nextZ;
                        }
                        this.fft.fft(this.work, 0, 2);
                        z = offset;
                        i = 0;
                        while (i < this.this$1.this$0.nZ2) {
                            this.input[z] = this.work[i];
                            this.input[z + 1] = this.work[i + 1];
                            i += 2;
                            z += this.this$1.this$0.nextZ;
                        }
                        ++y;
                        offset += this.this$1.this$0.nextY;
                    }
                }
            }

            public IntegerSchedule schedule() {
                return this.this$1.this$0.schedule;
            }
        }
    }

    private class ParallelIFFT
    extends ParallelRegion {
        private final int nZm1;
        private final IFFTXYLoop[] ifftXYLoop;
        private final IFFTZLoop[] ifftZLoop;
        public double[] input;
        final /* synthetic */ Real3DParallel this$0;

        private ParallelIFFT(Real3DParallel real3DParallel) {
            Real3DParallel real3DParallel2 = real3DParallel;
            Objects.requireNonNull(real3DParallel2);
            this.this$0 = real3DParallel2;
            this.nZm1 = real3DParallel.nZ - 1;
            this.ifftXYLoop = new IFFTXYLoop[real3DParallel.threadCount];
            this.ifftZLoop = new IFFTZLoop[real3DParallel.threadCount];
            for (int i = 0; i < real3DParallel.threadCount; ++i) {
                this.ifftXYLoop[i] = new IFFTXYLoop(this);
                this.ifftZLoop[i] = new IFFTZLoop(this);
            }
        }

        public void run() {
            int threadIndex = this.getThreadIndex();
            this.ifftXYLoop[threadIndex].input = this.input;
            this.ifftZLoop[threadIndex].input = this.input;
            try {
                this.execute(0, this.this$0.nX, this.ifftZLoop[threadIndex]);
                this.execute(0, this.nZm1, this.ifftXYLoop[threadIndex]);
            }
            catch (Exception e) {
                logger.severe(e.toString());
            }
        }

        private class IFFTXYLoop
        extends IntegerForLoop {
            private final Real fftX;
            private final Complex fftY;
            public double[] input;
            final /* synthetic */ ParallelIFFT this$1;

            private IFFTXYLoop(ParallelIFFT parallelIFFT) {
                ParallelIFFT parallelIFFT2 = parallelIFFT;
                Objects.requireNonNull(parallelIFFT2);
                this.this$1 = parallelIFFT2;
                this.fftX = new Real(parallelIFFT.this$0.n);
                this.fftY = new Complex(parallelIFFT.this$0.nY);
            }

            public void run(int lb, int ub) {
                for (int z = lb; z <= ub; ++z) {
                    int offset = z * this.this$1.this$0.nextZ;
                    int x = 0;
                    while (x < this.this$1.this$0.nX1) {
                        this.fftY.ifft(this.input, offset, this.this$1.this$0.nextY);
                        ++x;
                        offset += this.this$1.this$0.nextX;
                    }
                    offset = z * this.this$1.this$0.nextZ;
                    int y = 0;
                    while (y < this.this$1.this$0.nY) {
                        this.fftX.ifft(this.input, offset);
                        ++y;
                        offset += this.this$1.this$0.nextY;
                    }
                }
            }

            public IntegerSchedule schedule() {
                return this.this$1.this$0.schedule;
            }
        }

        private class IFFTZLoop
        extends IntegerForLoop {
            private final double[] work;
            private final Complex fft;
            public double[] input;
            final /* synthetic */ ParallelIFFT this$1;

            private IFFTZLoop(ParallelIFFT parallelIFFT) {
                ParallelIFFT parallelIFFT2 = parallelIFFT;
                Objects.requireNonNull(parallelIFFT2);
                this.this$1 = parallelIFFT2;
                this.fft = new Complex(parallelIFFT.this$0.nZ);
                this.work = new double[parallelIFFT.this$0.nZ2];
            }

            public void run(int lb, int ub) {
                for (int x = lb; x <= ub; ++x) {
                    int offset = x * 2;
                    int y = 0;
                    while (y < this.this$1.this$0.nY) {
                        int z = offset;
                        int i = 0;
                        while (i < this.this$1.this$0.nZ2) {
                            this.work[i] = this.input[z];
                            this.work[i + 1] = this.input[z + 1];
                            i += 2;
                            z += this.this$1.this$0.nextZ;
                        }
                        this.fft.ifft(this.work, 0, 2);
                        z = offset;
                        i = 0;
                        while (i < this.this$1.this$0.nZ2) {
                            this.input[z] = this.work[i];
                            this.input[z + 1] = this.work[i + 1];
                            i += 2;
                            z += this.this$1.this$0.nextZ;
                        }
                        ++y;
                        offset += this.this$1.this$0.nextY;
                    }
                }
            }

            public IntegerSchedule schedule() {
                return this.this$1.this$0.schedule;
            }
        }
    }

    private class ParallelConvolution
    extends ParallelRegion {
        private final int nZm1;
        private final int nYm1;
        private final int nX1nZ;
        private final FFTXYLoop[] fftXYLoop;
        private final FFTZ_Multiply_IFFTZLoop[] fftZ_Multiply_ifftZLoop;
        private final IFFTXYLoop[] ifftXYLoop;
        public double[] input;
        final /* synthetic */ Real3DParallel this$0;

        private ParallelConvolution(Real3DParallel real3DParallel) {
            Real3DParallel real3DParallel2 = real3DParallel;
            Objects.requireNonNull(real3DParallel2);
            this.this$0 = real3DParallel2;
            this.nZm1 = real3DParallel.nZ - 1;
            this.nYm1 = real3DParallel.nY - 1;
            this.nX1nZ = real3DParallel.nX1 * real3DParallel.nZ;
            this.fftXYLoop = new FFTXYLoop[real3DParallel.threadCount];
            this.fftZ_Multiply_ifftZLoop = new FFTZ_Multiply_IFFTZLoop[real3DParallel.threadCount];
            this.ifftXYLoop = new IFFTXYLoop[real3DParallel.threadCount];
            for (int i = 0; i < real3DParallel.threadCount; ++i) {
                this.fftXYLoop[i] = new FFTXYLoop(this);
                this.fftZ_Multiply_ifftZLoop[i] = new FFTZ_Multiply_IFFTZLoop(this);
                this.ifftXYLoop[i] = new IFFTXYLoop(this);
            }
        }

        public void run() {
            int threadIndex = this.getThreadIndex();
            this.fftXYLoop[threadIndex].input = this.input;
            this.fftZ_Multiply_ifftZLoop[threadIndex].input = this.input;
            this.ifftXYLoop[threadIndex].input = this.input;
            try {
                this.execute(0, this.nZm1, this.fftXYLoop[threadIndex]);
                this.execute(0, this.nYm1, this.fftZ_Multiply_ifftZLoop[threadIndex]);
                this.execute(0, this.nZm1, this.ifftXYLoop[threadIndex]);
            }
            catch (Exception e) {
                logger.severe(e.toString());
            }
        }

        private class FFTXYLoop
        extends IntegerForLoop {
            private final Real fftX;
            private final Complex fftY;
            public double[] input;
            final /* synthetic */ ParallelConvolution this$1;

            private FFTXYLoop(ParallelConvolution parallelConvolution) {
                ParallelConvolution parallelConvolution2 = parallelConvolution;
                Objects.requireNonNull(parallelConvolution2);
                this.this$1 = parallelConvolution2;
                this.fftY = new Complex(parallelConvolution.this$0.nY);
                this.fftX = new Real(parallelConvolution.this$0.n);
            }

            public void run(int lb, int ub) {
                for (int z = lb; z <= ub; ++z) {
                    int offset = z * this.this$1.this$0.nextZ;
                    int y = 0;
                    while (y < this.this$1.this$0.nY) {
                        this.fftX.fft(this.input, offset);
                        ++y;
                        offset += this.this$1.this$0.nextY;
                    }
                    offset = z * this.this$1.this$0.nextZ;
                    int x = 0;
                    while (x < this.this$1.this$0.nX1) {
                        this.fftY.fft(this.input, offset, this.this$1.this$0.nextY);
                        ++x;
                        offset += this.this$1.this$0.nextX;
                    }
                }
            }

            public IntegerSchedule schedule() {
                return this.this$1.this$0.schedule;
            }
        }

        private class FFTZ_Multiply_IFFTZLoop
        extends IntegerForLoop {
            private final double[] work;
            private final Complex fft;
            public double[] input;
            final /* synthetic */ ParallelConvolution this$1;

            private FFTZ_Multiply_IFFTZLoop(ParallelConvolution parallelConvolution) {
                ParallelConvolution parallelConvolution2 = parallelConvolution;
                Objects.requireNonNull(parallelConvolution2);
                this.this$1 = parallelConvolution2;
                this.work = new double[parallelConvolution.this$0.nZ2];
                this.fft = new Complex(parallelConvolution.this$0.nZ);
            }

            public void run(int lb, int ub) {
                int index = lb * this.this$1.nX1nZ;
                int offset = lb * this.this$1.this$0.nextY;
                for (int y = lb; y <= ub; ++y) {
                    int x = 0;
                    while (x < this.this$1.this$0.nX1) {
                        int z = offset;
                        int i = 0;
                        while (i < this.this$1.this$0.nZ2) {
                            this.work[i] = this.input[z];
                            this.work[i + 1] = this.input[z + 1];
                            i += 2;
                            z += this.this$1.this$0.nextZ;
                        }
                        this.fft.fft(this.work, 0, 2);
                        for (int i2 = 0; i2 < this.this$1.this$0.nZ2; i2 += 2) {
                            double r = this.this$1.this$0.recip[index++];
                            int n = i2;
                            this.work[n] = this.work[n] * r;
                            int n2 = i2 + 1;
                            this.work[n2] = this.work[n2] * r;
                        }
                        this.fft.ifft(this.work, 0, 2);
                        z = offset;
                        i = 0;
                        while (i < this.this$1.this$0.nZ2) {
                            this.input[z] = this.work[i];
                            this.input[z + 1] = this.work[i + 1];
                            i += 2;
                            z += this.this$1.this$0.nextZ;
                        }
                        ++x;
                        offset += this.this$1.this$0.nextX;
                    }
                }
            }

            public IntegerSchedule schedule() {
                return this.this$1.this$0.schedule;
            }
        }

        private class IFFTXYLoop
        extends IntegerForLoop {
            private final Real fftX;
            private final Complex fftY;
            public double[] input;
            final /* synthetic */ ParallelConvolution this$1;

            private IFFTXYLoop(ParallelConvolution parallelConvolution) {
                ParallelConvolution parallelConvolution2 = parallelConvolution;
                Objects.requireNonNull(parallelConvolution2);
                this.this$1 = parallelConvolution2;
                this.fftY = new Complex(parallelConvolution.this$0.nY);
                this.fftX = new Real(parallelConvolution.this$0.n);
            }

            public void run(int lb, int ub) {
                for (int z = lb; z <= ub; ++z) {
                    int offset = z * this.this$1.this$0.nextZ;
                    int x = 0;
                    while (x < this.this$1.this$0.nX1) {
                        this.fftY.ifft(this.input, offset, this.this$1.this$0.nextY);
                        ++x;
                        offset += this.this$1.this$0.nextX;
                    }
                    offset = z * this.this$1.this$0.nextZ;
                    int y = 0;
                    while (y < this.this$1.this$0.nY) {
                        this.fftX.ifft(this.input, offset);
                        ++y;
                        offset += this.this$1.this$0.nextY;
                    }
                }
            }

            public IntegerSchedule schedule() {
                return this.this$1.this$0.schedule;
            }
        }
    }
}

