/*
 * Decompiled with CFR 0.152.
 */
package ffx.numerics.fft;

import ffx.numerics.fft.MixedRadixFactor;
import ffx.numerics.fft.PassConstants;
import ffx.numerics.fft.PassData;
import jdk.incubator.vector.DoubleVector;
import jdk.incubator.vector.Vector;
import jdk.incubator.vector.VectorSpecies;
import org.apache.commons.math3.util.FastMath;

public class MixedRadixFactor6
extends MixedRadixFactor {
    private static final double sqrt3_2 = FastMath.sqrt((double)3.0) / 2.0;
    private final int di2;
    private final int di3;
    private final int di4;
    private final int di5;
    private final int dj2;
    private final int dj3;
    private final int dj4;
    private final int dj5;

    public MixedRadixFactor6(PassConstants passConstants) {
        super(passConstants);
        this.di2 = 2 * this.di;
        this.di3 = 3 * this.di;
        this.di4 = 4 * this.di;
        this.di5 = 5 * this.di;
        this.dj2 = 2 * this.dj;
        this.dj3 = 3 * this.dj;
        this.dj4 = 4 * this.dj;
        this.dj5 = 5 * this.dj;
    }

    @Override
    protected void passScalar(PassData passData) {
        double[] data = passData.in;
        double[] ret = passData.out;
        int sign = passData.sign;
        int i = passData.inOffset;
        int j = passData.outOffset;
        double tau = (double)sign * sqrt3_2;
        int k1 = 0;
        while (k1 < this.innerLoopLimit) {
            double z0r = data[i];
            double z1r = data[i + this.di];
            double z2r = data[i + this.di2];
            double z3r = data[i + this.di3];
            double z4r = data[i + this.di4];
            double z5r = data[i + this.di5];
            double z0i = data[i + this.im];
            double z1i = data[i + this.di + this.im];
            double z2i = data[i + this.di2 + this.im];
            double z3i = data[i + this.di3 + this.im];
            double z4i = data[i + this.di4 + this.im];
            double z5i = data[i + this.di5 + this.im];
            double ta1r = z2r + z4r;
            double ta1i = z2i + z4i;
            double ta2r = Math.fma(-0.5, ta1r, z0r);
            double ta2i = Math.fma(-0.5, ta1i, z0i);
            double ta3r = tau * (z2r - z4r);
            double ta3i = tau * (z2i - z4i);
            double a0r = z0r + ta1r;
            double a0i = z0i + ta1i;
            double a1r = ta2r - ta3i;
            double a1i = ta2i + ta3r;
            double a2r = ta2r + ta3i;
            double a2i = ta2i - ta3r;
            double tb1r = z5r + z1r;
            double tb1i = z5i + z1i;
            double tb2r = Math.fma(-0.5, tb1r, z3r);
            double tb2i = Math.fma(-0.5, tb1i, z3i);
            double tb3r = tau * (z5r - z1r);
            double tb3i = tau * (z5i - z1i);
            double b0r = z3r + tb1r;
            double b0i = z3i + tb1i;
            double b1r = tb2r - tb3i;
            double b1i = tb2i + tb3r;
            double b2r = tb2r + tb3i;
            double b2i = tb2i - tb3r;
            ret[j] = a0r + b0r;
            ret[j + this.im] = a0i + b0i;
            ret[j + this.dj] = a1r - b1r;
            ret[j + this.dj + this.im] = a1i - b1i;
            ret[j + this.dj2] = a2r + b2r;
            ret[j + this.dj2 + this.im] = a2i + b2i;
            ret[j + this.dj3] = a0r - b0r;
            ret[j + this.dj3 + this.im] = a0i - b0i;
            ret[j + this.dj4] = a1r + b1r;
            ret[j + this.dj4 + this.im] = a1i + b1i;
            ret[j + this.dj5] = a2r - b2r;
            ret[j + this.dj5 + this.im] = a2i - b2i;
            ++k1;
            i += this.ii;
            j += this.ii;
        }
        j += this.jstep;
        int k = 1;
        while (k < this.outerLoopLimit) {
            int index = k * 5;
            double w1r = this.wr[index];
            double w2r = this.wr[index + 1];
            double w3r = this.wr[index + 2];
            double w4r = this.wr[index + 3];
            double w5r = this.wr[index + 4];
            double w1i = (double)(-sign) * this.wi[index];
            double w2i = (double)(-sign) * this.wi[index + 1];
            double w3i = (double)(-sign) * this.wi[index + 2];
            double w4i = (double)(-sign) * this.wi[index + 3];
            double w5i = (double)(-sign) * this.wi[index + 4];
            int k12 = 0;
            while (k12 < this.innerLoopLimit) {
                double z0r = data[i];
                double z1r = data[i + this.di];
                double z2r = data[i + this.di2];
                double z3r = data[i + this.di3];
                double z4r = data[i + this.di4];
                double z5r = data[i + this.di5];
                double z0i = data[i + this.im];
                double z1i = data[i + this.di + this.im];
                double z2i = data[i + this.di2 + this.im];
                double z3i = data[i + this.di3 + this.im];
                double z4i = data[i + this.di4 + this.im];
                double z5i = data[i + this.di5 + this.im];
                double ta1r = z2r + z4r;
                double ta1i = z2i + z4i;
                double ta2r = Math.fma(-0.5, ta1r, z0r);
                double ta2i = Math.fma(-0.5, ta1i, z0i);
                double ta3r = tau * (z2r - z4r);
                double ta3i = tau * (z2i - z4i);
                double a0r = z0r + ta1r;
                double a0i = z0i + ta1i;
                double a1r = ta2r - ta3i;
                double a1i = ta2i + ta3r;
                double a2r = ta2r + ta3i;
                double a2i = ta2i - ta3r;
                double tb1r = z5r + z1r;
                double tb1i = z5i + z1i;
                double tb2r = Math.fma(-0.5, tb1r, z3r);
                double tb2i = Math.fma(-0.5, tb1i, z3i);
                double tb3r = tau * (z5r - z1r);
                double tb3i = tau * (z5i - z1i);
                double b0r = z3r + tb1r;
                double b0i = z3i + tb1i;
                double b1r = tb2r - tb3i;
                double b1i = tb2i + tb3r;
                double b2r = tb2r + tb3i;
                double b2i = tb2i - tb3r;
                ret[j] = a0r + b0r;
                ret[j + this.im] = a0i + b0i;
                MixedRadixFactor6.multiplyAndStore(a1r - b1r, a1i - b1i, w1r, w1i, ret, j + this.dj, j + this.dj + this.im);
                MixedRadixFactor6.multiplyAndStore(a2r + b2r, a2i + b2i, w2r, w2i, ret, j + this.dj2, j + this.dj2 + this.im);
                MixedRadixFactor6.multiplyAndStore(a0r - b0r, a0i - b0i, w3r, w3i, ret, j + this.dj3, j + this.dj3 + this.im);
                MixedRadixFactor6.multiplyAndStore(a1r + b1r, a1i + b1i, w4r, w4i, ret, j + this.dj4, j + this.dj4 + this.im);
                MixedRadixFactor6.multiplyAndStore(a2r - b2r, a2i - b2i, w5r, w5i, ret, j + this.dj5, j + this.dj5 + this.im);
                ++k12;
                i += this.ii;
                j += this.ii;
            }
            ++k;
            j += this.jstep;
        }
    }

    @Override
    protected void passSIMD(PassData passData) {
        if (!this.isValidSIMDWidth(this.simdWidth)) {
            this.passScalar(passData);
        } else if (this.im == 1) {
            this.interleaved(passData);
        } else {
            this.blocked(passData);
        }
    }

    private void interleaved(PassData passData) {
        double[] data = passData.in;
        double[] ret = passData.out;
        int sign = passData.sign;
        int i = passData.inOffset;
        int j = passData.outOffset;
        double tau = (double)sign * sqrt3_2;
        int k1 = 0;
        while (k1 < this.innerLoopLimit) {
            DoubleVector z0 = DoubleVector.fromArray((VectorSpecies)DOUBLE_SPECIES, (double[])data, (int)i);
            DoubleVector z1 = DoubleVector.fromArray((VectorSpecies)DOUBLE_SPECIES, (double[])data, (int)(i + this.di));
            DoubleVector z2 = DoubleVector.fromArray((VectorSpecies)DOUBLE_SPECIES, (double[])data, (int)(i + this.di2));
            DoubleVector z3 = DoubleVector.fromArray((VectorSpecies)DOUBLE_SPECIES, (double[])data, (int)(i + this.di3));
            DoubleVector z4 = DoubleVector.fromArray((VectorSpecies)DOUBLE_SPECIES, (double[])data, (int)(i + this.di4));
            DoubleVector z5 = DoubleVector.fromArray((VectorSpecies)DOUBLE_SPECIES, (double[])data, (int)(i + this.di5));
            DoubleVector ta1 = z2.add((Vector)z4);
            DoubleVector ta2 = ta1.mul(-0.5).add((Vector)z0);
            DoubleVector ta3 = z2.sub((Vector)z4).mul(tau).rearrange(SHUFFLE_RE_IM);
            DoubleVector a0 = z0.add((Vector)ta1);
            DoubleVector a1 = ta3.fma((Vector)NEGATE_RE, (Vector)ta2);
            DoubleVector a2 = ta3.fma((Vector)NEGATE_IM, (Vector)ta2);
            DoubleVector tb1 = z5.add((Vector)z1);
            DoubleVector tb2 = tb1.mul(-0.5).add((Vector)z3);
            DoubleVector tb3 = z5.sub((Vector)z1).mul(tau).rearrange(SHUFFLE_RE_IM);
            DoubleVector b0 = z3.add((Vector)tb1);
            DoubleVector b1 = tb3.fma((Vector)NEGATE_RE, (Vector)tb2);
            DoubleVector b2 = tb3.fma((Vector)NEGATE_IM, (Vector)tb2);
            a0.add((Vector)b0).intoArray(ret, j);
            a1.sub((Vector)b1).intoArray(ret, j + this.dj);
            a2.add((Vector)b2).intoArray(ret, j + this.dj2);
            a0.sub((Vector)b0).intoArray(ret, j + this.dj3);
            a1.add((Vector)b1).intoArray(ret, j + this.dj4);
            a2.sub((Vector)b2).intoArray(ret, j + this.dj5);
            k1 += INTERLEAVED_LOOP;
            i += LENGTH;
            j += LENGTH;
        }
        j += this.jstep;
        int k = 1;
        while (k < this.outerLoopLimit) {
            int index = k * 5;
            DoubleVector w1r = DoubleVector.broadcast((VectorSpecies)DOUBLE_SPECIES, (double)this.wr[index]);
            DoubleVector w2r = DoubleVector.broadcast((VectorSpecies)DOUBLE_SPECIES, (double)this.wr[index + 1]);
            DoubleVector w3r = DoubleVector.broadcast((VectorSpecies)DOUBLE_SPECIES, (double)this.wr[index + 2]);
            DoubleVector w4r = DoubleVector.broadcast((VectorSpecies)DOUBLE_SPECIES, (double)this.wr[index + 3]);
            DoubleVector w5r = DoubleVector.broadcast((VectorSpecies)DOUBLE_SPECIES, (double)this.wr[index + 4]);
            DoubleVector w1i = DoubleVector.broadcast((VectorSpecies)DOUBLE_SPECIES, (double)((double)(-sign) * this.wi[index])).mul((Vector)NEGATE_IM);
            DoubleVector w2i = DoubleVector.broadcast((VectorSpecies)DOUBLE_SPECIES, (double)((double)(-sign) * this.wi[index + 1])).mul((Vector)NEGATE_IM);
            DoubleVector w3i = DoubleVector.broadcast((VectorSpecies)DOUBLE_SPECIES, (double)((double)(-sign) * this.wi[index + 2])).mul((Vector)NEGATE_IM);
            DoubleVector w4i = DoubleVector.broadcast((VectorSpecies)DOUBLE_SPECIES, (double)((double)(-sign) * this.wi[index + 3])).mul((Vector)NEGATE_IM);
            DoubleVector w5i = DoubleVector.broadcast((VectorSpecies)DOUBLE_SPECIES, (double)((double)(-sign) * this.wi[index + 4])).mul((Vector)NEGATE_IM);
            int k12 = 0;
            while (k12 < this.innerLoopLimit) {
                DoubleVector z0 = DoubleVector.fromArray((VectorSpecies)DOUBLE_SPECIES, (double[])data, (int)i);
                DoubleVector z1 = DoubleVector.fromArray((VectorSpecies)DOUBLE_SPECIES, (double[])data, (int)(i + this.di));
                DoubleVector z2 = DoubleVector.fromArray((VectorSpecies)DOUBLE_SPECIES, (double[])data, (int)(i + this.di2));
                DoubleVector z3 = DoubleVector.fromArray((VectorSpecies)DOUBLE_SPECIES, (double[])data, (int)(i + this.di3));
                DoubleVector z4 = DoubleVector.fromArray((VectorSpecies)DOUBLE_SPECIES, (double[])data, (int)(i + this.di4));
                DoubleVector z5 = DoubleVector.fromArray((VectorSpecies)DOUBLE_SPECIES, (double[])data, (int)(i + this.di5));
                DoubleVector ta1 = z2.add((Vector)z4);
                DoubleVector ta2 = ta1.mul(-0.5).add((Vector)z0);
                DoubleVector ta3 = z2.sub((Vector)z4).mul(tau).rearrange(SHUFFLE_RE_IM);
                DoubleVector a0 = z0.add((Vector)ta1);
                DoubleVector a1 = ta3.fma((Vector)NEGATE_RE, (Vector)ta2);
                DoubleVector a2 = ta3.fma((Vector)NEGATE_IM, (Vector)ta2);
                DoubleVector tb1 = z5.add((Vector)z1);
                DoubleVector tb2 = tb1.mul(-0.5).add((Vector)z3);
                DoubleVector tb3 = z5.sub((Vector)z1).mul(tau).rearrange(SHUFFLE_RE_IM);
                DoubleVector b0 = z3.add((Vector)tb1);
                DoubleVector b1 = tb3.fma((Vector)NEGATE_RE, (Vector)tb2);
                DoubleVector b2 = tb3.fma((Vector)NEGATE_IM, (Vector)tb2);
                a0.add((Vector)b0).intoArray(ret, j);
                DoubleVector x1 = a1.sub((Vector)b1);
                DoubleVector x2 = a2.add((Vector)b2);
                DoubleVector x3 = a0.sub((Vector)b0);
                DoubleVector x4 = a1.add((Vector)b1);
                DoubleVector x5 = a2.sub((Vector)b2);
                w1r.fma((Vector)x1, (Vector)w1i.mul((Vector)x1).rearrange(SHUFFLE_RE_IM)).intoArray(ret, j + this.dj);
                w2r.fma((Vector)x2, (Vector)w2i.mul((Vector)x2).rearrange(SHUFFLE_RE_IM)).intoArray(ret, j + this.dj2);
                w3r.fma((Vector)x3, (Vector)w3i.mul((Vector)x3).rearrange(SHUFFLE_RE_IM)).intoArray(ret, j + this.dj3);
                w4r.fma((Vector)x4, (Vector)w4i.mul((Vector)x4).rearrange(SHUFFLE_RE_IM)).intoArray(ret, j + this.dj4);
                w5r.fma((Vector)x5, (Vector)w5i.mul((Vector)x5).rearrange(SHUFFLE_RE_IM)).intoArray(ret, j + this.dj5);
                k12 += INTERLEAVED_LOOP;
                i += LENGTH;
                j += LENGTH;
            }
            ++k;
            j += this.jstep;
        }
    }

    private void blocked(PassData passData) {
        double[] data = passData.in;
        double[] ret = passData.out;
        int sign = passData.sign;
        int i = passData.inOffset;
        int j = passData.outOffset;
        double tau = (double)sign * sqrt3_2;
        int k1 = 0;
        while (k1 < this.innerLoopLimit) {
            DoubleVector z0r = DoubleVector.fromArray((VectorSpecies)DOUBLE_SPECIES, (double[])data, (int)i);
            DoubleVector z1r = DoubleVector.fromArray((VectorSpecies)DOUBLE_SPECIES, (double[])data, (int)(i + this.di));
            DoubleVector z2r = DoubleVector.fromArray((VectorSpecies)DOUBLE_SPECIES, (double[])data, (int)(i + this.di2));
            DoubleVector z3r = DoubleVector.fromArray((VectorSpecies)DOUBLE_SPECIES, (double[])data, (int)(i + this.di3));
            DoubleVector z4r = DoubleVector.fromArray((VectorSpecies)DOUBLE_SPECIES, (double[])data, (int)(i + this.di4));
            DoubleVector z5r = DoubleVector.fromArray((VectorSpecies)DOUBLE_SPECIES, (double[])data, (int)(i + this.di5));
            DoubleVector z0i = DoubleVector.fromArray((VectorSpecies)DOUBLE_SPECIES, (double[])data, (int)(i + this.im));
            DoubleVector z1i = DoubleVector.fromArray((VectorSpecies)DOUBLE_SPECIES, (double[])data, (int)(i + this.di + this.im));
            DoubleVector z2i = DoubleVector.fromArray((VectorSpecies)DOUBLE_SPECIES, (double[])data, (int)(i + this.di2 + this.im));
            DoubleVector z3i = DoubleVector.fromArray((VectorSpecies)DOUBLE_SPECIES, (double[])data, (int)(i + this.di3 + this.im));
            DoubleVector z4i = DoubleVector.fromArray((VectorSpecies)DOUBLE_SPECIES, (double[])data, (int)(i + this.di4 + this.im));
            DoubleVector z5i = DoubleVector.fromArray((VectorSpecies)DOUBLE_SPECIES, (double[])data, (int)(i + this.di5 + this.im));
            DoubleVector ta1r = z2r.add((Vector)z4r);
            DoubleVector ta1i = z2i.add((Vector)z4i);
            DoubleVector ta2r = ta1r.mul(-0.5).add((Vector)z0r);
            DoubleVector ta2i = ta1i.mul(-0.5).add((Vector)z0i);
            DoubleVector ta3r = z2r.sub((Vector)z4r).mul(tau);
            DoubleVector ta3i = z2i.sub((Vector)z4i).mul(tau);
            DoubleVector a0r = z0r.add((Vector)ta1r);
            DoubleVector a0i = z0i.add((Vector)ta1i);
            DoubleVector a1r = ta2r.sub((Vector)ta3i);
            DoubleVector a1i = ta2i.add((Vector)ta3r);
            DoubleVector a2r = ta2r.add((Vector)ta3i);
            DoubleVector a2i = ta2i.sub((Vector)ta3r);
            DoubleVector tb1r = z5r.add((Vector)z1r);
            DoubleVector tb1i = z5i.add((Vector)z1i);
            DoubleVector tb2r = tb1r.mul(-0.5).add((Vector)z3r);
            DoubleVector tb2i = tb1i.mul(-0.5).add((Vector)z3i);
            DoubleVector tb3r = z5r.sub((Vector)z1r).mul(tau);
            DoubleVector tb3i = z5i.sub((Vector)z1i).mul(tau);
            DoubleVector b0r = z3r.add((Vector)tb1r);
            DoubleVector b0i = z3i.add((Vector)tb1i);
            DoubleVector b1r = tb2r.sub((Vector)tb3i);
            DoubleVector b1i = tb2i.add((Vector)tb3r);
            DoubleVector b2r = tb2r.add((Vector)tb3i);
            DoubleVector b2i = tb2i.sub((Vector)tb3r);
            a0r.add((Vector)b0r).intoArray(ret, j);
            a0i.add((Vector)b0i).intoArray(ret, j + this.im);
            a1r.sub((Vector)b1r).intoArray(ret, j + this.dj);
            a1i.sub((Vector)b1i).intoArray(ret, j + this.dj + this.im);
            a2r.add((Vector)b2r).intoArray(ret, j + this.dj2);
            a2i.add((Vector)b2i).intoArray(ret, j + this.dj2 + this.im);
            a0r.sub((Vector)b0r).intoArray(ret, j + this.dj3);
            a0i.sub((Vector)b0i).intoArray(ret, j + this.dj3 + this.im);
            a1r.add((Vector)b1r).intoArray(ret, j + this.dj4);
            a1i.add((Vector)b1i).intoArray(ret, j + this.dj4 + this.im);
            a2r.sub((Vector)b2r).intoArray(ret, j + this.dj5);
            a2i.sub((Vector)b2i).intoArray(ret, j + this.dj5 + this.im);
            k1 += BLOCK_LOOP;
            i += LENGTH;
            j += LENGTH;
        }
        j += this.jstep;
        int k = 1;
        while (k < this.outerLoopLimit) {
            int index = k * 5;
            double w1r = this.wr[index];
            double w2r = this.wr[index + 1];
            double w3r = this.wr[index + 2];
            double w4r = this.wr[index + 3];
            double w5r = this.wr[index + 4];
            double w1i = (double)(-sign) * this.wi[index];
            double w2i = (double)(-sign) * this.wi[index + 1];
            double w3i = (double)(-sign) * this.wi[index + 2];
            double w4i = (double)(-sign) * this.wi[index + 3];
            double w5i = (double)(-sign) * this.wi[index + 4];
            int k12 = 0;
            while (k12 < this.innerLoopLimit) {
                DoubleVector z0r = DoubleVector.fromArray((VectorSpecies)DOUBLE_SPECIES, (double[])data, (int)i);
                DoubleVector z1r = DoubleVector.fromArray((VectorSpecies)DOUBLE_SPECIES, (double[])data, (int)(i + this.di));
                DoubleVector z2r = DoubleVector.fromArray((VectorSpecies)DOUBLE_SPECIES, (double[])data, (int)(i + this.di2));
                DoubleVector z3r = DoubleVector.fromArray((VectorSpecies)DOUBLE_SPECIES, (double[])data, (int)(i + this.di3));
                DoubleVector z4r = DoubleVector.fromArray((VectorSpecies)DOUBLE_SPECIES, (double[])data, (int)(i + this.di4));
                DoubleVector z5r = DoubleVector.fromArray((VectorSpecies)DOUBLE_SPECIES, (double[])data, (int)(i + this.di5));
                DoubleVector z0i = DoubleVector.fromArray((VectorSpecies)DOUBLE_SPECIES, (double[])data, (int)(i + this.im));
                DoubleVector z1i = DoubleVector.fromArray((VectorSpecies)DOUBLE_SPECIES, (double[])data, (int)(i + this.di + this.im));
                DoubleVector z2i = DoubleVector.fromArray((VectorSpecies)DOUBLE_SPECIES, (double[])data, (int)(i + this.di2 + this.im));
                DoubleVector z3i = DoubleVector.fromArray((VectorSpecies)DOUBLE_SPECIES, (double[])data, (int)(i + this.di3 + this.im));
                DoubleVector z4i = DoubleVector.fromArray((VectorSpecies)DOUBLE_SPECIES, (double[])data, (int)(i + this.di4 + this.im));
                DoubleVector z5i = DoubleVector.fromArray((VectorSpecies)DOUBLE_SPECIES, (double[])data, (int)(i + this.di5 + this.im));
                DoubleVector ta1r = z2r.add((Vector)z4r);
                DoubleVector ta1i = z2i.add((Vector)z4i);
                DoubleVector ta2r = ta1r.mul(-0.5).add((Vector)z0r);
                DoubleVector ta2i = ta1i.mul(-0.5).add((Vector)z0i);
                DoubleVector ta3r = z2r.sub((Vector)z4r).mul(tau);
                DoubleVector ta3i = z2i.sub((Vector)z4i).mul(tau);
                DoubleVector a0r = z0r.add((Vector)ta1r);
                DoubleVector a0i = z0i.add((Vector)ta1i);
                DoubleVector a1r = ta2r.sub((Vector)ta3i);
                DoubleVector a1i = ta2i.add((Vector)ta3r);
                DoubleVector a2r = ta2r.add((Vector)ta3i);
                DoubleVector a2i = ta2i.sub((Vector)ta3r);
                DoubleVector tb1r = z5r.add((Vector)z1r);
                DoubleVector tb1i = z5i.add((Vector)z1i);
                DoubleVector tb2r = tb1r.mul(-0.5).add((Vector)z3r);
                DoubleVector tb2i = tb1i.mul(-0.5).add((Vector)z3i);
                DoubleVector tb3r = z5r.sub((Vector)z1r).mul(tau);
                DoubleVector tb3i = z5i.sub((Vector)z1i).mul(tau);
                DoubleVector b0r = z3r.add((Vector)tb1r);
                DoubleVector b0i = z3i.add((Vector)tb1i);
                DoubleVector b1r = tb2r.sub((Vector)tb3i);
                DoubleVector b1i = tb2i.add((Vector)tb3r);
                DoubleVector b2r = tb2r.add((Vector)tb3i);
                DoubleVector b2i = tb2i.sub((Vector)tb3r);
                a0r.add((Vector)b0r).intoArray(ret, j);
                a0i.add((Vector)b0i).intoArray(ret, j + this.im);
                DoubleVector x1r = a1r.sub((Vector)b1r);
                DoubleVector x1i = a1i.sub((Vector)b1i);
                DoubleVector x2r = a2r.add((Vector)b2r);
                DoubleVector x2i = a2i.add((Vector)b2i);
                DoubleVector x3r = a0r.sub((Vector)b0r);
                DoubleVector x3i = a0i.sub((Vector)b0i);
                DoubleVector x4r = a1r.add((Vector)b1r);
                DoubleVector x4i = a1i.add((Vector)b1i);
                DoubleVector x5r = a2r.sub((Vector)b2r);
                DoubleVector x5i = a2i.sub((Vector)b2i);
                x1r.mul(w1r).sub((Vector)x1i.mul(w1i)).intoArray(ret, j + this.dj);
                x2r.mul(w2r).sub((Vector)x2i.mul(w2i)).intoArray(ret, j + this.dj2);
                x3r.mul(w3r).sub((Vector)x3i.mul(w3i)).intoArray(ret, j + this.dj3);
                x4r.mul(w4r).sub((Vector)x4i.mul(w4i)).intoArray(ret, j + this.dj4);
                x5r.mul(w5r).sub((Vector)x5i.mul(w5i)).intoArray(ret, j + this.dj5);
                x1i.mul(w1r).add((Vector)x1r.mul(w1i)).intoArray(ret, j + this.dj + this.im);
                x2i.mul(w2r).add((Vector)x2r.mul(w2i)).intoArray(ret, j + this.dj2 + this.im);
                x3i.mul(w3r).add((Vector)x3r.mul(w3i)).intoArray(ret, j + this.dj3 + this.im);
                x4i.mul(w4r).add((Vector)x4r.mul(w4i)).intoArray(ret, j + this.dj4 + this.im);
                x5i.mul(w5r).add((Vector)x5r.mul(w5i)).intoArray(ret, j + this.dj5 + this.im);
                k12 += BLOCK_LOOP;
                i += LENGTH;
                j += LENGTH;
            }
            ++k;
            j += this.jstep;
        }
    }
}

