/*
 * Decompiled with CFR 0.152.
 */
package ffx.numerics.fft;

import ffx.numerics.fft.PassConstants;
import ffx.numerics.fft.PassData;
import jdk.incubator.vector.DoubleVector;
import jdk.incubator.vector.VectorShuffle;
import jdk.incubator.vector.VectorSpecies;

public abstract class MixedRadixFactor {
    private static final double[] negateReal = new double[]{-1.0, 1.0, -1.0, 1.0, -1.0, 1.0, -1.0, 1.0};
    private static final int[] shuffleMask = new int[]{1, 0, 3, 2, 5, 4, 7, 6};
    protected static final VectorSpecies<Double> DOUBLE_SPECIES = DoubleVector.SPECIES_PREFERRED;
    protected static final DoubleVector NEGATE_IM;
    protected static final DoubleVector NEGATE_RE;
    protected static final VectorShuffle<Double> SHUFFLE_RE_IM;
    protected static final int LENGTH;
    protected static final int INTERLEAVED_LOOP;
    protected static final int BLOCK_LOOP;
    protected static final DoubleVector NEGATE_IM_128;
    protected static final DoubleVector NEGATE_RE_128;
    protected static final VectorShuffle<Double> SHUFFLE_RE_IM_128;
    protected static final int LENGTH_128;
    protected static final int INTERLEAVED_LOOP_128;
    protected static final int BLOCK_LOOP_128;
    protected static final DoubleVector NEGATE_IM_256;
    protected static final DoubleVector NEGATE_RE_256;
    protected static final VectorShuffle<Double> SHUFFLE_RE_IM_256;
    protected static final int LENGTH_256;
    protected static final int INTERLEAVED_LOOP_256;
    protected static final int BLOCK_LOOP_256;
    protected static final DoubleVector NEGATE_IM_512;
    protected static final DoubleVector NEGATE_RE_512;
    protected static final VectorShuffle<Double> SHUFFLE_RE_IM_512;
    protected static final int LENGTH_512;
    protected static final int INTERLEAVED_LOOP_512;
    protected static final int BLOCK_LOOP_512;
    protected final int n;
    protected final int nFFTs;
    protected final int im;
    protected final int factor;
    protected final int product;
    protected final int outerLoopLimit;
    protected final int innerLoopLimit;
    protected final int nextInput;
    protected final int di;
    protected final int dj;
    protected final double[][] twiddles;
    protected final double[] wr;
    protected final double[] wi;
    protected final int ii;
    protected final int jstep;
    protected int simdWidth;

    public MixedRadixFactor(PassConstants passConstants) {
        this.n = passConstants.n();
        this.nFFTs = passConstants.nFFTs();
        this.im = passConstants.im();
        this.factor = passConstants.factor();
        this.product = passConstants.product();
        this.twiddles = passConstants.twiddles();
        this.outerLoopLimit = this.n / this.product;
        this.innerLoopLimit = this.product / this.factor * this.nFFTs;
        this.nextInput = this.n / this.factor * this.nFFTs;
        if (this.im == 1) {
            this.ii = 2;
            this.di = 2 * this.nextInput;
            this.dj = 2 * this.innerLoopLimit;
        } else {
            this.ii = 1;
            this.di = this.nextInput;
            this.dj = this.innerLoopLimit;
        }
        this.jstep = (this.factor - 1) * this.dj;
        int f1 = this.factor - 1;
        this.wr = new double[this.outerLoopLimit * f1];
        this.wi = new double[this.outerLoopLimit * f1];
        for (int k = 0; k < this.outerLoopLimit; ++k) {
            double[] twids = this.twiddles[k];
            int index = k * f1;
            for (int j = 0; j < f1; ++j) {
                this.wr[index + j] = twids[2 * j];
                this.wi[index + j] = twids[2 * j + 1];
            }
        }
        this.simdWidth = this.getOptimalSIMDWidth();
    }

    public String toString() {
        return " MixedRadixFactor {\n N: " + this.n + "\n Factor: " + this.factor + "\n Number of FFTs: " + this.nFFTs + "\n Next real value: " + this.ii + "\n Imaginary offset: " + this.im + "\n Product: " + this.product + "\n Outer Loop Limit: " + this.outerLoopLimit + "\n Inner Loop Limit: " + this.innerLoopLimit + "\n SIMD width: " + this.simdWidth + "\n Next input: " + this.nextInput + "\n Step between input values: " + this.di + "\n Step between output values: " + this.dj + "\n jstep =" + this.jstep + "}\n";
    }

    protected abstract void passScalar(PassData var1);

    protected boolean isValidSIMDWidth(int width) {
        if (width != LENGTH) {
            return false;
        }
        if (this.im == 1) {
            return this.innerLoopLimit % INTERLEAVED_LOOP == 0;
        }
        return this.innerLoopLimit % BLOCK_LOOP == 0;
    }

    protected int getOptimalSIMDWidth() {
        if (this.isValidSIMDWidth(LENGTH)) {
            return LENGTH;
        }
        return 0;
    }

    public int setSIMDWidth(int width) {
        this.simdWidth = this.isValidSIMDWidth(width) ? width : this.getOptimalSIMDWidth();
        return this.simdWidth;
    }

    protected abstract void passSIMD(PassData var1);

    protected static void multiplyAndStore(double x_r, double x_i, double w_r, double w_i, double[] ret, int re, int im) {
        ret[re] = Math.fma(w_r, x_r, -w_i * x_i);
        ret[im] = Math.fma(w_r, x_i, w_i * x_r);
    }

    static {
        LENGTH = DOUBLE_SPECIES.length();
        INTERLEAVED_LOOP = LENGTH / 2;
        BLOCK_LOOP = LENGTH;
        LENGTH_128 = DoubleVector.SPECIES_128.length();
        INTERLEAVED_LOOP_128 = LENGTH_128 / 2;
        BLOCK_LOOP_128 = LENGTH_128;
        LENGTH_256 = DoubleVector.SPECIES_256.length();
        INTERLEAVED_LOOP_256 = LENGTH_256 / 2;
        BLOCK_LOOP_256 = LENGTH_256;
        LENGTH_512 = DoubleVector.SPECIES_512.length();
        INTERLEAVED_LOOP_512 = LENGTH_512 / 2;
        BLOCK_LOOP_512 = LENGTH_512;
        if (LENGTH > 8) {
            throw new IllegalStateException("Unsupported SIMD vector size: " + LENGTH);
        }
        NEGATE_RE_128 = DoubleVector.fromArray((VectorSpecies)DoubleVector.SPECIES_128, (double[])negateReal, (int)0);
        NEGATE_IM_128 = NEGATE_RE_128.mul(-1.0);
        SHUFFLE_RE_IM_128 = VectorShuffle.fromArray((VectorSpecies)DoubleVector.SPECIES_128, (int[])shuffleMask, (int)0);
        NEGATE_RE_256 = DoubleVector.fromArray((VectorSpecies)DoubleVector.SPECIES_256, (double[])negateReal, (int)0);
        NEGATE_IM_256 = NEGATE_RE_256.mul(-1.0);
        SHUFFLE_RE_IM_256 = VectorShuffle.fromArray((VectorSpecies)DoubleVector.SPECIES_256, (int[])shuffleMask, (int)0);
        NEGATE_RE_512 = DoubleVector.fromArray((VectorSpecies)DoubleVector.SPECIES_512, (double[])negateReal, (int)0);
        NEGATE_IM_512 = NEGATE_RE_512.mul(-1.0);
        SHUFFLE_RE_IM_512 = VectorShuffle.fromArray((VectorSpecies)DoubleVector.SPECIES_512, (int[])shuffleMask, (int)0);
        switch (LENGTH) {
            case 2: {
                NEGATE_RE = NEGATE_RE_128;
                NEGATE_IM = NEGATE_IM_128;
                SHUFFLE_RE_IM = SHUFFLE_RE_IM_128;
                break;
            }
            case 4: {
                NEGATE_RE = NEGATE_RE_256;
                NEGATE_IM = NEGATE_IM_256;
                SHUFFLE_RE_IM = SHUFFLE_RE_IM_256;
                break;
            }
            case 8: {
                NEGATE_RE = NEGATE_RE_512;
                NEGATE_IM = NEGATE_IM_512;
                SHUFFLE_RE_IM = SHUFFLE_RE_IM_512;
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported SIMD DoubleVector size: " + LENGTH);
            }
        }
    }
}

