/*
 * Decompiled with CFR 0.152.
 */
package ffx.numerics.fft;

import edu.rit.pj.IntegerForLoop;
import edu.rit.pj.IntegerSchedule;
import edu.rit.pj.ParallelRegion;
import edu.rit.pj.ParallelTeam;
import ffx.numerics.fft.Complex;
import ffx.numerics.fft.Complex2D;
import ffx.numerics.fft.DataLayout1D;
import ffx.numerics.fft.DataLayout2D;
import ffx.numerics.fft.DataLayout3D;
import java.util.Arrays;
import java.util.Objects;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import jdk.incubator.vector.DoubleVector;
import jdk.incubator.vector.Vector;
import jdk.incubator.vector.VectorShuffle;
import jdk.incubator.vector.VectorSpecies;

public class Complex3DParallel {
    private static final Logger logger = Logger.getLogger(Complex3DParallel.class.getName());
    private final int nX;
    private final int nY;
    private final int nZ;
    private final int im;
    private final int ii;
    private final int nextX;
    private final int nextY;
    private final int nextZ;
    private final int trNextX;
    private final int trNextY;
    private final int trNextZ;
    private final double[] recip;
    private final int threadCount;
    private final ParallelTeam parallelTeam;
    private final Complex2D[] fftXY;
    private final Complex[] fftZ;
    private final int internalImZ;
    private final IntegerSchedule schedule;
    private final int nXm1;
    private final int nYm1;
    private final int nZm1;
    private final FFTRegion fftRegion;
    private final IFFTRegion ifftRegion;
    private final ConvolutionRegion convRegion;
    public double[] input;
    private boolean useSIMD;
    private final VectorSpecies<Double> species = DoubleVector.SPECIES_PREFERRED;
    private final int vectorSize = this.species.length();
    private final int[] shuffle = new int[]{0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7};
    private final VectorShuffle<Double> expandFirstHalf = VectorShuffle.fromArray(this.species, (int[])this.shuffle, (int)0);
    private final VectorShuffle<Double> expandSecondHalf = VectorShuffle.fromArray(this.species, (int[])this.shuffle, (int)this.vectorSize);
    private boolean packFFTs;
    private final boolean localZTranspose;
    public final double[] work3D;

    public Complex3DParallel(int nX, int nY, int nZ, ParallelTeam parallelTeam) {
        this(nX, nY, nZ, parallelTeam, DataLayout3D.INTERLEAVED);
    }

    public Complex3DParallel(int nX, int nY, int nZ, ParallelTeam parallelTeam, DataLayout3D dataLayout) {
        this(nX, nY, nZ, parallelTeam, null, dataLayout);
    }

    public Complex3DParallel(int nX, int nY, int nZ, ParallelTeam parallelTeam, @Nullable IntegerSchedule integerSchedule) {
        this(nX, nY, nZ, parallelTeam, integerSchedule, DataLayout3D.INTERLEAVED);
    }

    public Complex3DParallel(int nX, int nY, int nZ, ParallelTeam parallelTeam, @Nullable IntegerSchedule integerSchedule, DataLayout3D dataLayout) {
        int i;
        boolean local;
        DataLayout2D dataLayout2D;
        DataLayout1D dataLayout1D;
        this.nX = nX;
        this.nY = nY;
        this.nZ = nZ;
        this.parallelTeam = parallelTeam;
        this.recip = new double[nX * nY * nZ];
        switch (dataLayout) {
            default: {
                this.im = 1;
                this.ii = 2;
                this.nextX = 2;
                this.nextY = 2 * nX;
                this.nextZ = 2 * nX * nY;
                dataLayout1D = DataLayout1D.INTERLEAVED;
                dataLayout2D = DataLayout2D.INTERLEAVED;
                this.internalImZ = 1;
                this.trNextY = 2;
                this.trNextZ = 2 * nY;
                this.trNextX = 2 * nY * nZ;
                break;
            }
            case BLOCKED_X: {
                this.im = nX;
                this.ii = 1;
                this.nextX = 1;
                this.nextY = 2 * nX;
                this.nextZ = 2 * nX * nY;
                dataLayout1D = DataLayout1D.BLOCKED;
                dataLayout2D = DataLayout2D.BLOCKED_X;
                this.internalImZ = nY * nZ;
                this.trNextY = 1;
                this.trNextZ = nY;
                this.trNextX = 2 * nY * nZ;
                break;
            }
            case BLOCKED_XY: {
                this.im = nX * nY;
                this.ii = 1;
                this.nextX = 1;
                this.nextY = nX;
                this.nextZ = 2 * nY * nX;
                dataLayout1D = DataLayout1D.BLOCKED;
                dataLayout2D = DataLayout2D.BLOCKED_XY;
                this.internalImZ = nY * nZ;
                this.trNextY = 1;
                this.trNextZ = nY;
                this.trNextX = 2 * nY * nZ;
                break;
            }
            case BLOCKED_XYZ: {
                this.im = nX * nY * nZ;
                this.ii = 1;
                this.nextX = 1;
                this.nextY = nX;
                this.nextZ = nY * nX;
                dataLayout1D = DataLayout1D.BLOCKED;
                dataLayout2D = DataLayout2D.BLOCKED_XY;
                this.internalImZ = nY * nZ;
                this.trNextY = 1;
                this.trNextZ = nY;
                this.trNextX = 2 * nY * nZ;
            }
        }
        this.nXm1 = this.nX - 1;
        this.nYm1 = this.nY - 1;
        this.nZm1 = this.nZ - 1;
        this.threadCount = parallelTeam.getThreadCount();
        this.schedule = Objects.requireNonNullElseGet(integerSchedule, IntegerSchedule::fixed);
        this.useSIMD = true;
        String simd = System.getProperty("fft.simd", Boolean.toString(this.useSIMD));
        try {
            this.useSIMD = Boolean.parseBoolean(simd);
        }
        catch (Exception e) {
            this.useSIMD = false;
        }
        this.packFFTs = true;
        String pack = System.getProperty("fft.pack", Boolean.toString(this.packFFTs));
        try {
            this.packFFTs = Boolean.parseBoolean(pack);
        }
        catch (Exception e) {
            this.packFFTs = false;
        }
        String localTranspose = System.getProperty("fft.localZTranspose", "false");
        try {
            local = Boolean.parseBoolean(localTranspose);
        }
        catch (Exception e) {
            local = true;
        }
        this.localZTranspose = local;
        this.fftXY = new Complex2D[this.threadCount];
        for (i = 0; i < this.threadCount; ++i) {
            this.fftXY[i] = new Complex2D(nX, nY, dataLayout2D, this.im);
            this.fftXY[i].setPackFFTs(this.packFFTs);
            this.fftXY[i].setUseSIMD(this.useSIMD);
        }
        this.fftZ = new Complex[this.threadCount];
        for (i = 0; i < this.threadCount; ++i) {
            this.fftZ[i] = new Complex(nZ, dataLayout1D, this.internalImZ, nY);
            this.fftZ[i].setUseSIMD(this.useSIMD);
        }
        this.work3D = (double[])(this.localZTranspose ? null : new double[2 * nX * nY * nZ]);
        this.fftRegion = new FFTRegion(this);
        this.ifftRegion = new IFFTRegion(this);
        this.convRegion = new ConvolutionRegion(this);
    }

    public String toString() {
        return "Complex3DParallel {nX=" + this.nX + ", nY=" + this.nY + ", nZ=" + this.nZ + ", im=" + this.im + ", ii=" + this.ii + ", nextX=" + this.nextX + ", nextY=" + this.nextY + ", nextZ=" + this.nextZ + ", threadCount=" + this.threadCount + ", parallelTeam=" + String.valueOf(this.parallelTeam) + ", internalImZ=" + this.internalImZ + ", schedule=" + String.valueOf(this.schedule) + ", nXm1=" + this.nXm1 + ", nYm1=" + this.nYm1 + ", nZm1=" + this.nZm1 + ", fftRegion=" + String.valueOf((Object)this.fftRegion) + ", ifftRegion=" + String.valueOf((Object)this.ifftRegion) + ", convRegion=" + String.valueOf((Object)this.convRegion) + ", useSIMD=" + this.useSIMD + ", packFFTs=" + this.packFFTs + "}";
    }

    public void setUseSIMD(boolean useSIMD) {
        this.useSIMD = useSIMD;
        for (int i = 0; i < this.threadCount; ++i) {
            this.fftXY[i].setUseSIMD(useSIMD);
            this.fftZ[i].setUseSIMD(useSIMD);
        }
    }

    public void setPackFFTs(boolean packFFTs) {
        this.packFFTs = packFFTs;
        for (int i = 0; i < this.threadCount; ++i) {
            this.fftXY[i].setPackFFTs(packFFTs);
        }
    }

    public void convolution(double[] input) {
        this.input = input;
        try {
            this.parallelTeam.execute((ParallelRegion)this.convRegion);
        }
        catch (Exception e) {
            String message = "Fatal exception evaluating a convolution.\n";
            logger.log(Level.SEVERE, message, e);
        }
    }

    public void fft(double[] input) {
        this.input = input;
        try {
            this.parallelTeam.execute((ParallelRegion)this.fftRegion);
        }
        catch (Exception e) {
            String message = " Fatal exception evaluating the FFT.\n";
            logger.log(Level.SEVERE, message, e);
        }
    }

    public long[] getTiming() {
        return this.convRegion.getTiming();
    }

    public void ifft(double[] input) {
        this.input = input;
        try {
            this.parallelTeam.execute((ParallelRegion)this.ifftRegion);
        }
        catch (Exception e) {
            String message = "Fatal exception evaluating the inverse FFT.\n";
            logger.log(Level.SEVERE, message, e);
            System.exit(-1);
        }
    }

    public void initTiming() {
        this.convRegion.initTiming();
    }

    public String timingString() {
        return this.convRegion.timingString();
    }

    public void setRecip(double[] recip) {
        int recipNextY = this.nX;
        int recipNextZ = this.nY * this.nX;
        int index = 0;
        for (int x = 0; x < this.nX; ++x) {
            int dx = x;
            for (int z = 0; z < this.nZ; ++z) {
                int dz = dx + z * recipNextZ;
                for (int y = 0; y < this.nY; ++y) {
                    int conv = y * recipNextY + dz;
                    this.recip[index] = recip[conv];
                    ++index;
                }
            }
        }
    }

    private void recipConv(int recipOffset, double[] work, int workOffset) {
        if (this.useSIMD && this.internalImZ == 1) {
            this.recipConvSIMD(recipOffset, work, workOffset);
        } else {
            this.recipConvScalar(recipOffset, work, workOffset);
        }
    }

    private void recipConvScalar(int recipOffset, double[] work, int workOffset) {
        int index = workOffset;
        int rindex = recipOffset;
        for (int i = 0; i < this.nY * this.nZ; ++i) {
            double r = this.recip[rindex++];
            int n = index;
            work[n] = work[n] * r;
            int n2 = index + this.internalImZ;
            work[n2] = work[n2] * r;
            index += this.ii;
        }
    }

    private void recipConvSIMD(int recipOffset, double[] work, int workOffset) {
        int i;
        if (this.internalImZ != 1) {
            logger.severe(" Real and imaginary parts must be interleaved.");
        }
        int length = this.nY * this.nZ * 2;
        int vectorSize2 = this.vectorSize * 2;
        int vectorizedLength = length / vectorSize2 * vectorSize2;
        for (i = 0; i < vectorizedLength; i += vectorSize2) {
            DoubleVector recipVector = DoubleVector.fromArray(this.species, (double[])this.recip, (int)(recipOffset + i / 2));
            DoubleVector complexVector = DoubleVector.fromArray(this.species, (double[])work, (int)(workOffset + i));
            DoubleVector firstHalf = recipVector.rearrange(this.expandFirstHalf);
            complexVector = complexVector.mul((Vector)firstHalf);
            complexVector.intoArray(work, workOffset + i);
            complexVector = DoubleVector.fromArray(this.species, (double[])work, (int)(workOffset + this.vectorSize + i));
            DoubleVector secondHalf = recipVector.rearrange(this.expandSecondHalf);
            complexVector = complexVector.mul((Vector)secondHalf);
            complexVector.intoArray(work, workOffset + this.vectorSize + i);
        }
        while (i < length) {
            double r = this.recip[recipOffset + i / 2];
            int n = workOffset + i;
            work[n] = work[n] * r;
            int n2 = workOffset + i + this.internalImZ;
            work[n2] = work[n2] * r;
            i += 2;
        }
    }

    private void transpose(double[] input, int inputOffset, double[] output) {
        for (int z = 0; z < this.nZ; ++z) {
            for (int y = 0; y < this.nY; ++y) {
                double real = input[inputOffset + y * this.nextY + z * this.nextZ];
                double imag = input[inputOffset + y * this.nextY + z * this.nextZ + this.im];
                output[y * this.trNextY + z * this.trNextZ] = real;
                output[y * this.trNextY + z * this.trNextZ + this.internalImZ] = imag;
            }
        }
    }

    private void unTranspose(double[] input, int inputOffset, double[] output) {
        for (int z = 0; z < this.nZ; ++z) {
            for (int y = 0; y < this.nY; ++y) {
                double real = output[y * this.trNextY + z * this.trNextZ];
                double imag = output[y * this.trNextY + z * this.trNextZ + this.internalImZ];
                input[inputOffset + y * this.nextY + z * this.nextZ] = real;
                input[inputOffset + y * this.nextY + z * this.nextZ + this.im] = imag;
            }
        }
    }

    public static double[] initRandomData(final int dim, ParallelTeam parallelTeam) {
        int n = dim * dim * dim;
        final double[] data = new double[2 * n];
        try {
            parallelTeam.execute(new ParallelRegion(){

                public void run() {
                    try {
                        this.execute(0, dim - 1, new IntegerForLoop(this){
                            {
                                Objects.requireNonNull(this$0);
                            }

                            public void run(int lb, int ub) {
                                Random randomNumberGenerator = new Random(1L);
                                int index = dim * dim * lb * 2;
                                for (int i = lb; i <= ub; ++i) {
                                    for (int j = 0; j < dim; ++j) {
                                        for (int k = 0; k < dim; ++k) {
                                            double randomNumber;
                                            data[index] = randomNumber = randomNumberGenerator.nextDouble();
                                            index += 2;
                                        }
                                    }
                                }
                            }
                        });
                    }
                    catch (Exception e) {
                        System.out.println(e.getMessage());
                        System.exit(-1);
                    }
                }
            });
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            System.exit(-1);
        }
        return data;
    }

    public static void main(String[] args) throws Exception {
        long time;
        int i;
        Complex3DParallel complex3DParallel;
        Complex3DParallel complex3D;
        int dimNotFinal = 128;
        int nCPU = ParallelTeam.getDefaultThreadCount();
        int reps = 5;
        boolean blocked = false;
        try {
            dimNotFinal = Integer.parseInt(args[0]);
            if (dimNotFinal < 1) {
                dimNotFinal = 100;
            }
            if ((nCPU = Integer.parseInt(args[1])) < 1) {
                nCPU = ParallelTeam.getDefaultThreadCount();
            }
            if ((reps = Integer.parseInt(args[2])) < 1) {
                reps = 5;
            }
            blocked = Boolean.parseBoolean(args[3]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        int dim = dimNotFinal;
        System.out.printf("Initializing a %d cubed grid for %d CPUs.\nThe best timing out of %d repetitions will be used.%n", dim, nCPU, reps);
        ParallelTeam parallelTeam = new ParallelTeam(nCPU);
        ParallelTeam parallelTeam1 = new ParallelTeam(1);
        if (blocked) {
            complex3D = new Complex3DParallel(dim, dim, dim, parallelTeam1, DataLayout3D.BLOCKED_X);
            complex3DParallel = new Complex3DParallel(dim, dim, dim, parallelTeam, DataLayout3D.BLOCKED_X);
        } else {
            complex3D = new Complex3DParallel(dim, dim, dim, parallelTeam1, DataLayout3D.INTERLEAVED);
            complex3DParallel = new Complex3DParallel(dim, dim, dim, parallelTeam, DataLayout3D.INTERLEAVED);
        }
        int dimCubed = dim * dim * dim;
        double[] data = Complex3DParallel.initRandomData(dim, parallelTeam);
        double[] work = new double[dimCubed];
        Arrays.fill(work, 1.0);
        double toSeconds = 1.0E-9;
        long seqTime = Long.MAX_VALUE;
        long parTime = Long.MAX_VALUE;
        long seqTimeConv = Long.MAX_VALUE;
        long parTimeConv = Long.MAX_VALUE;
        complex3D.setRecip(work);
        complex3DParallel.setRecip(work);
        System.out.println("Warm Up Sequential FFT");
        complex3D.fft(data);
        System.out.println("Warm Up Sequential IFFT");
        complex3D.ifft(data);
        System.out.println("Warm Up Sequential Convolution");
        complex3D.convolution(data);
        for (i = 0; i < reps; ++i) {
            System.out.printf(" Iteration %d%n", i + 1);
            time = System.nanoTime();
            complex3D.fft(data);
            complex3D.ifft(data);
            time = System.nanoTime() - time;
            System.out.printf("  Sequential FFT:  %9.6f (sec)%n", toSeconds * (double)time);
            if (time < seqTime) {
                seqTime = time;
            }
            time = System.nanoTime();
            complex3D.convolution(data);
            time = System.nanoTime() - time;
            System.out.printf("  Sequential Conv: %9.6f (sec)%n", toSeconds * (double)time);
            if (time >= seqTimeConv) continue;
            seqTimeConv = time;
        }
        System.out.println("Warm up Parallel FFT");
        complex3DParallel.fft(data);
        System.out.println("Warm up Parallel IFFT");
        complex3DParallel.ifft(data);
        System.out.println("Warm up Parallel Convolution");
        complex3DParallel.convolution(data);
        complex3DParallel.initTiming();
        for (i = 0; i < reps; ++i) {
            if (i == reps / 2) {
                complex3DParallel.initTiming();
            }
            System.out.printf(" Iteration %d%n", i + 1);
            time = System.nanoTime();
            complex3DParallel.fft(data);
            complex3DParallel.ifft(data);
            time = System.nanoTime() - time;
            System.out.printf("  Parallel FFT:  %9.6f (sec)%n", toSeconds * (double)time);
            if (time < parTime) {
                parTime = time;
            }
            time = System.nanoTime();
            complex3DParallel.convolution(data);
            time = System.nanoTime() - time;
            System.out.printf("  Parallel Conv: %9.6f (sec)%n", toSeconds * (double)time);
            if (time >= parTimeConv) continue;
            parTimeConv = time;
        }
        System.out.printf(" Best Sequential FFT Time:   %9.6f (sec)%n", toSeconds * (double)seqTime);
        System.out.printf(" Best Sequential Conv. Time: %9.6f (sec)%n", toSeconds * (double)seqTimeConv);
        System.out.printf(" Best Parallel FFT Time:     %9.6f (sec)%n", toSeconds * (double)parTime);
        System.out.printf(" Best Parallel Conv. Time:   %9.6f (sec)%n", toSeconds * (double)parTimeConv);
        System.out.printf(" 3D FFT Speedup:             %9.6f X%n", (double)seqTime / (double)parTime);
        System.out.printf(" 3D Conv Speedup:            %9.6f X%n", (double)seqTimeConv / (double)parTimeConv);
        System.out.printf(" Parallel Convolution Timings:\n" + complex3DParallel.timingString(), new Object[0]);
        parallelTeam.shutdown();
        parallelTeam1.shutdown();
    }

    private class FFTRegion
    extends ParallelRegion {
        private final FFTXYLoop[] fftXYLoop;
        private final FFTZLoop[] fftZLoop;
        private final TransposeLoop[] transposeLoop;
        private final UnTransposeLoop[] unTransposeLoop;
        final /* synthetic */ Complex3DParallel this$0;

        private FFTRegion(Complex3DParallel complex3DParallel) {
            int i;
            Complex3DParallel complex3DParallel2 = complex3DParallel;
            Objects.requireNonNull(complex3DParallel2);
            this.this$0 = complex3DParallel2;
            this.fftXYLoop = new FFTXYLoop[complex3DParallel.threadCount];
            this.fftZLoop = new FFTZLoop[complex3DParallel.threadCount];
            for (i = 0; i < complex3DParallel.threadCount; ++i) {
                this.fftXYLoop[i] = new FFTXYLoop(complex3DParallel);
                this.fftZLoop[i] = new FFTZLoop(complex3DParallel);
            }
            if (!complex3DParallel.localZTranspose) {
                this.transposeLoop = new TransposeLoop[complex3DParallel.threadCount];
                this.unTransposeLoop = new UnTransposeLoop[complex3DParallel.threadCount];
                for (i = 0; i < complex3DParallel.threadCount; ++i) {
                    this.transposeLoop[i] = new TransposeLoop(complex3DParallel);
                    this.unTransposeLoop[i] = new UnTransposeLoop(complex3DParallel);
                }
            } else {
                this.transposeLoop = null;
                this.unTransposeLoop = null;
            }
        }

        public void run() {
            int threadIndex = this.getThreadIndex();
            try {
                if (this.this$0.localZTranspose) {
                    this.execute(0, this.this$0.nZm1, this.fftXYLoop[threadIndex]);
                    this.execute(0, this.this$0.nXm1, this.fftZLoop[threadIndex]);
                } else {
                    this.execute(0, this.this$0.nZm1, this.fftXYLoop[threadIndex]);
                    this.execute(0, this.this$0.nXm1, this.transposeLoop[threadIndex]);
                    this.execute(0, this.this$0.nXm1, this.fftZLoop[threadIndex]);
                    this.execute(0, this.this$0.nZm1, this.unTransposeLoop[threadIndex]);
                }
            }
            catch (Exception e) {
                logger.severe(e.toString());
            }
        }
    }

    private class IFFTRegion
    extends ParallelRegion {
        private final IFFTXYLoop[] ifftXYLoop;
        private final IFFTZLoop[] ifftZLoop;
        private final TransposeLoop[] transposeLoop;
        private final UnTransposeLoop[] unTransposeLoop;
        final /* synthetic */ Complex3DParallel this$0;

        private IFFTRegion(Complex3DParallel complex3DParallel) {
            int i;
            Complex3DParallel complex3DParallel2 = complex3DParallel;
            Objects.requireNonNull(complex3DParallel2);
            this.this$0 = complex3DParallel2;
            this.ifftXYLoop = new IFFTXYLoop[complex3DParallel.threadCount];
            this.ifftZLoop = new IFFTZLoop[complex3DParallel.threadCount];
            for (i = 0; i < complex3DParallel.threadCount; ++i) {
                this.ifftXYLoop[i] = new IFFTXYLoop(complex3DParallel);
                this.ifftZLoop[i] = new IFFTZLoop(complex3DParallel);
            }
            if (!complex3DParallel.localZTranspose) {
                this.transposeLoop = new TransposeLoop[complex3DParallel.threadCount];
                this.unTransposeLoop = new UnTransposeLoop[complex3DParallel.threadCount];
                for (i = 0; i < complex3DParallel.threadCount; ++i) {
                    this.transposeLoop[i] = new TransposeLoop(complex3DParallel);
                    this.unTransposeLoop[i] = new UnTransposeLoop(complex3DParallel);
                }
            } else {
                this.transposeLoop = null;
                this.unTransposeLoop = null;
            }
        }

        public void run() {
            int threadIndex = this.getThreadIndex();
            try {
                if (this.this$0.localZTranspose) {
                    this.execute(0, this.this$0.nXm1, this.ifftZLoop[threadIndex]);
                    this.execute(0, this.this$0.nZm1, this.ifftXYLoop[threadIndex]);
                } else {
                    this.execute(0, this.this$0.nXm1, this.transposeLoop[threadIndex]);
                    this.execute(0, this.this$0.nXm1, this.ifftZLoop[threadIndex]);
                    this.execute(0, this.this$0.nZm1, this.unTransposeLoop[threadIndex]);
                    this.execute(0, this.this$0.nZm1, this.ifftXYLoop[threadIndex]);
                }
            }
            catch (Exception e) {
                logger.severe(e.toString());
            }
        }
    }

    private class ConvolutionRegion
    extends ParallelRegion {
        private final FFTXYLoop[] fftXYLoop;
        private final TransposeLoop[] transposeLoop;
        private final FFTZIZLoop[] fftZIZLoop;
        private final UnTransposeLoop[] unTransposeLoop;
        private final IFFTXYLoop[] ifftXYLoop;
        private final long[] convTime;
        final /* synthetic */ Complex3DParallel this$0;

        private ConvolutionRegion(Complex3DParallel complex3DParallel) {
            int i;
            Complex3DParallel complex3DParallel2 = complex3DParallel;
            Objects.requireNonNull(complex3DParallel2);
            this.this$0 = complex3DParallel2;
            this.fftXYLoop = new FFTXYLoop[complex3DParallel.threadCount];
            this.fftZIZLoop = new FFTZIZLoop[complex3DParallel.threadCount];
            this.ifftXYLoop = new IFFTXYLoop[complex3DParallel.threadCount];
            this.convTime = new long[complex3DParallel.threadCount];
            for (i = 0; i < complex3DParallel.threadCount; ++i) {
                this.fftXYLoop[i] = new FFTXYLoop(complex3DParallel);
                this.fftZIZLoop[i] = new FFTZIZLoop(complex3DParallel);
                this.ifftXYLoop[i] = new IFFTXYLoop(complex3DParallel);
            }
            if (!complex3DParallel.localZTranspose) {
                this.transposeLoop = new TransposeLoop[complex3DParallel.threadCount];
                this.unTransposeLoop = new UnTransposeLoop[complex3DParallel.threadCount];
                for (i = 0; i < complex3DParallel.threadCount; ++i) {
                    this.transposeLoop[i] = new TransposeLoop(complex3DParallel);
                    this.unTransposeLoop[i] = new UnTransposeLoop(complex3DParallel);
                }
            } else {
                this.transposeLoop = null;
                this.unTransposeLoop = null;
            }
        }

        public void initTiming() {
            int i;
            for (i = 0; i < this.this$0.threadCount; ++i) {
                this.fftXYLoop[i].time = 0L;
                this.fftZIZLoop[i].time = 0L;
                this.ifftXYLoop[i].time = 0L;
            }
            if (!this.this$0.localZTranspose) {
                for (i = 0; i < this.this$0.threadCount; ++i) {
                    this.transposeLoop[i].time = 0L;
                    this.unTransposeLoop[i].time = 0L;
                }
            }
        }

        public long[] getTiming() {
            if (this.this$0.localZTranspose) {
                for (int i = 0; i < this.this$0.threadCount; ++i) {
                    this.convTime[i] = this.this$0.convRegion.fftXYLoop[i].time + this.this$0.convRegion.fftZIZLoop[i].time + this.this$0.convRegion.ifftXYLoop[i].time;
                }
            } else {
                for (int i = 0; i < this.this$0.threadCount; ++i) {
                    this.convTime[i] = this.this$0.convRegion.fftXYLoop[i].time + this.this$0.convRegion.transposeLoop[i].time + this.this$0.convRegion.fftZIZLoop[i].time + this.this$0.convRegion.unTransposeLoop[i].time + this.this$0.convRegion.ifftXYLoop[i].time;
                }
            }
            return this.convTime;
        }

        public String timingString() {
            StringBuilder sb = new StringBuilder();
            if (this.this$0.localZTranspose) {
                double xysum = 0.0;
                double zizsum = 0.0;
                double ixysum = 0.0;
                for (int i = 0; i < this.this$0.threadCount; ++i) {
                    double fftxy = (double)this.fftXYLoop[i].getTime() * 1.0E-9;
                    double ziz = (double)this.fftZIZLoop[i].getTime() * 1.0E-9;
                    double ifftxy = (double)this.ifftXYLoop[i].getTime() * 1.0E-9;
                    String s = String.format("  Thread %3d: FFTXY=%8.6f, FFTZIZ=%8.6f, IFFTXY=%8.6f\n", i, fftxy, ziz, ifftxy);
                    sb.append(s);
                    xysum += fftxy;
                    zizsum += ziz;
                    ixysum += ifftxy;
                }
                String s = String.format("  Sum       : FFTXY=%8.6f, FFTZIZ=%8.6f, IFFTXY=%8.6f\n", xysum, zizsum, ixysum);
                sb.append(s);
            } else {
                double xysum = 0.0;
                double transsum = 0.0;
                double zizsum = 0.0;
                double untranssum = 0.0;
                double ixysum = 0.0;
                for (int i = 0; i < this.this$0.threadCount; ++i) {
                    double fftxy = (double)this.fftXYLoop[i].getTime() * 1.0E-9;
                    double trans = (double)this.transposeLoop[i].getTime() * 1.0E-9;
                    double ziz = (double)this.fftZIZLoop[i].getTime() * 1.0E-9;
                    double untrans = (double)this.unTransposeLoop[i].getTime() * 1.0E-9;
                    double ifftxy = (double)this.ifftXYLoop[i].getTime() * 1.0E-9;
                    String s = String.format("  Thread %3d: FFTXY=%8.6f, Trans=%8.6f, FFTZIZ=%8.6f, UnTrans=%8.6f, IFFTXY=%8.6f\n", i, fftxy, trans, ziz, untrans, ifftxy);
                    sb.append(s);
                    xysum += fftxy;
                    transsum += trans;
                    zizsum += ziz;
                    untranssum += untrans;
                    ixysum += ifftxy;
                }
                String s = String.format("  Sum       : FFTXY=%8.6f, Trans=%8.6f, FFTZIZ=%8.6f, UnTrans=%8.6f, IFFTXY=%8.6f\n", xysum, transsum, zizsum, untranssum, ixysum);
                sb.append(s);
            }
            return sb.toString();
        }

        public void run() {
            int threadIndex = this.getThreadIndex();
            try {
                if (this.this$0.localZTranspose) {
                    this.execute(0, this.this$0.nZm1, this.fftXYLoop[threadIndex]);
                    this.execute(0, this.this$0.nXm1, this.fftZIZLoop[threadIndex]);
                    this.execute(0, this.this$0.nZm1, this.ifftXYLoop[threadIndex]);
                } else {
                    this.execute(0, this.this$0.nZm1, this.fftXYLoop[threadIndex]);
                    this.execute(0, this.this$0.nXm1, this.transposeLoop[threadIndex]);
                    this.execute(0, this.this$0.nXm1, this.fftZIZLoop[threadIndex]);
                    this.execute(0, this.this$0.nZm1, this.unTransposeLoop[threadIndex]);
                    this.execute(0, this.this$0.nZm1, this.ifftXYLoop[threadIndex]);
                }
            }
            catch (Exception e) {
                logger.severe(e.toString());
            }
        }
    }

    private class UnTransposeLoop
    extends IntegerForLoop {
        private long time;
        final /* synthetic */ Complex3DParallel this$0;

        private UnTransposeLoop(Complex3DParallel complex3DParallel) {
            Complex3DParallel complex3DParallel2 = complex3DParallel;
            Objects.requireNonNull(complex3DParallel2);
            this.this$0 = complex3DParallel2;
        }

        public void run(int lb, int ub) {
            for (int z = lb; z <= ub; ++z) {
                int trZ = z * this.this$0.trNextZ;
                int iZ = z * this.this$0.nextZ;
                for (int x = 0; x < this.this$0.nX; ++x) {
                    int y;
                    int trZX = trZ + x * this.this$0.trNextX;
                    int iZX = iZ + x * this.this$0.nextX;
                    for (y = 0; y < this.this$0.nY - 3; y += 4) {
                        int w1 = y * this.this$0.trNextY + trZX;
                        int w2 = w1 + this.this$0.trNextY;
                        int w3 = w2 + this.this$0.trNextY;
                        int w4 = w3 + this.this$0.trNextY;
                        int i1 = y * this.this$0.nextY + iZX;
                        int i2 = i1 + this.this$0.nextY;
                        int i3 = i2 + this.this$0.nextY;
                        int i4 = i3 + this.this$0.nextY;
                        this.this$0.input[i1] = this.this$0.work3D[w1];
                        this.this$0.input[i1 + this.this$0.im] = this.this$0.work3D[w1 + this.this$0.internalImZ];
                        this.this$0.input[i2] = this.this$0.work3D[w2];
                        this.this$0.input[i2 + this.this$0.im] = this.this$0.work3D[w2 + this.this$0.internalImZ];
                        this.this$0.input[i3] = this.this$0.work3D[w3];
                        this.this$0.input[i3 + this.this$0.im] = this.this$0.work3D[w3 + this.this$0.internalImZ];
                        this.this$0.input[i4] = this.this$0.work3D[w4];
                        this.this$0.input[i4 + this.this$0.im] = this.this$0.work3D[w4 + this.this$0.internalImZ];
                    }
                    while (y < this.this$0.nY) {
                        int workIndex = y * this.this$0.trNextY + trZX;
                        int inputIndex = y * this.this$0.nextY + iZX;
                        this.this$0.input[inputIndex] = this.this$0.work3D[workIndex];
                        this.this$0.input[inputIndex + this.this$0.im] = this.this$0.work3D[workIndex + this.this$0.internalImZ];
                        ++y;
                    }
                }
            }
        }

        public IntegerSchedule schedule() {
            return IntegerSchedule.fixed();
        }

        public long getTime() {
            return this.time;
        }

        public void finish() {
            this.time += System.nanoTime();
        }

        public void start() {
            this.time -= System.nanoTime();
        }
    }

    private class TransposeLoop
    extends IntegerForLoop {
        private long time;
        final /* synthetic */ Complex3DParallel this$0;

        private TransposeLoop(Complex3DParallel complex3DParallel) {
            Complex3DParallel complex3DParallel2 = complex3DParallel;
            Objects.requireNonNull(complex3DParallel2);
            this.this$0 = complex3DParallel2;
        }

        public void run(int lb, int ub) {
            if (this.this$0.internalImZ == 1) {
                for (int z = 0; z < this.this$0.nZ; ++z) {
                    for (int x = lb; x <= ub; ++x) {
                        int i1;
                        int y = 0;
                        int i = 0;
                        int iZX = x * this.this$0.nextX + z * this.this$0.nextZ;
                        int trZX = x * this.this$0.trNextX + z * this.this$0.trNextZ;
                        while (y < this.this$0.nY - 3) {
                            i1 = iZX + y * this.this$0.nextY;
                            int i2 = i1 + this.this$0.nextY;
                            int i3 = i2 + this.this$0.nextY;
                            int i4 = i3 + this.this$0.nextY;
                            int dest = trZX + y * this.this$0.trNextY;
                            this.this$0.work3D[dest] = this.this$0.input[i1];
                            this.this$0.work3D[dest + 1] = this.this$0.input[i1 + this.this$0.im];
                            this.this$0.work3D[dest + 2] = this.this$0.input[i2];
                            this.this$0.work3D[dest + 3] = this.this$0.input[i2 + this.this$0.im];
                            this.this$0.work3D[dest + 4] = this.this$0.input[i3];
                            this.this$0.work3D[dest + 5] = this.this$0.input[i3 + this.this$0.im];
                            this.this$0.work3D[dest + 6] = this.this$0.input[i4];
                            this.this$0.work3D[dest + 7] = this.this$0.input[i4 + this.this$0.im];
                            y += 4;
                            i += 8;
                        }
                        while (y < this.this$0.nY) {
                            i1 = iZX + y * this.this$0.nextY;
                            int dest = trZX + y * this.this$0.trNextY;
                            this.this$0.work3D[dest] = this.this$0.input[i1];
                            this.this$0.work3D[dest + 1] = this.this$0.input[i1 + this.this$0.im];
                            ++y;
                            i += 2;
                        }
                    }
                }
            } else {
                for (int z = 0; z < this.this$0.nZ; ++z) {
                    for (int x = lb; x <= ub; ++x) {
                        int i1;
                        int y = 0;
                        int i = 0;
                        int iZX = x * this.this$0.nextX + z * this.this$0.nextZ;
                        int trZX = x * this.this$0.trNextX + z * this.this$0.trNextZ;
                        while (y < this.this$0.nY - 3) {
                            i1 = iZX + y * this.this$0.nextY;
                            int i2 = i1 + this.this$0.nextY;
                            int i3 = i2 + this.this$0.nextY;
                            int i4 = i3 + this.this$0.nextY;
                            int destPos = trZX + y * this.this$0.trNextY;
                            this.this$0.work3D[destPos] = this.this$0.input[i1];
                            this.this$0.work3D[destPos + 1] = this.this$0.input[i2];
                            this.this$0.work3D[destPos + 2] = this.this$0.input[i3];
                            this.this$0.work3D[destPos + 3] = this.this$0.input[i4];
                            this.this$0.work3D[destPos + this.this$0.internalImZ] = this.this$0.input[i1 + this.this$0.im];
                            this.this$0.work3D[destPos + 1 + this.this$0.internalImZ] = this.this$0.input[i2 + this.this$0.im];
                            this.this$0.work3D[destPos + 2 + this.this$0.internalImZ] = this.this$0.input[i3 + this.this$0.im];
                            this.this$0.work3D[destPos + 3 + this.this$0.internalImZ] = this.this$0.input[i4 + this.this$0.im];
                            y += 4;
                            i += 4;
                        }
                        while (y < this.this$0.nY) {
                            i1 = iZX + y * this.this$0.nextY;
                            int destPos = trZX + y * this.this$0.trNextY;
                            this.this$0.work3D[destPos] = this.this$0.input[i1];
                            this.this$0.work3D[destPos + this.this$0.internalImZ] = this.this$0.input[i1 + this.this$0.im];
                            ++y;
                            ++i;
                        }
                    }
                }
            }
        }

        public IntegerSchedule schedule() {
            return IntegerSchedule.fixed();
        }

        public long getTime() {
            return this.time;
        }

        public void finish() {
            this.time += System.nanoTime();
        }

        public void start() {
            this.time -= System.nanoTime();
        }
    }

    private class FFTZIZLoop
    extends IntegerForLoop {
        private Complex localFFTZ;
        private long time;
        private final double[] work;
        final /* synthetic */ Complex3DParallel this$0;

        private FFTZIZLoop(Complex3DParallel complex3DParallel) {
            Complex3DParallel complex3DParallel2 = complex3DParallel;
            Objects.requireNonNull(complex3DParallel2);
            this.this$0 = complex3DParallel2;
            this.work = (double[])(complex3DParallel.localZTranspose ? new double[2 * complex3DParallel.nY * complex3DParallel.nZ] : null);
        }

        public void run(int lb, int ub) {
            if (this.this$0.localZTranspose) {
                for (int x = lb; x <= ub; ++x) {
                    int inputOffset = x * this.this$0.nextX;
                    this.this$0.transpose(this.this$0.input, inputOffset, this.work);
                    this.localFFTZ.fft(this.work, 0, this.this$0.ii);
                    int recipOffset = x * this.this$0.nY * this.this$0.nZ;
                    this.this$0.recipConv(recipOffset, this.work, 0);
                    this.localFFTZ.ifft(this.work, 0, this.this$0.ii);
                    this.this$0.unTranspose(this.this$0.input, inputOffset, this.work);
                }
            } else {
                for (int x = lb; x <= ub; ++x) {
                    int offset = x * this.this$0.nY * this.this$0.nZ * this.this$0.ii;
                    this.localFFTZ.fft(this.this$0.work3D, offset, this.this$0.ii);
                    int recipOffset = x * this.this$0.nY * this.this$0.nZ;
                    this.this$0.recipConv(recipOffset, this.this$0.work3D, offset);
                    this.localFFTZ.ifft(this.this$0.work3D, offset, this.this$0.ii);
                }
            }
        }

        public IntegerSchedule schedule() {
            return this.this$0.schedule;
        }

        public long getTime() {
            return this.time;
        }

        public void finish() {
            this.time += System.nanoTime();
        }

        public void start() {
            this.time -= System.nanoTime();
            int threadID = this.getThreadIndex();
            this.localFFTZ = this.this$0.fftZ[threadID];
        }
    }

    private class IFFTZLoop
    extends IntegerForLoop {
        private Complex localFFTZ;
        private long time;
        private final double[] work;
        final /* synthetic */ Complex3DParallel this$0;

        private IFFTZLoop(Complex3DParallel complex3DParallel) {
            Complex3DParallel complex3DParallel2 = complex3DParallel;
            Objects.requireNonNull(complex3DParallel2);
            this.this$0 = complex3DParallel2;
            this.work = (double[])(complex3DParallel.localZTranspose ? new double[2 * complex3DParallel.nY * complex3DParallel.nZ] : null);
        }

        public void run(int lb, int ub) {
            if (this.this$0.localZTranspose) {
                for (int x = lb; x <= ub; ++x) {
                    int inputOffset = x * this.this$0.nextX;
                    this.this$0.transpose(this.this$0.input, inputOffset, this.work);
                    this.localFFTZ.ifft(this.work, 0, this.this$0.ii);
                    this.this$0.unTranspose(this.this$0.input, inputOffset, this.work);
                }
            } else {
                for (int x = lb; x <= ub; ++x) {
                    int offset = x * this.this$0.nY * this.this$0.nZ * this.this$0.ii;
                    this.localFFTZ.ifft(this.this$0.work3D, offset, this.this$0.ii);
                }
            }
        }

        public IntegerSchedule schedule() {
            return this.this$0.schedule;
        }

        public long getTime() {
            return this.time;
        }

        public void finish() {
            this.time += System.nanoTime();
        }

        public void start() {
            this.time -= System.nanoTime();
            int threadID = this.getThreadIndex();
            this.localFFTZ = this.this$0.fftZ[threadID];
        }
    }

    private class FFTZLoop
    extends IntegerForLoop {
        private Complex localFFTZ;
        private long time;
        private final double[] work;
        final /* synthetic */ Complex3DParallel this$0;

        private FFTZLoop(Complex3DParallel complex3DParallel) {
            Complex3DParallel complex3DParallel2 = complex3DParallel;
            Objects.requireNonNull(complex3DParallel2);
            this.this$0 = complex3DParallel2;
            this.work = (double[])(complex3DParallel.localZTranspose ? new double[2 * complex3DParallel.nY * complex3DParallel.nZ] : null);
        }

        public void run(int lb, int ub) {
            if (this.this$0.localZTranspose) {
                for (int x = lb; x <= ub; ++x) {
                    int inputOffset = x * this.this$0.nextX;
                    this.this$0.transpose(this.this$0.input, inputOffset, this.work);
                    this.localFFTZ.fft(this.work, 0, this.this$0.ii);
                    this.this$0.unTranspose(this.this$0.input, inputOffset, this.work);
                }
            } else {
                for (int x = lb; x <= ub; ++x) {
                    int offset = x * this.this$0.nY * this.this$0.nZ * this.this$0.ii;
                    this.localFFTZ.fft(this.this$0.work3D, offset, this.this$0.ii);
                }
            }
        }

        public IntegerSchedule schedule() {
            return this.this$0.schedule;
        }

        public long getTime() {
            return this.time;
        }

        public void finish() {
            this.time += System.nanoTime();
        }

        public void start() {
            this.time -= System.nanoTime();
            int threadID = this.getThreadIndex();
            this.localFFTZ = this.this$0.fftZ[threadID];
        }
    }

    private class IFFTXYLoop
    extends IntegerForLoop {
        private Complex2D localFFTXY;
        private long time;
        final /* synthetic */ Complex3DParallel this$0;

        private IFFTXYLoop(Complex3DParallel complex3DParallel) {
            Complex3DParallel complex3DParallel2 = complex3DParallel;
            Objects.requireNonNull(complex3DParallel2);
            this.this$0 = complex3DParallel2;
        }

        public void run(int lb, int ub) {
            for (int z = lb; z <= ub; ++z) {
                int offset = z * this.this$0.nextZ;
                this.localFFTXY.ifft(this.this$0.input, offset);
            }
        }

        public IntegerSchedule schedule() {
            return this.this$0.schedule;
        }

        public long getTime() {
            return this.time;
        }

        public void finish() {
            this.time += System.nanoTime();
        }

        public void start() {
            this.time -= System.nanoTime();
            this.localFFTXY = this.this$0.fftXY[this.getThreadIndex()];
        }
    }

    private class FFTXYLoop
    extends IntegerForLoop {
        private Complex2D localFFTXY;
        private long time;
        final /* synthetic */ Complex3DParallel this$0;

        private FFTXYLoop(Complex3DParallel complex3DParallel) {
            Complex3DParallel complex3DParallel2 = complex3DParallel;
            Objects.requireNonNull(complex3DParallel2);
            this.this$0 = complex3DParallel2;
        }

        public void run(int lb, int ub) {
            for (int z = lb; z <= ub; ++z) {
                int offset = z * this.this$0.nextZ;
                this.localFFTXY.fft(this.this$0.input, offset);
            }
        }

        public IntegerSchedule schedule() {
            return this.this$0.schedule;
        }

        public long getTime() {
            return this.time;
        }

        public void finish() {
            this.time += System.nanoTime();
        }

        public void start() {
            this.time -= System.nanoTime();
            this.localFFTXY = this.this$0.fftXY[this.getThreadIndex()];
        }
    }
}

