/*
 * Decompiled with CFR 0.152.
 */
package ffx.numerics.fft;

import ffx.numerics.fft.Complex;
import ffx.numerics.fft.DataLayout1D;
import java.util.Random;

public class Complex1D {
    private final int n;
    private final int nX;
    private final Complex fftX;
    private final int nextX;
    private final int nY;
    private final Complex fftY;
    private final int nextY;
    private final DataLayout1D dataLayout;
    private final int externalIm;
    private final DataLayout1D internalDataLayout;
    private final int ii;
    private final int internalIm;
    private final double[] buffer;
    private final int trNextX;
    private final int trNextY;

    public Complex1D(int n) {
        this(n, DataLayout1D.INTERLEAVED, 1);
    }

    public Complex1D(int n, DataLayout1D dataLayout, int imOffset) {
        this.n = n;
        this.dataLayout = dataLayout;
        this.externalIm = imOffset;
        int[] factors = Complex.factor(n);
        if (factors.length == 1) {
            this.nX = n;
            this.nY = 1;
            this.fftX = new Complex(this.nX, dataLayout, imOffset);
            this.fftY = null;
            this.internalDataLayout = null;
            this.buffer = null;
            this.internalIm = -1;
            this.ii = -1;
            this.nextX = -1;
            this.nextY = -1;
            this.trNextX = -1;
            this.trNextY = 1;
        } else {
            int n1 = 1;
            int n2 = 1;
            for (int i = 0; i < factors.length; ++i) {
                if (i % 2 == 0) {
                    n1 *= factors[i];
                    continue;
                }
                n2 *= factors[i];
            }
            this.nX = n1;
            this.nY = n2;
            this.buffer = new double[n * 2];
            this.internalDataLayout = dataLayout;
            if (dataLayout == DataLayout1D.INTERLEAVED) {
                this.nextX = 2;
                this.nextY = 2 * this.nX;
                this.trNextY = 2;
                this.trNextX = 2 * this.nY;
                this.ii = 2;
                this.internalIm = 1;
            } else {
                this.nextX = 1;
                this.nextY = this.nX;
                this.trNextY = 1;
                this.trNextX = this.nY;
                this.ii = 1;
                this.internalIm = this.nX * this.nY;
            }
            this.fftY = new Complex(this.nY, dataLayout, this.externalIm, this.nX);
            this.fftX = new Complex(this.nX, this.internalDataLayout, this.internalIm, this.nY);
        }
    }

    public void fft(double[] data, int offset, int stride) {
        this.fftY.fft(data, offset, stride);
        this.fftX.fft(this.buffer, 0, 2);
    }

    public void ifft(double[] data, int offset, int stride) {
    }

    private void transpose(double[] input, int offset) {
        int index = 0;
        for (int x = 0; x < this.nX; ++x) {
            int dx = offset + x * this.nextX;
            for (int y = 0; y < this.nY; ++y) {
                double real = input[dx + y * this.nextY];
                double imag = input[dx + y * this.nextY + this.externalIm];
                this.buffer[index] = real;
                this.buffer[index + this.internalIm] = imag;
                index += this.ii;
            }
        }
    }

    private void unTranspose(double[] output, int offset) {
        int index = offset;
        for (int y = 0; y < this.nY; ++y) {
            int dy = y * this.trNextY;
            for (int x = 0; x < this.nX; ++x) {
                double real = this.buffer[dy + x * this.trNextX];
                double imag = this.buffer[dy + x * this.trNextX + this.internalIm];
                output[index] = real;
                output[index + this.externalIm] = imag;
                index += this.ii;
            }
        }
    }

    public static void main(String[] args) throws Exception {
        int dimNotFinal = 128;
        int reps = 5;
        try {
            dimNotFinal = Integer.parseInt(args[0]);
            if (dimNotFinal < 1) {
                dimNotFinal = 128;
            }
            if ((reps = Integer.parseInt(args[1])) < 1) {
                reps = 5;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        int dim = dimNotFinal;
        System.out.printf("Initializing a 1D array of length %d.\nThe best timing out of %d repetitions will be used.%n", dim, reps);
        Complex1D complex = new Complex1D(dim);
        double[] data = new double[dim * 2];
        Random random = new Random(1L);
        for (int i = 0; i < dim; ++i) {
            data[2 * i] = random.nextDouble();
        }
        double toSeconds = 1.0E-9;
        long seqTime = Long.MAX_VALUE;
        for (int i = 0; i < reps; ++i) {
            System.out.printf("Iteration %d%n", i + 1);
            long time = System.nanoTime();
            complex.fft(data, 0, 2);
            complex.ifft(data, 0, 2);
            time = System.nanoTime() - time;
            System.out.printf("Sequential: %12.9f%n", toSeconds * (double)time);
            if (time >= seqTime) continue;
            seqTime = time;
        }
        System.out.printf("Best Sequential Time:  %12.9f%n", toSeconds * (double)seqTime);
    }
}

