/*
 * Decompiled with CFR 0.152.
 */
package ffx.numerics.estimator;

import ffx.numerics.estimator.MultistateBennettAcceptanceRatio;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Logger;
import org.apache.commons.lang3.math.NumberUtils;

public class MBARFilter {
    private static final Logger logger = Logger.getLogger(MBARFilter.class.getName());
    private File[] barFiles;
    private final File fileLocation;
    private double[][][] eAll;
    private double[][] eAllFlat;
    private double[] temperatures;
    private int[] snaps;
    private final int[] numLambdas;
    private int windowsRead;
    private int windows;
    private MultistateBennettAcceptanceRatio mbar;
    private int startIndex = -1;
    private int endIndex = -1;
    private int numLambda;
    private boolean oneFile = false;

    public MBARFilter(File fileLocation, boolean continuousLambda) {
        this.fileLocation = fileLocation;
        this.barFiles = fileLocation.listFiles((dir, name) -> name.matches("energy_\\d+.mbar") || name.matches("energy_\\d+.bar"));
        assert (this.barFiles != null);
        if (this.barFiles.length == 0) {
            logger.severe(" No files matching 'energy_\\d+.mbar' or 'energy_\\d+.bar' found in " + fileLocation.getAbsolutePath());
        }
        Arrays.sort(this.barFiles, (f1, f2) -> {
            int state1 = Integer.parseInt(f1.getName().split("\\.")[0].split("_")[1]);
            int state2 = Integer.parseInt(f2.getName().split("\\.")[0].split("_")[1]);
            return Integer.compare(state1, state2);
        });
        this.windows = this.barFiles.length;
        this.temperatures = new double[this.windows];
        this.snaps = new int[this.windows];
        this.numLambdas = new int[this.windows];
        if (continuousLambda) {
            this.parseFile();
            this.oneFile = true;
        } else {
            this.parseFiles();
        }
    }

    public MultistateBennettAcceptanceRatio getMBAR(MultistateBennettAcceptanceRatio.SeedType seedType) {
        return this.getMBAR(seedType, 1.0E-7);
    }

    public MultistateBennettAcceptanceRatio getMBAR(MultistateBennettAcceptanceRatio.SeedType seedType, double tolerance) {
        double[] lambda = new double[this.windows];
        for (int i = 0; i < this.windows; ++i) {
            lambda[i] = (double)i / ((double)this.windows - 1.0);
        }
        this.mbar = this.eAll != null ? new MultistateBennettAcceptanceRatio(lambda, this.eAll, this.temperatures, tolerance, seedType) : new MultistateBennettAcceptanceRatio(lambda, this.snaps, this.eAllFlat, this.temperatures, tolerance, seedType);
        return this.mbar;
    }

    public MultistateBennettAcceptanceRatio[] getPeriodComparisonMBAR(MultistateBennettAcceptanceRatio.SeedType seedType, double tolerance) {
        double[] lambda = new double[this.windows];
        for (int i = 0; i < this.windows; ++i) {
            lambda[i] = (double)i / ((double)this.windows - 1.0);
        }
        MultistateBennettAcceptanceRatio[] mbar = new MultistateBennettAcceptanceRatio[10];
        for (int i = 0; i < 10; ++i) {
            double[][][] e = new double[this.windows][][];
            int maxSamples = NumberUtils.max((int[])this.snaps);
            int timePeriod = maxSamples / 10;
            for (int j = 0; j < this.windows; ++j) {
                e[j] = new double[this.windows][];
                for (int k = 0; k < this.windows; ++k) {
                    e[j][k] = new double[timePeriod];
                    if (timePeriod * (i + 1) > maxSamples) {
                        System.arraycopy(this.eAll[j][k], timePeriod * i, e[j][k], 0, maxSamples - timePeriod * i);
                        continue;
                    }
                    System.arraycopy(this.eAll[j][k], timePeriod * i, e[j][k], 0, timePeriod);
                }
            }
            logger.info(" Period: " + timePeriod * i + " - " + timePeriod * (i + 1) + " samples calculation.");
            mbar[i] = new MultistateBennettAcceptanceRatio(lambda, e, this.temperatures, tolerance, seedType);
        }
        return mbar;
    }

    private void parseFiles() {
        int maxSnaps;
        int minSnaps;
        boolean warn;
        this.eAll = new double[this.windows][][];
        for (int i = 0; i < this.windows; ++i) {
            this.eAll[i] = this.readFile(this.barFiles[i].getName(), i);
        }
        if (this.windowsRead != this.windows) {
            logger.severe("Failed to read all files in " + this.fileLocation.getAbsolutePath());
        }
        boolean bl = warn = (minSnaps = NumberUtils.min((int[])this.snaps)) != (maxSnaps = NumberUtils.max((int[])this.snaps));
        if (warn) {
            logger.warning("NOT ALL FILES CONTAINED THE SAME NUMBER OF SNAPSHOTS. ");
            logger.warning("SAMPLES PER WINDOW: " + Arrays.toString(this.snaps));
            double[][][] temp = new double[this.eAll.length][this.eAll[0].length][maxSnaps];
            for (int j = 0; j < this.windows; ++j) {
                for (int k = 0; k < this.windows; ++k) {
                    System.arraycopy(this.eAll[j][k], 0, temp[j][k], 0, this.snaps[j]);
                    for (int l = this.snaps[j]; l < maxSnaps; ++l) {
                        temp[j][k][l] = Double.NaN;
                    }
                }
            }
            this.eAll = temp;
        }
        int maxLambdas = NumberUtils.max((int[])this.numLambdas);
        for (int i = 0; i < this.windows; ++i) {
            if (this.numLambdas[i] == maxLambdas) continue;
            logger.severe(" Number of lambda evaluations in file " + this.barFiles[i].getName() + " does not match the number of lambda evaluations in the other files. This is unrecoverable.");
        }
        boolean bl2 = warn = maxLambdas != this.windows;
        if (warn) {
            String symbol = maxLambdas > this.windows ? "MORE" : "LESS";
            logger.warning("FILES CONTAIN " + symbol + " LAMBDA EVALUATIONS THAN ACTUAL TRAJECTORIES.");
            if (this.windows == 1) {
                logger.warning(" USE --continuousLambda FLAG IF USING A SINGLE FILE.");
            }
            symbol = maxLambdas > this.windows ? "Add" : "Remove";
            logger.severe(symbol + " completely empty files (zero lines) to fill in the gaps.");
        }
    }

    private void parseFile() {
        this.eAllFlat = this.readFile(this.barFiles[0].getName(), 0);
        this.snaps = new int[this.numLambda];
        for (int i = 0; i < this.numLambda; ++i) {
            this.snaps[i] = this.eAllFlat[i].length;
        }
        this.windows = this.numLambda;
        double temp = this.temperatures[0];
        this.temperatures = new double[this.windows];
        for (int i = 0; i < this.windows; ++i) {
            this.temperatures[i] = temp;
        }
    }

    public void writeFiles(File mbarFileLoc, double[][][] energies, double[] temperatures) {
        if (temperatures.length != this.windows) {
            double temp = temperatures[0];
            temperatures = new double[this.windows];
            for (int i = 0; i < this.windows; ++i) {
                temperatures[i] = temp;
            }
        }
        for (int i = 0; i < this.windows; ++i) {
            File file = new File(mbarFileLoc, "energy_" + i + ".mbar");
            this.writeFile(energies[i], file, temperatures[i]);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private double[][] readFile(String fileName, int state) {
        File tempBarFile = new File(this.fileLocation, fileName);
        ArrayList tempFileEnergies = new ArrayList();
        for (int i = 0; i < this.windows; ++i) {
            tempFileEnergies.add(new ArrayList());
        }
        try (FileReader fr1 = new FileReader(tempBarFile);
             BufferedReader br1 = new BufferedReader(fr1);){
            int count;
            String[] tokens;
            String line = br1.readLine();
            if (line != null) {
                tokens = line.trim().split("\\t *| +");
                this.temperatures[state] = Double.parseDouble(tokens[1]);
                count = 0;
                this.numLambda = 0;
                line = br1.readLine();
            } else {
                int i;
                for (i = 0; i < this.windows; ++i) {
                    ((ArrayList)tempFileEnergies.get(i)).add(Double.NaN);
                }
                this.snaps[state] = 0;
                this.temperatures[state] = 298.0;
                MultistateBennettAcceptanceRatio.FORCE_ZEROS_SEED = true;
                if (state != 0) {
                    this.numLambdas[state] = this.numLambdas[state - 1];
                }
                ++this.windowsRead;
                double[][] fileEnergies = new double[this.windows][];
                i = 0;
                while (true) {
                    if (i >= this.windows) {
                        double[][] i2 = fileEnergies;
                        return i2;
                    }
                    fileEnergies[i] = new double[((ArrayList)tempFileEnergies.get(i)).size()];
                    for (int j = 0; j < ((ArrayList)tempFileEnergies.get(i)).size(); ++j) {
                        fileEnergies[i][j] = (Double)((ArrayList)tempFileEnergies.get(i)).get(j);
                    }
                    ++i;
                }
            }
            while (line != null) {
                tokens = line.trim().split("\\t *| +");
                this.numLambda = tokens.length - 1;
                for (int i = 1; i < tokens.length; ++i) {
                    if (tempFileEnergies.size() < i) {
                        tempFileEnergies.add(new ArrayList());
                    }
                    ((ArrayList)tempFileEnergies.get(i - 1)).add(Double.parseDouble(tokens[i]));
                }
                ++count;
                line = br1.readLine();
            }
            this.numLambdas[state] = this.numLambda;
            if (state != 0 && this.numLambdas[0] == 0) {
                this.numLambdas[0] = this.numLambda;
            }
            this.snaps[state] = count;
        }
        catch (IOException e) {
            logger.info("Failed to read MBAR file: " + tempBarFile.getAbsolutePath());
            throw new RuntimeException(e);
        }
        double[][] fileEnergies = new double[tempFileEnergies.size()][];
        int i = 0;
        while (true) {
            if (i >= tempFileEnergies.size()) {
                ++this.windowsRead;
                return fileEnergies;
            }
            fileEnergies[i] = new double[((ArrayList)tempFileEnergies.get(i)).size()];
            for (int j = 0; j < ((ArrayList)tempFileEnergies.get(i)).size(); ++j) {
                fileEnergies[i][j] = (Double)((ArrayList)tempFileEnergies.get(i)).get(j);
            }
            ++i;
        }
    }

    public void writeFile(double[][] energies, File file, double temperature) {
        MultistateBennettAcceptanceRatio.writeFile(energies, file, temperature);
    }

    public void setStartSnapshot(int startIndex) {
        this.startIndex = startIndex;
        if (this.oneFile) {
            for (int i = 0; i < this.eAllFlat.length; ++i) {
                try {
                    this.eAllFlat[i] = Arrays.copyOfRange(this.eAllFlat[i], startIndex, this.eAllFlat[i].length);
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    logger.severe("Start index " + startIndex + " is out of bounds for file " + this.barFiles[i].getName());
                }
            }
        } else {
            for (int i = 0; i < this.eAll.length; ++i) {
                for (int j = 0; j < this.eAll[0].length; ++j) {
                    try {
                        this.eAll[i][j] = Arrays.copyOfRange(this.eAll[i][j], startIndex, this.eAll[i][j].length);
                        continue;
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        logger.severe("Start index " + startIndex + " is out of bounds for file " + this.barFiles[i].getName());
                    }
                }
            }
        }
    }

    public void setEndSnapshot(int endIndex) {
        this.endIndex = endIndex;
        if (this.oneFile) {
            for (int i = 0; i < this.eAllFlat.length; ++i) {
                try {
                    this.eAllFlat[i] = Arrays.copyOfRange(this.eAllFlat[i], 0, endIndex);
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    logger.severe("End index " + endIndex + " is out of bounds for file " + this.barFiles[i].getName());
                }
            }
        } else {
            for (int i = 0; i < this.eAll.length; ++i) {
                for (int j = 0; j < this.eAll[0].length; ++j) {
                    try {
                        this.eAll[i][j] = Arrays.copyOfRange(this.eAll[i][j], 0, endIndex);
                        continue;
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        logger.severe("End index " + endIndex + " is out of bounds for file " + this.barFiles[i].getName());
                    }
                }
            }
        }
    }

    public boolean readObservableData(boolean multiDataObservable, boolean isBiasData, boolean isDerivativeData) {
        if (isDerivativeData && !isBiasData) {
            this.barFiles = this.fileLocation.listFiles((dir, name) -> name.matches("derivative_\\d+.mbar") || name.matches("derivative_\\d+.bar") || name.matches("derivatives_\\d+.mbar") || name.matches("derivatives_\\d+.bar") || name.matches("observable_\\d+.mbar") || name.matches("observable_\\d+.bar"));
        } else if (isBiasData) {
            this.barFiles = this.fileLocation.listFiles((dir, name) -> name.matches("bias_\\d+.mbar") || name.matches("bias_\\d+.bar"));
        }
        if (this.barFiles == null || this.barFiles.length == 0) {
            return false;
        }
        Arrays.sort(this.barFiles, (f1, f2) -> {
            int state1 = Integer.parseInt(f1.getName().split("\\.")[0].split("_")[1]);
            int state2 = Integer.parseInt(f2.getName().split("\\.")[0].split("_")[1]);
            return Integer.compare(state1, state2);
        });
        if (this.oneFile) {
            this.eAllFlat = this.readFile(this.barFiles[0].getName(), 0);
            multiDataObservable = this.eAllFlat.length != this.numLambda;
        } else {
            int maxSnaps;
            boolean warn;
            this.eAll = new double[this.windows][][];
            for (int i = 0; i < this.windows; ++i) {
                this.eAll[i] = this.readFile(this.barFiles[i].getName(), i);
            }
            int minSnaps = NumberUtils.min((int[])this.snaps);
            boolean bl = warn = minSnaps != (maxSnaps = NumberUtils.max((int[])this.snaps));
            if (warn) {
                double[][][] temp = new double[this.eAll.length][this.eAll[0].length][maxSnaps];
                for (int j = 0; j < this.windows; ++j) {
                    for (int k = 0; k < this.windows; ++k) {
                        System.arraycopy(this.eAll[j][k], 0, temp[j][k], 0, this.snaps[j]);
                        for (int l = this.snaps[j]; l < maxSnaps; ++l) {
                            temp[j][k][l] = Double.NaN;
                        }
                    }
                }
                this.eAll = temp;
            }
        }
        if (this.startIndex != -1) {
            this.setStartSnapshot(this.startIndex);
        }
        if (this.endIndex != -1) {
            this.setEndSnapshot(this.endIndex);
        }
        if (isBiasData) {
            if (!this.oneFile) {
                this.mbar.setBiasData(this.eAll, multiDataObservable);
            } else {
                this.mbar.setBiasData(this.eAllFlat);
            }
        } else if (!this.oneFile) {
            this.mbar.setObservableData(this.eAll, multiDataObservable, false);
        } else {
            this.mbar.setObservableData(this.eAllFlat, false);
        }
        return true;
    }
}

