/*
 * Decompiled with CFR 0.152.
 */
package ffx.numerics.estimator;

import ffx.numerics.estimator.BootstrappableEstimator;
import ffx.numerics.math.RunningStatistics;
import ffx.numerics.math.SummaryStatistics;
import java.util.Arrays;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.logging.Logger;
import org.apache.commons.math3.util.FastMath;

public class EstimateBootstrapper {
    private static final Logger logger = Logger.getLogger(EstimateBootstrapper.class.getName());
    private static final int DEFAULT_LOG_INTERVAL = 100;
    private final BootstrappableEstimator estimate;
    private final int nWindows;
    private final SummaryStatistics[] freeEnergyDifferenceResults;
    private final SummaryStatistics[] enthalpyResults;

    public EstimateBootstrapper(BootstrappableEstimator estimator) {
        this.estimate = estimator;
        this.nWindows = this.estimate.getNumberOfBins();
        this.freeEnergyDifferenceResults = new SummaryStatistics[this.nWindows];
        this.enthalpyResults = new SummaryStatistics[this.nWindows];
    }

    public static int[] getBootstrapIndices(int length) {
        return EstimateBootstrapper.getBootstrapIndices(length, ThreadLocalRandom.current());
    }

    public static int[] getBootstrapIndices(int length, Random random) {
        return EstimateBootstrapper.getBootstrapIndices(length, random, Math.min(2, length));
    }

    public static int[] getBootstrapIndices(int length, Random random, int minDistinct) {
        switch (length) {
            case 0: {
                return new int[0];
            }
            case 1: {
                return new int[]{0};
            }
            case 2: {
                int[] indices = new int[]{random.nextBoolean() ? 0 : 1, random.nextBoolean() ? 0 : 1};
                return indices;
            }
        }
        int[] indices = random.ints(length, 0, length).toArray();
        long distinctVal = Arrays.stream(indices).distinct().count();
        int ctr = 0;
        while (distinctVal <= (long)minDistinct) {
            logger.info(String.format(" Regenerating array (iteration %d): only %d distinct values found for length %d.", ++ctr, distinctVal, length));
            indices = random.ints(length, 0, length).toArray();
            distinctVal = Arrays.stream(indices).distinct().count();
        }
        return indices;
    }

    public SummaryStatistics[] getEnthalpyResults() {
        return this.enthalpyResults;
    }

    public void bootstrap(long trials) {
        this.bootstrap(trials, 100L);
    }

    public void bootstrap(long trials, long logInterval) {
        RunningStatistics[] windows = new RunningStatistics[this.nWindows];
        RunningStatistics[] enthalpyWindows = new RunningStatistics[this.nWindows];
        for (int i = 0; i < this.nWindows; ++i) {
            windows[i] = new RunningStatistics();
            enthalpyWindows[i] = new RunningStatistics();
        }
        for (long i = 0L; i < trials; ++i) {
            if ((i + 1L) % logInterval == 0L) {
                logger.fine(String.format(" Bootstrap Trial %d", i + 1L));
            }
            this.estimate.estimateDG(true);
            double[] fe = this.estimate.getFreeEnergyDifferences();
            double[] enthalpy = this.estimate.getEnthalpyDifferences();
            for (int j = 0; j < this.nWindows; ++j) {
                windows[j].addValue(fe[j]);
                enthalpyWindows[j].addValue(enthalpy[j]);
            }
        }
        for (int i = 0; i < this.nWindows; ++i) {
            this.freeEnergyDifferenceResults[i] = new SummaryStatistics(windows[i]);
            this.enthalpyResults[i] = new SummaryStatistics(enthalpyWindows[i]);
        }
    }

    public double getTotalFreeEnergyDifference() {
        return this.getTotalFreeEnergyDifference(this.getFreeEnergyDifferences());
    }

    public double getTotalEnthalpyChange() {
        return this.getTotalEnthalpyChange(this.getEnthalpyChanges());
    }

    public double getTotalEntropyChange() {
        double dG = this.getTotalFreeEnergyDifference();
        double dH = this.getTotalEnthalpyChange();
        return dG - dH;
    }

    public double[] getFreeEnergyDifferences() {
        return Arrays.stream(this.freeEnergyDifferenceResults).mapToDouble(SummaryStatistics::getMean).toArray();
    }

    public double[] getEnthalpyChanges() {
        return Arrays.stream(this.enthalpyResults).mapToDouble(SummaryStatistics::getMean).toArray();
    }

    public double[] getEntropyChanges() {
        double[] dG = this.getFreeEnergyDifferences();
        double[] dH = this.getEnthalpyChanges();
        double[] dS = new double[this.nWindows];
        for (int i = 0; i < this.nWindows; ++i) {
            dS[i] = dG[i] - dH[i];
        }
        return dS;
    }

    public double getTotalFEDifferenceUncertainty() {
        return this.getTotalFEDifferenceUncertainty(this.getFEDifferenceVariances());
    }

    public double getTotalEnthalpyUncertainty() {
        return this.getTotalEnthalpyUncertainty(this.getEnthalpyVariances());
    }

    public double getTotalEntropyUncertainty() {
        double dG = this.getTotalFEDifferenceUncertainty();
        double dH = this.getTotalEnthalpyUncertainty();
        return FastMath.sqrt((double)(dG * dG + dH * dH));
    }

    public double[] getFEDifferenceStdDevs() {
        return Arrays.stream(this.freeEnergyDifferenceResults).mapToDouble(SummaryStatistics::getSd).toArray();
    }

    public double[] getEnthalpyStdDevs() {
        return Arrays.stream(this.enthalpyResults).mapToDouble(SummaryStatistics::getSd).toArray();
    }

    public double[] getEntropyStdDevs() {
        double[] dG = this.getFEDifferenceStdDevs();
        double[] dH = this.getEnthalpyStdDevs();
        double[] dS = new double[this.nWindows];
        for (int i = 0; i < this.nWindows; ++i) {
            dS[i] = FastMath.sqrt((double)(dG[i] * dG[i] + dH[i] * dH[i]));
        }
        return dS;
    }

    public double getTotalFreeEnergyDifference(double[] freeEnergyDifferences) {
        return this.estimate.getTotalFreeEnergyDifference(freeEnergyDifferences);
    }

    public double[] getFEDifferenceVariances() {
        return Arrays.stream(this.freeEnergyDifferenceResults).mapToDouble(SummaryStatistics::getVar).toArray();
    }

    public double getTotalFEDifferenceUncertainty(double[] variances) {
        return this.estimate.getTotalFEDifferenceUncertainty(variances);
    }

    public double getTotalEnthalpyChange(double[] enthalpyChanges) {
        return this.estimate.getTotalFreeEnergyDifference(enthalpyChanges);
    }

    public double getTotalEnthalpyUncertainty(double[] variances) {
        return this.estimate.getTotalEnthalpyUncertainty(variances);
    }

    public double[] getEnthalpyVariances() {
        return Arrays.stream(this.enthalpyResults).mapToDouble(SummaryStatistics::getVar).toArray();
    }
}

