/*
 * Decompiled with CFR 0.152.
 */
package ffx.numerics.estimator;

import ffx.numerics.estimator.StatisticalEstimator;
import java.util.Arrays;
import org.apache.commons.math3.util.FastMath;

public interface BootstrappableEstimator
extends StatisticalEstimator {
    public BootstrappableEstimator copyEstimator();

    public void estimateDG(boolean var1);

    default public void estimateDG() {
        this.estimateDG(false);
    }

    default public double getTotalFreeEnergyDifference(double[] freeEnergyDifferences) {
        return Arrays.stream(freeEnergyDifferences).sum();
    }

    default public double getTotalFEDifferenceUncertainty(double[] variances) {
        return FastMath.sqrt((double)Arrays.stream(variances).sum());
    }

    default public double getTotalEnthalpyDifference(double[] enthalpyDifferences) {
        return Arrays.stream(enthalpyDifferences).sum();
    }

    default public double getTotalEnthalpyUncertainty(double[] enthalpyVariances) {
        return FastMath.sqrt((double)Arrays.stream(enthalpyVariances).sum());
    }
}

