/*
 * Decompiled with CFR 0.152.
 */
package ffx.numerics.clustering.visualization;

import ffx.numerics.clustering.Cluster;
import ffx.numerics.clustering.CompleteLinkageStrategy;
import ffx.numerics.clustering.LinkageStrategy;
import ffx.numerics.clustering.PDistClusteringAlgorithm;
import ffx.numerics.clustering.visualization.DendrogramPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class DendrogramFrame
extends JFrame {
    public DendrogramFrame(Cluster cluster) {
        this.setSize(500, 400);
        this.setLocation(100, 200);
        this.setDefaultCloseOperation(3);
        JPanel content = new JPanel();
        DendrogramPanel dp = new DendrogramPanel();
        this.setContentPane(content);
        content.setBackground(Color.red);
        content.setLayout(new BorderLayout());
        content.add((Component)dp, "Center");
        dp.setBackground(Color.WHITE);
        dp.setLineColor(Color.BLACK);
        dp.setScaleValueDecimals(0);
        dp.setScaleValueInterval(1.0);
        dp.setShowDistances(false);
        dp.setModel(cluster);
        this.setVisible(true);
    }

    public static void main(String[] args) {
        CompleteLinkageStrategy strategy = new CompleteLinkageStrategy();
        DendrogramFrame f1 = new DendrogramFrame(DendrogramFrame.createSampleCluster(strategy));
        f1.setSize(500, 400);
        f1.setLocation(100, 200);
        DendrogramFrame f2 = new DendrogramFrame(DendrogramFrame.createSampleCluster2(strategy));
        f2.setSize(500, 400);
        f2.setLocation(600, 200);
    }

    private static Cluster createSampleCluster(LinkageStrategy strategy) {
        double[][] distances = new double[][]{{1.0, 9.0, 7.0, 11.0, 14.0, 4.0, 3.0, 8.0, 10.0, 9.0, 2.0, 8.0, 6.0, 13.0, 10.0}};
        String[] names = new String[]{"O1", "O2", "O3", "O4", "O5", "O6"};
        PDistClusteringAlgorithm alg = new PDistClusteringAlgorithm();
        Cluster cluster = alg.performClustering(distances, names, strategy);
        cluster.toConsole(0);
        return cluster;
    }

    private static Cluster createSampleCluster2(LinkageStrategy strategy) {
        double[][] distances = new double[][]{{1.0, 9.0, 7.0, 11.0, 14.0, 12.0, 4.0, 3.0, 8.0, 10.0, 12.0, 9.0, 2.0, 8.0, 9.0, 6.0, 13.0, 11.0, 10.0, 7.0, 2.0}};
        String[] names = new String[]{"O1", "O2", "O3", "O4", "O5", "O6", "07"};
        PDistClusteringAlgorithm alg = new PDistClusteringAlgorithm();
        Cluster cluster = alg.performClustering(distances, names, strategy);
        cluster.toConsole(0);
        return cluster;
    }
}

