/*
 * Decompiled with CFR 0.152.
 */
package ffx.numerics.clustering;

import ffx.numerics.clustering.Cluster;
import ffx.numerics.clustering.ClusterPair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.PriorityQueue;
import java.util.logging.Logger;

public class DistanceMap {
    public static final Logger logger = Logger.getLogger(DistanceMap.class.getName());
    private final Map<String, Item> pairHash;
    private final PriorityQueue<Item> data = new PriorityQueue();

    public DistanceMap() {
        this.pairHash = new HashMap<String, Item>();
    }

    public List<ClusterPair> list() {
        ArrayList<ClusterPair> l = new ArrayList<ClusterPair>(this.data.size());
        for (Item clusterPair : this.data) {
            l.add(clusterPair.pair);
        }
        return l;
    }

    public ClusterPair findByCodePair(Cluster c1, Cluster c2) {
        String inCode = this.hashCodePair(c1, c2);
        Item item = this.pairHash.get(inCode);
        return item == null ? null : item.pair;
    }

    public ClusterPair removeFirst() {
        Item poll = this.data.poll();
        while (poll != null && poll.removed) {
            poll = this.data.poll();
        }
        if (poll == null) {
            return null;
        }
        ClusterPair link = poll.pair;
        this.pairHash.remove(poll.hash);
        return link;
    }

    public boolean remove(ClusterPair link) {
        Item remove = this.pairHash.remove(this.hashCodePair(link));
        if (remove == null) {
            return false;
        }
        remove.removed = true;
        return true;
    }

    public boolean add(ClusterPair link) {
        Item e = new Item(this, link);
        Item existingItem = this.pairHash.get(e.hash);
        if (existingItem != null) {
            logger.info("hashCode = " + existingItem.hash + " adding redundant link:" + String.valueOf(link) + " (exist:" + String.valueOf(existingItem) + ")");
            return false;
        }
        this.pairHash.put(e.hash, e);
        this.data.add(e);
        return true;
    }

    public Double minDist() {
        Item peek = this.data.peek();
        if (peek != null) {
            return peek.pair.getLinkageDistance();
        }
        return null;
    }

    private String hashCodePair(ClusterPair link) {
        return this.hashCodePair(link.getlCluster(), link.getrCluster());
    }

    private String hashCodePair(Cluster lCluster, Cluster rCluster) {
        return this.hashCodePairNames(lCluster.getName(), rCluster.getName());
    }

    private String hashCodePairNames(String lName, String rName) {
        if (lName.compareTo(rName) < 0) {
            return lName + "~~~" + rName;
        }
        return rName + "~~~" + lName;
    }

    public String toString() {
        return this.data.toString();
    }

    private class Item
    implements Comparable<Item> {
        final ClusterPair pair;
        final String hash;
        boolean removed;

        Item(DistanceMap distanceMap, ClusterPair p) {
            Objects.requireNonNull(distanceMap);
            this.removed = false;
            this.pair = p;
            this.hash = distanceMap.hashCodePair(p);
        }

        @Override
        public int compareTo(Item o) {
            return this.pair.compareTo(o.pair);
        }

        public String toString() {
            return this.hash;
        }
    }
}

