/*
 * Decompiled with CFR 0.152.
 */
package ffx.numerics.atomic;

import edu.rit.pj.IntegerForLoop;
import edu.rit.pj.ParallelRegion;
import edu.rit.pj.ParallelTeam;
import edu.rit.pj.reduction.SharedDoubleArray;
import ffx.numerics.atomic.AtomicDoubleArray;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PJDoubleArray
implements AtomicDoubleArray {
    private static final Logger logger = Logger.getLogger(PJDoubleArray.class.getName());
    private SharedDoubleArray array;
    private int arraySize;

    public PJDoubleArray(int arraySize) {
        this.arraySize = arraySize;
        this.array = new SharedDoubleArray(arraySize);
    }

    @Override
    public void add(int threadID, int index, double value) {
        this.array.getAndAdd(index, value);
    }

    @Override
    public void alloc(int newSize) {
        this.arraySize = newSize;
        if (this.array.length() < newSize) {
            this.array = new SharedDoubleArray(newSize);
        }
    }

    @Override
    public double get(int index) {
        return this.array.get(index);
    }

    @Override
    public void reduce(int lowerBound, int upperBound) {
    }

    @Override
    public void reduce(ParallelTeam parallelTeam, int lowerBound, int upperBound) {
    }

    @Override
    public void reset(int threadID, int lowerBound, int upperBound) {
        this.resetSerially(lowerBound, upperBound);
    }

    private void resetSerially(int lowerBound, int upperBound) {
        for (int i = lowerBound; i <= upperBound; ++i) {
            this.array.set(i, 0.0);
        }
    }

    @Override
    public void reset(ParallelTeam parallelTeam, final int lowerBound, final int upperBound) {
        try {
            parallelTeam.execute(new ParallelRegion(this){
                final /* synthetic */ PJDoubleArray this$0;
                {
                    PJDoubleArray pJDoubleArray = this$0;
                    Objects.requireNonNull(pJDoubleArray);
                    this.this$0 = pJDoubleArray;
                }

                public void run() throws Exception {
                    this.execute(lowerBound, upperBound, new IntegerForLoop(this){
                        final /* synthetic */ 1 this$1;
                        {
                            1 v0 = this$1;
                            Objects.requireNonNull(v0);
                            this.this$1 = v0;
                        }

                        public void run(int first, int last) {
                            this.this$1.this$0.resetSerially(first, last);
                        }
                    });
                }
            });
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Exception resetting a PJDoubleArray", e);
        }
    }

    @Override
    public void scale(int threadID, int index, double value) {
        double current = this.array.get(index);
        this.array.getAndSet(index, current * value);
    }

    @Override
    public void set(int threadID, int index, double value) {
        this.array.getAndSet(index, value);
    }

    @Override
    public int size() {
        return this.arraySize;
    }

    @Override
    public void sub(int threadID, int index, double value) {
        this.array.getAndAdd(index, -value);
    }
}

