/*
 * Decompiled with CFR 0.152.
 */
package ffx.numerics.atomic;

import edu.rit.pj.ParallelTeam;
import ffx.numerics.atomic.AdderDoubleArray;
import ffx.numerics.atomic.MultiDoubleArray;
import ffx.numerics.atomic.PJDoubleArray;

public interface AtomicDoubleArray {
    public void add(int var1, int var2, double var3);

    public void alloc(int var1);

    public double get(int var1);

    public void reduce(int var1, int var2);

    public void reduce(ParallelTeam var1, int var2, int var3);

    public void reset(int var1, int var2, int var3);

    public void reset(ParallelTeam var1, int var2, int var3);

    public void scale(int var1, int var2, double var3);

    public void set(int var1, int var2, double var3);

    public int size();

    public void sub(int var1, int var2, double var3);

    public static enum AtomicDoubleArrayImpl {
        ADDER{

            @Override
            public AtomicDoubleArray createInstance(int threads, int size) {
                return new AdderDoubleArray(size);
            }
        }
        ,
        MULTI{

            @Override
            public AtomicDoubleArray createInstance(int threads, int size) {
                return new MultiDoubleArray(threads, size);
            }
        }
        ,
        PJ{

            @Override
            public AtomicDoubleArray createInstance(int threads, int size) {
                return new PJDoubleArray(size);
            }
        };


        public abstract AtomicDoubleArray createInstance(int var1, int var2);
    }
}

