/*
 * Decompiled with CFR 0.152.
 */
package org.rcsb.cif.text;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.stream.Collectors;
import org.rcsb.cif.CifOptions;
import org.rcsb.cif.ParsingException;
import org.rcsb.cif.model.Block;
import org.rcsb.cif.model.text.TextBlock;
import org.rcsb.cif.model.text.TextFile;
import org.rcsb.cif.text.CifTokenType;
import org.rcsb.cif.text.FrameContext;
import org.rcsb.cif.text.TokenizerState;

public class TextCifReader {
    public TextCifReader(CifOptions options) {
    }

    public TextFile read(InputStream inputStream) throws ParsingException, IOException {
        String content = new BufferedReader(new InputStreamReader(inputStream)).lines().collect(Collectors.joining("\n"));
        inputStream.close();
        return this.readText(content);
    }

    public TextFile readText(String data) throws ParsingException {
        if (data.isEmpty()) {
            throw new ParsingException("Cannot parse empty file.");
        }
        ArrayList<Block> dataBlocks = new ArrayList<Block>();
        TokenizerState tokenizer = new TokenizerState(data);
        String blockHeader = "";
        FrameContext blockCtx = new FrameContext();
        ArrayList<TextBlock> saveFrames = new ArrayList<TextBlock>();
        FrameContext saveCtx = new FrameContext();
        TextBlock saveFrame = new TextBlock(saveCtx.getCategories(), "");
        tokenizer.moveNext();
        while (tokenizer.getTokenType() != CifTokenType.END) {
            CifTokenType token = tokenizer.getTokenType();
            if (token == CifTokenType.DATA) {
                if (tokenizer.inSaveFrame) {
                    throw new ParsingException("Unexpected data block inside a save frame.", tokenizer.getLineNumber());
                }
                if (!blockCtx.getCategories().isEmpty()) {
                    TextBlock block = new TextBlock(blockCtx.getCategories(), blockHeader);
                    dataBlocks.add(block);
                    block.getSaveFrames().addAll(saveFrames);
                }
                blockHeader = tokenizer.getData().substring(tokenizer.getTokenStart() + 5, tokenizer.getTokenEnd());
                blockCtx = new FrameContext();
                saveFrames.clear();
                tokenizer.moveNext();
                continue;
            }
            if (tokenizer.getTokenType() == CifTokenType.SAVE) {
                String saveHeader = tokenizer.getData().substring(tokenizer.getTokenStart() + 5, tokenizer.getTokenEnd());
                if (saveHeader.isEmpty()) {
                    if (!saveCtx.getCategories().isEmpty()) {
                        saveFrames.add(saveFrame);
                    }
                    tokenizer.inSaveFrame = false;
                } else {
                    if (tokenizer.inSaveFrame) {
                        throw new ParsingException("Save frames cannot be nested.", tokenizer.getLineNumber());
                    }
                    tokenizer.inSaveFrame = true;
                    String safeHeader = tokenizer.getData().substring(tokenizer.getTokenStart() + 5, tokenizer.getTokenEnd());
                    saveCtx = new FrameContext();
                    saveFrame = new TextBlock(saveCtx.getCategories(), safeHeader);
                }
                tokenizer.moveNext();
                continue;
            }
            if (token == CifTokenType.LOOP) {
                tokenizer.handleLoop(tokenizer.inSaveFrame ? saveCtx : blockCtx);
                continue;
            }
            if (token == CifTokenType.COLUMN_NAME) {
                tokenizer.handleSingle(tokenizer.inSaveFrame ? saveCtx : blockCtx);
                continue;
            }
            throw new ParsingException("Unexpected token (" + String.valueOf((Object)token) + "). Expected data_, loop_, or data name.", tokenizer.getLineNumber());
        }
        if (tokenizer.inSaveFrame) {
            throw new ParsingException("Unfinished save frame (" + saveFrame.getBlockHeader() + ").", tokenizer.getLineNumber());
        }
        if (!blockCtx.getCategories().isEmpty() || !saveFrames.isEmpty()) {
            TextBlock block = new TextBlock(blockCtx.getCategories(), blockHeader);
            dataBlocks.add(block);
            block.getSaveFrames().addAll(saveFrames);
        }
        return new TextFile(dataBlocks);
    }
}

