/*
 * Decompiled with CFR 0.152.
 */
package org.rcsb.cif.model.binary;

import java.lang.reflect.Array;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.rcsb.cif.binary.codec.BinaryCifCodec;
import org.rcsb.cif.model.Category;
import org.rcsb.cif.model.Column;
import org.rcsb.cif.model.LinkedCaseInsensitiveMap;
import org.rcsb.cif.model.binary.BinaryColumn;
import org.rcsb.cif.model.binary.BinaryFloatColumn;
import org.rcsb.cif.model.binary.BinaryIntColumn;
import org.rcsb.cif.model.binary.BinaryStrColumn;

public class BinaryCategory
implements Category {
    private final String name;
    private final int rowCount;
    private final Object[] encodedColumns;
    private final Map<String, Column<?>> decodedColumns;
    private final List<String> columnNames;

    public BinaryCategory(String name, int rowCount, Object[] encodedColumns) {
        this.name = name;
        this.rowCount = rowCount;
        this.encodedColumns = encodedColumns;
        this.decodedColumns = new LinkedCaseInsensitiveMap();
        this.columnNames = Stream.of(encodedColumns).map(map -> ((Map)map).get("name")).map(String.class::cast).collect(Collectors.toList());
    }

    @Override
    public String getCategoryName() {
        return this.name;
    }

    @Override
    public int getRowCount() {
        return this.rowCount;
    }

    @Override
    public Column<?> getColumn(String name) {
        int[] mask;
        Optional<Map<String, Object>> optional = this.find(name);
        if (optional.isEmpty()) {
            return new Column.EmptyColumn(name);
        }
        if (this.decodedColumns.containsKey(name)) {
            return this.decodedColumns.get(name);
        }
        Map<String, Object> encodedColumn = optional.get();
        Object binaryData = BinaryCifCodec.decode((Map)encodedColumn.get("data"));
        int rowCount = Array.getLength(binaryData);
        Map maskMap = (Map)encodedColumn.get("mask");
        int[] nArray = mask = maskMap == null || maskMap.isEmpty() ? null : (int[])BinaryCifCodec.decode(maskMap);
        BinaryColumn decodedColumn = binaryData instanceof int[] ? new BinaryIntColumn(name, rowCount, (int[])binaryData, mask) : (binaryData instanceof double[] ? new BinaryFloatColumn(name, rowCount, (double[])binaryData, mask) : new BinaryStrColumn(name, rowCount, (String[])binaryData, mask));
        this.decodedColumns.put(name, decodedColumn);
        return decodedColumn;
    }

    private Optional<Map<String, Object>> find(String name) {
        return Stream.of(this.encodedColumns).map(m -> (Map)m).filter(m -> name.equalsIgnoreCase((String)m.get("name"))).findFirst();
    }

    @Override
    public Map<String, Column<?>> getColumns() {
        this.columnNames.forEach(this::getColumn);
        return this.decodedColumns;
    }

    @Override
    public List<String> getColumnNames() {
        return this.columnNames;
    }
}

