/*
 * Decompiled with CFR 0.152.
 */
package org.rcsb.cif.model;

import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.rcsb.cif.EmptyColumnException;
import org.rcsb.cif.model.ValueKind;

public interface Column<T> {
    public String getColumnName();

    public int getRowCount();

    public String getStringData(int var1);

    default public Stream<String> stringData() {
        return IntStream.range(0, this.getRowCount()).mapToObj(this::getStringData);
    }

    public ValueKind getValueKind(int var1);

    default public Stream<ValueKind> valueKinds() {
        return IntStream.range(0, this.getRowCount()).mapToObj(this::getValueKind);
    }

    default public boolean isDefined() {
        return this.getRowCount() > 0;
    }

    public T getArray();

    public static class EmptyColumn
    implements Column<Void> {
        public static final EmptyColumn UNNAMED_COLUMN = new EmptyColumn(""){

            @Override
            public String getStringData(int row) {
                throw new EmptyColumnException("anonymous column is undefined");
            }

            @Override
            public ValueKind getValueKind(int row) {
                throw new EmptyColumnException("anonymous column is undefined");
            }
        };
        private final String name;

        public EmptyColumn(String name) {
            this.name = name;
        }

        @Override
        public String getColumnName() {
            return this.name;
        }

        @Override
        public int getRowCount() {
            return 0;
        }

        @Override
        public String getStringData(int row) {
            throw new EmptyColumnException("column " + this.name + " is undefined");
        }

        @Override
        public ValueKind getValueKind(int row) {
            throw new EmptyColumnException("column " + this.name + " is undefined");
        }

        @Override
        public Stream<ValueKind> valueKinds() {
            return Stream.empty();
        }

        @Override
        public Void getArray() {
            return null;
        }
    }
}

